/*****************************************************************************/
/* UNGZNEWS.CMD : Un-GZip Newsbatch (v0.71)                                  */
/*                                                                           */
/* This script will decompress newsbatches compressed with GZip.             */
/*                                                                           */
/* WaterGate/2 v0.93 does not handle GZip compressed newsbatches correctly.  */
/* Run this script before you run WaterGate/2, so WaterGate gets             */
/* uncompressed newsbatches to handle.                                       */
/*                                                                           */
/* This script will need a patched version of GZip, which can handle the     */
/* '#! cunbatch' line on top of the newsbatch. This line is not a part of    */
/* real compressed file, but is added for use on unix systems. This script   */
/* will use this line also, but only to see of a .D file is a compressed     */
/* newsbatch or not.                                                         */
/*                                                                           */
/* An example of such a patched version is the one distributed in the        */
/* package of GiGo. If you get this scripted within the archive UNGZN071.ZIP */
/* then this patched version should be in the package.                       */
/*                                                                           */
/* Author: Jos Huijnen                     E-Mail : jos@snake.xs4all.nl      */
/*                                                  the_snake@compuserve.com */
/*                                CompuServe Mail : 101350,1074              */
/*                              Fidonet (Netmail) : 2:284/312                */
/*****************************************************************************/

arg x
parse upper var x spooldir linkname

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

'@echo off'

if spooldir='' | linkname='' then
do
   say ''
   say ''
   say 'You didn''t specify the drive/path to your UUCP spool directory'
   say 'or a (dir)name of your link this script is running for.'
   say ''
   say '     Usage   : UNGZNEWS [drive]:\[spooldir] link(dir)name'
   say '     Example : UNGZNEWS C:\UUCP\SPOOL XS4ALL'
   say ''
   exit
end
if substr(spooldir,length(spooldir))='\' then spooldir=delstr(spooldir,length(spooldir))
call SysFileTree spooldir || '\' || linkname || '\*.D', 'file', 'FO'
do count=1 to file.0
   eof=lines(file.count)
   do while (eof<>0)
      tmptext=linein(file.count)
      text=translate(tmptext,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')
      if pos('#! cunbatch',text)<>0 then
      do
         call lineout(file.count)
         filename=substr(file.count,lastpos('\',file.count)+1)
         filename=delstr(filename,pos('.',filename))
         filepath=delstr(file.count,lastpos('\',file.count)+1)
         'REN ' || filepath || filename || '.D ' || filename || '.GZ'
         'GZIP -d ' || filepath || filename
         'REN ' || filepath || filename || ' ' || filename || '.D'
         eof=0
      end
      if eof<>0 then eof=lines(file.count)
   end
   call lineout(file.count)
end
call SysDropFuncs
