/*******************************************************************
      (c) copyright 2009 Santronics Software, Inc.

file     : odometer.js
developer: HLS
date     : 01/07/2009
version  : 452.8
about    :

Use this javascript to display a "odometer" table using the a css
class style called "meter"

Example usage within a WCT page:

   <link rel="stylesheet" type="text/css" href="odometer.css">
   <script type="text/javascript" src="odometer.js"></script>

   <script>
   odoMeterDrawTable("@TOTALCALLS@");
   </script>

The function odoMeterDrawTable(sc,css) takes a meter value 'sc' as a string,
splits it into digits and wraps table cells around each digit.  The table,
row and columns all use the class "meter" by default.  A different css class
can be passed allowing you to create your own styles. see odometer.css.

********************************************************************/

function odoMeterSplit(s, separator)
{
  s = s.replace(/,/g,"").split("").toString().replace(/,/g,separator);
  return s;
}

function odoMeterDrawTable(sc, css)
{
  var meter = {value: "0",css: "meter"};

  if (typeof sc == "object") {
     meter = sc;
  } else {
     meter.value = sc;
     meter.css   = css;
  }
  if (meter.css == undefined) meter.css = "meter";
  var clid  = "class='"+meter.css+"'";
  var td    = "<td "+clid+">";
  var tr    = "<tr "+clid+">";
  var table = "<table "+clid+">";
  sc = odoMeterSplit(meter.value,"</td>"+td);
  sc = td+sc+"</td>";
  sc = tr+sc+"</tr>";
  sc = table+sc+"</table>";
  document.writeln(sc);
}

