(**************************************************************************)
(*
(*                           
(*                      
(*                       
(*                  
(*            
(*            
(*             
(*             
(*                
(*                           
(*                                       
(*
(*
(*					   Wildcat mail tosser V2.7
(*
(*
(*				 Copyright 1994,95,96 Michael Dailly
(*
(*  Copyright Notice
(*	----------------
(*
(*	  Michael Dailly retains ALL copyright to this program and its source.
(*	  The user may alter or amend the source in anyway he or she wishes.
(*	  However, the program may NOT be sold, but must be given freely and
(*	  any changes (including full source) must be sent to the Author
(*	  (Michael Dailly). Failing to do so is a violation of copyright. 
(*    The Authors name (Michael Dailly) MUST appear in the programs 
(*    copyright notice, and in any documentation, and it must clearly 
(*    state that the program is a modification of wcTOSS. The full modified 
(*	  source code must be included in the programs archive for all to 
(*	  use and examine. 
(*
(*
(*	 This copyright notice,and the authors name(s) must remain in all files.
(*
(*
(***************************************************************************)


UNIT Func;

interface

uses     crt,dos,memory;

Const
	ScreenBase = $b800;
	VidSeg	 = $a000;
	Ind        : Array[0..15] of byte = (0,0,0,1,0,0,0,8,0,1,2,3,4,5,8,7);
	ColourNo	 = $3c8;
	ColourAttr = $3c9;

	XMode	 = 1;	{ xor pixels ON }
	MMode	 = 1;	{ Masked text	 }
	NMode	 = 0;	{ draw ON		 }

	TString	 = 1;	{ string gadget }
	TGraphic	 = 2;	{ graphic gadget}

Type
	TxtScreen	 = Record						{ make an array for the	}
				att	: byte;				{ Text screen			}
				ch   : byte;
			   End;
	TxtScrArr	= Array[0..4200] of TxtScreen;
	TxtScr	= ^TxtScr;
	tVScr	= Array [0..24,0..79] of word;
     pVScr	= ^tVscr;
	VScr		= Array [0..64000] of byte;
	VidScr	= ^Vscr;
	WindowStruct	= Record
				Wxcord : Integer;
				Wycord : Integer;
				Wxsize : Integer;
				Wysize : Integer;
				WPoint : Pointer;
               	Cx,Cy  : integer;
                    Ret	  : Boolean;
			End;
	PtrRec         = Record
				   Ofs,Seg  :	Word;
				End;
	Colours	= Record
		  r : Byte;
		  g : Byte;
		  b : Byte;
		  End;



VAR
     RestoreIt :  Boolean;

	FillPattern: boolean;
	FillPat	 : pointer;
	FillPatXsize: word;
	FillPatYsize: word;

	lp1	 	 : integer;
	Dmode	 : byte;
	Key		 : char;
	FuncKey	 : Boolean;
	TextScreen : TxtScr;
	VidScreen	 : VidScr;
     YY,XX      : Word;
     Ox,Oy      : Word;
     But        : word;
     Moved      : Boolean;
     Mouse      : Boolean;
     Rset       : registers;
	Eor		 : byte;
	PrintMode	 : Byte;

	clickF     : Boolean;
	click      : boolean;

     Table      : Array [1..256] of Colours;
	Windows	 : Array [1..20] of WindowStruct;
     Cwind	 : integer; { Current window }
     tx,ty	 : integer;
     ret		 : boolean;

     swapfile	 : file;
     StartPtr   : pointer;
     SaveSize   : longint;


Function		Hex (V : longint; s : word) : string;
Function       _Dec (hexstr : string) : word;
Function		REV (Data : Byte) : Byte;
Function		Spc (Number : word) : String;
Function		ALetter (Ch : Char) : Boolean;
Function		Ascii (Ch : Char) : Boolean;
Function		ANumber (Ch : Char) : Boolean;
Function		AHexDig (Ch : Char) : Boolean;
Function		Digit (Ch : Char) : Byte;
Function		GetStr (VAR Sst : String; In1,In2 : word) : String;
Function		UpperCase (I : String) : String;
{Var L : Integer;}
Function		LowerCase (I : String) : String;
Function		GetChar (x,y : word) : Word;
Function		MemCmp (p1,p2 : pointer; size : word) : Boolean;
Function		GetKey : Char;
Function	     OpenWindow(Xc,Yc,Xs,Ys,c,b : word) : integer;
Function		Fpc (Number : word; cc : char) : String;
Function		Rstr (n : longint) : string;
Function		Rval (s : string) : longint;
Function		Rad (r : real) : real;

Procedure      MemCopy (p1,p2 : pointer; size : word);
Procedure		MemCopyW (p1,p2 : pointer; size : word);
Procedure		PutChar (x,y,chr : word);
Procedure      DoMouse;
Procedure      SetupMouse (Halt_Flag : Boolean);
Procedure		CloseWindow(Wind : integer);
Procedure		SetWindow (Wind : integer);
Procedure		DoColours;
Procedure		SetMode;
Procedure		RestoreMode;
Procedure		WaitVBlank;
Procedure		SetColour (ColR,R,G,B : byte);
Procedure		FreeMemory(p : pointer; S : longint);
Procedure		Load (Name : string; VAR p : pointer; VAR S : longint);

Procedure 	OpenSwapFile;
Procedure 	CloseSwapFile;
Procedure 	DoFreemem;
Procedure 	DoAllocMem;

implementation

(***************************************************************************)
(*
(*	OpenSwapfile
(*
(***************************************************************************)
Procedure OpenSwapFile;
Begin
	assign  (swapfile,'swapfile.MD');
     rewrite (swapfile,1);
End;
(***************************************************************************)
(*
(*	Closewapfile
(*
(***************************************************************************)
Procedure CloseSwapFile;
Begin
     Close (swapfile);
     Erase (Swapfile);
End;

(***************************************************************************)
(*
(*   Do free Memory
(*
(***************************************************************************)
Procedure DoFreemem;
          type tt = array [0..32768] of byte;
               pt = ^tt;
          VAR name : string;
          VAR max,Current : pointer;
          VAR save,Base,top : longint;
          VAR basew,topw : word;
          VAR t : pt;
Begin
     current:=StartPtr;
     max:=heapend;
     seek (swapfile,1);

     { get pointers into LONGINTS, so i can do full pointer arith. }
     base:=0;
     top:=0;
     asm
        mov    ax,word ptr current+2
        mov    word ptr base+1,ax
        mov    ax,word ptr current
        mov    basew,ax

        mov    ax,word ptr max+2
        mov    word ptr top+1,ax
        mov    ax,word ptr max
        mov    topw,ax
     End;
     base:=(base shr 4)+basew;
     top:=(top shr 4)+topw;
     SaveSize:=top-base;
     Save:=savesize;

     repeat
           blockwrite (swapfile,current^,32768);
           dec (save,$8000);
           asm
              add   word ptr current+2,$800
           end;
     until (save<$8000);

     if save>0 then blockwrite (swapfile,current^,save);

     SetmemTop (StartPtr);

End;

(***************************************************************************)
(*
(*   Do Alloc Memory
(*
(***************************************************************************)
Procedure DoAllocMem;
          VAR name : string;
          VAR max,Current : pointer;
          VAR save,Base,top : longint;
          VAR basew,topw : word;
Begin
     SetmemTop (HeapEnd);
     current:=StartPtr;
     seek (swapfile,1);
     Save:=savesize;

     repeat
           blockread (swapfile,current^,32768);
           dec (save,$8000);
           asm
              add   word ptr current+2,$800
           end;
     until (save<$8000);

     if save>0 then blockread (swapfile,current^,save);
End;

(**************************************************************************************)
(*	Hex (number,number of dig)
(**************************************************************************************)
Function	Hex (V : longint; s : word) : string;
		VAR st : string;
		Const	hexstr : string[16] = '0123456789ABCDEF';
 Begin
	st:=hexstr[1+(V and $f0000000) shr 28];
	st:=st+hexstr[1+(V and $f000000) shr 24];
	st:=st+hexstr[1+(V and $f00000) shr 20];
	st:=st+hexstr[1+(V and $f0000) shr 16];

	st:=st+hexstr[1+(V and $f000) shr 12];
	st:=st+hexstr[1+(V and $f00) shr 8];
	st:=st+hexstr[1+(V and $f0) shr 4];
	st:=st+hexstr[1+(V and $f)];

	if s<8 then delete (st,1,8-s);
     hex:=st;
 End;

(**************************************************************************************)
(*	WaitVblank
(**************************************************************************************)
Procedure	WaitVBlank;
		VAR i : byte;
	Begin
		i:=8;
		while (i=8) do			{ wait till out	}
			i:=Port[$3da] and 8;


		while (i=0) do			{ wait till IN		}
			i:=Port[$3da] and 8;

	End;


(**************************************************************************************)
(*
(*		Dec : get the dec value of a HEX "Nibble,Byte,Word,etc..."
(*
(**************************************************************************************)
Function	_Dec (hexstr : string) : word;
		const  HexDigits: ARRAY[0..15] OF CHAR = '0123456789ABCDEF';
          VAR f : word;
   Begin
	Asm
          push bp
          push si
		mov	ax,0	     { clear answer }
		mov	@Result,ax{ clear answer }
		mov	bx,ax
		lea	si,hexstr	{ get string address }
		lodsb		{ get string length  }
		mov	cl,al
		xor	ch,ch	{ got loop counter }
		inc	cx		{ dummy inc        }


@SkipBit:	dec	cx
          js   @HexExit  { cx neg? (<0) }
@Loop:	lodsb		{ get char     }
          cmp	al,'$'	{ doller sign? }
		jz	@SkipBit

		mov	ah,al
		push	si
		lea	si,HexDigits
		mov	dx,16	{ find char }
@loop2:	lodsb		{ get hex char }
		cmp	ah,al
		jz	@Gotit
		dec	dx
		jnz	@loop2
		pop	si		{ not a hex digit --- exi --- }
		jmp	@HexExit
@gotit:
		dec	dx
		xor	dx,15
          shl  bx,4
          add  bx,dx     { add on new nibble }
          pop  si

          loop @loop

@HexExit:
          pop si
          pop bp
          mov ax,bx
          mov @Result,ax
	End;
   End;



(***************************************************************************)
(*
(* Reverse byte
(*
(***************************************************************************)
Function		Rev	(Data : Byte) : Byte;
			VAR temp : byte;
   Begin
	Asm
		mov	cl,Data
		xor	al,al
		rcr	cl,1		{ bit 0 }
		rcl	al,1
		rcr	cl,1		{ bit 1 }
		rcl	al,1
		rcr	cl,1 	{ bit 2 }
		rcl	al,1
		rcr	cl,1 	{ bit 3 }
		rcl	al,1
		rcr	cl,1		{ bit 4 }
		rcl	al,1
		rcr	cl,1		{ bit 5 }
		rcl	al,1
		rcr	cl,1		{ bit 6 }
		rcl	al,1
		rcr	cl,1		{ bit 7 }
		rcl	al,1
		mov	@Result,al
	End
   End;


(***************************************************************************)
(*
(* return X number of spaces
(*
(***************************************************************************)
Function		Spc (Number : word) : String;
			VAR Ts : String[80];
	Begin
          Asm
			push bp
			mov	cx,Number
               and  cx,cx
               js   @none
			lea	bp,Ts		{ Get string address }
			mov	al,' '		{ fill with space  }
			mov  [bp],cl		{ store new length }
			and	cx,cx		{ size 0? }
			jz	@None
			inc	bp

@more:		mov  [bp],al
			inc	bp
			loop	@more
@none:
			pop	bp
		End;
		Spc:=Ts;
	End;


(***************************************************************************)
(*
(* return X number of "char"
(*
(***************************************************************************)
Function		Fpc (Number : word; cc : char) : String;
			VAR Ts : String[200];
	Begin
          Asm
			push bp
			mov	cx,Number
               and  cx,cx
               js   @none
			mov	al,cc		{ get char to fill with }
			lea	bp,Ts		{ Get string address    }
			mov  [bp],cl		{ store new length      }
			and	cx,cx		{ size 0?               }
			jz	@none
			inc	bp

@more:		mov  [bp],al
			inc	bp
			loop	@more
@none:
			pop	bp
		End;
		Fpc:=Ts;
	End;



(***************************************************************************)
(*
(* Number of letter check
(*
(***************************************************************************)
Function		ALetter (Ch : Char) : Boolean;
	Begin Aletter:= Ch in ['A'..'Z','a'..'Z'] end;

Function		ANumber (Ch : Char) : Boolean;
	Begin ANumber:= Ch in ['0'..'9'] End;

Function		AHexDig (Ch : Char) : Boolean;
	Begin AHexDig:= Ch in ['0'..'9','A'..'F','a'..'f'] end;

Function		Ascii (Ch : Char) : Boolean;
	Begin If Ch in ['0'..'9','A'..'Z','a'..'z','.','_'] then Ascii:=True else Ascii:=False end;

(***************************************************************************)
(*
(* Returns the VALUE of the digit
(*
(***************************************************************************)
Function		Digit (Ch : Char) : byte;
  Begin
	Asm
		mov	al,Ch		{ get char }
		sub	al,'0'		{ get ascii value }
		mov	@Result,al
	End;
  End;




(***************************************************************************)
(*
(*	GetStr
(*
(***************************************************************************)
Function		GetStr (VAR Sst : String; In1,In2 : Word) : String;
			VAR I : Integer;
			VAR Ts : String;
Begin
	Ts:='';
	For I:=In1 to In2 Do If (I <= Length(Sst)) Then Ts:=Ts+Sst[I];
	GetStr:=Ts;
End;


(***************************************************************************)
(*
(* Uppercase FUNCTION
(*
(***************************************************************************)
Function		UpperCase (I : String) : String;
			Var L : Integer;
Begin
	For L:=1 to Length(I) Do
		I[L]:= UpCase(I[L]);

	UpperCase:=I;
End;


(***************************************************************************)
(*
(* LowerCase FUNCTION
(*
(***************************************************************************)
Function		LowerCase (I : String) : String;
			Var L : Integer;
Begin
	For L:=1 to Length(I) Do
     	if (I[L]>='A') AND (I[L]<='Z') then
			I[L]:=chr(ord(I[L])+ord('a')-ord('A'));

	LowerCase:=I;
End;

(***************************************************************************)
(*
(* GetChar(x,y);
(*
(***************************************************************************)
Function		GetChar (x,y : word) : Word;
			VAR Offset : integer;
               VAR scr : pVscr;
Begin
	Scr:=ptr(segb800,0);
     GetChar:=Scr^[y,x];
End;

(***************************************************************************)
(*
(* GetChar(x,y);
(*
(***************************************************************************)
Procedure	PutChar (x,y,chr : word);
			VAR Offset : integer;
               VAR scr : pVscr;
Begin
	Scr:=ptr(segb800,0);
     Scr^[y,x]:=Chr;
End;

(***************************************************************************)
(*
(*	Comp 2 blocks of memory
(*
(**)
Function	MemCmp (p1,p2 : pointer; size : word) : Boolean;
 Begin
	Asm
		push	ds			{ save the segments as we probably }
		push	es			{ shouldn't mess with them         }
		mov	cx,size
		les	di,p1		{ get mem block 1 }
		lds	si,p2
		repe	cmpsb
		mov	al,1 		{ Flag equal }
		jcxz @FiniOK		{ Jump if I'm not lying }

		mov	al,0		     { OOps I lied, Flag not equal }

@FiniOK:	pop	es			{ restore the segments }
		pop	ds
          mov	@Result,al
	End;
 End;


(***************************************************************************)
(*
(*	Copy a block of memory
(*
(**)
Procedure	MemCopy (p1,p2 : pointer; size : word);
 Begin
	Asm
		push	ds			{ save the segments as we probably }
		push	es			{ shouldn't mess with them         }
		mov	cx,size
		les	di,p2		{ get mem block 1 }
		lds	si,p1
          rep  movsb

          pop	es			{ restore the segments }
		pop	ds
	End;
 End;

(***************************************************************************)
(*
(*	Copy a block of memory (sizes in WORDS)
(*
(**)
Procedure	MemCopyW (p1,p2 : pointer; size : word);
 Begin
	Asm
		push	ds			{ save the segments as we probably }
		push	es			{ shouldn't mess with them         }
		mov	cx,size
		les	di,p2		{ get mem block 1 }
		lds	si,p1
          rep  movsw

          pop	es			{ restore the segments }
		pop	ds
	End;
 End;

(***************************************************************************)
(*
(*	Return Deg
(*
(***************************************************************************)
Function	Rad (r : real) : real;
	Begin Rad:=r/57.2957 End;


(***************************************************************************)
(*                                                                         *)
(* get Mouse (x,y) and button State		 					     *)
(*                                                                         *)
(**)
Procedure	DoMouse;
	Begin
	   If Mouse Then
		Begin
           Rset.AX	:=3;
           Intr	($33,Rset);

           if (xx=Rset.Cx) and (yy=Rset.Dx*2) then
              Moved:=False
           else
              Moved:=True;

           XX := Rset.CX;
           YY := (Rset.DX * 2);
           But:= Rset.BX;

		End;
	End;


(***************************************************************************)
(*                                                                         *)
(* Setup Mouse								   *)
(*                                                                         *)

Procedure	SetupMouse (Halt_Flag : Boolean);
	Begin
		Rset.AX	:=0;				(* Reset Mouse	   *)
		Intr	($33,Rset);


		If Rset.AX = 65535 Then
		   Begin
			Mouse	:=True;

			Rset.AX	:=4;	(* Setup Mouse to top left of screen	   *)
			Rset.CX	:=0;
			Rset.DX	:=0;
			Intr	($33,Rset);

		   end	else
			Begin
				Mouse := False;
				Writeln ('Mouse not found.');
				if Halt_Flag then Halt(1);
			End;
	End;


(***************************************************************************)
(*
(* Open a window (X,Y,Xsize,Ysize)   Returns Window number (or -1);
(*
(***************************************************************************)
Function	OpenWindow(Xc,Yc,Xs,Ys,c,b : word) : integer;
			VAR MemAmount : LongInt;
			VAR Temp,Wind,Loop,Loop2 : integer;
			VAR P : Pointer;
			VAR Segs,Off,Data,Index :  Word;
			VAR TT : Byte;


	Begin
          textcolor(c);
          textbackground(b);
          Loop:=1;
		While (Windows[loop].Wpoint <> nil) AND (Loop<21) Do
			Inc (Loop);

		if ((Xc<1) OR (Xc>78) OR (Yc<1) OR (Yc>48)) OR (Loop>20) then
			Begin
				OpenWindow:=-1; 		(* cant open window *)
				Exit;
			End;
		Wind:=Loop;
		Dec (xc); Dec (yc);				(* make bigger for boarder *)
		Inc (xs,3); Inc (ys,3);               (* AND shadow *)




		MemAmount:=(xs*2)*(Ys+5);			(* Save background *)
		GetMem (P,(MemAmount+15) And $fff0);
		Segs := PtrRec (P).Seg;
		Off:= PtrRec (p).Ofs;
		if (off+memamount) AND $ffff < off then
			exit;
		Index:=0;
		For Loop:=0 to ys-1 Do
			Begin
				For Loop2:=0 to xs-1 Do
					Begin
						Data:=GetChar(Loop2+xc,Loop+yc);
						Memw[Segs:Off+Index]:=Data;
						Inc (Index,2);
					End;
			End;
		Windows [Wind].Wxcord:=Xc;
		Windows [Wind].Wycord:=Yc;
		Windows [Wind].Wxsize:=xs;
		Windows [Wind].Wysize:=ys;
		Windows [Wind].Wpoint:=P;
		Windows [Wind].cx:=Xc+1;
		Windows [Wind].cy:=Yc+1;
		Windows [Wind].Ret:=False;
		OpenWindow := Wind;
      	Cwind:=Wind;



          {gotoxy(Xc,Yc);}

		Window (xc+1,yc+1,(xc+Xs-1),(Yc+Ys));		(* Draw boarder *)
		Write(Char(201));
		Temp:=xs-3;
		For Loop:=1 to xs-3 Do
			Write (Char(205));
		Write (Char(187));
		For Loop:=1 to ys-3 Do
				Write (Char(186),Spc(Temp),Char(186));
		Write(Char(200));
		For Loop:=1 to xs-3 Do
			Write (Char(205));
		Write (Char(188));



		For Loop:=1 to Ys-2 Do			(* Do Shadow *)
		 Begin
			Data:=GetChar(Xc+Xs-1,Yc+loop);
			Temp:=Data shr 8;
			Data:=(((Ind[temp shr 4] shl 4) OR (Ind[Temp And $0f]) *256) OR (Data AND $00ff));
			PutChar (Xc+Xs-1,Yc+loop,Data);
		 End;
		For Loop:=1 to xs-1 Do
		 Begin
			Data:=GetChar(Xc+Loop,Yc+Ys-1);
			Temp:=Data AND $ff00 shr 8;
			Data:=(((Ind[temp shr 4] shl 4) OR (Ind[Temp And $0f]) *256) OR (Data AND $00ff));
			PutChar (Xc+loop,Yc+Ys-1,Data);
		 End;

		Window (xc+2,yc+2,(xc+Xs)-2,(Yc+Ys)-2);	  (* define text window *)
	End;


(***************************************************************************)
(*
(* Redefine Text Window
(*
(***************************************************************************)
Procedure		SetWindow (Wind : integer);
			VAR xc,yc,xs,ys : integer;
	Begin
		Xc:=Windows [Wind].Wxcord;
		Yc:=Windows [Wind].Wycord;
		Xs:=Windows [Wind].Wxsize;
		Ys:=Windows [Wind].Wysize;
		Window (xc+2,yc+2,(xc+Xs)-2,(Yc+Ys)-2);			(* define text window *)
     	Cwind:=Wind;
        	tx:=Windows [Wind].Cx;  { current X and Y   }
        	ty:=Windows [Wind].Cy;
          Ret:=Windows [Wind].Ret; { return NEXT line? }
	End;

(***************************************************************************)
(*
(* Close a window (Window Number)
(*
(***************************************************************************)
Procedure	CloseWindow(Wind : integer);
			VAR MemAmount : LongInt;
			VAR Loop,Loop2 : integer;
			VAR P : Pointer;
			VAR Segs,Off,Data,Index :  Word;
			VAR Xc,Yc,Xs,Ys : integer;

	Begin
		if Wind=-1 then exit;
		Xc:=Windows [Wind].Wxcord;
		Yc:=Windows [Wind].Wycord;
		Xs:=Windows [Wind].Wxsize;
		Ys:=Windows [Wind].Wysize;
		P:=Windows [Wind].Wpoint;

		MemAmount:=(xs*2)*(Ys+5);
		Segs := PtrRec (P).Seg;
		Off:= PtrRec (p).Ofs;

		Index:=0;
		For Loop:=0 to ys-1 Do
			Begin
				For Loop2:=0 to xs-1 Do
					Begin
						Data:=MemW[Segs:Off+Index];
						PutChar(Loop2+xc,Loop+yc,Data);
						Inc (Index,2);
					End;
			End;
		Windows [Wind].Wxcord:=0;
		Windows [Wind].Wycord:=0;
		Windows [Wind].Wxsize:=0;
		Windows [Wind].Wysize:=0;
		Windows [Wind].Wpoint:=nil;
		FreeMem (P,(MemAmount+15) and $fff0);
	End;


(***************************************************************************)
(*
(* Get A key
(*
(***************************************************************************)
Function	GetKey : Char;
	Begin
		if keyPressed then
			Begin
				Key:=Readkey;
				if Key <> #0 then Funckey := False else
					Begin
						FuncKey := True;
						Key:=readkey;
					End;
			End;
		GetKey:=Key;
	End;




(***************************************************************************)
(*									   						*)
(* Copy in colours                                                         *)
(*                                                                         *)

Procedure	DoColours;
		VAR f,i :integer;
	Begin
		Port[ColourNo]:=0;
		i:=1;
		for f:=1 to 256 do
			Begin
				Port[ColourAttr]:=Byte(Table[f].r shr 2);
				Port[ColourAttr]:=Byte(Table[f].g shr 2);
				Port[ColourAttr]:=Byte(Table[f].b shr 2);
			End;
	End;


(***************************************************************************)
(*									   						*)
(* Copy in a colour                                                        *)
(*                                                                         *)

Procedure	SetColour (ColR,R,G,B : byte);
	Begin
		Port[ColourNo]:=ColR;
		Port[ColourAttr]:=R shr 2;
		Port[ColourAttr]:=G shr 2;
		Port[ColourAttr]:=B shr 2;
	End;


(***************************************************************************)
(*                                                                         *)
(* Set mode 13                                                             *)
(*                                                                         *)
Procedure	SetMode;
	Begin
		Rset.Ah:=$0f;
		Intr ($10,Rset);
		Dmode:=Rset.Al;

		Rset.ax	:= $13;			(* Select Mode		   *)
		Intr	($10,Rset);
	End;



(***************************************************************************)
(*
(*  Restore old mode
(*
(***************************************************************************)
Procedure	RestoreMode;
	Begin
		Rset.Ah	:= $00;
		Rset.al	:= Dmode;
		Intr	($10,Rset);
	End;


(***************************************************************************)
(*
(*	Return a number as a string
(*
(***************************************************************************)
Function		Rstr (n : longint) : string;
		VAR s : string;
	Begin
		Str (n,s);
		Rstr:=s;
	End;

(***************************************************************************)
(*
(*	Return a string as a number
(*
(***************************************************************************)
Function		Rval (s : string) : longint;
		VAR n : longint;
		VAR c : word;
	Begin
		Val (s,n,c);
		RVal:=n;
	End;

(***************************************************************************)
(*
(*	FreeMemory
(*
(***************************************************************************)
Procedure	FreeMemory(p : pointer; S : longint);
  Begin
	FreeMem (p,(s+15) and $fff0);
  End;


(***************************************************************************)
(*
(*	Load a file
(*
(***************************************************************************)
Procedure	Load (Name : string; VAR p : pointer; VAR S : longint);
	VAR f : file;
	VAR d : searchrec;
 Begin
	FindFirst (Name,AnyFile,D);
	S:=D.Size;
	if doserror<>0 then
	 Begin
		s:=0; p:=NIL;
		exit;
	 End;
	Assign (f,name);
	reset (f,1);
 	getmem (p,(s+15) and $fff0);
	blockread (f,p^,s);
	close (f);
 End;



(***************************************************************************)
(*
(*	Setup unit
(*
(***************************************************************************)
Begin
     StartPtr:=HeapPtr;
	TextScreen:=Ptr(segb800,$0000);		{ make array point to screen }

     Cwind:=-1;
	for Lp1:=0 to 20 do
	 Windows[lp1].Wpoint := nil;

End.




