(**************************************************************************)
(*
(*                           
(*                      
(*                       
(*                  
(*            
(*            
(*             
(*             
(*                
(*                           
(*                                       
(*
(*
(*					   Wildcat mail tosser V2.7
(*					  WcToss NodeList Index Gen.
(*
(*				 Copyright 1994,95,96 Michael Dailly
(*
(*  Copyright Notice
(*	----------------
(*
(*	  Michael Dailly retains ALL copyright to this program and its source.
(*	  The user may alter or amend the source in anyway he or she wishes.
(*	  However, the program may NOT be sold, but must be given freely and
(*	  any changes (including full source) must be sent to the Author
(*	  (Michael Dailly). Failing to do so is a violation of copyright. 
(*    The Authors name (Michael Dailly) MUST appear in the programs 
(*    copyright notice, and in any documentation, and it must clearly 
(*    state that the program is a modification of wcTOSS. The full modified 
(*	  source code must be included in the programs archive for all to 
(*	  use and examine. 
(*
(*
(*	  This copyright notice,and the authors name must remain in all files.
(*
(*
(*
(*	Makes an INDEX file for the fidonet nodelist
(*
(* FORMAT
(* ------
(*
(*	Zone,NEXT_ZONE_INDEX,Number_of_Hosts
(*		Host,Next_host_index,Number_of_nodes
(*					node,node,node,.......,node,node
(*		Host,Next_host_index,Number_of_nodes
(*					node,node,node,.......,node,node
(*
(*	Zone,NEXT_ZONE_INDEX,Number_of_Hosts
(*		Host,Next_host_index,Number_of_nodes
(*					node,node,node,.......,node,node
(*		Host,Next_host_index,Number_of_nodes
(*					node,node,node,.......,node,node
(*
(*	-1 in any NEXT zone/host index= end of list...
(*	ie.
(*		Zone, nextindex, number
(*		 6,	 $FFFFFFFF, 12
(*
(****************************************************************************)
Program	WcToss_node_Index;

uses	dos,crt,func;


type		tBuff	=	array [0..65100] of byte;
		pBuff	=	^tBuff;

		tNode	=	array [0..16384] of word;
          pNode	=	^tNode;
Var
		nodelist	:	file;
          nodeindex	:	file;

          index	:	longint;
          current	:	longint;
          Buffer	:	pBuff;
          NodeBuff	:	pNode;
          DirInfo   :    Searchrec;
     	Size		:	longint;
		Done		:	Boolean;
          s		:	string;
		Zones	:	longint;
          hosts	:	longint;
          nodes	:	longint;
          NoHosts	:	word;
          NoNodes	:	word;
          NI		:	longint;
		LastZone	:	longint;
		LastHost	:	longint;
          Last		:	longint;
          MaxNodes	:	word;


(****************************************************************************)
(*
(*	Write a word to the WCTOSS index buffer.
(*
(****************************************************************************)
procedure	WriteWord (VAR i : longint; value : word);
		VAR s : string;
Begin
	seek (nodeindex,i);
     BlockWrite (nodeindex,value,2);
     inc (I,2);
End;

Procedure	WriteLong (VAR i : longint; Value : longint);
Begin
	seek (nodeindex,i);
     BlockWrite (nodeindex,Value,4);
     inc (I,4);
End;

(****************************************************************************)
(*
(*	Get a LINE from the file...
(*
(****************************************************************************)
Function	ReadaLine : string;
		Var amount : word;
          VAR ss : string;
          VAR a : byte;
Begin
	if (index<current) or (index>current+64000) then
     Begin
     	seek (nodelist,index);
          if (size-index<65000) then
          	amount:=Size-Index
          else
          	amount:=65000;

          Blockread (nodelist,Buffer^[0],amount);
          current:=index;
     End;

     ss:='';
     repeat
     	a:=Buffer^[index-current];
          if a<>13 then
     		ss:=ss+char(a);
          inc (index);
     until (a=13);
	inc (index);

	readaline:=ss;
End;
(****************************************************************************)
(* Return a NUMBER from a string. ends in a comma
(****************************************************************************)
Function	Rnum (s : string; i : word) : word;
		VAR s2 : string;
          VAR i2 : word;
Begin
	s2:=copy(s,i,length(s)-i);
     i2:=pos (',',s2);
     if i2=0 then
	Begin
     	Writeln ('Error in Nodelist');
          close (nodelist);
          halt;
     End;
     Rnum:=Rval (copy(s2,1,i2-1));
End;


(****************************************************************************)
(*
(*	Process a ZONE
(*
(****************************************************************************)
Procedure	ProcessZone;
	VAR z : word;
Begin
     if LastZone<>0 then
     Begin
		WriteLong (LastZone,NI);			{ write index to NEXT zone }
          WriteWord (LastZone,NoHosts);		{ write number of hosts in zone }
     End;

     z:=Rnum(s,6);			{ get ZONE }
	Writeln;
	Writeln;
	Writeln ('Zone: ',z);	{ write INFO }
     inc (zones);

     WriteWord (NI,Z);		{ write Zone number						}
     LastZone:=NI;			{ remember THIS point					}
     WriteLong (NI,0);		{ Leave NEXT ZONE index blank just now..	}
     WriteWord (NI,0);		{ Leave host number blank just now			}

     NoHosts:=0;			{ start host count						}
End;



(****************************************************************************)
(*
(*	Process a HOST or REGION.
(*
(****************************************************************************)
Procedure	ProcessHost (i : word);
		VAR z : word;
Begin
     if LastHost<>0 then
     Begin
          if (MaxNodes<NoNodes) then MaxNodes:=NoNodes;
		BlockWrite (NodeIndex,NodeBuff^[0],(NoNodes*2));
          inc (NI,NoNodes*2);
		WriteLong (LastHost,NI);			{ write index to NEXT zone }
          WriteWord (LastHost,NoNodes);		{ write number of hosts in zone }
     End;

     z:=Rnum(s,i);			{ get Hosts/Region's }
	Write (z,',');	{ write INFO }
     inc (NoHosts);
     inc (Hosts);

     WriteWord (NI,Z);		{ write Zone number						}
     LastHost:=NI;			{ remember THIS point					}
     WriteLong (NI,0);		{ Leave NEXT ZONE index blank just now..	}
     WriteWord (NI,0);		{ Leave host number blank just now			}

     NoNodes:=0;			{ start host count						}
End;

(****************************************************************************)
(*
(*	Get a number between commas. ie "????,12,????" etc...
(*
(****************************************************************************)
Function	GetNodeNumber (s : string) : word;
		VAR i : word;
		VAR s2 : string;
          VAR done : boolean;
Begin
	i:=pos (',',s); s2:=''; inc (i);  done:=False;
	repeat
     	if s[i]=',' then
			done:=true
          else
     		s2:=s2+s[i];
		inc (i);
	until (done);
     GetNodeNumber:=Rval(s2);
End;


(****************************************************************************)
(*
(*	Process the nodelist - main.
(*
(****************************************************************************)
Procedure	ProcessLine;
		VAR NodeNo : word;
Begin
	if copy (s,1,5)='Zone,' then ProcessZone
     else	if (copy (s,1,5)='Host,') then ProcessHost (6)
	else if (copy (s,1,7)='Region,') then ProcessHost (8)
     else if (s[1]<>';') then
        Begin
          NodeNo:=GetNodeNumber(s);
		NodeBuff^[NoNodes]:=NodeNo;
		inc (NoNodes);
     	inc (Nodes);
        End;
End;


(****************************************************************************)
(*
(*	Main process.. (set up etc...)
(*
(*
(****************************************************************************)
Begin
     Writeln ('WcToss NodeList Index Generator V0.1');
     Writeln ('     Copyright Mike Dailly 1994');
     Writeln;

     If (ParamCount<>1) then
     Begin
     	Writeln;
		Writeln ('WCINDEX [Path+Nodelist]');
     	halt;
     End;


     {findfirst (ParamStr(1),AnyFile,dirinfo);}

     NI:=0;
	new (buffer);
     new (nodebuff);
     assign (nodelist,ParamStr(1));
     reset (nodelist,1);
     assign (NodeIndex,'FidoList.idx');
     rewrite (NodeIndex,1);

     size:=filesize(nodelist);
	current:=$20000; index:=0; MaxNodes:=0;

     Nodes:=0; Zones:=0; LastZone:=0; LastHost:=0; Hosts:=0;
     repeat
     	s:=readaline;
          ProcessLine;
     until (done) or (size<=index);


     BlockWrite (NodeIndex,NodeBuff^[0],(NoNodes*2));
	WriteLong (LastHost,-1);			{ write index to NEXT zone }
     WriteWord (LastHost,NoNodes);		{ write number of hosts in zone }

	WriteLong (LastZone,-1);			{ write index to NEXT zone }
     WriteWord (LastZone,NoHosts);		{ write number of hosts in zone }

     close (nodelist);
     close (nodeindex);
	dispose (Buffer);
     dispose (NodeBuff);
	Writeln;
     Writeln;
	Writeln ('Zones=',zones,'.  Hosts/Regions=',Hosts,'.  Nodes=',Nodes,'.  MaxNodes=',MaxNodes,'.');
End.





