(**************************************************************************)
(*
(*                           
(*                      
(*                       
(*                  
(*            
(*            
(*             
(*             
(*                
(*                           
(*                                       
(*
(*
(*					   Wildcat mail tosser V2.7
(*
(*			     Copyright 1994,95,96 Michael Dailly
(*
(*  Copyright Notice
(*	----------------
(*
(*	  Michael Dailly retains ALL copyright to this program and its source.
(*	  The user may alter or amend the source in anyway he or she wishes.
(*	  However, the program may NOT be sold, but must be given freely and
(*	  any changes (including full source) must be sent to the Author
(*	  (Michael Dailly). Failing to do so is a violation of copyright. 
(*    The Authors name (Michael Dailly) MUST appear in the programs 
(*    copyright notice, and in any documentation, and it must clearly 
(*    state that the program is a modification of wcTOSS. The full modified 
(*	  source code must be included in the programs archive for all to 
(*	  use and examine. 
(*
(*
(*	  This copyright notice,and the authors name must remain in all files.
(*
(*
(**************************************************************************)
unit ScreenIO;

interface

uses	dos,crt,func;

const   none    = 32767;
        Center  =-1;
        HexTab  : string=('0123456789ABCDEF');

type    tScr = array[0..2000] of word;
        pScr = ^tScr;
        tScra = array[0..24,0..79] of word;
        pScra = ^tScra;


var     Scr    : pointer;
        Screen : pScr;
        ScreenA: pScra;
        Saved  : pScr;

{        tx,ty  : integer;     { text pos, X,Y }
        tc,tb  : byte;        { text colours! }
        Disk   : word;
        ls     : word;
        W1     : word;

        Menus	: array[1..20] of string;


Function Hex (c : char) : integer;
Function GetLen(s : string) : integer;
Function ReadText (s : string; x,Len,max : word) : string;
Function ReadInText (c,b,Y : integer; S : string; Len,max : integer) : string;
Function PrintOption (col,bak,y : word; s : string) : integer;
Function Menu (col,bak,def,Max : integer; VAR w : integer) : integer;

Procedure SetColour (b,c : byte);
Procedure SetXY(x,y : integer);
Procedure MyWrite (x,y: integer; s : string);
Procedure MyWriteln (x,y : integer; s: string);
Procedure MyWriteChar (x,y: integer; c : char);
Procedure SetInt29;
Procedure FreeInt29;

implementation
(****************************************************************************)
(*
(*	Screen Capturing.
(*
(****************************************************************************)
procedure IntSave; assembler;
asm
  dw 0
  dd 0
end; { IntSave }

procedure IntHandler(Flags, CS, IP, AX, BX, CX, DX,
                     SI, DI, DS, ES, BP: Word); interrupt;
begin
	MyWriteChar (none,none,Char(ax and $ff));
end;

(****************************************************************************)
(*
(*	Setup Int 29
(*
(****************************************************************************)
Procedure SetInt29;
Begin
     GetIntVec($29, Pointer(@IntSave^));	{ screen capture ON! }
     SetIntVec($29, Addr(IntHandler));
End;

(****************************************************************************)
(*
(*	Free up int 29 vector
(*
(****************************************************************************)
Procedure FreeInt29;
Begin
     SetIntVec($29, Pointer(@IntSave^));
End;

(****************************************************************************)
(* Set the Colour.
(****************************************************************************)
Procedure SetColour (b,c : byte);
Begin
	tc:=c;
     tb:=b;
End;


(****************************************************************************)
(* Return the value of a HEX dig
(****************************************************************************)
Function Hex (c : char) : integer;
         VAR i,i2 : word;
Begin
     c:=upcase(c);
     i:=0;
     for i:=1 to 16 do
      if c=HexTab[i] then i2:=i-1;
     Hex:=i2;
End;

(***************************************************************************)
(*
(*   Get the REAL length of a string! (strip control codes!)
(*
(***************************************************************************)
Function GetLen(s : string) : integer;
         VAR i,l : word;
Begin
     i:=0;
     l:=length(s);
     while (i<l) do
     Begin
           if (s[i]='#') or (s[i]=#255) then
            Begin
                dec (l,3);
                inc (i,3);
            End
           else
            inc (i);
     End;
     GetLen:=l;
End;


(***************************************************************************)
(*
(*   Set X,Y
(*
(***************************************************************************)
Procedure SetXY(x,y : integer);
Begin
	if y<>none then ty:=y else if Cwind>0 then ty:=Windows[Cwind].CY;
     if x=-1 then
          tx:=(80-ls) shr 1
     else
     if x<>none then tx:=x else if Cwind>0 then tx:=Windows[Cwind].CX;
End;

(****************************************************************************)
(*
(*	Inc Y pos in a window (also scroll window)
(*
(****************************************************************************)
Procedure IncYpos;
	VAR i : word;
Begin
	inc (ty);
     if Cwind>0 then
     Begin
      With Windows[Cwind] do
      Begin
     	if (ty>=Wycord+(Wysize-2)) then
     	Begin
     	  ty:=Wycord+Wysize-3;
            for yy:=Wycord+1 to Wycord+Wysize-4 do
              for xx:=Wxcord+1 to Wxcord+Wxsize-3 do
            	ScreenA^[yy,xx]:=ScreenA^[yy+1,xx];

            for xx:=Wxcord+1 to Wxcord+Wxsize-3 do
            Begin
            	i:=ScreenA^[Wycord+Wysize-3,xx];
               i:=(i and $ff00)+$20;
            	ScreenA^[Wycord+Wysize-3,xx]:=i;
            End;
		End;
		Windows[Cwind].Ret:=False;
          Cy:=ty;
		tx:=Wxcord+1;
      	Cx:=tx;
      End;
     End;
End;

(****************************************************************************)
(*
(*	inc X pos in a window
(*
(****************************************************************************)
Procedure IncXpos;
Begin
	inc (tx);
     if Cwind>0 then
     with Windows[CWind] do
	Begin
     	if (tx>=Wxcord+(Wxsize-2)) then
          Begin
            IncYpos;
          End;
          Cx:=tx;
     End;
End;


(****************************************************************************)
(*
(*   My Writeln with Colours etc!
(*
(****************************************************************************)
Procedure MyWrite (x,y: integer; s : string);
          VAR i : longint;
          VAR b : boolean;
          VAR xx,yy : integer;
          VAR a : byte;
Begin
     i:=1; ls:=Getlen(s);
	if Windows[Cwind].Ret then incYpos;
     SetXY(x,y);
     repeat
	 	 if Windows[Cwind].Ret then incYpos;
           if s[i]='#' then
             Begin
                CASE S[I+1] of
                 'c' : tc:=Hex(s[i+2]);
                 'b' : tb:=Hex(s[i+2]);
                End;
                inc (i,3);
             End
           else
             Begin
             	   a:=ord(s[i]);
                  if a=13 then
                     Windows[Cwind].cx:=Windows[Cwind].Wxcord+1
                  else
                     if a<>10 then
                       Begin
                  		ScreenA^[ty,tx]:=ord(s[i])+(tc*256)+((tb*256) shl 4);
                  		inc (i);
                  		incXpos;
                       End
                     else
                     	incYpos;
             End;
     until (i>Length(s));
End;

Procedure MyWriteln (x,y : integer; s: string);
Begin
     MyWrite (x,y,s);
     tx:=0;
     Windows[Cwind].Ret:=True;
End;

(****************************************************************************)
(*
(*   My WriteCHar with Colours etc!
(*
(****************************************************************************)
Procedure MyWriteChar (x,y: integer; c : char);
          VAR i : longint;
          VAR b : boolean;
          VAR xx,yy : integer;
          VAR a : byte;
Begin
	if Windows[Cwind].Ret then incYpos;
     SetXY(x,y);

     if c=#8 then
	 Begin
		if Windows[Cwind].cx>Windows[Cwind].Wxcord+1 then
     		dec(Windows[Cwind].cx);
      End
     else
     if c=#13 then
     	Windows[Cwind].cx:=Windows[Cwind].Wxcord+1
     else
     	if c<>#10 then
           Begin
          	ScreenA^[ty,tx]:=ord(c)+(tc*256)+((tb*256) shl 4);
               inc (i);
               incXpos;
           End
     	else
          	incYpos;
End;


(***************************************************************************)
(*
(*   Print up option in a windows!
(*
(***************************************************************************)
Function PrintOption (col,bak,y : word; s : string) : integer;
          VAR len,x : word;
		VAR w1: integer;
Begin
     len:=Getlen(s);
     x:=(80-(len+2)) shr 1;
	w1:=OpenWindow(x,y,len+2,3, col,bak);
     Writeln;
     tc:=col;
     tb:=bak;
     MyWrite(x+1,Y+1,s);
     PrintOption:=w1;
End;

(***************************************************************************)
(*
(*   Read in a line of text
(*
(***************************************************************************)
Function ReadText (s : string; x,Len,max : word) : string;
         VAR i,i2,i3 : word;
         VAR old,s2 : string;
Begin
     dec(len);
     old:=s;
     i:=length(s);
     if i<len then
     Begin
          s2:=s;
     End
     else s2:=copy(s,1,len);

     repeat
           waitvblank;
           i:=length(s);
           if i<len then s2:=s+'_'
           else
           Begin
                i:=length(s)-len;
                s2:=copy(s,i+1,len)+'_';
           End;
           Mywrite(x,none,spc(len+1));
           Mywrite(-1,none,s2);


           key:=#0;
           {repeat until (keypressed);}
           key:=getkey;

           if key=#8 then s:=copy(s,1,length(s)-1);
           if (key>#31) and (key<=#127) and (length(s)<max) then
                s:=s+key;


     until (key=#13) or (key=#27);
     if key=#27 then
     Begin
          ReadText:=Old;
          exit;
     End;
     ReadText:=s;

End;

(***************************************************************************)
(* Get Installation DIR
(***************************************************************************)
Function ReadInText (c,b,Y : integer; S : string; Len,max : integer) : string;
         VAR x,w2 : word;
Begin
     x:=(80-(len+2)) shr 1;
	w2:=OpenWindow(x,Y,len+2,3, c,b);
     tc:=c;
     tb:=b;
     SetXY(none,Y+1);
     MyWriteln(none,none,' ');
     ReadInText:=ReadText(s,x+1,Len,max);
     CloseWindow(w2);
End;


(***************************************************************************)
(*
(*	Do MENU selection..
(*
(*   Format:
(*		  '#cF#b1text here'      = normal selectable
(*		  '#cF#b1text here'+#255 = non-selectable
(*
(***************************************************************************)
Function Menu (col,bak,def,Max : integer; VAR w : integer) : integer;
          VAR y,l2,len,x : word;
		VAR i,xx,yy,w1: integer;
          VAR cur : word;
          VAR ch : char;
Begin
	len:=0;
	for w1:=1 to Max do
     Begin
       l2:=getLen(Menus[w1]);
       if l2>len then len:=l2;
     End;

     x:=(80-(len+2)) shr 1;
     y:=(25-Max) div 2;
     if w<=0 then
		w:=OpenWindow(x,y,len+2,Max, col,bak)
     else
        SetWindow(W);


     cur:=def;
     ch:=Menus[cur][3];
     Menus[cur][3]:=Menus[cur][6];
     Menus[cur][6]:=ch;
     key:=#0;
	repeat
          if (key IN ['H','P']) then
          Begin
     			ch:=Menus[cur][3];
     			Menus[cur][3]:=Menus[cur][6];
     			Menus[cur][6]:=ch;
          End;
          case key of
            'P' : repeat
            			inc (Cur);
                    	if Cur>Max then Cur:=1;
                  until (Menus[Cur][length(Menus[cur])]<>'');
            'H' : repeat
            		dec (Cur);
                    if Cur=0 then Cur:=Max;
                  until (Menus[Cur][length(Menus[cur])]<>'');
          end;
          if (Key IN ['P','H']) then
          Begin
     			ch:=Menus[cur][3];
     			Menus[cur][3]:=Menus[cur][6];
     			Menus[cur][6]:=ch;
		End;
          xx:=x; yy:=y;
          for i:=1 to MAX do Begin MyWrite (xx,yy,Menus[i]); inc (yy); End;



          key:=#0;
          repeat until (keypressed);
     	key:=getkey;
     until (key=#13) or (key=#27);
	Menu:=Cur;
End;

(****************************************************************************)
(* Install
(****************************************************************************)
Begin

     Scr:=Ptr(segb800,0);
     Screen:=Scr;
     ScreenA:=Scr;
End.
