/* 
  You can do whatever You want with it. But there is no warranty
  nor even implied warranty on both binary and code provided.
*/

#include <stdio.h>
#include <locale.h>
#include <curses.h>

#define PCOL 1024
#define PROW 1024

int buffer[PCOL][PROW];
int bufferu[PCOL][PROW];

int lines=0;
int cols=0;

int conv_table[2][256]={
{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255},
{0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,199,252,233,226,228,224,229,231,234,235,232,239,238,236,196,197,201,230,198,244,246,242,251,249,255,214,220,162,163,165,8359,402,225,237,243,250,241,209,170,186,191,8976,172,189,188,161,171,187,9617,9618,9619,9474,9508,9569,9570,9558,9557,9571,9553,9559,9565,9564,9563,9488,9492,9524,9516,9500,9472,9532,9566,9567,9562,9556,9577,9574,9568,9552,9580,9575,9576,9572,9573,9561,9560,9554,9555,9579,9578,9496,9484,9608,9604,9612,9616,9600,945,223,915,960,931,963,181,964,934,920,937,948,8734,966,949,8745,8801,177,8805,8804,8992,8993,247,8776,176,8729,183,8730,8319,178,9632,160}
};

int conv2utf8(int charin) {

  int r=0;

  r=conv_table[1][charin];

  return(r);

}

void init_buffer() {

  int i;
  int j;

  for (j=0;j<PROW;j++) {
    for (i=0;i<PCOL;i++) {
      buffer[i][j]=0;
      bufferu[i][j]=0; 
    }
  }
}

void print_ansi_file() {

  int i;
  int j;

  for (j=0;j<PROW;j++) {
    for (i=0;i<PCOL;i++) {
      printf("%lc",bufferu[i][j]);
      if(buffer[i][j]==10) { break; } 
    }
    if (j==lines) { printf("\n"); break; }
  }
}

void print_page(int shift) {

  int i;
  int j;

  for (j=shift;j<LINES+shift;j++) {
    for (i=0;i<PCOL;i++) {
      printf("%lc",bufferu[i][j]);
      if (buffer[i][j]==10) { break; }
    }
  }
}

void convert_buffer() {

  int i,j;

  for (j=0;j<PROW;j++) {
    for (i=0;i<PCOL;i++) {
      bufferu[i][j]=conv2utf8(buffer[i][j]);
      if (buffer[i][j]==10) { break; }
    }
  } 
}

void read_ansi_file(char *fName) {

  int c;
  FILE *file;
  file = fopen(fName, "r");

  if (file) {
    while ((c = getc(file)) != EOF) {
      buffer[cols][lines]=c;
      cols++;
      if (cols>PCOL || c==10) { lines++; cols=0; }
    }
    fclose(file);
  }
}

void init_console() {
  setlocale(LC_ALL, "");
  initscr();
  nonl(); 
  noecho();
}

void deinit_console(int mode) {
  endwin();
  nl();
  echo();
  if (mode==1) {  printf ("\e[2J\e[0;0H\e[1;37;40mn\r"); }
}

int main(int argc, char **argv) {

  init_buffer();

  if (argc==2) {
    init_console();
    read_ansi_file(argv[1]);
    convert_buffer();
    print_ansi_file(argv[1]);
    deinit_console(0);
  } else {
    printf("Usage: ansiu <filename.ans>\n");
  }

  return (0);

}
