Program Update;
(*

   Simple program to update T-Hangman score file from version 1.6 to 1.7

Originally Written: 8/25/1998

Last Modified: 8/26/1998

*)
{$IFDEF OS2}
uses
  Os2Def;
{$ENDIF}

{$IFDEF VPDEMO}
  {&Dynamic VP11Demo.Lib}               { Required by demo version of VP }
{$ENDIF}

Type
  Old_Score=Record              { Begin score file struct        }
    scorename: String[25];      { Users name                     }
    scorepoints: LongInt;       { Users points                   }
    {$IFDEF OS2}                { OS/2 uses LongInts for these:  }
    numofplays: Longint;        { Stored # of plays remaining    }
    d: Longint;                 { Day user last played (DD)      }
    m: Longint;                 { Month user last played (MM)    }
    y: Longint;                 { Year user last played (YYYY)   }
    hour: Longint;              { Hour user last played (24 Hr.) }
    min: Longint;               { Minute user last played        }
    {$ELSE}                     { And DOS uses Words for these:  }
    numofplays: Integer;        { Stored # of plays remaining    }
    d: Word;                    { Day user last played (DD)      }
    m: Word;                    { Month user last played (MM)    }
    y: Word;                    { Year user last played (YYYY)   }
    hour: Integer;              { Hour user last played (24 Hr.) }
    min: Integer;               { Minute user last played        }
    {$ENDIF}
  end;                          { End score file struct          }

  New_Score=Record              { Begin score file struct        }
    scorename: String[25];      { Users name                     }
    scorepoints: LongInt;       { Users points                   }
    numofplays: Integer;        { Stored # of plays remaining    }
    MonthPlays: Longint;        { Number of plays this month     }
    {$IFDEF MSDOS}              { DOS Requires Word's            }
    d: Word;                    { Day user last played (DD)      }
    m: Word;                    { Month user last played (MM)    }
    y: Word;                    { Year user last played (YYYY)   }
    hour: Word;                 { Hour user last played (24 Hr.) }
    min: Word;                  { Minute user last played        }
    {$ELSE}                     { OS/2/Win32 Requires Longints   }
    d: Longint;                 { Day user last played (DD)      }
    m: LongInt;                 { Month user last played (MM)    }
    y: LongInt;                 { Year user last played (YYYY)   }
    hour: LongInt;              { Hour user last played (24 Hr.) }
    min: LongInt;               { Minute user last played        }
    {$ENDIF}
  end;                          { End score file struct          }

var
  Oldone: Old_Score;                    { Old score record }
  Newone: New_Score;                    { New score record }
  F_Old: File;                          { Old score file }
  F_New: File;                          { New score file }

Procedure Transfer;
begin
  FillChar(Newone, SizeOf(Newone), #0);
  Newone.Scorename := Oldone.Scorename;
  Newone.Scorepoints := Oldone.Scorepoints;
  Newone.Numofplays := Oldone.Numofplays;
  Newone.Monthplays := 0;
  Newone.D := Oldone.D;
  Newone.M := Oldone.M;
  Newone.Y := Oldone.Y;
  Newone.Hour := Oldone.Hour;
  Newone.Min := Oldone.Min;
end;

begin
  Assign(F_Old, 'SCORES.DAT');
  {$I-}
  Reset(F_Old, 1);
  {$I+}
  if IOResult <> 0 then
  begin
    WriteLn;
    WriteLn('Couldn''t open SCORES.DAT - Aborting.');
    Halt(255);
  end;
  Assign(F_New, 'TEMP.$$$');
  {$I-}
  Rewrite(F_New, 1);
  {$I+}
  if IOResult <> 0 then
  begin
    WriteLn;
    WriteLn('Couldn''t create temp file - Aborting.');
    Halt(255);
  end;
  While not Eof(F_Old) do
  begin
    FillChar(Oldone, SizeOf(Oldone), #0);
    Blockread(F_Old, Oldone, SizeOf(Oldone));
    Transfer;
    BlockWrite(F_New, Newone, SizeOf(Newone));
  end;
  Close(F_Old);
  Close(F_New);
  {$I-}
  Rename(F_Old, 'SCORES.OLD');
  {$I+}
  If IOResult <> 0 then
  begin
    WriteLn;
    WriteLn('Couldn''t rename SCORES.DAT - Aborting.');
    Halt(255);
  end;
  {$I-}
  Rename(F_New, 'SCORES.DAT');
  {$I+}
  If IOResult <> 0 then
  begin
    WriteLn;
    WriteLn('Couldn''t rename temp file - Aborting.');
    Halt(255);
  end;
  WriteLn;
  WriteLn('Success!');
end.