unit enigma;

interface

uses
  crt;

procedure Pipeln(S: String);
procedure Pipe(S: String);
function Itos(N: Integer): String;
{$IFDEF MSDOS}
Function stoi(s: string): Integer;
{$ELSE}
Function stoi(s: string): LongInt;
{$ENDIF}
{$IFDEF MSDOS}
{UnCrunches TheDraw pascal Crunched ANSi's}
procedure Uncrunch(var addr1, addr2; blklen: integer);
procedure CursorOff;
procedure CursorOn;
{$ENDIF}
{$IFDEF LINUX}
Function Inpt(Len, Xpos, Ypos, Attr1, Attr2: Byte; Limiter: Char; Def: String): String;{These last 2 funcs taken from SWAG..}
{$ENDIF}
function Long2Hex(L: LongInt): String;
function Byte2Hex(Numb : Byte): String;
Procedure CrLf;
Function PipeLength(S: String): Byte;
Function Center(S: String): String;
(*{$IFDEF MSDOS}*)
(*{$IFDEF LINUX}*)
Function strupcase(s: String): String;
Function delfile(s: String): Boolean;
Function Exist(s: String): Boolean;
(*{$ENDIF}*)
(*{$ENDOF}*)
implementation

Function Byte2Hex(numb : Byte): string;
Const
  HexChars : Array[0..15] of Char = '0123456789ABCDEF';
begin
  Byte2Hex[0] := #2;
  Byte2Hex[1] := HexChars[numb shr  4];
  Byte2Hex[2] := HexChars[numb and 15];
end;

Function Numb2Hex(numb: Word): String;
begin
  Numb2Hex := Byte2Hex(hi(numb))+Byte2Hex(lo(numb));
end;

Function Long2Hex(L: LongInt): String;
begin
  Long2Hex := Numb2Hex(L shr 16) + Numb2Hex(L);
end;

function itos(n: integer): string;
var
  v: string;
begin
  str(n,v);
  itos:=v;
end;

{$IFDEF MSDOS}
Function stoi(s: string): Integer;
var
  i, code: Integer;
begin
  val(s, i, code);
  stoi := i;
end;
{$ELSE}
Function stoi(s: string): LongInt;
var
  i, code: LongInt;
begin
  val(s, i, code);
  stoi := i;
end;
{$ENDIF}

{$IFDEF LINUX}
Function Inpt(Len, Xpos, Ypos, Attr1, Attr2: Byte; Limiter: Char; Def: String): String;
var
  P: Byte;                              { Current position in string }
  B: Byte;                              { Temp byte }
  Ch: char;                             { Char to be processed }
  S: String;                            { String to work with }
  OTa: Byte;                            { Saved text attribute }
  FirstKey: Boolean;                    { Is this the first pressed key? }
begin
  FirstKey := TRUE;
  OTa := TextAttr;
  GotoXY(Xpos,Ypos);
  Textcolor(Attr2);
  for B := 1 to len do Write(Limiter);
  for B := 1 to len do Write(#8);
  Textcolor(Attr1);
  if Length(Def) > Len then S := Copy(Def, 1, Len) else
    S := Def;
  Write(S);
  P := Length(S);
  repeat
    Ch := Readkey;
    if FirstKey then
    begin
      if Ch in [#32..#126] then begin
        GotoXY(Xpos,Ypos);
        Textcolor(Attr2);
        for B := 1 to len do Write(Limiter);
        for B := 1 to len do Write(#8);
        Textcolor(Attr1);
        S := '';
        P := 0;
      end;
      FirstKey := FALSE;
    end;
    case Ch of
      #1..#7,#10..#12,#14..#31,#127..#255 : Ch := #0;
      #08 : begin
        if Length(S) > 0 then
        begin
          if P = Length(S) then
          begin
            Dec(S[0]);
            Dec(P);
            Write(#8);
            TextColor(Attr2);
            Write(Limiter);
            TextColor(Attr1);
            Write(#8);
          end else if P > 0 then
          begin
            Delete(S, P, 1);
            GotoXY(WhereX - 1, Ypos);
            Write(Copy(S, P, Length(S)));
            Dec(P);
            TextColor(Attr2);
            Write(Limiter);
            TextColor(Attr1);
            GotoXY(Xpos + P, Ypos);
          end;
        end;
      end;
      #13 : ;
      #00 : begin
        Ch := ReadKey;
        case Ch of
          #83 : begin { Del }
            if P < Length(S) then
            begin
              Delete(S, P + 1, 1);
              Write(Copy(S, P + 1, Length(S)));
              TextColor(Attr2);
              Write(Limiter);
              TextColor(Attr1);
              GotoXY(Xpos + P, Ypos);
            end;
          end;
          #75 : begin { Left }
            if (P > 0) AND (Length(S) > 0) then
            begin
              Dec(P);
              GotoXY(WhereX - 1, Ypos);
            end;
          end;
          #77 : begin { Right }
            if (P < Length(S)) AND (Length(S) < Len) then
            begin
              Inc(P);
              Write(S[P]);
            end;
          end;
          #71 : begin { Home }
            P := 0;
            GotoXY(Xpos, Ypos);
          end;
          #79 : begin { End }
            P := Length(S);
            GotoXY(Xpos + P, Ypos);
          end;
        end;
      end;
      else
      begin
        if (P = Length(S)) AND (Length(S) < Len) then
        begin
          S := S + Ch;
          Write(Ch);
          Inc(P);
        end else if (P < Length(S)) then
        begin
          Inc(P);
          Insert(Ch, S, P);
          if Length(S) > Len then Dec(S[0]);
          Write(Copy(S, P, Length(S)));
          GotoXY(Xpos + P, Ypos);
        end;
      end;
    end;
  until (Ch = #13);
  Inpt := S;
  TextAttr := OTa;
end;
{$ENDIF}

{$IFDEF MSDOS}
procedure Uncrunch(var addr1, addr2; blklen: integer);
begin
  inline (
    $1E/$C5/$B6/ADDR1/$C4/$BE/ADDR2/$8B/$8E/blklen/$E3/$5B/$8B/$D7/
    $33/$C0/$FC/$AC/$3C/$20/$72/$05/$AB/$E2/$F8/$EB/$4C/$3C/$10/$73/$07/
    $80/$E4/$F0/$0A/$E0/$EB/$F1/$3C/$18/$74/$13/$73/$19/$2C/$10/$02/$C0/
    $02/$C0/$02/$C0/$02/$C0/$80/$E4/$8F/$0A/$E0/$EB/$DA/$81/$C2/$A0/$00/
    $8B/$FA/$EB/$D2/$3C/$1B/$72/$07/$75/$CC/$80/$F4/$80/$EB/$C7/$3C/$19/
    $8B/$D9/$AC/$8A/$C8/$B0/$20/$74/$02/$AC/$4B/$32/$ED/$41/$F3/$AB/$8B/
    $CB/$49/$E0/$AA/$1F);
end;

procedure CursorOff; assembler;
asm
  mov ah, $01
  mov cx, $FFFF
  int $10
end;

procedure CursorOn; assembler;
asm
  mov ah, $01
  mov cx, 1543
  int $10
end;
{$ENDIF}

Procedure Pipe(S: String);
var
  F, U: Byte;
  {$IFDEF MSDOS}
  Z: Word;
  {$ELSE}
  Z: LongInt;
  {$ENDIF}
  J, Buf: string;
  PipeOff: boolean;

  Procedure Flushbuf;
  begin
  if Buf <> '' then
    begin
      Write(Buf);
      Buf := '';
    end;
  end;

begin
  if S= '' then Exit;
  U := 0;
  PipeOff := FALSE;
  Buf := '';
  repeat
    Inc(U);
    j := S[U + 1] + S[U + 2];
    Val(J, F, Z);
    if (S[U]='|') and (Z <> 0) then
    begin
      if (J = '') then
      begin
        PipeOff := FALSE;
        if ((Length(S) - U) >= 2) then Inc(U, 2);
      end else if (J = '') then
      begin
        PipeOff := TRUE;
        if ((length(S) - U) >= 2) then Inc(U, 2);
      end else if (J = 'cr') and (not PipeOff) then
      begin
        CrLf;
        if ((Length(S) - U) >= 2) then Inc(U, 2);
      end else Buf := Buf + '|';
    end else if (S[U] = '|') and (F in [0..31]) and (not pipeOff) then
    begin
      Flushbuf;
      case F of
        0 : begin
          TextBackGround(0);
          TextColor(7);
          Delete(S,U,2);
        end;
        1..15 : begin
          TextColor(F);
          Delete(S,U,2);
        end;
        16..31 : begin
          TextBackGround(F - 16);
          Delete(S,U,2);
        end;
      end;
    end else Buf := Buf + S[U];
  until (U = Length(S));
  Flushbuf;
end;

Procedure PipeLn(S: String);
begin
  Pipe(S);
  WriteLn;
end;

Procedure CrLf;
begin
  WriteLn;
end;

Function PipeLength(S: String): Byte;
var
  c, i: Byte;
begin
  c := Length(S);
  for i := 1 to Length(S) do
    if S[i] = '|' then dec(c, 3);
  PipeLength := c;
end;

Function Center(S: String): String;
var
  i, k: integer;
  j: string;
begin
  j := '';
  k := (Lo(WindMax) div 2) - (PipeLength(S) div 2);
  for i := 1 to k do
    j := j + ' ';
  Center := j + S;
end;

Function Strupcase(S: String): String;
var
  a: Integer;
begin
  for a:=1 to length(S) do s[a]:=upcase(s[a]);
  strupcase:=s;
  end;

Function delfile(s: String): Boolean;
var
  f: File;
begin
  Assign(F, s);
  {$I-}erase(f);{$I+}
  if ioresult<>0 then delfile:=False else delfile:=True;
end;

Function Exist(s: String): Boolean;
var
  f: File;
  Oldmode: BYte;
begin
  OldMode:=Filemode;
  Filemode:=0;
  Assign(F,S);
  {$I-}Reset(F);{$I+}
  Exist := ioresult<>0;
  Filemode:=Oldmode;
end;
end.
