unit Pipes;
{
Lord and Pipe color code unit (Adapted for the 'net)

Written by Stewart Honsberger

Originally Written: 1/6/1998

Last Modified: 2/2/1998
}
INTERFACE

Procedure Pipe(Thestring: String);
Procedure PipeLn(Thestring: String);

IMPLEMENTATION

var
  S: String;

Procedure Lord;
Var
   C: Char;
   Blah: String;
Begin
  while (Length(S) >= 1) AND (S[1] <> '|') do begin
      if S[1] = '`' then begin
      Blah := Copy(S,2,1);
      C := Blah[1];
      if Length(S) >= 1 Then
      case C Of
        '1': Write('<FONT COLOR="Blue">');
        '2': Write('<FONT COLOR="Green">');
        '3': Write('<FONT COLOR="Cyan">');
        '4': Write('<FONT COLOR="Red">');
        '5': Write('<FONT COLOR="Purple">');
        '6': Write('<FONT COLOR="Yellow">');
        '7': Write('<FONT COLOR="#CFCFCF">');
        '8': Write('<FONT COLOR="#7F7F7F">');
        '9': Write('<FONT COLOR="#0000FF">');
        '0': Write('<FONT COLOR="#00FF00">');
        '!': Write('<FONT COLOR="#00FFFF">');
        '@': Write('<FONT COLOR="#FF0000">');
        '#': Write('<FONT COLOR="#FF00FF">');
        '$': Write('<FONT COLOR="Yellow">');
        '%': Write('<FONT COLOR="White">');
        else Write(S[1] + S[2]);
      end;
      Delete(S, 1, 2);
    end else begin
      Write(S[1]);
      Delete(S, 1, 1);
    end;
  end;
end;

Procedure Bars;
Var
   B: Byte;
   C: Integer;
 {$IFDEF MSDOS}
   I: Integer;
 {$ELSE}
   I: Longint;
 {$ENDIF}
Begin
  B:=1;
  while (B <= Length(S)) AND (S[B + 1] <> '`') do begin
    if (S[B] = '|') AND ((Length(S) - B) >= 2) then begin
      Inc(B);
      Val(Copy(S,B,2), C, I);
      if B <= Length(S) Then
      case C Of
        1: Write('<FONT COLOR="Blue">');
        2: Write('<FONT COLOR="Green">');
        3: Write('<FONT COLOR="Cyan">');
        4: Write('<FONT COLOR="Red">');
        5: Write('<FONT COLOR="Purple">');
        6: Write('<FONT COLOR="Yellow">');
        7: Write('<FONT COLOR="#CFCFCF">');
        8: Write('<FONT COLOR="#7F7F7F">');
        9: Write('<FONT COLOR="#0000FF">');
        10: Write('<FONT COLOR="#00FF00">');
        11: Write('<FONT COLOR="#00FFFF">');
        12: Write('<FONT COLOR="#FF0000">');
        13: Write('<FONT COLOR="#FF00FF">');
        14: Write('<FONT COLOR="Yellow">');
        15: Write('<FONT COLOR="White">');
        else Write(S[B - 1] + S[B] + S[B + 1]);
      end;
      Inc(B, 2);
    end else begin
      Write(S[B]);
      Inc(B);
    end;
  end;
  Delete(S, 1, B - 1);
end;

Procedure Pipe(Thestring: String);
begin
  S := Thestring;
  While Length(S) > 0 do begin
    If S[1] = '|' then begin
      Bars;
    end else if S[1] = '`' then begin
      Lord;
    end else begin
      Write(S[1]);
      Delete(S, 1, 1);
    end;
  end;
end;

Procedure PipeLn(Thestring: String);
begin
  Pipe(Thestring);
  WriteLn('<BR>');
end;

begin
end.
