Unit dspin;
{
                DSpin - Door version of Spinning Curser Input
                             - Sep 05 / 1997
                This Unit has my new Funky Input routine.
                Also has the dynlb stuff from Enigma
}

interface

function ReadKeySpin(wait : Byte) : Char;
function readnospinkey : Char;
function ReadStringSpin(Len, X, Y, Attr1, Attr2: Byte; Limiter: Char): String;
function DPipeStrLen(S: String): Byte;
function Tdnylb(quest, ys, ns: string): boolean;
function Tdynlb(quest, ys, ns: string): boolean;

implementation
Uses
{$IFDEF OS2}
  os2base,
  Door2,
{$ELSE}
  door,
{$ENDIF}
  Crt;

Const
  SpinChar : Array [1..4] of Char = ('','/','','\');

Function ReadKeySpin(Wait : Byte) : Char;
Var
  X,Y  : Byte;
  Num  : Byte;
  Ch   : Char;
begin
  Num := 1;                               (* initialize SpinChars  *)
  X   := WhereX;                          (* Where am I ??         *)
  Y   := WhereY;
  Repeat
    DGotoXY(X, Y);                   (* Go back               *)
    DPipe(SpinChar[Num]);           (* Spin the Cursor       *)
    Delay(Wait);                    (* Wait, it's to fast!   *)
    DGotoXY(X, Y);                   (* Go back               *)
{    DWrite(#8); }
    Inc(Num);                       (* Next SpinChar, please *)
    if Num = 5 then Num := 1;       (* I have only 5 Chars   *)
  Until DKeyPressed;
  DReadc(ch);                        (* Get the pressed Key   *)
  ReadKeySpin := Ch;                    (* give a result         *)
end;

function readnospinkey : Char;
Var
  Ch   : Char;
begin
  Repeat
    {$IFDEF OS2}
      dossleep(1);
    {$ENDIF}
  Until DKeyPressed;
  DReadc(ch);                            { Get the pressed Key   }
  ReadNoSpinKey:= Ch;                    { give a result         }
end;

function ReadStringSpin(Len, X, Y, Attr1, Attr2: Byte; Limiter: Char): String;
var
  i: integer;
 ch: char;
  s: string;
begin
  dgotoxy(x,y);
  fg(Attr2);
  for i:=1 to len do dwrite(Limiter);
  for i:=1 to len do dwrite(#8);
  fg(Attr1);
  x:=wherex;
  y:=wherey;
  s:='';
  repeat
    ch:=ReadKeySpin(40);
    if (ch<>#8) and (ch<>^M) and (ch<>#9) and (length(s)<Len) then
      begin
        if ch in [#1..#7,#10..#12,#14..#31,#127..#255] then ch:=#0 else
        begin
          s:=s+ch;
          DPipe(ch);
        end;
      end;
    if (ch=chr(8)) and (length(s)>0) then
      begin
        delete(s,length(s),1);
        DPipe(chr(8));
        fg(Attr2);
        DPipe(Limiter);
        fg(Attr1);
        dPipe(#8);
      end;
  until (ch=^M) or (ch=#9);
  readstringspin:=s;
end;

function DPipeStrLen(S: String): Byte;
Var
  C: Byte;
  B: Integer;
Begin
  C:=Length(S);
  For B:=1 to Length(S) Do
    If S[B]='|' Then Dec(C, 3);
  DPipeStrLen:=C;
End;

function Tdynlb(quest, ys, ns: string): boolean;
var
  ch    : char;
  i,j   : integer;
  yn    : char;
  ysl,
  nsl   : integer;

procedure yes(b: boolean);
var
  i: integer;
begin
  for i:=1 to ysl do
    dwrite(#8);
  if b=true then
    dpipe(ys)
  else dpipe(ns);
end;

begin
  Ysl:=DPipeStrLen(Ys);
  dpipe('|09'+quest+ys);
  tdynlb:=true;
  repeat
    dreadc(ch);
    ch:=upcase(ch);
    if ch in ['Y','D','4',#75] then {'y','d',#75}
      yn:='Y';
    if ch in ['N','C','6',#77] then {'y','c',#77}
      yn:='N';
    case yn of
      'Y': begin
             yes(true);
             tdynlb:=true;
           end;
      'N': begin
             yes(false);
             tdynlb:=false;
           end;
    end;
  until ch=#13;
  DCrlf;
end;


function Tdnylb(quest, ys, ns: string): boolean;
var
  ch: char;
  i,j: integer;
  yn: char;
  ysl, nsl: integer;

procedure yes(b: boolean);
var
  i: integer;
begin
  for i:=1 to nsl do
    dwrite(#8);
  if b=true then
    dpipe(ys)
  else dpipe(ns);
end;

begin
  Nsl:=DPipeStrLen(Ns);
  dpipe('|09'+quest+Ns);
  tdnylb:=false;
   repeat
    dreadc(ch);
    ch:=upcase(ch);
    if ch in ['Y','D','4',#75] then {D}
      yn:='Y';
    if ch in ['N','C','6',#77] then {C}
      yn:='N';
    case yn of
      'Y': begin
             yes(true);
             tdnylb:=true;
           end;
      'N': begin
             yes(false);
             tdnylb:=false;
           end;
    end;
  until ch=#13;
  DCrlf;
end;

begin
end.
