Unit CgiStf;
{
  This unit is for my CGI programs.  Has the commands from strstf and
  my pipe etc.
        Oct 28 1997
}
interface

function stoi(s: string): longint;
function strupcase(s: string): string;
function scmp(s, s1: string): boolean;
function token(c: char; var s: string): string;
procedure crlf;
function convert(s: string): string;
function itos(n: longint): string;               {Integer to String}
function exedir: string;                         {Get the Main directory}
function delfile(s: string): boolean;

implementation

function stoi(s: string): longint;
var
  {$IFDEF MSDOS}
  i: Integer;
  j: Integer;
  {$ELSE}
  i: longint;
  j: longint;
  {$ENDIF}
begin
  val(s, i, j);
  stoi:=i;
end;

function strupcase(s: string): string;
var
  i: integer;
begin
  for i:=1 to length(s) do s[i]:=upcase(s[i]);
  strupcase:=s;
end;

function scmp(s, s1: string): boolean;
begin
  if strupcase(s)=strupcase(s1) then
    scmp:=true else scmp:=false;
end;

function token(c: char; var s: string): string;
var tmp: string;
begin
  if (pos(c, s)<>0) then
    begin
      tmp:=copy(s, 1, pos(c, s)-1);
      delete(s, 1, pos(c, s));
    end else
    begin
      tmp:=copy(s, 1, length(s));
      delete(s, 1, length(s));
    end;
  token:=tmp;
end;

Procedure CrLf;
Begin
  WriteLn('<BR>');
end;

function convert(s: string): string;
var
  s1: string;
  i: integer;
  {$IFDEF MSDOS}
  j, k: Integer;
  {$ELSE}
  j, k: LongInt;
  {$ENDIF}
begin
  for i:=1 to length(s) do if s[i]='+' then s[i]:=' ';
  repeat
    i:=pos('%', s);
    if i>0 then
      begin
        s1:=copy(s, i+1, 2);
        delete(s, i, 3);
        s1:='$'+s1;
        val(s1, j, k);
        if k=0 then
          begin
            s1:=char(j);
            insert(s1, s, i);
          end;
      end;
  until pos('%', s)=0;
  convert:=s;
end;

function delfile(s: string): boolean;
var f: file;
begin
  assign(f, s);
  {$I-}erase(f);{$I+}
  if ioresult<>0 then delfile:=false else delfile:=true;
end;

function exedir: string;                         {Get the Main directory}
var
  s: string;
begin
  s:=paramstr(0);
  while s[length(s)]<>'\' do dec(s[0]);
  exedir:=s;
end;

function itos(n: longint): string;               {Integer to String}
var s: string;
begin
  str(n, S);
  ItoS:=S;
end;


begin
end.
