Program EzyWhoCGI;
{
        EzyWhoCGI - Display Today's and Yesterday's callers to your
        webpage of Ezycom 2.15 or newer.
        Written by: Shawn Highfield on Jan 22 2015

        TODO:



        DONE:   Jan 23 2015
                If no callers today don't crash - happily go to Yesterday
                Display No callers today if none.
                Make all the graphics configurable.
                Jan 26 2015
                What is no yesterday's callers?
}

uses
  Pipes,
  dos;

type
    (* **********************************************************
       Filename:    <systempath>TODAY.BBS
                    <systempath>YESTER.BBS
       Last Update: 1/2/94
       Description: Used by Ezycom to today's/yesterday's callers
       ********************************************************** *)
       ontodayrecord = record
          line        : byte;
          name        : string[35];
          alias       : string[35];
          location    : string[25];
          baudrate    : longint;
          logontime   : smallword;
          logofftime  : smallword;
          didwhat     : byte;
          (* Bit 0 : (N) NewUser
                 1 : (U) Upload
                 2 : (D) Download
                 3 : (R) Read Mail
                 4 : (S) Sent Mail
                 5 : (O) Outside
                 6 : (C) Chat to Sysop and/or User
                 7 : (P) Paged *)
          freespace   : array[1..20] of char;
       end;
   todaytype = array[1..22] of ontodayrecord;

var
  fv: File;// of todaytype; BLOCKREAD only uses UNTYPED file types
  todayrec: ^TodayType;
  TmpFile: File;
  CurPos: Word;
  NumRead: LongInt;
  Loop: Word;
  NewHour, NewMin: String;      {Logon / Logoff Time}
  TieVersion: String;           {Version of program}
  TheDataFile: String;          {Path to ezycom's today.bbs / yester.bbs}
  MainURL: String;              {Main web site: ie: www.tinysbbs.com}
  Colours: String;              {HTMl Colour settings}
  TodaysPic: String;            {Today's Callers Picture}
  YesterPic: String;            {Yesterday's Callers Picture}
  JumpNow: BooLean;             {Jump to Yesterday if no callers today}
  Noyesterday: Boolean;         {No callers Yesterday either}

(*----------HANDY FUNCTIONS------------*)
function itos(n: longint): string;
var s: string;
begin
  str(n, S);
  ItoS:=S;
end;

function exedir: string;                         {Get the Main directory}
var
  s: string;
begin
  s:=paramstr(0);
  while s[length(s)]<>'\' do dec(s[0]);
  exedir:=s;
end;
(*----------------------------------*)

Procedure NotFound;            {This is shown in case of a file error}
begin
  WriteLn('<HTML>');
  WriteLn('<TITLE>Last Callers</TITLE>');
  WriteLn('<BR>');
  WriteLn('<FONT COLOR="Blue"><FONT SIZE=+4>The last callers list is blank.</FONT></FONT><BR>');
  WriteLn('<FONT COLOR="White">');
  WriteLn('<BR>');
  WriteLn('<A HREF="' + mainurl + '"Back to original page</A> <BR>');
  WriteLN('<BR>');
  WriteLn('<Font Color="Cyan">' + TieVersion);
  Write('<FONT COLOR="Yellow">Written by: Shawn ''<A HREF="');
  WriteLn('mailto://shighfield@gmail.com">Tiny</A>'' Highfield<BR>');
  WriteLn('<A HREF="http://www.tinysbbs.com">Tiny''s BBS</A>');
  WriteLn('</HTML>');
end;

Procedure ReadTheConfig;
var
  f: Text;
begin
  Assign(F, exedir + 'ezywho.cfg');
  {$I-}Reset(f);{$I+}
  if ioresult<>0 then                           {File not found!}
  begin
    NotFOund;
    Halt;
  end;
  ReadLn(F, TheDataFile);                       {Get the datafile path}
  ReadLn(F, mainurl);                           {The URL to return to in case of error etc.}
  ReadLn(F, colours);                           {Colour settings}
  ReadLn(F, Todayspic);                         {The path / image for today's}
  ReadLn(F, Yesterpic);                         {Path / image for yesterday's}
  Close(F);
end;

Procedure TableSetup;
begin
  WriteLn('<table style="text-align: left; width: 55%;" border="1" cellpadding="2" cellspacing="2">');
  WriteLn('<tbody>');
  WriteLn('<tr>');
  WriteLn('<td style="vertical-align: top; width: 45%">');
  Pipe('|15U|07ser|15n|07ame');
  WriteLn('</TD>');
  WriteLn('<td style="vertical-align: top; width: 22%">');
  Pipe('|15L|07ocation');
  WriteLn('</TD>');
  WriteLn('<td style="vertical-align: top; width: 10%">');
  Pipe('|15L|07ogon');
  WriteLn('</TD>');
  WriteLn('<td style="vertical-align: top; width: 10%">');
  Pipe('|15L|07ogoff');
  WriteLn('</TD>');
end;

Procedure CheckToday;
begin
  Assign(fv,TheDataFile + 'today.bbs');
  {$I-}reset(fv);{$I+}
  If ioresult<>0 then begin
    Notfound;
    Halt;
  end else
  if (filesize(fv) = 0) then JumpNow := True;
end;

Procedure CheckYesterday;
begin
  Assign(fv,TheDataFile + 'yester.bbs');
  {$I-}reset(fv);{$I+}
  If ioresult<>0 then begin
    Notfound;
    Halt;
  end else
  if (filesize(fv) = 0) then NoYesterday := True;
end;


Procedure Today;
begin
  WriteLN('<IMG SRC="' + TodaysPic + '">');
  TableSetup;
  CurPos := 0;
  Loop := 1;
  Assign(fv,TheDataFile + 'today.bbs');
  {$I-}reset(fv);{$I+}
  If ioresult<>0 then begin
    Notfound;
    Halt;
  end else
  seek(fv,filesize(fv));       {Found it!}
  New(TodayRec);
  seek(fv,loop-1);
  blockread(fv,todayrec^,22,numread);
  Repeat
    WriteLn('<TR>');
    WriteLn('<td style="vertical-align: top;">');
    Pipe('|10' + todayrec^[loop].alias);
    WriteLn('</TD>');
    WriteLn('<td style="vertical-align: top;">');
    Pipe('|11' + Todayrec^[Loop].location);
    WriteLn('</TD>');

    newhour := ItoS(todayrec^[loop].logontime div 100);
    newmin := ItoS(todayrec^[loop].logontime mod 100);
    WriteLn('<td style="vertical-align: top;">');
    Pipe('|13' + newhour + ':' + newmin+' ');
    WriteLn('</TD>');

    newhour := ItoS(todayrec^[loop].logofftime div 100);
    newmin := ItoS(todayrec^[loop].logofftime mod 100);
    WriteLn('<td style="vertical-align: top;">');
    Pipe('|13' + newhour + ':' + newmin+' ');
    WriteLn('</TD>');

    Inc(curpos);
    Inc(loop);
  until curpos = numread;
  WriteLn('</TD></TR>');
  WriteLn('</TABLE>');
end;

Procedure Yesterday;
begin
  TableSetup;
  CurPos := 0;
  Loop := 1;
  Assign(fv,TheDataFile + 'yester.bbs');
  {$I-}reset(fv);{$I+}
  If ioresult<>0 then begin
    NotFound;
    Halt;
  end else
  seek(fv,filesize(fv));       {Found it!}
  New(TodayRec);
  seek(fv,loop-1);
  blockread(fv,todayrec^,22,numread);
  Repeat
    WriteLn('<TR>');
    WriteLn('<td style="vertical-align: top;">');
    Pipe('|10' + todayrec^[loop].alias);
    WriteLn('</TD>');
    WriteLn('<td style="vertical-align: top;">');
    Pipe('|11' + Todayrec^[Loop].location);
    WriteLn('</TD>');

    newhour := ItoS(todayrec^[loop].logontime div 100);
    newmin := ItoS(todayrec^[loop].logontime mod 100);
    WriteLn('<td style="vertical-align: top;">');
    Pipe('|13' + newhour + ':' + newmin+' ');
    WriteLn('</TD>');

    newhour := ItoS(todayrec^[loop].logofftime div 100);
    newmin := ItoS(todayrec^[loop].logofftime mod 100);
    WriteLn('<td style="vertical-align: top;">');
    Pipe('|13' + newhour + ':' + newmin+' ');
    WriteLn('</TD>');

    Inc(curpos);
    Inc(loop);
  until curpos = numread;
  WriteLn('</TD></TR>');
  WriteLn('</TABLE>');
end;

Begin
  TieVersion:='EzyWho/CGI - Version 0.02';
  JumpNow := False;
  ReadTheConfig;
  writeln('Content-type: text/html');
  writeln;
  WriteLn('<HTML>');
  WriteLn('<HEAD>');
  WriteLn('<TITLE>Last Callers</TITLE>');
  WriteLn('</HEAD>');
  WriteLn(colours);
  WriteLn('<BR>');
  WriteLn('<CENTER>');
  CheckToday;
  if JumpNow = False then Today else
  if JumpNow = True then
  begin
    WriteLN('<IMG SRC="' + TodaysPic + '">');
    WriteLn('<BR>');
    PipeLn('|12NO |11Callers yet today |15:(');
    WriteLn('<BR>');
  end else
  WriteLn('<BR>');
  WriteLN('<IMG SRC="' + YesterPic + '">');
  WriteLn('<BR>');
  Checkyesterday;
  if NoYesterday = False then Yesterday else
  if NoYesterday = True then
  begin
    PipeLn('|12NO |11Callers yesterday |15:(');
    WriteLn('<BR>');
  end;
// Footer display
  WriteLn('</TABLE>');
  WriteLn('<BR>');
  WriteLn('<Font Color="Cyan">' + TieVersion);
  Write('<FONT COLOR="Yellow">Written by: Shawn ''<A HREF="');
  WriteLn('mailto://shighfield@gmail.com">Tiny</A>'' Highfield<BR>');
  WriteLn('<A HREF="http://www.tinysbbs.com">Tiny''s BBS</A>');
  WriteLn('</CENTER></BODY> </HTML>');
End.
