(*


   Psych0MultinodeMesssenger - a public domain program started by
   Andrew Ziem, aka Psych0, BBS: Psychosis 719-532-0053, 1:128/234,
    andrew.ziem@a26.gryn.org, psych0o@aol.com

   With contributions from
   [your name/contacts here, put what you did in the What's New section]



   ---- What's New -----

   v0.50, released 96/06/26 by AHZ
    * first release
      - kind of sucked  =)

   v0.51, released 97/05/29 by AHZ
    * released the source and made PMM public domain
    * squashed a bug or two
       - would not send to just one node
       - ?
    * reports "Node does not exist" instead of crashing
    * reports "Node is not active"
    * reports users to whom the message was sent
    * note: minor last minute changes, re-released 5/31


   ---- To Do List ----

    * port to C and OS/2.
    * make strings customizable, especailly the part the users on the BBS will
      see
      - steal that from Tg's default language file?
    * impliment making and handling of fake users
      - rename to Psych0MultinodeManager or TGMM
    * translate certain MCI codes (such as time)
    * allow multiple (but not all) nodes, eg: 1-5, 10-12
    * "force" message on nodes with quiet flag activated
    * work-around for TG's limit of 255(?) characters of total text
       - split message into sizable portions
    * make PMM look better

   ---- Known Bugs ----

    * none


   *)


{.$DEFINE PSYCH0}                          { if you ain't me, uncomment this }

program PMM;

uses
 dos,
 crt;

{$I c:\tp\bin\bbs\telegard.inc}

{$IFDEF PSYCH0}

{ My own, *private* stuff }

 {$define NoUnixTimeType}
{$I c:\tp\psy\consts.pas}

 {$define existdirinfo}
{$I c:\tp\psy\common.pas}

{$ELSE}

 {$define existdirinfo}
{$I c:\tp\psy\pmm.inc}

{$ENDIF} {PSYCH0}


const
progname         = 'Psych0MultinodeMessenger';
progver          = '0.51';
progdate         = '97/05/29';
progbbs          = 'Telegard v3.02';

author           = 'Psych0';
authinit         = 'AHZ';

str_warning      = 'WARNING: ';
str_affirmative  = 'Yup';
str_negative     = 'Nope';

str_hdr1         = '`09'+progname+' v'+progver+'.'+authinit+' for '+progbbs+'.  '+progdate;
str_hdr2         = '`09All Rites Reversed (K) Do What You Like`03';

c_error     = 12;
c_normal    =  7;

modeChange  =  1;
modeMessage =  2;
modeWhosOn  =  3;

maxNodes    = 255;

ToAllNodes  = -1;

size_configrec = sizeof(configrec);
size_nodesrec  = sizeof(nodesrec);

fmConfigRec    = fmReadOnly+fmDenyNone;

receiptYes  =  1;
receiptNo   =  2;

var
config      : configrec;
shortmsg    : shortmsgrec;
nodes       : nodesrec;

to_node     : integer;
message     : string[155];
mode        : byte;
receipt     : byte;

f,
f2          : file;

x,
x2          : longint;
tmpint      : integer;
tmpstr      : string;
tmpchar     : char;


{$I c:\tp\psy\tgwrite.pas}


procedure CritError(message:string);
begin;
textattr:=12;
writeln('*** ',message, ' (ERR) ***');
textattr:=7;
halt(255);
end;

procedure processcmdline;
var
 s,
 s2  : string;

begin;
s:=paramstr(1);
if paramcount=0 then s:='?';
case upcase(s[1]) of
 '?': begin;
{      writeln('Usage:   PMM <commands> -<switch 1> -<switch 2...etc> <node> <message>'+CRLF+}
      writeln('Usage:   PMM <command type> [command type dependent stuff]'+CRLF+
              'Usage:   PMM M[+/-] [node#] [message text]'+CRLF+
              'Example: PMM M- 0 AUTOMATED: Mail packet just tossed'+CRLF);
              Writeln(

              'Commmand types:'+CRLF+
{              '  c  Change user'+CRLF+}
              '  m  Message user'+CRLF+
              '  w  Who''s online listing'+CRLF+
              '  ?  This help'+CRLF
              );

         end;
 'C': mode:=modeChange;
 'S',
 'M': begin
      mode:=modeMessage;
      case upcase(s[2]) of
       '+','Y','T':receipt:=receiptYes;
       '-','N','F':receipt:=receiptNo;
       end;
      end;
 'W': mode:=modeWhosOn;

  end;{case of s[1]}


{for x:=2 to paramcount do
 begin;
 s:=paramstr(x);
 for x2:=1 to length(s) do s[x2]:=upcase(s[x2]);
 if ((s[1]='/') or (s[1]='-') ) and (length(s)>1) then
  begin;
  delete(s,1,1);
  s2:=s;
  delete(s2,1,1);
  case s[1] of

   'N': begin;
        for x2:=1 to length(s2) do s2[x2]:=upcase(s2[x2]);
        if s2='ALL' then to_node:=-1 else
         begin
         if x2>0 then writeln(str_warning,'invalid parameter '+s2);
         end;
        end;
     end;
   end;
  end;}
 end;


procedure WhosOnlineListing;
begin;
TgWriteLn('`0FNode  Name                           Speed  Status          Location');
TgWriteLn('`09    ');

assign(f,config.datapath+'NODES.DAT');
{$I-}reset(f,size_nodesrec);{$I+}
while not eof(f) do
 begin;
 blockread(f,nodes,1);
 case nodes.statusid of
  0 : tmpstr:='`0EWaiting for a caller';
  1 : tmpstr:='`0COffline/Unavailable';
  2 : tmpstr:='`0EExternal event';
  3 : tmpstr:='`0E'+nodes.handle;
  4 : tmpstr:='`0EWaiting for reset';
  end;
 TgWrite('`0F'+PadR(IntToStr(FilePos(F)),6,' ')+padr(tmpstr,34,' '));
 case nodes.statusid of
  0,
  1,
  2,
  3 : tmpstr:=inttostr(nodes.bpsrate);
  else tmpstr:='';
  end;
 if tmpstr='0' then tmpstr:='Local';
 if nodes.statusid<>3 then tmpstr:='`07-';
 TgWrite('`0B'+Padl(tmpstr,6,' '));

 writeln;
 end;
close(f);
end;


begin;
TGWriteln(CRLF+str_hdr1+CRLF+
               str_hdr2+CRLF);

if not exist(fAddSlash(GetEnv('TELEGARD'))+'CONFIG.TG') then
 begin;
 TGWriteln('`07If you have not done so, set the TELEGARD enviroment variable by '+CRLF+
           'typing      SET TELEGARD=<TELEGARD_DIRECTORY>'+CRLF);
 end;

{ read the Telegard CONFIG.TG configuration file }
assign(f,fAddSlash(GetEnv('TELEGARD'))+'CONFIG.TG');
filemode:=fmConfigRec;
{$I-}reset(f,size_configrec);{$I+}
if ioresult>0 then CritError('unable to read '+fAddSlash(GetEnv('TELEGARD'))+'CONFIG.TG');
blockread(f,config,1);
close(f);

processcmdline;


if mode=modeMessage then
 begin;
 TgWriteLn('`07Send Inter-node Message -'+CRLF);

{ TgWriteLn('-- soon to be who''s online listing will be put here --'+CRLF); }
 WhosOnlineListing;
 writeln;

 if ParamCount>1 then
  begin;
  val(paramstr(2),to_node,tmpint);
  if tmpint=0 then
   TgWriteLn('`09Node (0=All)? `0B'+IntToStr(to_node));
  if (tmpint=0) and (to_node=0) then
   to_node:=ToAllNodes;
  end;

 if to_node=0 then
  begin;
  TgWrite('`09Node (0=All)? `0B');
  readln(tmpstr);
  val(tmpstr,to_node,tmpint);
  if tmpint>0 then exit;                                    { not a number }
  end;

 if to_node=0 then
  to_node:=ToAllNodes;

 if to_node > 0 then
  begin;

  { if sending to just one node, check if it's active }

  assign(f,config.datapath+'NODES.DAT');
  {$I-} reset(f,size_nodesrec);  {$I+}
  if to_node > filesize(f) then
   begin;
   TgWriteln('`0CNode does not exist.');
   exit;
   end;

  seek(f,to_node-1);                       { -1 because filepos(0) = node 1 }
  blockread(f,nodes,1);
  close(f);

  if nodes.statusid<>3 then
   begin;
   TgWriteLn('`0CNode is currently inactive.');
   exit;
   end;

  end;

 {
 Send Inter-node Message -

 Node  Name                           Speed  Status          Location
     
 1     Offline/Unavailable            -      -               -
 2     Offline/Unavailable            -      -               -
 3     psych0                         Local  main menu       Hell

 Node (0=All)? 1
 Node is not currently active
 }

 if ParamCount > 2 then
  begin;

  { message specified on command line -- gather the message }

  message:=ParamStr(3);
  if ParamCount>3 then
   for x:=4 to ParamCount do
    message:=message+' '+paramstr(x);
  TgWriteLn('`09Message? `0B'+Message);
  end else
  begin;
  TgWrite('`09Message? `0B');
  readln(message);
  if empty(message) then tgWriteLn('`0CAborted.');
  if empty(message) then exit;
  end;

 TgWrite(CRLF+'`0CSend ''From User/Node'' receipt? ['+str_affirmative+']: `0B');
 if receipt=0 then
  begin;
  tmpchar:=readkey;
  if upcase(tmpchar)='N' then receipt:=receiptNo else receipt:=receiptYes;
  end;

 if receipt=receiptNo then
  TgWriteln(str_negative) else TgWriteLn(str_affirmative);

 if receipt=receiptYes then
  message:='`04<`0C(`8E*`0C)`04> `0FFrom '+config.sysopname+' (PMM):`09'+CRLF+'`07'+message;
  { ^ TG will only display 255 total text }

 {
 `04<`0C(`8E*`0C)`04> `0FFrom psych0 (Node 3):`09
 1943 ~SM`0CSend 'From User/Node' receipt? [~&Y]: `0B
 1944 `0CNode is not currently active
 }


 { send the message }

 assign(f,config.datapath+'NODES.DAT');
 {$I-}reset(f,size_nodesrec);{$I+}
 while not eof(f) do
  begin;
  blockread(f,nodes,1);
{  tgwriteln('`0Edebug: filepos='+inttostr(filepos(f))); }

  if (nodes.statusid=3)                                     { 3 - CONNECTED }
   and not (isquiet in nodes.flags)                        { quiet flag off }
   and ((filepos(f)=To_Node) or (To_Node=ToAllNodes))        { correct node }
   then
   begin;
   assign(f2,config.datapath+'INODE'+IntToStr(FilePos(F))+'.Dat');
   filemode:=fmReadWrite+fmDenyNone;
   {$I-}reset(f2,1);{$I+}
   if ioresult=2 then rewrite(f2,1);           { file doesn't exist, create }
   seek(f2,filesize(f2));                             { find the right spot }
   shortmsg.userid:= nodes.userid;
   shortmsg.msg   := message;
   blockwrite(f2,shortmsg,sizeof(shortmsg));
   close(f2);
   TgWriteLn('`07Message sent to `0B'+nodes.handle+'`07.');
   end;

  end;

 close(f);
 end;


if mode=modeWhoson then
 begin;
 TgWriteLn('`07Who''s Online Listing - (not finished)'+CRLF);

 WhosOnlineListing;
 end;

if (mode=0) or (mode=modeChange) then
 TgWriteLn('`0CERROR:  Command line is probably incorrect or empty.');
end.

{Who's Online Listing - contribute and help get more nodes

Node  Name                           Speed  Status          Location
    
1     Offline/Unavailable            -      -               -
2     Offline/Unavailable            -      -               -
3     Waiting for a caller           Local  -               -}

{
1918 `0F~EL5~&1 `0E~EL30~&2 `0B~EL6~&7 `0A~EL15~&6 `09~EL18~&4
1919 `0F~EL5~&1 `0EWaiting for a caller           `0B~EL6~&7`07 -               -
1920 `0F~EL5~&1 `0EExternal event                 `0B~EL6~&7`07 -               -
1921 `0F~EL5~&1 `0COffline/Unavailable            `07-      -               -
1922 `0F~EL5~&1 `0CUnknown                        `07-      -               -
 }