load("sbbsdefs.js");
load("DM_Libs.js");

var config          = new Config();
var defaultConfig   = "DM_NewScanConfig.cfg";

var screenBottom = {
    x:1,
    y:console.screen_rows
};

config.defaults = {
    settings: {
        lightbar_enable: 1
    },
    groups: {
        header_file: "newscang",
        frame_x: 3,
        frame_y: 4,
        frame_height: 17,
        frame_width: 74,
        frame_scrollbar: 0,
        scrollbar_color: "\1n",
        scrollbar_arrows: 0,
        scrollbar_hide: 1,
        desc_width: 50,
        lightbar_normal: "\x010\1h\1c",
        lightbar_active: "\x014\1h\1w"
    },
    subs: {
        header_file: "newscans",
        frame_x: 3,
        frame_y: 6,
        frame_height: 15,
        frame_width: 74,
        frame_scrollbar: 0,
        scrollbar_color: "\1n",
        scrollbar_arrows: 0,
        scrollbar_hide: 1,
        desc_width: 60,
        color_normal: "\1c",
        color_active: "\1h\1c",
        lightbar_normal: "\x010\1h\1c",
        lightbar_active: "\x014\1h\1w",
        lightbar_on: " on  ",
        lightbar_off: " off "
    }
};

String.prototype.lpad = function(padString, length) {
    var str = this;
    while (str.length < length)
        str = padString + str;
    return str;
}

String.prototype.rpad = function(padString, length) {
    var str = this;
    while (str.length < length)
        str = str + padString;
    return str;
}

function selectGroup() {
    var select = new Selection();
    var userInput = new UserInput();
    var scroll = new Scrollbar(
            config.groups.frame_x + config.groups.frame_width,
            config.groups.frame_y,
            config.groups.frame_height,
            "vertical",
            config.groups.scrollbar_color,
            config.groups.scrollbar_arrows
    );
    var groups = [];

    // Populate the available groups a user can access.
    for (var i = 0; i < msg_area.grp_list.length; i++) {
        if (user.compare_ars(msg_area.grp_list[i].ars)) {
            groups.push(msg_area.grp_list[i]);
        }
    }
    select.setup(groups.length, config.groups.frame_height, 0);

    function draw(refresh) {
        if (refresh !== true) refresh = false;
        for (var row = 0; row < select.height; row++) {
            if (!refresh && select.page == select.prev.page) {
                if (row != select.row && row != select.prev.row) continue;
            }
            console.gotoxy(config.groups.frame_x, config.groups.frame_y + row);

            var mark = {active: "", normal: ""};
            if (config.groups.indicator_normal != null && config.groups.indicator_active != null) {
                if (typeof bbs.curgrp === "number" && row == bbs.curgrp) {
                    mark.active = config.groups.indicator_active;
                    mark.normal = config.groups.indicator_normal;
                } else {
                    mark.active = " ".rpad(" ", strip_ctrl(config.groups.indicator_active).length);
                    mark.normal = mark.active;
                }
            }

            if (select.isOver(row)) {
                if (select.page == select.prev.page) break;
                console.print("\1n" + " ".rpad(" ", config.groups.desc_width + strip_ctrl(mark.active).length) + "\r\n");
                continue;
            } else {
                if (select.row == row)
                    console.print("\1n".concat(
                                config.groups.lightbar_active,
                                mark.active,
                                "\1n",
                                config.groups.lightbar_active,
                                groups[select.getItem(row)].description.slice(0, config.groups.desc_width).rpad(" ", config.groups.desc_width),
                                "\1n\r\n"));
                else
                    console.print("\1n".concat(
                                config.groups.lightbar_normal,
                                mark.normal,
                                "\1n",
                                config.groups.lightbar_normal,
                                groups[select.getItem(row)].description.slice(0, config.groups.desc_width).rpad(" ", config.groups.desc_width),
                                "\1n\r\n"));
            }
        }
        if (!refresh) {
            if (select.row != select.prev.row || select.page != select.prev.page) {
                if (config.groups.frame_scrollbar &&
                        select.items >= select.height)
                    scroll.draw(select.active(), select.total());
            }
        } else {
            if (config.groups.frame_scrollbar &&
                    (config.groups.scrollbar_hide == 0 &&
                     select.totalPages() == 0))
                scroll.draw(select.active(), select.total());

            if (config.groups.prompt_text != null) {
                if (config.groups.prompt_x != null && config.groups.prompt_y != null)
                    console.gotoxy(config.groups.prompt_x, config.groups.prompt_y);
                console.putmsg("\1n" + config.groups.prompt_text + "\1n");
            }
        }
        console.gotoxy(1, console.screen_rows);
    }

    console.putmsg("\1q@NOPAUSE@");
    if (config.groups.header_file != null) {
        bbs.menu("newscan/" + config.groups.header_file);
        screenBottom.y = console.getxy().y;
        if (screenBottom.y < console.screen_rows)
            screenBottom.y++;

        console.putmsg("\1q@NOPAUSE@");
    }

    draw(true);
    while(bbs.online) {
        //draw();
        cmd = userInput.WaitForKey();
        cmd = cmd.toUpperCase();
        switch (cmd) {
            case userInput.__keys__.UP:
                select.prev();
                break;
            case userInput.__keys__.DOWN:
                select.next();
                break;
            case userInput.__keys__.PGUP:
                select.prevPage();
                break;
            case userInput.__keys__.PGDN:
                select.nextPage();
                break;
            case userInput.__keys__.ENTER:
                return select.active();
                break;
            case userInput.__keys__.ESC:
            case userInput.__keys__.DOUBLE_ESC:
            case 'Q':
                return null;
                break;
        }
        draw();
    }
    return;
}

function selectSub(group) {
    var userInput = new UserInput();
    var select = new Selection();
    var scroll = new Scrollbar(
            config.subs.frame_x + config.subs.frame_width,
            config.subs.frame_y,
            config.subs.frame_height,
            "vertical",
            config.subs.scrollbar_color,
            config.subs.scrollbar_arrows
    );
    var subs = [];

    // Populate the available subs a user can access.
    for (var i = 0; i < msg_area.grp_list[group].sub_list.length; i++) {
        if (msg_area.grp_list[group].sub_list[i].can_read) {
            subs.push(msg_area.grp_list[group].sub_list[i]);
        }
    }
    select.setup(subs.length, config.subs.frame_height, 2);

    function draw(refresh, frameonly) {
        if (refresh   !== true) refresh   = false;
        if (frameonly !== true) frameonly = false;

        for (var row = 0; row < select.height; row++) {
            if (!refresh && select.page == select.prev.page) {
                if (row != select.row && row != select.prev.row) continue;
            }
            console.gotoxy(config.subs.frame_x, config.subs.frame_y + row);

            var mark = {active: "", normal: ""};
            if (config.subs.indicator_normal != null && config.subs.indicator_active != null) {
                if (typeof bbs.cursub === "number" &&
                        (select.page * config.subs.frame_height) + row == bbs.cursub &&
                        group == bbs.curgrp) {
                    mark.active = config.subs.indicator_active;
                    mark.normal = config.subs.indicator_normal;
                } else {
                    mark.active = " ".rpad(" ", strip_ctrl(config.groups.indicator_active).length);
                    mark.normal = mark.active;
                }
            }

            if (select.isOver(row)) {
                if (select.page == select.prev.page) break;
                console.print("\1n" + " ".rpad(" ", config.subs.frame_width) + "\r\n");
                continue;
            } else {
                if (select.row == row)
                    console.print("\1n".concat(
                                config.subs.color_active,
                                mark.active,
                                "\1n",
                                config.subs.color_active,
                                subs[select.getItem(row)].description.slice(0, config.subs.desc_width).rpad(" ", config.subs.desc_width),
                                "\1n"));
                else
                    console.print("\1n".concat(
                                config.subs.color_normal,
                                mark.normal,
                                "\1n",
                                config.subs.color_normal,
                                subs[select.getItem(row)].description.slice(0, config.subs.desc_width).rpad(" ", config.subs.desc_width),
                                "\1n"));
            }

            if (subs[select.getItem(row)].scan_cfg & SCAN_CFG_NEW) {
                if (select.row == row && select.col == 0)
                    console.print("\1n".concat(
                                config.subs.lightbar_active,
                                config.subs.lightbar_on,
                                "\1n "));
                else
                    console.print("\1n".concat(
                                config.subs.lightbar_normal,
                                config.subs.lightbar_on,
                                "\1n "));
            } else {
                if (select.row == row && select.col == 0)
                    console.print("\1n".concat(
                                config.subs.lightbar_active,
                                config.subs.lightbar_off,
                                "\1n "));
                else
                    console.print("\1n".concat(
                                config.subs.lightbar_normal,
                                config.subs.lightbar_off,
                                "\1n "));
            }

            if (subs[select.getItem(row)].scan_cfg & SCAN_CFG_TOYOU) {
                if (select.row == row && select.col == 1)
                    console.print("\1n".concat(
                                config.subs.lightbar_active,
                                config.subs.lightbar_on,
                                "\1n"));
                else
                    console.print("\1n".concat(
                                config.subs.lightbar_normal,
                                config.subs.lightbar_on,
                                "\1n"));
            } else {
                if (select.row == row && select.col == 1)
                    console.print("\1n".concat(
                                config.subs.lightbar_active,
                                config.subs.lightbar_off,
                                "\1n"));
                else
                    console.print("\1n".concat(
                                config.subs.lightbar_normal,
                                config.subs.lightbar_off,
                                "\1n"));
            }
            console.crlf();
        }
        if (!refresh) {
            if (select.row != select.prev.row || select.page != select.prev.page) {
                if (config.subs.frame_scrollbar &&
                        select.items >= select.height)
                    scroll.draw(select.active(), select.total());
            }
        } else {
            if (config.subs.frame_scrollbar &&
                    ((config.subs.scrollbar_hide == 0 &&
                        select.totalPages() == 0) ||
                     select.totalPages() > 0 ))
                scroll.draw(select.active(), select.total());
            if (config.subs.prompt_text != null) {
                if (config.subs.prompt_x != null && config.subs.prompt_y != null)
                    console.gotoxy(config.subs.prompt_x, config.subs.prompt_y);
                console.putmsg("\1n" + config.subs.prompt_text + "\1n");
            }
        }
        console.gotoxy(1, console.screen_rows);
    }

    console.putmsg("\1q", P_NOPAUSE);
    if (config.subs.header_file != null) {
        bbs.menu("newscan/" + config.subs.header_file);
        screenBottom.y = console.getxy().y;
        if (screenBottom.y < console.screen_rows)
            screenBottom.y++;
        console.putmsg("\1q@NOPAUSE@", P_NOPAUSE);
    }

    draw(true);
    while(bbs.online) {
        cmd = userInput.WaitForKey();
        cmd = cmd.toUpperCase();
        switch (cmd) {
            case userInput.__keys__.UP:
                select.prev();
                break;
            case userInput.__keys__.DOWN:
                select.next();
                break;
            case userInput.__keys__.LEFT:
            case userInput.__keys__.RIGHT:
                select.nextColumn(true);
                break;
            case userInput.__keys__.PGUP:
                select.prevPage();
                break;
            case userInput.__keys__.PGDN:
                select.nextPage();
                break;
            case userInput.__keys__.ENTER:
                if (select.col == 0)
                    subs[select.active()].scan_cfg ^= SCAN_CFG_NEW;
                else
                    subs[select.active()].scan_cfg ^= SCAN_CFG_TOYOU;
                break;
            case '+':
                if (select.col == 0) {
                    for (var s = 0; s < subs.length; s++) {
                        subs[s].scan_cfg |= SCAN_CFG_NEW;
                    }
                } else {
                    for (var s = 0; s < subs.length; s++) {
                        subs[s].scan_cfg |= SCAN_CFG_TOYOU;
                    }
                }
                draw(true, true);
                continue;
                break;
            case '-':
                if (select.col == 0) {
                    for (var s = 0; s < subs.length; s++) {
                        subs[s].scan_cfg &= ~(SCAN_CFG_NEW);
                    }
                } else {
                    for (var s = 0; s < subs.length; s++) {
                        subs[s].scan_cfg &= ~(SCAN_CFG_TOYOU);
                    }
                }
                draw(true, true);
                continue;
                break;
            case userInput.__keys__.DOUBLE_ESC:
                return false;
                break;
            case userInput.__keys__.ESC:
            case 'Q':
                return null;
                break;
        }
        draw(false);
    }
    return;
}

function main(ansi) {
    ansi = typeof ansi !== 'undefined' ? ansi : console.term_supports(USER_ANSI);
    var activeSelection = 0;
    var selectAction    = false;
    var keyInput        = new UserInput();

    while (bbs.online) {
        if (msg_area.grp_list.length == 0) {
            console.clear("\1n");
            console.print("\1y^AhThere are no message groups.\r\n\1p");
            console.clear("\1n");
            exit();
        }

        console.clear("\1n");
        var group = selectGroup();
        if (group == null) {
            console.gotoxy(1,console.screen_rows - 1);
            console.clear("\1n");
            exit();
        } else {
            var sub = selectSub(group);
            if (sub == null) {
                continue;
            } else {
                console.clear("\1n");
                exit();
            }
            continue;
        }
        exit();
    }
}

try {
    config.load(js.exec_dir + defaultConfig);
    main();
} catch(err) {
    log(LOG_ERR, err);
    console.print("\1n\r\n\r\n");
    console.clearline("\1n");
    console.print("\1r\1hAn exception has occurred in " + js.exec_file + ". Please let your sysop know.\1n\r\n");
    console.clearline("\1n");
    console.pause();
}

