#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>
#include <stdarg.h>
#include <getopt.h>

#include <smapi/msgapi.h>

#include "qwk.h"
#include "cfg.h"
#include "rep.h"
#include "yaqn.h"

void make_rep();

void stripkludge(char *p)
{
	unsigned int j,i,m1,m2;

	for(j=0;j<4;j++){
		for(i=0;p[i];i++){
			m1=m2=0;
			if(p[i]==''){
				m1=i;
				while(p[i] && p[i]!='\r')	i++;
				if(p[i]=='\r')
					m2=i;
				}
			if(m1+m2 && m2>m1){
				memcpy(p+m1,p+m2+1,strlen(p)-m2);
				}
			}
		}
}

void getmsginfo(HMSG hmsg, unsigned int qwkidx, char *hostid, int msgnum)
{
	unsigned char *msgtxt;
	unsigned int j,textLen;
	long int i,k;
	struct QwkHdr qh;
	XMSG xmsg;
	FILE *out;
	char path[90];
	char textout[128];
	char buff[26];


	memset(&qh, ' ', sizeof(struct QwkHdr));


	/*  Find out how many message records we have */
	textLen = MsgGetTextLen(hmsg);
	j=(textLen/128)+2L;
	k=j*128;
	msgtxt= (unsigned char *) malloc(k);
	memset(msgtxt,'\0',k);
	memset(&qh,' ',sizeof(struct QwkHdr));
	MsgReadMsg(hmsg, &xmsg, 0, textLen, msgtxt, 0, NULL);

	msgtxt[textLen]='\0';
	memset(buff,' ',26);
	sprintf(buff,"%d",j);
	for(i=strlen(buff);i<26;i++)
		buff[i]=' ';
	memset(qh.Msgrecs,' ',6);
	memcpy(qh.Msgrecs,buff,6);

	stripkludge(msgtxt);
	for(i=strlen(msgtxt)+1;i<k;i++)
			msgtxt[i]=' ';

	/* Replace \r with \xe3 */
	for(i=0;i<strlen(msgtxt);i++){
		if(msgtxt[i]=='\r'){
			msgtxt[i]='\xe3';
			}
		}

	for(i=k;i;i--)
		if(msgtxt[i]=='\0')
			msgtxt[i]=' ';

	/* Fill up msgnum fields */
	memset(buff,' ',25);
	sprintf(buff,"%d",qwkidx);
	memset(qh.Msgnum,' ',7);
	memcpy(qh.Msgnum,buff,strlen(buff));

	/* initialize the From, To and Subj fields */
	qh.MsgFrom[0]='\0';
	qh.MsgTo[0]='\0';
	qh.MsgSubj[0]='\0';
	
	if(strlen(xmsg.from) > 24) 	xmsg.from[24]= 0;
	if(strlen(xmsg.to) > 24) 	xmsg.to[24]= 0;
	if(strlen(xmsg.subj) > 24) 	xmsg.subj[24]= 0;

	memset(qh.MsgFrom,' ',25);
	memset(qh.MsgSubj,' ',25);
	memset(qh.MsgTo,' ',25);

	memcpy(qh.MsgFrom, xmsg.from, strlen(xmsg.from));
	memcpy(qh.MsgTo,   xmsg.to  , strlen(xmsg.to));
	memcpy(qh.MsgSubj, xmsg.subj, strlen(xmsg.subj));
	memset(qh.Msgpass,' ',12);

	qh.Msglive = 0xE1;
	qh.Msgstat= ' ';
	memset(qh.Msgfiller,' ',3);qh.Msgfiller[2]='*';
	memset(qh.Msgrply,' ',8);

	/* Define the conference area */
	qh.Msgarealo = (unsigned char) (qwkidx & 0xFF);
	qh.Msgareahi = (unsigned char) ((qwkidx & 0xFF00) >> 8);

	/* Define the Time */
	sprintf(buff,"%02d:%02d",
		xmsg.date_written.time.hh,
		xmsg.date_written.time.mm);
	memcpy(qh.Msgtime,buff,5);

	/* Define the Date */
	sprintf(buff,"%02d-%02d-%02d",
		xmsg.date_written.date.mo,
		xmsg.date_written.date.da,
		xmsg.date_written.date.yr+1980-2000);
	memcpy(qh.Msgdate,buff,8);

	/* Open the REP file */
	strlwr(hostid);
	sprintf(path,"%s%s.msg",conf.tmppath,hostid);

	out=fopen(path,"r+");
	if(!out){					/* If the file does not already exist */
		out=fopen(path,"w");    /* Create a new one, and add the header */
		if(out!=NULL){
			memset(textout,' ',128);
			memcpy(textout,hostid,strlen(hostid));
			fwrite(&textout,128,1,out);
			}
		else{
			logger("Unable to open %s",path);
			logger("");
			return;
			}
		} 
	else{ /* If we can open the file for read/write, then we are good to go */
		fseek(out,0L,SEEK_END);
		}

	/* Write the message header */
	fwrite(&qh,sizeof(struct QwkHdr),1,out);
	/* Write the message body */
	fwrite(msgtxt,k-128,1,out);
	fclose(out);
}

void read_jam()
{
	HAREA area;
	HMSG  hmsg;
	XMSG  xmsg;
	dword highestMsg, i;
	int  unsent=0;
    struct cfg_area* tarea;

/*	logger(PROGNAME);*/
	logger("");
	logger("Exporting messages.");

    for(tarea = conf.areas; tarea; tarea=tarea->next){
		if(tarea->num==0) break;
		unsent=0;
		area=MsgOpenArea((unsigned char*) tarea->path, MSGAREA_NORMAL, (word)(tarea->type | MSGTYPE_ECHO)); 
		if (area !=NULL){
			i = 0;
			highestMsg = MsgGetNumMsg(area);
			while (i < highestMsg){
				hmsg = MsgOpenMsg(area, MOPEN_RW, ++i);
				if (hmsg == NULL) continue;
				MsgReadMsg(hmsg, &xmsg, 0, 0, NULL, 0, NULL);
				if (((xmsg.attr & MSGSENT) != MSGSENT) &&
					((xmsg.attr & MSGLOCKED) != MSGLOCKED) &&
					((xmsg.attr & MSGLOCAL) == MSGLOCAL)) {
					getmsginfo(hmsg,tarea->num,tarea->hub,i);
					unsent++;
					xmsg.attr |= MSGSENT;
					MsgWriteMsg(hmsg, 0, &xmsg, NULL, 0, 0, 0, NULL); 
					tarea->cnt++;
					}
				MsgCloseMsg(hmsg);
				}
			if(unsent) logger("Area: %d - %d msgs.", tarea->num,unsent);
			else		logger("Area: %d - no msgs.",tarea->num);
			MsgCloseArea(area);
			}
		else		
			logger("Area: %d - no msgs.",tarea->num);
		}
	logger("");
	make_rep();

	logger("Export Report:");
	for(tarea=conf.areas; tarea; tarea=tarea->next){
		if(tarea->cnt)
			logger("Conf %d -> %d messages.",tarea->num,tarea->cnt);
		}
	logger("");
	logger("");
}

void make_rep()
{
	char zipstr[128],repfile[128],buff[51],msgfile[128];
	int ret=0,rnum=1;
    DIR	*dir;
    struct dirent *ent;

	for(hubs=conf.hosts; hubs; hubs=hubs->next){
		logger("Packing %s.msg to %s.rep",hubs->hub,hubs->hub);
		for(packr=conf.packers; packr; packr=packr->next){
			if(!strcasecmp(packr->name,hubs->arc))
				break;
			}
		if(!packr)	logger("No packer defined for %s",hubs->arc);;
		if(!packr)	continue;

		buff[0]='\0';
		sprintf(buff,"%s.msg",hubs->hub);
		msgfile[0]='\0';
	
		dir=opendir(conf.tmppath);
   	 	while((ent = readdir(dir))){
			if(!strcasecmp(ent->d_name,buff)){
				sprintf(msgfile,"%s%s",conf.tmppath,ent->d_name);
				}
			}
		if(!strlen(msgfile)) logger("No %s.msg file found!",hubs->hub);
		if(!strlen(msgfile)) continue;
		
		sprintf(repfile,"%s%s.rep",conf.inbound,hubs->hub);
		while(fexist(repfile)){
			sprintf(repfile,"%s%s.re%d",conf.inbound,hubs->hub,rnum++);
			}
		sprintf(zipstr,"%s %s %s",hubs->arc,repfile,msgfile);
		ret=system(zipstr);
		if(ret){ logger("Unable to create REP file"); }
		closedir(dir);
		}
	del_tmp(); 
}

