#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>
#include <unistd.h>
#include <getopt.h>

#include "qwk.h"

char *strrepl(char *Str, size_t BufSiz, const char *OldStr, const char *NewStr);

extern char *optarg;
extern int optind, opterr, optopt;
int stripkludge;

/* Stolen from MBSE - http://mbse.sourceforge.net */

char* StripSpaces(char* str, int size)
{
    static char TempStr[128]; 
    int x;
 
   	memcpy(TempStr, str, size); 
	TempStr[size] = '\0';
    if((x = (size - 1)) > 0) {
		while(x > 0 && TempStr[x] == ' ') 
			TempStr[x--] = '\0';
    	}
	strcpy(str,TempStr);    
    return(TempStr);
}

int Qwk2Cr(char* buf)
{
    do {
		if(*buf == '\xe3')
		    *buf = '\n';
   	 } while(*buf++);

    return(0);
}

char *strrepl(char *Str, size_t BufSiz, const char *OldStr, const char *NewStr)
{
	int OldLen, NewLen;
	char *p, *q;

	if(NULL == (p = strstr(Str, OldStr)))
		return Str;
	OldLen = strlen(OldStr);
	NewLen = strlen(NewStr);
	if ((strlen(Str) + NewLen - OldLen + 1) > BufSiz)
		return NULL;
	memmove(q = p+NewLen, p+OldLen, strlen(p+OldLen)+1);
	memcpy(p, NewStr, NewLen);
	return q;
}

void translate(char *in, unsigned int size)
{
	while(strstr(in,"b"))	strrepl(in,size,"b","");
	while(strstr(in,"c"))	strrepl(in,size,"c","");
	while(strstr(in,"g"))	strrepl(in,size,"g","");
	while(strstr(in,"h"))	strrepl(in,size,"h","");
	while(strstr(in,"k"))	strrepl(in,size,"k","");
	while(strstr(in,"n"))	strrepl(in,size,"n","");
	while(strstr(in,"p"))	strrepl(in,size,"p","");
	while(strstr(in,"r"))	strrepl(in,size,"r","");
	while(strstr(in,"w"))	strrepl(in,size,"w","");
	while(strstr(in,"y"))	strrepl(in,size,"y","");

	while(strstr(in,"B"))	strrepl(in,size,"B","");
	while(strstr(in,"C"))	strrepl(in,size,"C","");
	while(strstr(in,"G"))	strrepl(in,size,"G","");
	while(strstr(in,"H"))	strrepl(in,size,"H","");
	while(strstr(in,"K"))	strrepl(in,size,"K","");
	while(strstr(in,"N"))	strrepl(in,size,"N","");
	while(strstr(in,"P"))	strrepl(in,size,"P","");
	while(strstr(in,"R"))	strrepl(in,size,"R","");
	while(strstr(in,"W"))	strrepl(in,size,"W","");
	while(strstr(in,"Y"))	strrepl(in,size,"Y","");
/*
	if (!stripkludge){
	for(x=0;x<4;x++){
		mark1=0;
		mark2=0;
		for(i=0;i<strlen(in);i++){
			if(strncmp(in+i,"@MSGID:",7)==0)	mark1=i;
			if(strncmp(in+i,"@REPLY:",7)==0)	mark1=i;
			if(strncmp(in+i,"@VIA:",5)==0)		mark1=i;
			if(strncmp(in+i,"@TZ:",4)==0)		mark1=i;
			if(mark1>0)
				mark1--;
			if(mark1>=0){
				for(j=mark1;j<strlen(in);j++){
					if(in[j]=='\n'){
						mark2=j+1;
						break;
						}
					}
				}
			}
			if(mark1>=0 || mark2>0){
				memmove(in+mark1, in+mark2, strlen(in)-mark2+1);
				}
			}
		}
*/
}


int process_ndx(char *outfile, char *msgdat)
{
    FILE *fp_dat,*out;
	unsigned int confnum; 
    char tbuf[128];
    struct QwkHdr qwkhdr;
    int records, i;
    char *bigbuf;

	char date[10],tim[11],num[11];
   
    fp_dat = fopen(msgdat, "r");

	if(!fp_dat) {
		printf("\n\rCould not open %s.  exiting.",msgdat);
		return(0);
    	}

	printf("\n");
	fread(&qwkhdr, sizeof(struct QwkHdr), 1, fp_dat);
	while(fread(&qwkhdr, sizeof(struct QwkHdr), 1, fp_dat)){
		records = atoi(qwkhdr.Msgrecs);
		bigbuf=malloc(records*128);
		memset(bigbuf,'\0',records*128);
		memset(tbuf,'\0',128);

		confnum=0L;
		confnum=(qwkhdr.Msgareahi & 0x00FF)<<8;
		confnum+=qwkhdr.Msgarealo;

		StripSpaces(qwkhdr.MsgFrom,25);
		StripSpaces(qwkhdr.MsgSubj,25);
		StripSpaces(qwkhdr.MsgTo,25);
		StripSpaces(qwkhdr.Msgpass,12);
		StripSpaces(qwkhdr.Msgrply,8);
		StripSpaces(qwkhdr.Msgrecs,6);
		StripSpaces(qwkhdr.Msgnum,7);

		printf("\n\rCopying Message #[%s] to (%d)",
			qwkhdr.Msgnum,confnum);

		out=fopen(outfile,"at+");
		if(out==NULL)
			out=fopen(outfile,"w+");
		if(out!=NULL){

			memset(tim,'\0',5);
			memcpy(tim,qwkhdr.Msgtime,5);
			tim[5]='\0';

			memset(date,'\0',8);
			memcpy(date,qwkhdr.Msgdate,8);
			date[8]='\0';

			memset(num,'\0',7);
			strcpy(num,qwkhdr.Msgnum);

			fprintf(out,"\n==============================================================================\n");
			fprintf(out,"From: %-25.25s Date:%s %s\n",
				qwkhdr.MsgFrom, date, tim);
			fprintf(out,"To..: %-25.25s Conf:%d (%d)\n",
				qwkhdr.MsgTo, confnum,records);
			fprintf(out,"Subj: %-25.25s Msg#:%s\n",
				qwkhdr.MsgSubj, num);
			fprintf(out,"------------------------------------------------------------------------------\n");

			for(i=1; i < records; i++) {
				fread(tbuf, 128, 1, fp_dat);
				StripSpaces(tbuf, 128); 
				Qwk2Cr(tbuf); 
				strcat(bigbuf,tbuf);
				} 
			translate(bigbuf,strlen(bigbuf));    
			fwrite(bigbuf,strlen(bigbuf),1,out);
			fclose(out);
			free(bigbuf);
			}
		}
   	fclose(fp_dat);
    return(1);
}

void usage()
{
	printf("\n\rUsage: qwk2txt -m <input file> -t <output file>\n\r");
	printf("   -m <input file>      where <input file> is the MESSAGE.DAT file\n\r");
	printf("                        that contains the raw QWK messages.\n\r");
	printf("   -t <output file>     where <output file> is the text filename\n\r");
	printf("                        that the qwk messages are written to.\n\r");
	exit(0);
}

int main(int argc, char *argv[])
{
	char opt;
	char outfile[128],msgfile[128];
	int cnt=0;

	stripkludge=FALSE;
	while((opt=getopt(argc,argv,"km:t:"))!=-1){
		cnt++;
		switch(opt){
			case 'k':	stripkludge=TRUE;	break;
			case 't':
				strcpy(outfile,optarg);
				break;
			case 'm':
				strcpy(msgfile,optarg);
				break;
			case '?':	
				usage(); 
				break;
				}
			}
	if(cnt==0){
		usage(); 
		}
	process_ndx(outfile,msgfile);    
	printf("\n\r");
	return (0);
}
