#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>
#include <getopt.h>

#include <smapi/msgapi.h>

#include "qwk.h"
#include "cfg.h"
#include "yaqn.h"

char *read_qwk(struct hub_list *hl);
int del_qwk();
int del_tmp();

char* StripSpaces(char* str, int size)
{
    static char TempStr[128];
    int x;
    
    memcpy(TempStr, str, size);
    TempStr[size] = '\0';
    
    if((x = (size - 1)) > 0)
    {
	while(x > 0 && TempStr[x] == ' ')
	    TempStr[x--] = '\0';
    }
	strcpy(str,TempStr);
	return(TempStr);
}

int Qwk2Cr(char* buf)
{
    do {
		if(*buf == '\xe3')
		    *buf = '\r';
		} while(*buf++);
    
    return(0);
}

int process_ndx()
{
    FILE *fp_dat;
	unsigned int confnum,msgnum; 
    char tbuf[128];
    struct QwkHdr qwkhdr;
    int records, i, areatype=MSGTYPE_JAM;
    char *bigbuf,areapath[128];
    char msgname[128];
    HAREA area;
    HMSG msg;
    XMSG xmsg;

	logger(PROGNAME); 
	for(hubs = conf.hosts; hubs; hubs = hubs->next){
		logger("Importing QWK messages for %s.",hubs->hub);
		sprintf(msgname,read_qwk(hubs));
		fp_dat = fopen(msgname, "r");

		if(!fp_dat) logger("--- No Mesages Found!",hubs->hub);
		if(!fp_dat) continue;

		fread(&qwkhdr, sizeof(struct QwkHdr), 1, fp_dat);
		while(fread(&qwkhdr, sizeof(struct QwkHdr), 1, fp_dat)) {
			records = atoi(qwkhdr.Msgrecs);
			bigbuf=malloc(records*128);
			memset(bigbuf,'\0',records*128);
			memset(tbuf,'\0',128);

			confnum=0L;
			confnum=(qwkhdr.Msgareahi & 0x00FF)<<8;
			confnum+=qwkhdr.Msgarealo;
	
			StripSpaces(qwkhdr.MsgFrom,25);
			StripSpaces(qwkhdr.MsgSubj,25);
			StripSpaces(qwkhdr.MsgTo,25);
			StripSpaces(qwkhdr.Msgpass,12);
			StripSpaces(qwkhdr.Msgnum,7);
			StripSpaces(qwkhdr.Msgrply,8);
			StripSpaces(qwkhdr.Msgrecs,6);
			msgnum=atoi(qwkhdr.Msgnum);
	
			for(tarea = conf.areas; tarea; tarea=tarea->next){
				if(confnum == tarea->num){
					areatype=tarea->type;
					strcpy(areapath,tarea->path);
				    break;
					}
				}
			if(!tarea){
				tarea = malloc(sizeof(struct cfg_area));
				tarea->num=confnum;
				tarea->cnt=0;
				sprintf(tarea->path,"%s%d",hubs->defpath,confnum);
				sprintf(tarea->hub,"%s",hubs->hub);
				if(!hubs->deftype) hubs->deftype=MSGTYPE_JAM;
				tarea->type=hubs->deftype;
				tarea->next=conf.areas;
				conf.areas=tarea;
				areatype=tarea->type;
				strcpy(areapath,tarea->path);
				logger("----Creating new area \"%d\" at %s",
					tarea->num, tarea->path);
				AddArea2Cfg(tarea);
				}
			tarea->cnt++;	
			logger("Message #%d->%d",msgnum,confnum);
		
			for(i=1; i < records; i++) {
				fread(tbuf, 128, 1, fp_dat);
				StripSpaces(tbuf, 128);
				Qwk2Cr(tbuf);
				strcat(bigbuf, tbuf); 
				} 
	
			translate(bigbuf,strlen(bigbuf));  

			memset(&xmsg, '\0', sizeof(XMSG));

		    area = MsgOpenArea(areapath, MSGAREA_CRIFNEC, areatype); 
			msg = MsgOpenMsg(area, MOPEN_CREATE, 0); 
	
			xmsg.orig.zone = conf.aka.zone;
			xmsg.orig.net = conf.aka.net;	
			xmsg.orig.node = conf.aka.node;	
			xmsg.orig.point = conf.aka.point;		
			xmsg.dest.zone = conf.aka.zone;
			xmsg.dest.net = conf.aka.net;	
			xmsg.dest.node = conf.aka.node;	
			xmsg.dest.point = conf.aka.point;		
	
			sprintf(tbuf,"%c%c",qwkhdr.Msgdate[0],qwkhdr.Msgdate[1]);
			xmsg.date_written.date.mo=atoi(tbuf);

			sprintf(tbuf,"%c%c",qwkhdr.Msgdate[3],qwkhdr.Msgdate[4]);
			xmsg.date_written.date.da=atoi(tbuf);
	
			sprintf(tbuf,"%c%c",qwkhdr.Msgdate[6],qwkhdr.Msgdate[7]);
			xmsg.date_written.date.yr=atoi(tbuf)+20;
	
			sprintf(tbuf,"%c%c",qwkhdr.Msgtime[0],qwkhdr.Msgtime[1]);
			xmsg.date_written.time.hh=atoi(tbuf);
	
			sprintf(tbuf,"%c%c",qwkhdr.Msgtime[3],qwkhdr.Msgtime[4]);
			xmsg.date_written.time.mm=atoi(tbuf);

			strcpy(xmsg.from, qwkhdr.MsgFrom);
			strcpy(xmsg.to,   qwkhdr.MsgTo);	
			strcpy(xmsg.subj, qwkhdr.MsgSubj);		

			MsgWriteMsg(msg, 0, &xmsg, bigbuf, 
				strlen(bigbuf)+1, strlen(bigbuf)+1, 0, NULL);
			MsgCloseMsg(msg);
/*			free(bigbuf); */
			}
		fclose(fp_dat);
		del_qwk();
		del_tmp();
		}
	logger("");
    return(1);
}

char *read_qwk(struct hub_list *hl)
{
    DIR	*dir, *tdir;
    struct dirent *ent, *tent;
    char qfile[51],unzipcmd[128];
	static char tp[128];
	int ret;

	for(packr=conf.packers; packr; packr=packr->next){
		if(!strcasecmp(hl->arc,packr->name))
			break;
		}

	if(!packr)	return(NULL);

	sprintf(qfile,"%s.qwk",hl->hub);
    
    dir = opendir(conf.inbound);
    
    while((ent = readdir(dir))) {
		if(!strcasecmp(ent->d_name,qfile)){
			sprintf(qwkfile,"%s%s",conf.inbound,ent->d_name);
			sprintf(unzipcmd,"%s %s%s -d %s",
				packr->unarc,conf.inbound,ent->d_name,conf.tmppath);
			ret=system(unzipcmd);  
			if(!ret){
				tdir=opendir(conf.tmppath);
				while((tent=readdir(tdir))){
					if(!strcasecmp(tent->d_name,"messages.dat")){
						sprintf(tp,"%s%s",conf.tmppath,tent->d_name);
						}
					}
				closedir(tdir);
				}
			else{
				logger("Error extracting qwk file.  aborting.");
				logger("");
				exit(33);
				}
			}
		}
	closedir(dir);
	return(tp);
}

int del_qwk()
{
	int ret=0;

	if(strlen(qwkfile)){
		ret=remove(qwkfile);
		if(ret){ logger("Error deleting %s",qwkfile); logger("");}
		}
	return(ret);
}

