#include <stdio.h> 
#include <stdlib.h> 
#include <sys/types.h> 
#include <dirent.h> 
#include <string.h>
#include <strings.h>

#include <smapi/msgapi.h> 

#include "qwk.h" 
#include "cfg.h"
#include "yaqn.h"


void AddArea2Cfg(struct cfg_area *ta)
{
	FILE *fptr;
	char mtyp[11];


	if(ta->type==MSGTYPE_JAM)			strcpy(mtyp,"JAM");
	else if(ta->type==MSGTYPE_SQUISH)	strcpy(mtyp,"Squish");
	else								strcpy(mtyp,"JAM");

	fptr=fopen(configfile,"at");
	if(fptr!=NULL){
		fprintf(fptr,"\nArea %d %s %s %s",ta->num,ta->hub,mtyp,ta->path);
		fclose(fptr);
		}
}

void strlwr(char *tstr)
{
	while(*tstr){
		if(*tstr>='A' && *tstr<='Z')
			*tstr+=32;
		*tstr++;
		}
}

int strip_crlf(char* buffer)
{
    do {
		if(*buffer == '\n' || *buffer == '\r')
		    *buffer = '\0';
   		} while(*buffer++);

	return(0);
}

int read_config(struct cfg* config)
{
    FILE *fp = NULL;
    char buffer[128],*p,ttxt[11];
    char *keyword, *value;
    
    fp = fopen(configfile, "r");
    
    if(!fp)
    {
	printf("Can't open configfile");
	return(-1);
    }
    
    memset(config, '\0', sizeof(struct cfg));

    while(fgets(buffer, 128, fp))
    {
	strip_crlf(buffer);

	keyword = strtok(buffer, " ");
	value = strtok(NULL, "");
	
	if(!keyword || !value) continue;
	    
	if(!strcasecmp(keyword, "Aka")) {
	    sscanf(value, "%d:%d/%d.%d", &config->aka.zone, &config->aka.net,
			 &config->aka.node, &config->aka.point);
		}
	else if(!strcasecmp(keyword, "Temppath")) {
	    strncpy(config->tmppath, value, 128); }
	else if(!strcasecmp(keyword, "LogFile")) {
	    strncpy(config->logfile, value, 128); }
	else if(!strcasecmp(keyword, "Inbound")) { 
		strncpy(config->inbound, value, 128); }
	else if(!strcasecmp(keyword, "Badpath")) {
	    strncpy(config->badpath, value, 128); }
	else if(!strcasecmp(keyword, "Badtype")) {
		if(!strcasecmp(value, "JAM")) 		  config->badtype = MSGTYPE_JAM;
		else if(!strcasecmp(value, "Squish")) config->badtype = MSGTYPE_SQUISH;
		else 								  config->badtype = MSGTYPE_SDM; }
	else if(!strcasecmp(keyword, "Packer")) {
	    packr = malloc(sizeof(struct arc_list));
	    packr->next = config->packers;
	    config->packers = packr;

		p=strtok(value,";"); 	if(p)	strcpy(packr->name,p);
		p=strtok(NULL,";"); 	if(p)	strcpy(packr->arc,p);
		p=strtok(NULL,";"); 	if(p)	strcpy(packr->unarc,p);
		}
	else if(!strcasecmp(keyword, "Area")) {
	    tarea = malloc(sizeof(struct cfg_area));
	    tarea->next = config->areas;
	    config->areas = tarea;

		p=strtok(value," \r\n\t");	if(p)	tarea->num=atoi(p);
		p=strtok(NULL," \r\n\t");	if(p)	strcpy(tarea->hub,p);	
		p=strtok(NULL," \r\n\t");	if(p)	strcpy(ttxt,p);
		p=strtok(NULL," \r\n\t");	if(p)	strcpy(tarea->path,p);

		if(!strcasecmp(ttxt, "JAM")) 		  	tarea->type=MSGTYPE_JAM;
		else if(!strcasecmp(ttxt, "Squish")) 	tarea->type=MSGTYPE_SQUISH;
		else 								  	tarea->type=MSGTYPE_SDM; 

		tarea->cnt = 0;
		strlwr(tarea->hub);
		}
	else if(!strcasecmp(keyword, "Hub")) {
	    hubs = malloc(sizeof(struct hub_list));
	    hubs->next = config->hosts;
	    config->hosts = hubs;

		p=strtok(value," \r\n\t");	if(p)	strcpy(hubs->hub,p);	
		p=strtok(NULL," \r\n\t");	if(p)	strcpy(hubs->arc,p);
		p=strtok(NULL," \r\n\t");	if(p)	strcpy(hubs->aka,p);
		p=strtok(NULL," \r\n\t");	if(p)	strcpy(ttxt,p);
		p=strtok(NULL," \r\n\t");	if(p)	strcpy(hubs->defpath,p);

		if(!strcasecmp(ttxt, "JAM")) 		  	hubs->deftype=MSGTYPE_JAM;
		else if(!strcasecmp(ttxt, "Squish")) 	hubs->deftype=MSGTYPE_SQUISH;
		else 								  	hubs->deftype=MSGTYPE_SDM; 
		}
   	}

	return(0);
}
