PROGRAM DelLog;

USES Dos,
     Crt,
     Ramon;

VAR LogFile : TEXT;
    LogPath : STRING;
    Search  : SearchRec;

BEGIN
     LogPath:=GetEnv ('WGTESTLOG');

     IF (LogPath = '') THEN
     BEGIN
          WriteLn (#7,'WGTESTLOG not set');
          Halt;
     END;

     FindFirst (LogPath,$3F,Search);
     IF (DosError <> 0) THEN
     BEGIN
          WriteLn ('DELLOG: '+LogPath+' not found');
          Halt;
     END;

     WriteLn;
     WriteLn ('Logfile: ',LogPath);
     WriteLn;
     WriteLn ('Type Y to delete this logfile or N to keep it');

     REPEAT
           IF (ReadKey <> kUnknown) THEN
              AsciiKey:=' '
           ELSE
               AsciiKey:=UpCase (AsciiKey);

           IF (AsciiKey = 'N') THEN
           BEGIN
                WriteLn ('Log file will be kept');
                WriteLn;
                Halt;
           END;

           {$IFNDEF OS2}
           IF (AsciiKey <> 'Y') THEN
           BEGIN
                Sound (2500);
                Delay (75);
                NoSound;
           END;
           {$ENDIF}

     UNTIL (AsciiKey = 'Y');

     WriteLn ('Log file will be erased');
     WriteLn;

     Assign (LogFile,LogPath);
     Erase (LogFile);
END.
