PROGRAM CopyLog;

USES Dos,
     Ramon;

{--------------------------------------------------------------------------}
{ TimeStamp                                                                }
{                                                                          }
{ Deze functie geeft een string in het formaat "10:13:12" terug met de     }
{ huidige tijd erin.                                                       }
{                                                                          }
FUNCTION TimeStamp : STRING;

VAR Hour,Min,Sec,SecH  : WordLong;

BEGIN
     GetTime (Hour,Min,Sec,SecH);

     TimeStamp:=AddUpWithPre0s (2,Word2String (Hour))+':'+
                AddUpWithPre0s (2,Word2String (Min))+':'+
                AddUpWithPre0s (2,Word2String (Sec));
END;


VAR LogFile  : TEXT;
    LogPath  : STRING;
    WorkPath : STRING;
    Regel    : STRING;
    IORes    : BYTE;
    InFile   : TEXT;

BEGIN
     LogPath:=GetEnv ('WGTESTLOG');

     IF (LogPath = '') THEN
     BEGIN
          WriteLn (#7,'WGTESTLOG not set');
          Halt;
     END;

     WorkPath:=GetEnv ('WORKDRIVE');

     IF (WorkPath = '') THEN
     BEGIN
          WriteLn (#7,'WORKDRIVE not set');
          Halt;
     END;

     WorkPath:=WorkPath+'\wtrgate\wtrgate.log';

     Assign (LogFile,LogPath);
     {$I-} Append (LogFile); {$I+} IORes:=IOResult;
     IF (IORes = 2) THEN
     BEGIN
          {$I-} ReWrite (LogFile); {$I+} IORes:=IOResult;
     END;

     IF (IORes <> 0) THEN
     BEGIN
          WriteLn (#7,'Error appending to / creating '+LogPath,' (error ',IORes,')');
          Halt;
     END;

     Assign (InFile,WorkPath);
     {$I-} Reset (InFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          Regel:=TimeStamp+Spaces (5)+'Error opening '+WorkPath+' (error '+Byte2String (IORes)+')';
          WriteLn (LogFile,Regel);
          WriteLn (Regel);
     END ELSE
     BEGIN
          Regel:=TimeStamp+Spaces (5)+'--- Contents of '+WorkPath+' start ---';
          WriteLn (LogFile,Regel);
          WriteLn (Regel);

          WHILE (NOT Eof (InFile)) DO
          BEGIN
               ReadLn (InFile,Regel);
               WriteLn (LogFile,Regel);
          END;

          Close (InFile);

          Regel:=TimeStamp+Spaces (5)+'--- Contents of '+WorkPath+' end ---';
          WriteLn (LogFile,Regel);
          WriteLn (Regel);

          (*
          {$I-} Erase (InFile); {$I+} IORes:=IOResult;
          IF (IORes <> 0) THEN
             WriteLn (LogFile,TimeStamp+Spaces (5)+'Error deleting '+WorkPath+' (error '+Byte2String (IORes)+')');
          *)
     END;

     Close (LogFile);
END.
