UNIT BinTxt;

{ this unit contains the bin-to-text conversion engine and is }
{ used both by CheckOut and the standalone Bin2Txt utility.   }

INTERFACE

FUNCTION Convert_BinTxt (InPath,OutPath : STRING) : STRING;


IMPLEMENTATION

USES Ramon;

CONST Printable : SET OF CHAR = [' '..'~'];

FUNCTION Convert_BinTxt (InPath,OutPath : STRING) : STRING;

VAR InFile    : FILE;
    OutFile   : TEXT;
    Buf       : ARRAY[1..100] OF CHAR;
    BytesRead : WordLong;
    Regel     : STRING;
    IORes     : BYTE;
    P         : LONGINT;
    Lp        : BYTE;
    CheckCnt  : BYTE;

BEGIN
     Assign (InFile,InPath);
     {$I-} Reset (InFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          Convert_BinTxt:='Failed to open '+InPath+' (error '+Byte2String (IOREs)+')';
          Exit;
     END;

     Assign (OutFile,OutPath);
     {$I-} ReWrite (OutFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          Close (InFile);
          Convert_BinTxt:='Failed to craete '+OutPath+' (error '+Byte2String (IORes)+')';
          Exit;
     END;

     P:=0;
     WHILE (P < FileSize (InFile)) DO
     BEGIN
          Seek (InFile,P);
          BlockRead (InFile,Buf,50,BytesRead);

          Regel:='';

          { if at least five printables, then print it }
          IF (Buf[1] IN Printable) AND (Buf[2] IN Printable) AND (Buf[3] IN Printable) AND
             (Buf[4] IN Printable) AND (Buf[5] IN Printable) THEN
          BEGIN
               FOR Lp:=1 TO BytesRead DO
               BEGIN
                    IF NOT (Buf[Lp] IN Printable) THEN
                       Break;

                    Regel:=Regel+Buf[Lp];
                    Inc (P);
               END;
          END ELSE
          BEGIN
               IF (BytesRead > 12) THEN
                  CheckCnt:=12
               ELSE
                  CheckCnt:=BytesRead;

               FOR Lp:=1 TO CheckCnt DO
               BEGIN
                    Regel:=Regel+Byte2HexString (Byte (Buf[Lp]))+'-';
                    Inc (P);

                    IF (Lp < BytesRead-4) AND
                       (Buf[Lp+1] IN Printable) AND
                       (Buf[Lp+2] IN Printable) AND
                       (Buf[Lp+3] IN Printable) AND
                       (Buf[Lp+4] IN Printable) AND
                       (Buf[Lp+5] IN Printable)
                    THEN
                        Break;
               END;

               Delete (Regel,Length (Regel),1);
          END;

          WriteLn (OutFile,Regel);
     END;

     Close (OutFile);
     Close (InFile);

     Convert_BinTxt:='';
END;

END.
