UNIT WtrFunc;

{ -------------------------------------------------- }
{ WtrFunc.Pas                                        }
{                                                    }
{ This unit contains some basic functions to access  }
{ the configuration and areabase files.              }
{                                                    }
{ (c) 1994 WaterLine Software Development            }

INTERFACE

{ Include Structure definitions }

{$I kit\Config.Inc    }
{$I AreaBase.Inc  }
{$I UserBase.Inc  }

FUNCTION  ReadConfiguration( VAR Config : ConfigRecord ) : Boolean;

FUNCTION  OpenAreaBase( VAR AreaBaseFile : FILE ) :  Boolean;
FUNCTION  AreaBaseRecordCount( VAR AreaBaseFile : FILE ) : Longint;
FUNCTION  ReadAreaBaseRecord( VAR AreaBaseFile : FILE ; VAR AreaRec : AreaBaseRecord ; Rec : Longint ) : BOOLEAN;
PROCEDURE CloseAreaBase( VAR AreaBaseFile : FILE );

IMPLEMENTATION

USES Dos;

VAR  Directory : STRING;

{ -------------------------------------------------------------------------}
{ ReadConfiguration                                                        }
{                                                                          }
{ Opens the WaterGate configuration file and tries to read it into memory  }

FUNCTION ReadConfiguration( VAR Config : ConfigRecord ) : Boolean;
VAR ConfigFile : FILE;
BEGIN

  ReadConfiguration := false;
  Directory := GetEnv('WTRGATE');

  IF (Directory[ length( Directory ) ] <> '\') AND (Directory<>'') THEN
   Directory := Directory + '\';

  {$I-}
  Assign( ConfigFile, Directory + ConfigFileName);
  Reset( ConfigFile, 1 );
  {$I-}

  IF IoResult > 0 THEN
   Exit;

  {$I-}
  Seek( ConfigFile, 26 );
  BlockRead( ConfigFile, Config, SizeOf( Config ));
  Close( ConfigFile );
  {$I+}

  ReadConfiguration:= (IoResult = 0);
END;

{ ------------------------------------------------------------------------- }
{ OpenAreaBase                                                              }
{                                                                           }
{ Opens the area configuration file.                                        }

FUNCTION OpenAreaBase( VAR AreaBaseFile : FILE ) :  Boolean;
BEGIN

  {$I-}
  Assign( AreaBaseFile , Directory + AreaBaseFileName );
  Reset( AreaBaseFile , 1 );
  {$I+}
  OpenAreaBase := (IoResult = 0);

END;

{ --------------------------------------------------------------------------}
{ ReadAreaBaseRecord                                                        }
{                                                                           }
{ Reads a record from the areabase                                          }

FUNCTION ReadAreaBaseRecord( VAR AreaBaseFile : FILE ; VAR AreaRec : AreaBaseRecord ; Rec : Longint ) : BOOLEAN;
BEGIN
  {$I-}
  Seek( AreaBaseFile , Rec * sizeof( AreaBaseRecord ) + 26 );
  BlockRead( AreaBaseFile , AreaRec , sizeof( AreaRec ));
  {$I+}
  ReadAreaBaseRecord := (IOResult = 0);
END;

{ ------------------------------------------------------------------------- }
{ AreaBaseRecordCount                                                       }
{                                                                           }
{ Returns the number of record in the areabase                              }

FUNCTION AreaBaseRecordCount( VAR AreaBaseFile : FILE ) : Longint;
BEGIN
  AreaBaseRecordCount := (FileSize (AreaBaseFile) - 26) DIV SizeOf( AreaBaseRecord );
END;


{ ------------------------------------------------------------------------- }
{ CloseAreaBase                                                             }
{                                                                           }
{ Closes the Area Configuration; could have done the same with one line of  }
{ code of course.                                                           }

PROCEDURE CloseAreaBase( VAR AreaBaseFile : FILE );
BEGIN
  Close( AreaBaseFile );
END;

BEGIN
 Directory := '';
END.