PROGRAM WTR2MAX;

{ WaterGate to Maximus                                                      }
{                                                                           }
{ File    : WTR2MAX.PAS                                                     }
{ Compiler: Turbo Pascal v7.00                                              }
{ Date    : 19/03/1994                                                      }
{ Version : 1.01                                                            }
{                                                                           }
{ This program exports all active areas in the WaterGate configuration to   }
{ a textfile formated like Maximus 2.00 's MSGAREA.CTL. The program         }
{ searches for the WaterGate configuration in its current directory, or the }
{ directory set by the WTRGATE enviroment variable.                         }
{                                                                           }
{ Usage:                                                                    }
{                                                                           }
{ WTR2MAX [BOARD=<boardnumber>] [FILE=<filename>]                           }
{                                                                           }
{ BOARD is the boardnumber WaterGate should start numbering, if no number   }
{ is given WaterGate starts at board 1. FILE is the output filename, the    }
{ default is 'MSGAREA.CTL'                                                  }
{                                                                           }
{ Maximus 2.00 is a BBS program                                             }
{ Copyrighted by Scott J. Dudley                                            }

{ "WtrFunc" contains some basic functions to access the configuration       }

USES WtrFunc;

CONST DefaultFileName   = 'MSGAREA.CTL';
      DefaultStartBoard = 1;

VAR   Config            : ConfigRecord;
      AreaData          : AreaBaseRecord;
      AreaBaseFile      : FILE;
      MaximusAreaFile   : Text;

      MaximusAreaName   : STRING;
      BoardNumber       : Longint;


{ -------------------------------------------------------------------------}
{ ShowInfo                                                                 }
{                                                                          }

PROCEDURE ShowInfo;
BEGIN
 Writeln( 'Wtr2Max v1.00' );
 Writeln( 'Waterline Software Dev. 1994');
 Writeln;
END;


{ -------------------------------------------------------------------------}
{ ShowHelp                                                                 }
{                                                                          }

PROCEDURE ShowHelp;
BEGIN
 Writeln( 'Usage: WTR2MAX [BOARD=<boardnumber>] [FILE=<filename>]');
 Writeln;
 Writeln( 'BOARD        -  Starting number for the message boards');
 Writeln( 'FILE         -  Filename to export to');
 Writeln;
 Writeln( 'Run this program from your directory containing your WaterGate');
 Writeln( 'configuration files, or set the WTRGATE enviroment variable.');
 Writeln;
END;

{ ------------------------------------------------------------------------- }
{ ParseCommandLineOptions                                                   }
{                                                                           }
{ Checks the commandline for BOARD= and FILE= commands                      }

PROCEDURE ParseCommandLineOptions;
VAR ParamCounter : Byte;
    ToUpper      : Byte;
    Error        : Integer;
    Parameter    : String;
BEGIN


 { Check for commandline options }
 FOR ParamCounter := 1 TO ParamCount DO
  BEGIN

   { Search for the next parameter                    }
   Parameter := ParamStr( ParamCounter );
   FOR ToUpper := 1 TO Length( Parameter ) DO
    Parameter[ToUpper] := UpCase( Parameter[ToUpper] );

   { Check for a optional different start number      }
   IF Pos( 'BOARD=' , Parameter )=1 THEN
    BEGIN
    Val( Copy( Parameter , 7,255), BoardNumber, Error );

    IF Error > 0 THEN
     BEGIN
     Writeln('Error! Syntax error in "BOARD=" parameter !');
     Halt(1);
     END;

    Continue;
    END;

   { Check for an optional different output file name }
   IF Pos( 'FILE=' , ParaMeter )=1 THEN
    BEGIN
    MaximusAreaName := Copy( ParaMeter, 6, 255);
    Continue;
    END;

   { Unknown option }
   Writeln('Error! Unknown command line option : ',Parameter );
   Writeln;

   ShowHelp;
   Halt(1);

  END;

END;


{ ------------------------------------------------------------------------- }
{ Main                                                                      }
{                                                                           }
{ Processes the area configuration, and dumps it into an export file        }

VAR AreaCounter : Longint;

BEGIN

 { Initialization                      }
 BoardNumber     := DefaultStartBoard;
 MaximusAreaName := DefaultFileName;

 { Show program info                   }
 ShowInfo;

 { Check the command line              }
 ParseCommandlineOptions;

 { Try to open the Configuration file  }
 IF NOT ReadConfiguration( Config ) THEN
  BEGIN
  Writeln('Error! Unable to open WaterGate configuration file !');
  Halt(1);
  END;

 { Try to open the AreaBase file       }
 IF NOT OpenAreaBase( AreaBaseFile ) THEN
  BEGIN
  Writeln('Error! Unable to open WaterGate Area Base !');
  Halt(1);
  END;

 { Try to open the Maximus export file }

 {$I-}
 Assign( MaximusAreaFile , MaximusAreaName );
 Rewrite( MaximusAreaFile );
 {$I+}

 IF IoResult > 0 THEN
  BEGIN
  Writeln( 'Error! Unable to open "' + MaximusAreaName + '" for output.');
  Halt(1);
  END;

 { Export all areas to disk            }
 FOR AreaCounter := 1 TO AreaBaseRecordCount( AreaBaseFile ) DO
  BEGIN

   ReadAreaBaseRecord( AreaBaseFile, AreaData, AreaCounter );

   IF (NOT AreaData.Deleted) AND (AreaData.FidoMsgStyle IN [SquishType,FidoMsgType] ) THEN
   BEGIN

    { Show a counter for those nervous CTRL-ALT-DELlers }
    Write( 'Area : ' , AreaCounter , #13 );

    Writeln( MaximusAreaFile , 'Area ' , BoardNumber );
    Writeln( MaximusAreaFile , ' MsgAccess Twit');

    CASE AreaData.FidoMsgStyle OF
     SquishType : Writeln( MaximusAreaFile, ' Type      Squish' );
     FidoMsgType: Writeln( MaximusAreaFile, ' Type      *.MSG' );
    END;

    Writeln( MaximusAreaFile,' MsgInfo   ' + AreaData.AreaName_F );
    Writeln( MaximusAreaFile,' Echomail  ' + AreaData.FidoMsgPath );

    IF AreaData.OriginNr = 0 THEN
     Writeln( MaximusAreaFile, ' Origin  0 ' + AreaData.Origin )
    ELSE
     Writeln( MaximusAreaFile, ' Origin  0 ' + Config.Origins[ AreaData.OriginNr ] );

    Writeln( MaximusAreaFile,' Public    Only');
    Writeln( MaximusAreaFile,'End Area');
    Writeln( MaximusAreaFile );

    Inc( BoardNumber );
   END;
  END;

 { Close all open files }
 CloseAreaBase( AreaBaseFile );
 Close ( MaximusAreaFile );

 Writeln;
 Writeln( 'Finished !');

END.
