{ -------------------------------------------------- }
{ AreaBase.Inc                                       }
{                                                    }
{ This file contains the structure definitions of    }
{ the WaterGate Area Database.                       }
{                                                    }
{ (c) 1994 WaterLine Software Development            }

{$IFNDEF WTR_AREABASE}
{$DEFINE WTR_AREABASE}

{$I Globals.Inc}

CONST MaxLenModerator       = MaxLenUserName;
TYPE  AreaNameString        = STRING[MaxLenAreaName];
      mdType                = (mdNONE,mdUSE);                       { Moderator type                     }
      AreaRecordType        = (area_echo,area_netmail,area_local);

TYPE  AreaBaseRecord = RECORD
                            Deleted    : BOOLEAN;                   { Record no longer valid if true     }

                            AreaType   : AreaRecordType;

                            AreaName_U,
                            AreaName_F : AreaNameString;

                            Comment    : STRING[MaxLenComment];     { Description                        }
                            IsInGroups : GroupFlagType;             { In groups (bits 1-26)              }
                            UserList   : SubscriptBaseRecordNrType; { Connected Users                    }

                            { Fido   }

                            OriginAka  : BYTE;    { offset in Config.NodeNrs    }
                            SeenByAkas : LONGINT; { Bits 0-20 add AKA to SeenBy }

                            Passive    : Boolean; { Make passive when uplink is disconnected }
                            AlwPassive : Boolean; { Do not make this area passive            }

                            { Usenet }

                            OriginNr   : BYTE; {1/2 for Config.Origins[], 0=custom }
                            Origin     : STRING[MaxLenOrigin]; { Custom Origin }

                            { Fidonet Local Base }

                            FidoMsgStyle: FidoMsgStyleType;         { Type of base }
                            FidoMsgPath : STRING[ 79 ];             { Path to base }
                            FidoMsgAge  : Integer;                  { Days to keep }
                            FidoMsgLimit: Integer;                  { Numb to keep }

                            { Usenet special  }

                            Moderated    : mdType;                  { Moderated    }
                            Moderator    : STRING[MaxLenModerator]; { Moderator    }
                      END;

{$ENDIF}

