PROGRAM Dlu2Bag;

USES Dos;

PROCEDURE ProcessDLU (Name : STRING);

VAR InFile  : TEXT;
    BagFile : TEXT;
    IORes   : BYTE;
    BagName : STRING;
    Regel   : STRING;
    Convert : BOOLEAN;

BEGIN
     Assign (InFile,Name);
     {$I-} Reset (InFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          WriteLn ('Error opening ',Name,' (error ',IORes,')');
          Exit;
     END;

     BagName:=Name;
     IF (Pos ('.',BagName) > 0) THEN
        BagName:=Copy (BagName,1,Pos ('.',BagName)-1);
     BagName:=BagName+'.BAG';

     Assign (BagFile,BagName);
     {$I-} ReWrite (BagFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          WriteLn ('Error creating ',BagName,' (error ',IORes,')');
          Close (InFile);
          Exit;
     END;

     WriteLn ('Creating ',BagName,' from ',Name);

     Convert:=TRUE;
     WHILE (NOT Eof (InFile)) DO
     BEGIN
          ReadLn (InFile,Regel);

          IF Convert THEN
          BEGIN
               IF (Regel = #$7F) THEN
                  Break; { end of file }

               IF (Copy (Regel,1,4) = '423 '{article not available}) THEN
                  Continue; { stay in Convert mode }

               IF (Copy (Regel,1,4) <> '220 ') THEN
                  WriteLn ('ERROR: Expected "220" at start of ',Regel);

               WriteLn (BagFile,'#! rnews 0');

               Convert:=FALSE;
          END ELSE
          BEGIN
               IF (Regel = '.') THEN
                  Convert:=TRUE
               ELSE
                   WriteLn (BagFile,Regel);
          END;

     END; { while }

     Close (BagFile);
     Close (InFile);
END;


VAR Search : SearchRec;

BEGIN
     WriteLn ('DLU to BAG conversion program v1.00 (990307)');
     WriteLn ('FreeWare - Written by Ramon van der Winkel');
     WriteLn;

     IF (ParamCount = 0) THEN
     BEGIN
          WriteLn ('This program convers .DLU files to .BAG files.');
          WriteLn ('A .DLU file is created by NetTamer when it downloads news');
          WriteLn ('articles. The .BAG file can be processed by WaterGate.');
          WriteLn;
          WriteLn ('Usage: dlu2bag <file search pattern>');
          WriteLn;
          WriteLn ('Example: dlu2bag myfile.dlu');
          WriteLn ('Example: dlu2bag somepath\yourfile.dlu');
          WriteLn ('Example: dlu2bag *.dlu');
          WriteLn;
          WriteLn ('The .BAG files are always created in the current directory!');
          Exit;
     END;

     FindFirst (ParamStr (1),$3F,Search);
     WHILE (DosError = 0) DO
     BEGIN
          IF ((Search.Attr AND $10) = 0) AND (Search.Size > 0) THEN
             ProcessDLU (Search.Name);

          FindNext (Search);
     END;
END.
