PROGRAM TdbTest;

USES Tdb;

CONST MAX_DATA = 500;

TYPE TestRecord = RECORD
                        RecNr : WORD;
                        Data  : ARRAY[1..MAX_DATA] OF WORD;
                  END;

VAR TdbNr : TdbNrType;
    Lp    : WORD;
    ARec  : TestRecord;
    Nr    : WORD;
    Lp2   : WORD;

BEGIN
     WriteLn ('TdbTest v1.00 - 970410');
     WriteLn;

     IF (TdbCreate ('TDBTEST.TDB','TdbTest Database v1',TdbNr) <> _TdbOk) THEN
     BEGIN
          WriteLn ('Could not create tdbtest.tdb');
          Exit;
     END;

     TdbSetIO (TdbNr,SizeOf (TestRecord));

     WriteLn ('Writing...');

     FOR Lp:=1 TO MAX_DATA DO
         ARec.Data[Lp]:=Lp;

     FOR Lp:=1 TO 10000 DO
     BEGIN
          ARec.RecNr:=Lp;
          TdbWrite (TdbNr,Lp,ARec);
     END;

     WriteLn ('MemAvail=',MemAvail);

     WriteLn ('Caching...');
     TdbCache (TdbNr);

     WriteLn ('MemAvail=',MemAvail);

     {
     WriteLn ('Reading...');

     FOR Lp:=1 TO 20000 DO
     BEGIN
          Nr:=1+Random (20000);

          TdbRead (TdbNr,Nr,ARec);

          IF (ARec.RecNr <> Nr) THEN
             WriteLn ('Error in record ',Nr,': RecNr=',ARec.RecNr);

          FOR Lp2:=1 TO MAX_DATA DO
              IF (ARec.Data[Lp2] <> Lp2) THEN
                 WriteLn ('Error in record ',Nr,': Data[',Lp2,']=',Lp2);
     END;
     }

     {
     WriteLn ('Writing more...');

     FOR Lp:=1 TO MAX_DATA DO
         ARec.Data[Lp]:=Lp;

     FOR Lp:=15001 TO 25000 DO
     BEGIN
          ARec.RecNr:=Lp;
          TdbWrite (TdbNr,Lp,ARec);
     END;
     }

     WriteLn ('Reading...');

     FOR Lp:=1 TO 10000 DO
     BEGIN
          Nr:=1+Random (10000);

          TdbRead (TdbNr,Nr,ARec);

          IF (ARec.RecNr <> Nr) THEN
             WriteLn ('Error in record ',Nr,': RecNr=',ARec.RecNr);

          FOR Lp2:=1 TO MAX_DATA DO
              IF (ARec.Data[Lp2] <> Lp2) THEN
                 WriteLn ('Error in record ',Nr,': Data[',Lp2,']=',Lp2);
     END;

     TdbClose (TdbNr);

     WriteLn ('MemAvail=',MemAvail);
     WriteLn ('Program ended');
END.
