{ PCBoardDump                                                           }
{                                                                       }
{ Dumpt de inhoud van een PCBoard file op het scherm                    }

PROGRAM PCBDump;

USES {Ramon,}PCBoard,Globals;

TYPE DateArray = ARRAY [1..8] OF Byte;
VAR  StdOut    : Text;

PROCEDURE DumpData ( Data : ARRAY OF Byte ; Length : Byte );
VAR Lp : Byte;
BEGIN
 FOR Lp := 0 TO (Length-1) DO
  BEGIN
  IF Data[Lp] = 227 THEN
   Writeln(StdOut)
  ELSE
   Write( StdOut , Chr( Data[Lp] ));
  END;
END;

VAR  IndexFile,
     BaseFile : FILE;
     BaseHeader: PCB_BaseHeader;
     MsgHeader : PCB_MessageHeader;
     IdxEntry  : PCB_IndexEntry;
     MsgNumb   : Longint;
     Body      : Array [1..128] OF Byte;
     Lp        : Longint;
     TmpX      : Longint;

BEGIN

   Assign( StdOut , '' );
   Rewrite(StdOut);

   Writeln( StdOut , 'PCBoard message dumper v1.0');
   Writeln( StdOut );

   Assign ( BaseFile , ParamStr(1) );
   {$I-} Reset( BaseFile , 1 ); {$I+}

   Assign ( IndexFile, ParamStr(1) + '.IDX' );
   {$I-} Reset( IndexFile, 1 ); {$I+}

   IF IoResult > 0 THEN
    BEGIN
    Writeln(StdOut , 'Unable to open ',ParamStr(1));
    Exit;
    END;

   { Lees de header van de base in      }
   BlockRead ( BaseFile , BaseHeader , Sizeof( BaseHeader ));

   { Dump de informatie naar het scherm }

   Writeln( StdOut , 'Base : ' , ParamStr(1) );
   Writeln( StdOut , '--------------------------------------------------------');
   Writeln( StdOut );
   Writeln( StdOut , 'High message : ',Micro2Longint ( BaseHeader.HighMessage ));
   Writeln( StdOut , 'Low message  : ',Micro2Longint ( BaseHeader.LowMessage  ));
   Writeln( StdOut , 'Active       : ',Micro2Longint ( BaseHeader.Active      ));
   Writeln( StdOut , 'Callers      : ',Micro2Longint ( BaseHeader.Callers     ));
   Writeln( StdOut );

   MsgNumb := 0;

   WHILE (NOT Eof( BaseFile )) DO
    BEGIN
     BlockRead( BaseFile , MsgHeader , sizeof( MsgHeader ));
     BlockRead( IndexFile, IdxEntry  , sizeof( IdxEntry  ));

     Inc( MsgNumb );

    WITH MsgHeader DO
     BEGIN

     Writeln( StdOut , 'Message : ' , MsgNumb );
     Writeln( StdOut , 'Offset  : ' , FilePos( BaseFile ) - Sizeof( MsgHeader ));
     Writeln( StdOut );
     Writeln( StdOut , 'Status     : ' , Status );
     Writeln( StdOut , 'MsgNumber  : ' , Micro2Longint( MsgNumber ));
     Writeln( StdOut , 'RefNumber  : ' , Micro2Longint( RefNumber ));
     Writeln( StdOut , 'NumBlocks  : ' , NumBlocks );

     Write  ( StdOut , 'Datum      : ' ); DumpData ( Date , 8 ); Writeln( StdOut );
     Write  ( StdOut , 'Tijd       : ' ); DumpData ( Time , 5 ); Writeln( StdOut );
     Write  ( StdOut , 'ToField    : ' ); DumpData ( ToField , 25 ); Writeln( StdOut );

     Writeln( StdOut );
     WriteLn( StdOut , 'Reply date   : ' , ReplyDate ); {Julian}
     Writeln( StdOut , 'Reply status : ' , ReplyStatus );
     Write  ( StdOut , 'From Field   : ' ); DumpData( FromField,25); Writeln( StdOut );
     Write  ( StdOut , 'Subj FIeld   : ' ); DumpData( SubjField,25); Writeln( StdOut );
     Write  ( StdOut , 'Password     : ' ); DumpData( Password,12 ); Writeln( StdOut );
     Writeln( StdOut , 'Activeflag   : ' , ActiveFlag );
     Writeln( StdOut , 'EchoFlag     : ' , EchoFlag   );
     Writeln( StdOut , 'Reserved1    : ' , Reserved1  );
     Writeln( StdOut , 'ExtendedSt   : ' , ExtendedSt );
     Writeln( StdOut , 'Reserved2    : ' , Reserved2  );

     Writeln( StdOut , 'IDX Offset       : ' , IDXEntry.Offset     );
     Writeln( StdOut , 'IDX MessageNumb  : ' , IDXEntry.MessageNumb);
     Write  ( StdOut , 'IDX TOName       : ' ); DumpData ( IDXEntry.TOName   , 25 ); Writeln( StdOut );
     Write  ( StdOut , 'IDX TOName       : ' ); DumpData ( IDXEntry.FROMName , 25 ); Writeln( StdOut );
     Writeln( StdOut , 'IDX Status       : ' , IDXEntry.Status );
     Writeln( StdOut , 'IDX Date         : ' , IDXEntry.Date   );
     Write ( StdOut , 'IDX NotUsed      : ' ); DumpData ( IDXEntry.Reserved,3); Writeln;
     Writeln( StdOut );

     FOR Lp := 1 TO (NumBlocks-1) DO
      BEGIN
       BlockRead( BaseFile , Body , 128 );
       DumpData( Body , 128 );
      END; {For}

     END; {With MsgHeader}

    END; {While !Eof}

   Close( BaseFile ); Close (IndexFile );
END.





