PROGRAM KeyTest;

{$IFOPT G+} ### {$ENDIF}

{--------------------------------------------------------------------------}
{ Byte2HexString                                                           }
{                                                                          }
{ Zet de opgegeven BYTE om in een hexadecimale representatie van 2 digits. }
{                                                                          }
FUNCTION Byte2HexString (Getal : BYTE) : STRING;

CONST HexDigits : ARRAY[0..15] OF CHAR = ('0','1','2','3','4','5','6','7',
                                          '8','9','A','B','C','D','E','F');

BEGIN
     Byte2HexString:=HexDigits[Getal SHR 4]+HexDigits[Getal AND 15];
END;


{--------------------------------------------------------------------------}
{ Word2HexString                                                           }
{                                                                          }
{ Zet de opgegeven WORD om in een hexadecimale representatie van 4 tekens. }
{                                                                          }
FUNCTION Word2HexString (Getal : WORD) : STRING;
BEGIN
     Word2HexString:=Byte2HexString (Getal SHR 8)+
                     Byte2HexString (Getal AND 255);
END;


VAR Result    : WORD;
    ScanCode  : BYTE;
    AsciiCode : BYTE;

BEGIN
     WriteLn ('KeyTest v1.01 - 970414');
     WriteLn;

     IF (ParamCount = 0) THEN
     BEGIN
          WriteLn ('Detecting MF-II keyboard support...');
          WriteLn ('Calling INT 0x16, with AX=0x1200');
          WriteLn;

          ASM
             MOV AX,$1200
             INT $16
             MOV Result,AX
          END;
     END ELSE
         Result:=$1200;

     IF ((Result AND $FF00) <> $1200) THEN
     BEGIN
          WriteLn ('BIOS support for MF-II keyboads present.');
          WriteLn ('AX out was 0x',Word2HexString (Result));
          WriteLn;
          WriteLn ('Press a key to continue..');

          ASM
             MOV AH,$10
             INT 16h
             MOV ScanCode,AH
             MOV AsciiCode,AL
          END;

     END ELSE
     BEGIN
          WriteLn ('BIOS support for MF-II keyboards NOT present.');
          WriteLn;
          WriteLn ('Press a key to continue..');

          ASM
             MOV AH,0
             INT 16h
             MOV ScanCode,AH
             MOV AsciiCode,AL
          END;

     END;

     WriteLn ('Survived! ;)');
     WriteLn;

     WriteLn ('ScanCode: 0x',Byte2HexString (ScanCode));
     WriteLn ('KeyCode:  0x',Byte2HexString (AsciiCode));

     WriteLn;
     WriteLn ('Program ended');
END.
