PROGRAM GrpTest;

USES Cfg,
     Database;

VAR G2,
    Group : GroupFlagType;

BEGIN
     ReadConfigFile;
     OpenDatabases;

     WriteLn ('R/w groups filter: ',BuildGroupListDesc (ReadWriteGroupsFilter,255));

     ResetGroupFlags (Group);
     WriteLn ('After reset: ',BuildGroupListDesc (Group,255));

     WriteLn ('TestGroupListIsEmpty: ',TestGroupListIsEmpty (Group));

     AddGroupToGroupList (Group,1);
     AddGroupToGroupList (Group,6);
     AddGroupToGroupList (Group,36);
     AddGroupToGroupList (Group,128);

     WriteLn ('After adding A1,B1,H1,Z3: ',BuildGroupListDesc (Group,255));

     WriteLn ('TestGroupListIsEmpty: ',TestGroupListIsEmpty (Group));

     WriteLn ('TestIfInGroup (A1): ',TestIfInGroup (Group,1));
     WriteLn ('TestIfInGroup (A2): ',TestIfInGroup (Group,2));
     WriteLn ('TestIfInGroup (B1): ',TestIfInGroup (Group,6));
     WriteLn ('TestIfInGroup (H1): ',TestIfInGroup (Group,36));
     WriteLn ('TestIfInGroup (Z1): ',TestIfInGroup (Group,126));
     WriteLn ('TestIfInGroup (Z3): ',TestIfInGroup (Group,128));

     WriteLn ('TestGroupListSame (g,g): ',TestGroupListSame (Group,Group));
     WriteLn ('TestGroupListSame (g,rw): ',TestGroupListSame (Group,ReadWriteGroupsFilter));

     WriteLn ('TestIfGroupCommon (g,g): ',TestIfGroupCommon (Group,Group));
     WriteLn ('TestIfGroupCommon (g,rw): ',TestIfGroupCommon (Group,ReadWriteGroupsFilter));
     WriteLn ('TestIfGroupCommon (rw,g): ',TestIfGroupCommon (ReadWriteGroupsFilter,Group));
     WriteLn ('TestIfGroupCommon3 (rw,g,rw): ',TestIfGroupCommon3 (ReadWriteGroupsFilter,Group,ReadWriteGroupsFilter));

     G2:=ReadWriteGroupsFilter;
     CreateCommonGroup (G2,Group,ReadWriteGroupsFilter);

     WriteLn ('CreateCommonGroup: ',BuildGroupListDesc (G2,255));

     CloseDatabases;
END.
