PROGRAM DumpList;

CONST MaxLenListNameType = 30;

TYPE ListNameType    = STRING[MaxLenListNameType];
     ListSystemType  = (lstName,lstFido,lstUUCP,lstRemoteGateway);
     ListAccessType  = (laReadWrite,laReadOnly,laWriteOnly);
     ListConfirmType = (lcNever,lcOk,lcReq1,lcReq2,lcReq3);
     ListAddrType    = (laNowhere,laFrom,laReplyTo,laSender);
     ListServerRecordNrType = WORD;

CONST MaxLenFidoAddrDomain = 25;

TYPE FidoAddrType = RECORD
                          Zone   : WORD;
                          Net    : WORD;
                          Node   : WORD;
                          Point  : WORD;
                          Domain : STRING[MaxLenFidoAddrDomain];
                    END;

TYPE ListServerRecord = RECORD
                             Deleted     : BOOLEAN;
                             ListSystem  : ListSystemType;
                             NextUser    : ListServerRecordNrType;

                             { common fields for all user types }
                             { RWI960721 }
                             Access          : ListAccessType;
                             { RWI961208 }
                             SubscribedDate  : LONGINT;
                             ConfirmedDate   : LONGINT;
                             ConfirmReqDate  : LONGINT;
                             ConfirmState    : ListConfirmType;
                             ConfirmCode     : LONGINT; { hex nr }

                             CASE INTEGER OF
                                  {ServerInfo}
                                  0 : (ListName        : ListNameType;
                                       ListDescription : STRING[40];
                                       ListWelcome     : STRING[79];
                                       ListAKA         : BYTE;
                                       ListPrivate     : BOOLEAN;
                                       OnlyKnown       : BOOLEAN;
                                       Active          : BOOLEAN;
                                       AreaName        : STRING[60];
                                       EchoList        : BOOLEAN;
                                       ListEcho        : BOOLEAN;
                                       { RWI960721 }
                                       DefaultAccess   : ListAccessType;
                                       { RWI961208 }
                                       MLAddress       : ListAddrType;
                                       ConfirmInterval : BYTE; { days }
                                       HomeDomain      : BYTE; { 1..MaxSystemDomains }
                                       AdminPassword   : STRING[8];
                                       );

                                  { fido }
                                  1 : (Address   : FidoAddrType;
                                       Name      : STRING[50];
                                      );

                                  { usenet }
                                  2 : (Email     : STRING[50];
                                      );

                                  { remote gateway }
                                  3 : (GWAddress : FidoAddrType;
                                       GWUser    : STRING[50];
                                       GWEmail   : STRING[50];
                                      );
                       END;

VAR InFile : FILE;
    Rec    : ListServerRecord;
    RecNr  : WORD;
    Header : STRING;

BEGIN
     Assign (Output,'');
     ReWrite (Output);

     Assign (InFile,ParamStr (1));
     Reset (InFile,1);

     WriteLn (Output,'Filename: ',ParamStr (1));

     BlockRead (InFile,Header,26);
     Header[0]:=#26;
     WriteLn (Output,'Header:   ',Header);

     RecNr:=0;

     WHILE (FilePos (InFile) < FileSize (InFile)) DO
     BEGIN
          Inc (RecNr);
          BlockRead (InFile,Rec,SizeOf (ListServerRecord));

          WriteLn (Output,'-----------------------------------------------------');
          WriteLn (Output,'Record Nr:  ',RecNr);
          WriteLn (Output,'Deleted:    ',Rec.Deleted);
          Write   (Output,'ListSystem: ',Byte (Rec.ListSystem),' (');
          CASE Rec.ListSystem OF
               lstName : WriteLn (Output,'List Definition)');
               lstFido : WriteLn (Output,'FTN subscriber)');
               lstUUCP : WriteLn (Output,'RFC subscriber)');
               lstRemoteGateway : WriteLn (Output,'Remote GW subscriber)');
               ELSE WriteLn ('**UNKNOWN**)');
          END;

          WriteLn (Output,'NextUser:   ',Rec.NextUser);

          CASE Rec.ListSystem OF
               lstName :
                   BEGIN
                        WriteLn (Output,'Name:       ',Rec.ListName);
                        WriteLn (Output,'Descr.:     ',Rec.ListDescription);
                        WriteLn (Output,'Welcome:    ',Rec.ListWelcome);
                        WriteLn (Output,'Aka:        ',Rec.ListAka);
                        WriteLn (Output,'Private:    ',Rec.ListPrivate);
                        WriteLn (Output,'OnlyKnown   ',Rec.OnlyKnown);
                        WriteLn (Output,'Active      ',Rec.Active);
                        WriteLn (Output,'AreaName    ',Rec.AreaName);
                        WriteLn (Output,'EchoList    ',Rec.EchoList);
                        WriteLn (Output,'ListEcho    ',Rec.ListEcho);
                        WriteLn (Output,'DefAccess:  ',Byte (Rec.DefaultAccess));
                        WriteLn (Output,'MLAddress:  ');
                        WriteLn (Output,'ConfirmInt: ',Rec.ConfirmInterval);
                   END;

               lstFido:
                   WriteLn (Output,'Address:    "',Rec.Name,'"%',
                                                   Rec.Address.Zone,':',
                                                   Rec.Address.Net,'/',
                                                   Rec.Address.Node,'.',
                                                   Rec.Address.Point);

               lstUUCP:
                   WriteLn (Output,'Address:    ',Rec.EMail);

               lstRemoteGateway:
                   WriteLn (Output,'Address:    ',Rec.GWEmail,' via "',
                                                  Rec.GWUser,'"%',
                                                  Rec.GWAddress.Zone,':',
                                                  Rec.GWAddress.Net,'/',
                                                  Rec.GWAddress.Node,'.',
                                                  Rec.GWAddress.Point);
          END; { case }

     END; { while }

     Close (InFile);
END.
