PROGRAM WtrConf;

{ WaterGate Configuration Program }

{$I platform.inc}

{$A+,F-,P-,Q-,R-,S-,V+,X+}

{$IFDEF PLATFORM_OS2_OR_WIN32}
{$M 16384}
{$ENDIF}

{$IFDEF PLATFORM_DOS_ALL}
{$M 16384,0,655360}
{$ENDIF}

{$IFNDEF WTRCONF} ## Check your conditional defines! ## {$ENDIF}

{$IFNDEF PLATFORM_OS2_WIN32}
{$IFOPT G+}       ## Switch of 286 code generation! ## {$ENDIF}
{$ENDIF}

{$IFOPT B+}       ## DISABLE Complete Boolean Evaluation ## {$ENDIF}

USES Ramon,
     Globals,
     Cfg,
     Database,
     FlexCfg,
     ImpExp,
     Tdb,
     FlexTdb,
     Copyrigh,
     CfgEdit,
     AreaBase,
     UserBase,
     Mappers,
     ListEdit,
    {CfgExport,}
     Dos,
     GrpEdit;

{$I wtrhlp.inc}

PROCEDURE ShowHelp;
BEGIN
     WriteLn ('Starting the program without any command line parameters will give a desktop');
     WriteLn ('with menu from which you can choose any of the options shown below.');
     WriteLn;
     WriteLn ('Usage: WTRCONF'+
              {$IFDEF PLATFORM_OS2}   '2'+ {$ENDIF}
              {$IFDEF PLATFORM_WIN32} 'W'+ {$ENDIF}
              ' [command]');
     WriteLn;
     WriteLn (' ?                           Show this information.');
     WriteLn;
     WriteLn (' EXPORT_SQUISH [<filename>]  Exports to SQUISH.CFG in the current directory');
     WriteLn ('                              or to <filename> if you define one.');
     WriteLn;
     WriteLn (' EXPORT_AREAS [<filename>]   Exports to AREAS.BBS in the current directory');
     WriteLn ('                              or to <filename> if you define one.');
     WriteLn;
     WriteLn (' IGNORE_SYSTEMDIR            Ignore system directory in WTRCFG.TDB and load');
     WriteLn ('                              the databases from current directory instead.');
END;


{--------------------------------------------------------------------------}
{ main                                                                     }
{                                                                          }

VAR Quit      : BOOLEAN;
    Param,
    Tmp       : STRING;
    LetterTel,
    ParamTel  : BYTE;
    Error     : BOOLEAN;
    Dir       : DirStr;
    Name      : NameStr;
    Ext       : ExtStr;
    P         : BYTE;
    Yb        : XYType;

LABEL Einde;

BEGIN
     WriteLn (FullProgramName+' v'+FullProgramVersion);
     WriteLn (CopyrightLine);
     WriteLn;

     {$IFNDEF PLATFORM_OS2_OR_WIN32}
     {$IFOPT G+}
     { check for PC/AT or higher }
     IF (Test8086 = 0) THEN
     BEGIN
          WriteLn (FullProgramName+' requires a PC/AT (286) or higher to run');
          Halt (1);
     END;
     {$ENDIF}
     {$ENDIF}

     Param:=UpCaseString (ParamStr (1));
     IF (Param = '?') OR (Param = 'HELP') OR (Param = '-H') OR (Param = '-?') THEN
     BEGIN
          ShowHelp;
          Exit;
     END;

     SetupEmptyConfig;

     Error:=FALSE;
     IF (NOT ReadConfigFile) THEN
        Error:=TRUE
     ELSE BEGIN
          IF (Param = 'IGNORE_SYSTEMDIR') THEN
             Config.SystemDir:='';

          WriteLn ('+ Loaded '+FoundConfigPath);
          WriteLn ('+ System directory is '+Config.SystemDir);
          WriteLn;

          IF (NOT OpenDatabases) THEN
             Error:=TRUE
          ELSE
              IF (NOT Flex_Init) THEN
                 Error:=TRUE;
     END;

     IF Error THEN
     BEGIN
          CloseDatabases;
          WriteLn;
          WriteLn ('# Unable to open/create configuration files',#7);
          WriteLn;
          Halt (1);
     END;

     IF (ParamCount > 0) THEN
     BEGIN
          IF (Param = 'EXPORT_SQUISH') THEN
          BEGIN
               IF (ParamStr(2) = '') THEN ExportSquishConfig ('SQUISH.CFG')
                                     ELSE ExportSquishConfig (ParamStr(2));
               GOTO Einde;
          END;

          IF (Param = 'EXPORT_AREAS') THEN
          BEGIN
               IF (ParamStr(2) = '') THEN ExportAreasBBS ('AREAS.BBS')
                                     ELSE ExportAreasBBS (ParamStr(2));
               GOTO Einde;
          END;

          IF (Param <> 'IGNORE_SYSTEMDIR') THEN
          BEGIN
               WriteLn ('Unknown commandline option "'+Param+'" found.');
               Exit;
          END;
     END;

     AssignHelpFile (Config.SystemDir+'WTRGATE.HLP',HTR_HELP_VERSION_CRC);

     DesktopCopyright:='WSD';
     OpenDesktop (FullProgramName,FullProgramVersion);
     WriteKeysLine (' ^F1 Help  ^Esc Return ');

     IF (Config.SystemDir <> '') AND
        (NOT CaselessMatch_CC (Config.SystemDir+ConfigFilename,UNC_FExpand (FoundConfigPath))) THEN
     BEGIN
          Yb:=Video.Rows-9;
          WindowPush (3,Yb,80,8);
          BoxDraw (Double,3,Yb,75,8);

          WriteXY (5,Yb,' Database files in use ');

          SetColor (cBoxData);
          WriteXY (5,Yb+1,UNC_FExpand (FoundConfigPath));
          WriteXY (5,Yb+2,UNC_FExpand (TdbGetFilename (AreaBaseTdbNr)));
          WriteXY (5,Yb+3,UNC_FExpand (TdbGetFilename (UserBaseTdbNr)));
          WriteXY (5,Yb+4,UNC_FExpand (TdbGetFilename (SubscriptBaseTdbNr)));
          WriteXY (5,Yb+5,UNC_FExpand (TdbGetFilename (ListUserTdbNr)));
          WriteXY (5,Yb+6,UNC_FExpand (FlexFilename));

          FSplit (UNC_FExpand (FoundConfigPath),Dir,Name,Ext);
          Tmp:='WARNING: System directory is '+Config.SystemDir+
               ', while WTRCFG.TDB was loaded from '+Dir+'. You might need IGNORE_SYSTEMDIR.';

          P:=71; { max lengte eerste regel }
          WHILE (Tmp[P] <> ' ') DO
                Dec (P);

          Error2Lines (Copy (Tmp,1,P-1),Copy (Tmp,P+1,255));

          WindowPop;
     END;

     {$IFDEF Alfa}  ShowCopyRight; {$ENDIF}
     {$IFDEF Beta}  ShowCopyRight; {$ENDIF}
     {$IFDEF Gamma} ShowCopyRight; {$ENDIF}

     MenuDefine (27,255,'Main Menu');
     MenuAddItem ('System configuration');
     MenuAddItem ('Area definitions');
     MenuAddItem ('User definitions');
     MenuAddItem ('Link definitions');
     MenuAddItem ('Filter definitions');
     MenuAddItem ('Mailing list definitions');
     MenuAddItem ('Group descriptions');
     MenuAddItem ('Import/export menu');
    {MenuAddItem ('Config Integrity Check');}
     MenuAddItem ('About '+FullProgramName);
     MenuAddItem ('Exit program');
     MenuSetHelp (htr_WtrConf_Main_Menu);
     MenuShow;

     Quit:=FALSE;
     REPEAT
           CASE MenuSelect OF
                mOpt01 : EditSystemConfig;
                mOpt02 : AreaConfigs;
                mOpt03 : EditSystems (FALSE);
                mOpt04 : EditSystems (TRUE{links});
                mOpt05 : EditMappers;
                mOpt06 : EditMailingLists;
                mOpt07 : EditGroupDescriptions;
                mOpt08 : ImportExportMenu;
               {mOpt09 : CheckConfig;}
                mOpt09 : ShowAboutBox;
                mOpt10 : Quit:=TRUE;

                kEsc   : BEGIN
                              MenuDefine (Video.Cols-20,Video.Rows-9,'Quit?');
                              MenuAddItem ('Yes');
                              MenuAddItem ('No');
                              MenuShow;

                              IF (MenuSelect = mOpt01) THEN
                                 Quit:=TRUE;

                              MenuErase;
                         END;
           END; { case }
     UNTIL Quit;

     MenuErase;

     CloseDesktop;

Einde:
     Flex_Done;
     CloseDatabases;

     WriteLn ('Ending ',FullProgramName,' v',FullProgramVersion);
END.

