{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT UserBase;

{$i platform.inc}

{ Routines om de UserBase te editten vanuit WtrConf }

{ History:

RvdW 20-02-93 Deze unit afgesplitst uit wtrconf.pas
     26-03-93 DeleteUserBaseRecord aangepast zodat ook alle subscribed
              areas eerst unsubscribed werden, zowel vanuit de UserData
              als de AreaData. Waarschijnlijk werden hierdoor de msgs
              meerdere keren weggeschreven.
     27-03-93 Aliases toegevoegd aan de Usenet nodes.
              DefGroups in EmptyUserDataRecord toegevoegd.
     31-03-93 Globale var. FromUserData toegevoegd ivm wijzigingen door MD
              in FIDO.PAS
              Fido systemen hebben nu ook een UUCPName en Domain adressen.
     03-04-93 Leuk bugje bij het aanmaken van een nieuwe user opgelost. Als
              een nieuwe user werd aangemaakt en op areas aangesloten, dan
              wilde de subscribe routines het UserBase record naar disk
              schrijven ahv het EditRecNr. Maar die was nog niet ingevuld
              en het record bestond nog niet op disk...
     08-09-93 Toevoegen van $IFDEF WtrConf
     18-02-94 Toevoegen van ondersteuning GZip
}

INTERFACE

USES Database;

{$IFDEF WtrConf}
PROCEDURE EmptyUserDataRecord;
PROCEDURE EditSystems (Links : BOOLEAN);
FUNCTION  EditUserBaseRecord (RecNr : UserBaseRecordNrType) : BOOLEAN;
PROCEDURE CleanEdittedUserRecord;
{$ENDIF}

VAR UserData      : UserBaseRecord;
    PacketUserData: UserBaseRecord;
    UserDataRecNr : UserBaseRecordNrType;


IMPLEMENTATION

USES Ramon,
     Globals,
     Cfg,
     Logs,
     Fido,
     Tdb;

{$I WTRHLP.INC}

{$IFDEF WtrConf}
VAR EditRecNr          : UserBaseRecordNrType;
    FidoAddrDesc       : STRING[MaxLenFidoAddrString]; { 12345:12345/12345.12345 }
    MaxPktLenStr       : STRING[8];
    MaxArcLenStr       : STRING[8];
    ExportAkaStr       : STRING[MaxLenFidoAddrString];
    SystemAkaStr       : STRING[MaxLenFidoAddrString];
    FakeAkaStr         : STRING[17];
    MaxLenExportAkaStr : BYTE;
    MailGradeStr,
    NewsGradeStr       : STRING[1];
    TunnelToFieldNr    : FieldNrType;

{--------------------------------------------------------------------------}
{ FixUserDataRecord                                                        }
{                                                                          }
{ Deze routine maakt de velden van het UserData record op lengte. Alleen   }
{ het System veld moet ingevuld zijn om te kunnen weten welke velden aan-  }
{ gepakt moeten worden.                                                    }
{                                                                          }
PROCEDURE FixUserDataRecord;

VAR DomainLp : 1..MaxUserDomains;
    ComprLp  : CompressionType;

BEGIN
     WITH UserData DO
     BEGIN
          Organization:=AddUpWithSpaces (MaxLenOrganization,Organization);
          GroupListDesc:=AddUpWithSpaces (54,BuildGroupListDesc (Groups,54));
          AreaFixPwd:=AddUpWithSpaces (MaxLenAreaFixPwd,AreaFixPwd);
          UUCPName:=AddUpWithSpaces (MaxLenUUCPName,UUCPName);

          FOR DomainLp:=1 TO MaxUserDomains DO
              Domains[DomainLp]:=AddUpWithSpaces (MaxLenDomain,Domains[DomainLp]);

          CASE System OF
               _F :
                   BEGIN
                        FidoAddrDesc:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Address));

                        SysOp:=AddUpWithSpaces (MaxLenSysOpName,SysOp);
                        PacketPwd:=AddUpWithSpaces (8,PacketPwd);

                        MaxPktLenStr:=AddUpWithSpaces (8,Longint2String (MaxPKTLength));

                        IF (ExportAka = 0) THEN
                           ExportAkaStr:='Automatic'
                        ELSE
                            ExportAkaStr:=Fido2Str (Config.NodeNrs[ExportAka]);

                        MaxLenExportAkaStr:=MaxLenFidoAddrString;
                        ExportAkaStr:=AddUpWithSpaces (MaxLenExportAkaStr,ExportAkaStr);
                        MaxArcLenStr:=AddUpWithSpaces (8,Longint2String (MaxArcLength));
                        TunnelTo:=AddUpWithSpaces (MaxLenDomain,TunnelTo);
                        NodeOutDir:=AddUpWithSpaces (MaxLenPath,NodeOutDir);
                   END;

               _B :
                   BEGIN
                        BAGBackLink:=AddUpWithSpaces (MaxLenUUCPName,BAGBackLink);
                        BagPath:=AddUpWithSpaces (MaxLenPath,BagPath);
                   END;

               _S :
                   BEGIN
                        SmtpInPath:=AddUpWithSpaces (MaxLenPath,SmtpInPath);
                        SmtpOutPath:=AddUpWithSpaces (MaxLenPath,SmtpOutPath);
                   END;

               _P :
                   BEGIN
                        Pop3File:=AddUpWithSpaces (MaxLenPath,Pop3File);
                        Pop3Recipient:=AddUpWithSpaces (MaxLenDomain,Pop3Recipient);
                        Pop3Separator:=AddUpWithSpaces (15,Pop3Separator);
                        Pop3EnvelopeHdr:=AddUpWithSpaces (25,Pop3EnvelopeHdr);
                   END;

               _BBS :
                   BEGIN
                        Inbound:=AddUpWithSpaces (MaxLenPath,Inbound);
                        Outbound:=AddUpWithSpaces (MaxLenPath,Outbound);
                        SystemAkaStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[SystemAka]));
                        FakeAkaStr:=AddUpWithSpaces (17,Word2String (FakeZone)+':'+
                                                        Word2String (FakeNet)+'/'+
                                                        Word2String (FakeNode));
                        InboundExt:=AddUpWithSpaces (3,InboundExt);
                   END;

               _SOUP :
                    BEGIN
                         UUCPName:=AddUpWithSpaces (MaxLenUUCPName, UUCPName);
                         SoupOutPath:=AddUpWithSpaces (MaxLenPath, SoupOutPath);
                         SoupInPath:=AddUpWithSpaces (MaxLenPath, SoupInPath);
                         SoupRecipient:=AddUpWithSpaces (MaxLenDomain, SoupRecipient);
                         SoupEnvelopeHdr:=AddUpWithSpaces (25, SoupEnvelopeHdr);
                    END;

               _INETMAIL :
                    BEGIN
                         UUCPName:=AddUpWithSpaces (MaxLenUUCPName, UUCPName);
                         InetMailQueue := AddUpWithSpaces (MaxLenPath, InetMailQueue);
                         InetMailSOurceDomain := AddUpWithSpaces (MaxLenDomain, InetMailSourceDomain);
                    END;
          END; { case }
     END; { with }
END;


{--------------------------------------------------------------------------}
{ EmptyUserDataRecord                                                      }
{                                                                          }
{ Deze routine initialiseert alle velden van het UserData record en roept  }
{ daarna FixUserDataRecord aan om de velden op lengte te laten maken.      }
{ Alleen het System veld laat ie met rust, dat moet al ingevuld zijn en    }
{ alleen de velden van dat systeem worden geinitialiseerd.                 }
{                                                                          }
PROCEDURE EmptyUserDataRecord;

VAR DomainLp : 1..MaxUserDomains;

BEGIN
     WITH UserData DO
     BEGIN
          Deleted:=FALSE;
          Organization:='';
          Passive:=FALSE;
          AreaFixPwd:='';
          AllowFrom:=FALSE;
          AllowCreate:=FALSE;
          AreaList:=NILRecordNr;
          UUCPName:='';
          AllowSubDomains:=FALSE;
          FOR DomainLp:=1 TO MaxUserDomains DO
              Domains[DomainLp]:='';

          Groups:=Config.DefGroups_U;

          CASE System OF
               _F :
                   BEGIN
                        Groups:=Config.DefGroups_F;
                        Address.Zone:=0;
                        Address.Net:=0;
                        Address.Node:=0;
                        Address.Point:=0;
                        Address.Domain:='';
                        SysOp:='';
                        PacketPwd:='';
                        Compression:=Config.NewUserFTNCompressor;
                        SendFormat:=Config.NewUserSendFormat;
                        MaxPKTLength:=Config.NewUserMaxPktSize;
                        LastArchDow:=0;
                        LastArchNr:=0;
                        ExportAka:=0;
                        DecodeFiles:=FALSE;
                        MaxArcLength:=Config.NewUserMaxArcSize;
                        TunnelTo:='';
                        Notify_F:=Config.NewUserNotify;
                        PktFormat:=fptPkt;
                        NodeOutDir:='';
                   END;

               _U :
                   BEGIN
                        Compress:=Config.NewUserUUCPCompress;
                        CunBatch:=Config.NewUserAddBatchHdr;
                        MailGrade:=Config.NewUserMailGrade;
                        NewsGrade:=Config.NewUserNewsGrade;
                        GigoT:=FALSE;
                        Notify_U:=Config.NewUserNotify;
                   END;

               _B :
                   BEGIN
                        BAGBackLink:='';
                        BagPath:='';
                   END;

               _S :
                   BEGIN
                        SmtpInPath:='';
                        SmtpOutPath:='';
                   END;

               _P :
                   BEGIN
                        Pop3File:='';
                        Pop3Recipient:='example@yourdomain';
                        Pop3Separator:='From ';
                        Pop3EnvelopeHdr:='X-Envelope-To:';
                   END;

               _BBS :
                   BEGIN
                        Groups:=Config.DefGroups_F;
                        Inbound:='';
                        Outbound:='';
                        FakeZone:=0;
                        FakeNet:=0;
                        FakeNode:=0;
                        SystemAKA:=1;
                        InboundExt:='PKT';
                        KeepSBP:=FALSE;
                        Reserved1:=0;
                   END;

               _SOUP :
                    BEGIN
                         UUCPName:='';
                         SoupInPath:='';
                         SoupOutPath:='';
                         SoupRecipient:='example@yourdomain';
                         SoupEnvelopeHdr:='X-Envelope-To:';
                         UsingWGSOUP:=TRUE;
                    END;
          END; { case }
     END; { with }

     FixUserDataRecord;
END;


{--------------------------------------------------------------------------}
{ EditUserDataGroupsList                                                   }
{                                                                          }
{ Met deze routine kan de Groups variabele in het UserData veld aangepast  }
{ worden. Ook wordt de GroupListDesc aangepast bij het verlaten van deze   }
{ routine.                                                                 }
{                                                                          }
PROCEDURE EditUserDataGroupsList; FAR;
BEGIN
     EditGroupsList (UserData.Groups,
                     'User is allowed in these groups',
                     '<user is not allowed in any group>',
                     htr_UserEdit_NowAllowedGroups,
                     htr_UserEdit_NotYetAllowedGroups);
END;


{--------------------------------------------------------------------------}
{ EditUserDataSubscrToList                                                 }
{                                                                          }
{ Met deze routine kunnen de aangesloten areas voor een User bekeken word- }
{ en eventueel uitgebreid. UserData contains the user record.              }
{                                                                          }
PROCEDURE EditUserDataSubscrToList; FAR;

VAR Rebuild,
    First,
    Quit2,
    Quit     : BOOLEAN;
    Search   : SubscrSearchRecord;
    Keuze,
    Keuze2,
    Lp       : WORD;
    Lp2      : AreaBaseRecordNrType;
    AreaData : AreaBaseRecord;
    RWFilter : GroupFlagType;

    {----------------------------------------------------------------------}
    { AddAreaToList                                                        }
    {                                                                      }
    { Deze routine voegt de omschrijving van de area toe aan de lijst.     }
    { AreaData contains the area information.                              }
    {                                                                      }
    PROCEDURE AddAreaToList (Index : WORD; AddToPrevList : BOOLEAN);

    VAR S : STRING;

    BEGIN
         IF (AreaData.AreaName_F <> '') AND (UserData.System IN [_F,_BBS]) THEN
            S:=AreaData.AreaName_F
         ELSE
             S:=AreaData.AreaName_U;

         IF (NOT TestIfGroupCommon (UserData.Groups,AreaData.IsInGroups)) THEN
         BEGIN
              IF (Length (S) < 15) THEN
                 S:=AddUpWithSpaces (15,S);
              S:=S+'  [no group access!]'
         END ELSE
         BEGIN
              IF (Length (S) < 25) THEN
                 S:=AddUpWithSpaces (25,S);
              IF (NOT TestIfGroupCommon3 (UserData.Groups,AreaData.IsInGroups,RWFilter)) THEN
                 S:=S+'  R/O';
         END;

         IF AddToPrevList THEN
            ListAddItemToPrevList (S,Index,Sorted)
         ELSE
             ListAddItem (S,Index,Bottom{Sorted});
    END;

    {----------------------------------------------------------------------}
    { GiveAreaInfo                                                         }
    {                                                                      }
    { This routine brings up a little window with information on the area  }
    { the cursor is on, the areas the user is allowed to subscribe from    }
    { and the common areas.                                                }
    {                                                                      }
    PROCEDURE GiveAreaInfo (Index : WORD);

    CONST Xb = 4;
          Yb = 10;
          Xl = 75;
          Yl = 13;
          Xb2 = Xb+13;

    VAR CommonGroups : GroupFlagType;
        S            : STRING;
        Lp           : 1..MaxGroups;

    BEGIN
         ReadAreaBaseRecord (Index,AreaData);

         WindowPush (Xb,Yb,Xl,Yl);
         BoxDraw (Double,Xb,Yb,Xl,Yl);

         WriteXY (Xb+2,Yb+1,'Area Information');
         WriteXY (Xb+2,Yb+3,'FTN name');
         WriteXY (Xb+2,Yb+4,'RFC name');
         WriteXY (Xb+2,Yb+5,'Comment');
         WriteXY (Xb+2,Yb+6,'Mandatory');
         WriteXY (Xb+2,Yb+7,'In groups');

         WriteXY (Xb+2,Yb+9,'Common groups with user');
         WriteXY (Xb+2,Yb+10,'Read Write');
         WriteXY (Xb+2,Yb+11,'Read Only');

         SetColor (cBoxData);
         WriteXY (Xb2,Yb+3,AreaData.AreaName_F);
         WriteXY (Xb2,Yb+4,AreaData.AreaName_U);
         WriteXY (Xb2,Yb+5,AreaData.Comment);
         IF (AreaData.Mandatory) THEN
            WriteXY (Xb2,Yb+6,'Yes')
         ELSE
             WriteXY (Xb2,Yb+6,'No');
         WriteXY (Xb2,Yb+7,BuildGroupListDesc (AreaData.IsInGroups,MaxLenAreaName));

         CreateCommonGroup (CommonGroups,AreaData.IsInGroups,UserData.Groups);
         CreateCommonGroup (CommonGroups,CommonGroups,RWFilter);
         { only R/W groups left now }
         S:=BuildGroupListDesc (CommonGroups,MaxLenAreaName);
         IF (S = '') THEN
            S:='none';
         WriteXY (Xb2,Yb+10,S);

         CreateCommonGroup (CommonGroups,AreaData.IsInGroups,UserData.Groups);
         { remove all the R/W groups from the CommonGroups }
         FOR Lp:=1 TO MaxGroups DO
             IF TestIfInGroup (RWFilter,Lp) THEN
                DeleteGroupFromGroupList (CommonGroups,Lp);
         S:=BuildGroupListDesc (CommonGroups,MaxLenAreaName);
         IF (S = '') THEN
            S:='none';
         WriteXY (Xb2,Yb+11,S);

         PushKeysLine;
         WriteKeysLine (' Press any key to continue');

         ReadKey;

         PopKeysLine;

         WindowPop;
    END;

VAR AreasExpect,
    AreasCount,
    HulpCount   : WORD;
    PercDone    : BYTE;
    GroupRec    : GroupDescRecord;

BEGIN
     ListDefine (3,3,39,Video.Rows-4,Default,
                 'Areas subscribed to',
                 htr_UserEdit_SubscribedAreas);

     Message ('Reading areas user is subscribed to  (0%)  ');

     AreasExpect:=CountSubscribedAreas (UserData.AreaList);
     AreasCount:=0;

     { calculate the R/W filter for this user based on the group records }
     RWFilter:=AllGroups;
     FOR Lp:=1 TO MaxGroups DO
     BEGIN
          ReadGroupDescRecord (Lp,GroupRec);
          IF GroupRec.ReadOnly THEN
             DeleteGroupFromGroupList (RWFilter,Lp);
     END; { for }

     GetFirstAreaUserIsSubscribedTo (UserData.AreaList,Search);
     WHILE (Search.Found) DO
     BEGIN
          ReadAreaBaseRecord (Search.AreaBaseRecordNr,AreaData);
          AddAreaToList (Search.AreaBaseRecordNr,FALSE);
          Inc (AreasCount);
          GetNextAreaUserIsSubscribedTo (Search);

          PercDone:=Round ((AreasCount/AreasExpect)*100);
          WriteXYC (50,MessageYB,cMessage,
                                   RepChar (PercDone DIV 10,'')+
                                   RepChar (10-(PercDone DIV 10),'')+
                                   ' ('+Byte2String (PercDone)+'%)');

          { kijk of de user wil aborten }
          IF KeyPressed AND (ReadKey = kEsc) THEN
          BEGIN
               WindowPop;
               ListErase;
               Exit;
          END;
     END; { while }

     WindowPop; { message }

     ListSortNow;

     Quit:=FALSE;
     REPEAT
           IF (ListItemCount = 0) THEN
              ListAddItem ('<not subscribed to any area>',65534,Bottom);

           Keuze:=ListSelect (DoTag,[kIns,kDel]);

           ListRemoveItem (65534);

           CASE Key OF
                kIns :
                    BEGIN
                         ListDefine (77,3,39,Video.Rows-4,TopRight,
                                     'Allowed areas not subscribed to',
                                     htr_UserEdit_SubscribableAreas);

                         Message ('Reading areas user is not subscribed to  (0%)  ');

                         Quit2:=FALSE;

                         AreasExpect:=AreaBaseRecCount;

                         FOR Lp2:=1 TO AreasExpect DO
                         BEGIN
                              ReadAreaBaseRecord (Lp2,AreaData);

                              { RWI 950727: ListItemNrInPrevList gemaakt en onderstaande }
                              {             vervangen.                                   }
                              { (NOT TestIfAreaIsInUserRec_AreaList (UserData.AreaList,Lp2))}

                              IF (NOT AreaData.Deleted) AND
                                 TestIfGroupCommon (AreaData.IsInGroups,UserData.Groups) AND
             { RWI 960929 }      (AreaData.AreaType IN [Area_Echo,Area_Local]) AND
                                 (NOT ListItemNrInPrevList (Lp2))
                              THEN
                                  AddAreaToList (Lp2,FALSE);

                              PercDone:=Round ((Lp2/AreasExpect)*100);
                              WriteXYC (52,MessageYB,cMessage,
                                                       RepChar (PercDone DIV 10,'')+
                                                       RepChar (10-(PercDone DIV 10),'')+
                                                       ' ('+Byte2String (PercDone)+'%)');

                              { kijk of de user wil aborten }
                              IF KeyPressed AND (ReadKey = kEsc) THEN
                              BEGIN
                                   Quit2:=TRUE;
                                   Break; { uit de for }
                              END;
                         END;

                         WindowPop; { message }

                         IF Quit2 THEN
                         BEGIN
                              ListErase;
                              Continue; { met de buitenste repeat/until }
                         END;

                         ListSortNow;

                         IF (ListItemCount = 0) THEN
                            ListAddItem ('<already subscribed to all areas>',65534,Bottom);

                         Quit2:=FALSE;
                         REPEAT
                               Keuze2:=ListSelect (DoTag,[]);

                               CASE Key OF
                                    kEsc :
                                        Quit2:=TRUE;

                                    kRet :
                                        BEGIN
                                             IF (ListTagCount = 0) THEN
                                             BEGIN
                                                  AddAreaToUserSubscrToList (UserData,Keuze2);

                                                  ReadAreaBaseRecord (Keuze2,AreaData);
                                                  AddUserToAreaSubscrList (AreaData,EditRecNr);
                                                  WriteAreaBaseRecord (Keuze2,AreaData);

                                                  AddAreaToList (Keuze2,TRUE);
                                             END ELSE
                                             BEGIN
                                                  Message ('Connecting areas  (0%)  ');

                                                  FOR Lp:=1 TO ListTagCount DO
                                                  BEGIN
                                                       Keuze2:=ListGetTaggedItemNr (Lp);

                                                       AddAreaToUserSubscrToList (UserData,Keuze2);
                                                       ReadAreaBaseRecord (Keuze2,AreaData);
                                                       AddUserToAreaSubscrList (AreaData,EditRecNr);
                                                       WriteAreaBaseRecord (Keuze2,AreaData);

                                                       AddAreaToList (Keuze2,TRUE);

                                                       PercDone:=Round ((Lp/ListTagCount)*100);
                                                       WriteXYC (41,MessageYB,cMessage,
                                                                                RepChar (PercDone DIV 10,'')+
                                                                                RepChar (10-(PercDone DIV 10),'')+
                                                                                ' ('+Byte2String (PercDone)+'%)');

                                                       IF KeyPressed AND (ReadKey = kEsc) THEN
                                                          Break; { uit de for }
                                                  END; { for }

                                                  WindowPop; { message }
                                             END;

                                             WriteUserBaseRecord (EditRecNr,UserData);

                                             Quit2:=TRUE;
                                        END;
                               END; { case }
                         UNTIL Quit2;

                         ListErase;
                    END;

                kDel :
                    BEGIN
                         IF (ListTagCount = 0) THEN
                         BEGIN
                              IF (Keuze < 65000) AND (AreYouSureWithHelp ('Unsubscribe this area?',1224) = mOpt01) THEN
                              BEGIN
                                   RemoveAreaFromUserSubscrToList (UserData,Keuze);

                                   ReadAreaBaseRecord (Keuze,AreaData);
                                   RemoveUserFromAreaSubscrList (AreaData,EditRecNr);
                                   WriteAreaBaseRecord (Keuze,AreaData);

                                   WriteUserBaseRecord (EditRecNr,UserData);

                                   ListRemoveItem (Keuze);
                              END;
                         END ELSE
                             IF (AreYouSureWithHelp ('Unsubscribe these areas?',
                                                     htr_UserEdit_UnSubscribe_AreYouSure) = mOpt01) THEN
                             BEGIN
                                  Message ('Unsubscribing areas  (0%)  ');

                                  HulpCount:=ListTagCount;
                                  WHILE (ListTagCount > 0) DO
                                  BEGIN
                                       Keuze:=ListGetTaggedItemNr (1);

                                       RemoveAreaFromUserSubscrToList (UserData,Keuze);

                                       ReadAreaBaseRecord (Keuze,AreaData);
                                       RemoveUserFromAreaSubscrList (AreaData,EditRecNr);
                                       WriteAreaBaseRecord (Keuze,AreaData);

                                       WriteUserBaseRecord (EditRecNr,UserData);

                                       ListRemoveItem (Keuze);

                                       PercDone:=Round (((HulpCount-ListTagCount)/HulpCount)*100);
                                       WriteXYC (42,MessageYB,cMessage,
                                                                RepChar (PercDone DIV 10,'')+
                                                                RepChar (10-(PercDone DIV 10),'')+
                                                                ' ('+Byte2String (PercDone)+'%)');

                                       IF KeyPressed AND (ReadKey = kEsc) THEN
                                          Break; { uit de while }

                                  END; { while }

                                  WindowPop; { message }
                             END;
                    END; { kDel }

                kRet :
                    GiveAreaInfo (Keuze);

                kEsc : Quit:=TRUE;
           END; { case }
     UNTIL Quit;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ CheckUserDataFidoAddr                                                    }
{                                                                          }
{ Met deze routine kan het fido address in UserData gewijzigd worden.      }
{                                                                          }
FUNCTION CheckUserDataFidoAddr (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     FidoSplit (DeleteBackSpaces (BufferPtr^),UserData.Address);
     BufferPtr^:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (UserData.Address));
     CheckUserDataFidoAddr:=TRUE;
END;


{--------------------------------------------------------------------------}
{ EditUserDataExportAka                                                    }
{                                                                          }
{ Met deze routine kan de ExportAka gekozen worden.                        }
{                                                                          }
PROCEDURE EditUserDataExportAka; FAR;

VAR AkaLp : 1..MaxAKAs;
    Keuze : WORD;

BEGIN
     ListDefine (40,7,30,Video.Rows-15,Default,
                 'Export AKA selection',
                 htr_UserEdit_SelectExportAka);

     ListSetConvertRoutine (FidoAkaListConvertFunc);

     FOR AkaLp:=1 TO MaxAKAs DO
         IF (Fido2Str (Config.NodeNrs[AkaLp]) <> '0') THEN
            ListAddItem (Fido2Str (Config.NodeNrs[AkaLp]),AkaLp,Convert);

     ListAddItem ('Automatic',0,Top);
     ListSetCursorOnItem (UserData.ExportAKA);

     Keuze:=ListSelect (NoTag,[]);

     IF (Key = kRet) THEN
        UserData.ExportAKA:=Keuze;

     IF (UserData.ExportAKA = 0) THEN
        ExportAkaStr:='Automatic'
     ELSE
         ExportAkaStr:=Fido2Str (Config.NodeNrs[UserData.ExportAka]);

     ExportAkaStr:=AddUpWithSpaces (MaxLenExportAkaStr,ExportAkaStr);

     ListErase;
END;


{--------------------------------------------------------------------------}
{ EditUserDataSystemAka                                                    }
{                                                                          }
{ Met deze routine kan de SystemAka voor een BBS Interface link gekozen    }
{ worden.                                                                  }
{                                                                          }
PROCEDURE EditUserDataSystemAka; FAR;

VAR AkaLp : 1..MaxAKAs;
    Keuze : WORD;

BEGIN
     ListDefine (40,7,30,Video.Rows-15,Default,'System AKA selection',1064);

     ListSetConvertRoutine (FidoAkaListConvertFunc);

     FOR AkaLp:=1 TO MaxAKAs DO
         IF (Fido2Str (Config.NodeNrs[AkaLp]) <> '0') THEN
            ListAddItem (Fido2Str (Config.NodeNrs[AkaLp]),AkaLp,Convert);

     ListSetCursorOnItem (UserData.SystemAka);

     Keuze:=ListSelect (NoTag,[]);

     IF (Key = kRet) THEN
        UserData.SystemAka :=Keuze;

     SystemAkaStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[UserData.SystemAka]));

     ListErase;
END;


{--------------------------------------------------------------------------}
{ CheckGrayCunBatch                                                        }
{                                                                          }
{ Deze routine wordt aangeroepen als de UUCP compressie vorm veranderd     }
{ is. Als de compressie nu op NONE staat, dan wordt het CunBatch veld      }
{ grijs gemaakt.                                                           }
{                                                                          }
PROCEDURE CheckGrayCunBatch; FAR;
BEGIN
     IF (UserData.Compress = uctNone) THEN
        FieldDisableField (LastFieldNr+1)
     ELSE
         FieldEnableField (LastFieldNr+1);

     FieldUpdateOneField (LastFieldNr+1);
END;


{--------------------------------------------------------------------------}
{ CheckFirstDomain                                                         }
{                                                                          }
{ Deze routine checkt het eerste domain adres dat ingevoerd wordt. Hier    }
{ mag namelijk geen routing informatie in staan, zoals een punt aan het    }
{ begin. Ook apestaartjes op de eerste positie zijn verkeerd.              }
{                                                                          }
FUNCTION CheckFirstDomain (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     IF (BufferPtr^ = '') THEN
     BEGIN
          CheckFirstDomain:=TRUE;  { no problemo }
          Exit;
     END;

     IF (BufferPtr^[1] = '@') THEN
     BEGIN
          Error ('A domain name never starts with a @ sign.');
          CheckFirstDomain:=FALSE;
          Exit;
     END;

     IF (BufferPtr^[1] = '.') THEN
     BEGIN
          Error2Lines ('The first domain must not start with a dot!',
                       'Press Escape and F1 for more information.');
          CheckFirstDomain:=FALSE;
          Exit;
     END;

     CheckFirstDomain:=TRUE; { no problemos }
END;


{--------------------------------------------------------------------------}
{ CheckOtherDomain                                                         }
{                                                                          }
FUNCTION CheckOtherDomain (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     CheckOtherDomain:=TRUE;  { assume no problems }

     IF (BufferPtr^ = '') THEN
        Exit;

     IF (BufferPtr^[1] = '@') THEN
     BEGIN
          Error ('A domain name never starts with a @ sign.');
          CheckOtherDomain:=FALSE;
          Exit;
     END;

     { return result is TRUE }
END;


{--------------------------------------------------------------------------}
{ CheckRecipient                                                           }
{                                                                          }
FUNCTION CheckRecipient (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     IF (Pos (' ',DeleteFrontAndBackSpaces (BufferPtr^)) > 0) THEN
     BEGIN
          Error ('An e-mail address does not contain spaces');
          CheckRecipient:=FALSE;
     END ELSE
         CheckRecipient:=TRUE;
END;


{--------------------------------------------------------------------------}
{ BagFileMgr                                                               }
{                                                                          }
{ Deze routine roept de file manager aan voor BAG files. Als er een zoek   }
{ patroon aan het einde staat, dan wordt die eraf gekapt, waarna er naar   }
{ directories kan worden gezocht en de zoekstring/file er weer aangeplakt  }
{ wordt.                                                                   }
{                                                                          }
PROCEDURE BagFileMgr (BufferPtr : StringPtr; CheckOnly : BOOLEAN); FAR;

VAR ZoekStr : STRING;

BEGIN
     IF CheckOnly THEN
        Exit;

     BufferPtr^:=DeleteFrontAndBackSpaces (BufferPtr^);

     ZoekStr:='';

     IF (BufferPtr^ <> '') AND (Pos ('\',BufferPtr^) = 0) THEN
        Error ('Not matching expected format D:\DIR\*.EXT')
     ELSE BEGIN
          WHILE (BufferPtr^ <> '') AND (BufferPtr^[Length (BufferPtr^)] <> '\') DO
          BEGIN
               ZoekStr:=BufferPtr^[Length (BufferPtr^)]+ZoekStr;
               Delete (BufferPtr^,Length (BufferPtr^),1);
          END;
     END;

     BufferPtr^:=FileManager (BufferPtr^,'','*.*');

     IF (BufferPtr^[Length (BufferPtr^)] = '\') THEN
        BufferPtr^:=BufferPtr^+ZoekStr;

     BufferPtr^:=AddUpWithSpaces (MaxLenPath,BufferPtr^);
END;


{--------------------------------------------------------------------------}
{ Pop3FileMgr                                                              }
{                                                                          }
{ Deze routine roept de file manager aan voor POP3 file selectie.          }
{                                                                          }
PROCEDURE Pop3FileMgr (BufferPtr : StringPtr; CheckOnly : BOOLEAN); FAR;

VAR ZoekStr : STRING;

BEGIN
     IF CheckOnly THEN
        Exit;

     BufferPtr^:=DeleteFrontAndBackSpaces (BufferPtr^);
     BufferPtr^:=FileManager (BufferPtr^,'','*.*');
     BufferPtr^:=AddUpWithSpaces (MaxLenPath,BufferPtr^);
END;

{--------------------------------------------------------------------------}
{ InetMailFIleMgr                                                          }
{                                                                          }
{ This routine runs the file manager to select an INET.MAIL queue.         }
{                                                                          }
PROCEDURE InetMailFileMgr (BufferPtr : StringPtr; CheckOnly : BOOLEAN); FAR;

VAR ZoekStr : STRING;

BEGIN
     IF CheckOnly THEN
        Exit;

     BufferPtr^:=DeleteFrontAndBackSpaces (BufferPtr^);
     BufferPtr^:=FileManager (BufferPtr^,'','*.*');
     BufferPtr^:=AddUpWithSpaces (MaxLenPath,BufferPtr^);
END;

{--------------------------------------------------------------------------}
{ CheckFakeAka                                                             }
{                                                                          }
{ Deze routine interpreteert en controleerd het ingevoerde fake aka veld   }
{ en slaat de nieuwe input op in de velden.                                }
{                                                                          }
FUNCTION CheckFakeAka (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR HulpAka : FidoAddrType;

BEGIN
     FidoSplit (DeleteFrontAndBackSpaces (BufferPtr^),HulpAka);

     WITH UserData DO
     BEGIN
          FakeZone:=HulpAka.Zone;
          FakeNet:=HulpAka.Net;
          FakeNode:=HulpAka.Node;

          BufferPtr^:=AddUpWithSpaces (17,Word2String (FakeZone)+':'+
                                          Word2String (FakeNet)+'/'+
                                          Word2String (FakeNode));
     END; { with }

     CheckFakeAka:=TRUE; { no problemos }
END;


{--------------------------------------------------------------------------}
{ PickReturnSystem                                                         }
{                                                                          }
{ This routine presents a pick list for the BAG return system, including   }
{ mail2news.                                                               }
{                                                                          }
PROCEDURE PickReturnSystem; FAR;

VAR Current,
    UserLp  : UserBaseRecordNrType;
    UserRec : UserBaseRecord;
    Keuze   : WORD;

BEGIN
     ListDefine (35,8,40,Video.Rows-10,Default,
                 'Applicable BAG return systems',
                 htr_UserEdit_SelectReturnSystem);

     Current:=0;

     FOR UserLp:=1 TO UserBaseRecCount DO
     BEGIN
          ReadUserBaseRecord (UserLp,UserRec);

          IF (NOT UserRec.Deleted) AND (UserRec.System = _U) THEN
          BEGIN
               ListAddItem (UserRec.UUCPName+' ('+UserRec.Organization+')',UserLp,Sorted);
               IF CaselessMatch (UserRec.UUCPName,DeleteBackSpaces (UserData.BAGBackLink)) THEN
                  Current:=UserLp;
          END;
     END;

     ListAddItem ('mail2news (mail via smarthost)',60000,Sorted);
     ListSetCursorOnItem (Current);

     Keuze:=ListSelect (NoTag,[]);

     IF (Key = kRet) THEN
     BEGIN
          IF (Keuze = 60000) THEN
             UserData.BAGBackLink:='mail2news'
          ELSE BEGIN
               ReadUserBaseRecord (Keuze,UserRec);
               UserData.BAGBackLink:=UserRec.UUCPName;
          END;

          UserData.BAGBackLink:=AddUpWithSpaces (MaxLenUUCPName,UserData.BAGBackLink);
     END;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ CheckMaxPktLenFunc                                                       }
{                                                                          }
{ This routine checks the new contents of the Maxmimum PKT Length field,   }
{ stores it in the PKT record and reformats the field on screen.           }
{                                                                          }
FUNCTION CheckMaxPktLenFunc (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     UserData.MaxPktLength:=CheckNumberLimits (BufferPtr,50000,MaxLongint);
     CheckMaxPktLenFunc:=TRUE;
END;


{--------------------------------------------------------------------------}
{ CheckMaxArcLenFunc                                                       }
{                                                                          }
FUNCTION CheckMaxArcLenFunc (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     UserData.MaxArcLength:=CheckNumberLimits (BufferPtr,50000,MaxLongint);
     CheckMaxArcLenFunc:=TRUE;
END;


{--------------------------------------------------------------------------}
{ GrayTunnelToField                                                        }
{                                                                          }
PROCEDURE GrayTunnelToField; FAR;
BEGIN
     IF (UserData.SendFormat IN [stMailTunnel,stSEAT]) THEN
        FieldEnableField (TunnelToFieldNr)
     ELSE
         FieldDisableField (TunnelToFieldNr);

     FieldUpdateOneField (TunnelToFieldNr);
END;


{--------------------------------------------------------------------------}
{ DrawUserBaseRecordScreen                                                 }
{                                                                          }
{ Deze routine tekent het scherm waarin de User Database gegevens verwerkt }
{ kunnen worden. Ook de Fields worden hier gedefinieerd. Wel moet in       }
{ UserData.System het systeem type te vinden zijn omdat dit andere velden  }
{ oplevert. De Fields worden gelinkt aan de globale UserData variabele.    }
{                                                                          }
PROCEDURE DrawUserBaseRecordScreen;

CONST Xl  = 76;
      Xb  = 2;
      Xb2 = Xb+21;
      Xb3 = Xb+61;

VAR DomainLp   : 1..MaxUserDomains;
    SystemDesc : STRING[21];
    FieldY     : XYType;
    Yb,Yl      : XYType;

BEGIN
     CASE UserData.System OF
          _F :
              BEGIN
                   SystemDesc:='FTN style user';

                   Yb:=2;

                   IF (Video.Rows > 25) THEN
                      Yl:=26
                   ELSE BEGIN
                        Yl:=22;

                        MaxLenExportAkaStr:=20;
                        ExportAkaStr:=Copy (ExportAkaStr,1,MaxLenExportAkaStr);
                   END;
              END;

          _U :
              BEGIN
                   SystemDesc:='UUCP style user';

                   Yb:=3;
                   Yl:=20;

                   IF (Video.Rows > 25) THEN
                      Inc (Yb);

                   IF NOT (UserData.MailGrade IN ['A'..'Z']) THEN
                      UserData.MailGrade:='A';

                   IF NOT (UserData.NewsGrade IN ['A'..'Z']) THEN
                      UserData.NewsGrade:='Z';

                   MailGradeStr:=UserData.MailGrade;
                   NewsGradeStr:=UserData.NewsGrade;
              END;

          _B :
              BEGIN
                   SystemDesc:='BAG supplier link';

                   Yb:=5;
                   Yl:=8;
              END;

          _S :
              BEGIN
                   SystemDesc:='SMTP mailer link ';

                   Yb:=5;
                   Yl:=10;
              END;

          _P :
              BEGIN
                   SystemDesc:='POP3 mailbox link';

                   Yb:=5;
                   Yl:=7;
              END;

          _BBS :
              BEGIN
                   SystemDesc:='BBS Interface link';

                   Yb:=5;
                   Yl:=11;
              END;

          _SOUP:
               BEGIN
                    SystemDesc :='SOUP Mailer Link';

                    Yb:=5;
                    Yl:=12;
               END;

          _INETMAIL:
               BEGIN
                    SystemDesc := 'Inet.Mail Mailer Link';

                    Yb:=5;
                    Yl:=6;
               END;

     END; { case }

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);
     WriteXY (Xb+2,Yb,'['+SystemDesc+']');

     FieldInit;

     SetLines (Single);
     FieldY:=Yb;

     IF (UserData.System = _F) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Address');
          FieldAutoDefineCheckOne (Xb2,FieldY,@FidoAddrDesc,
                                   RepChar (MaxLenFidoAddrString,'$'),CheckUserDataFidoAddr);
          FieldSetHelp (0,htr_UserEdit_Address);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'SysOp');
          FieldAutoDefineOne (Xb2,FieldY,@UserData.Sysop,RepChar (MaxLenSysopName,'$'));
          FieldSetHelp (0,htr_UserEdit_SysOp);
     END;

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Organization');
     FieldAutoDefineLongOne (Xb2,FieldY,Xl-Xb2+1,@UserData.Organization,RepChar (MaxLenOrganization,'$'));
     FieldSetHelp (0,htr_UserEdit_Organization);

     IF NOT (UserData.System IN [_INETMAIL,_S,_P]) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Allowed groups');
          FieldAutoDefineList (Xb2,FieldY,@GroupListDesc,EditUserDataGroupsList);
          FieldSetHelp (0,htr_UserEdit_AllowedGroups);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Subscribed to');
          FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditUserDataSubscrToList);
          FieldSetHelp (0,htr_UserEdit_SubscribedTo);
     END;

     IF (UserData.System = _F) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'AreaFix password');
          FieldAutoDefineOne (Xb2,FieldY,@UserData.AreaFixPwd,RepChar (MaxLenAreaFixPwd,'$'));
          FieldSetPassword (0);
          FieldSetHelp (0,htr_UserEdit_AreafixNewsfixPassword);

          IF (Yl > 23) THEN
          BEGIN
               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'AreaFix special');
               FieldAutoDefineToggles (Xb2,FieldY,UserData.AllowFrom,'no|yes',0);
               FieldSetHelp (0,htr_UserEdit_AreafixNewsfixSpecial);

               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'Create new areas');
               FieldAutoDefineToggles (Xb2,FieldY,UserData.AllowCreate,'no|yes',0);
               FieldSetHelp (0,htr_UserEdit_CreateNewAreas);

               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'Passive');
               FieldAutoDefineToggles (Xb2,FieldY,UserData.Passive,'no|yes',0);
               FieldSetHelp (0,htr_UserEdit_Passive);

               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'Notify');
               FieldAutoDefineToggles (Xb2,FieldY,UserData.Notify_F,'no|yes',0);
               FieldSetHelp (0,htr_UserEdit_Notify);

               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'PKT password');
               FieldAutoDefineOne (Xb2,FieldY,@UserData.PacketPwd,RepChar (8,'$'));
               FieldSetPassword (0);
               FieldSetHelp (0,htr_UserEdit_PKTPassword);

               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'Export AKA');
               FieldAutoDefineList (Xb2,FieldY,@ExportAkaStr,EditUserDataExportAka);
               FieldSetHelp (0,htr_UserEdit_ExportAKA);
          END ELSE
          BEGIN
               WriteXY (Xb+42,FieldY,VR+' AreaFix special');
               FieldAutoDefineToggles (Xb3,FieldY,UserData.AllowFrom,'no|yes',0);
               FieldSetHelp (0,htr_UserEdit_AreafixNewsfixSpecial);

               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'PKT password');
               FieldSetPassword (0);
               FieldAutoDefineOne (Xb2,FieldY,@UserData.PacketPwd,RepChar (8,'$'));
               FieldSetHelp (0,htr_UserEdit_PKTPassword);

               WriteXY (Xb+42,FieldY,VR+' Passive');
               FieldAutoDefineToggles (Xb3,FieldY,UserData.Passive,'no|yes',0);
               FieldSetHelp (0,htr_UserEdit_Passive);

               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'Export AKA');
               FieldAutoDefineList (Xb2,FieldY,@ExportAkaStr,EditUserDataExportAka);
               FieldSetHelp (0,htr_UserEdit_ExportAKA);

               WriteXY (Xb+42,FieldY,VR+' Create new areas');
               FieldAutoDefineToggles (Xb3,FieldY,UserData.AllowCreate,'no|yes',0);
               FieldSetHelp (0,htr_UserEdit_CreateNewAreas);
          END;

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Packet size limit');
          FieldAutoDefineCheckOne (Xb2,FieldY,@MaxPktLenStr,RepChar (8,'%'),CheckMaxPktLenFunc);
          FieldSetHelp (0,htr_UserEdit_PacketSizeLimit);

          IF (Video.Rows <= 25) THEN
          BEGIN
               WriteXY (Xb+42,FieldY,VR+' Notify');
               FieldAutoDefineToggles (Xb3,FieldY,UserData.Notify_F,'no|yes',0);
               FieldSetHelp (0,htr_UserEdit_Notify);
          END;

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Archive size limit');
          FieldAutoDefineCheckOne (Xb2,FieldY,@MaxArcLenStr,RepChar (8,'%'),CheckMaxArcLenFunc);
          FieldSetHelp (0,htr_UserEdit_ArchiveSizeLimit);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'PKT format');
          FieldAutoDefineToggles (Xb2,FieldY,UserData.PktFormat,'pkt|pkt2000',0);
          FieldSetHelp (0,htr_UserEdit_PKTFormat);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Compression');
          FieldAutoDefineToggles (Xb2,FieldY,UserData.Compression,'arc|arj|lzh|pak|zip|zoo|rar|op1||none',0);
          FieldSetHelp (0,htr_UserEdit_Compression);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Send format');
          FieldAutoDefineTogglesCall (Xb2,FieldY,UserData.SendFormat,
{## SEAT is disabled for the moment   'normal|hold|crash|direct|mailtunnel|seat',}
                                      'normal|hold|crash|direct|mailtunnel',
                                      0,GrayTunnelToField);
          FieldSetHelp (0,htr_UserEdit_SendFormat);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Tunnel e-mail');
          FieldAutoDefineOne (Xb2,FieldY,@UserData.TunnelTo,RepChar (MaxLenDomain,'$'));
          FieldSetHelp (0,htr_UserEdit_TunnelEmailAddress);
          TunnelToFieldNr:=FieldGetLastAutoFieldNr;

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Decode files');
          FieldAutoDefineToggles (Xb2,FieldY,UserData.DecodeFiles,'no|yes',0);
          FieldSetHelp (0,htr_UserEdit_DecodeFiles);
          FieldDisableField (0);
     END;

     IF (UserData.System = _U) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'NewsFix password');
          FieldAutoDefineOne (Xb2,FieldY,@UserData.AreaFixPwd,RepChar (MaxLenAreaFixPwd,'$'));
          FieldSetPassword (0);
          FieldSetHelp (0,htr_UserEdit_AreafixNewsfixPassword);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'NewsFix special');
          FieldAutoDefineToggles (Xb2,FieldY,UserData.AllowFrom,'no|yes',0);
          FieldSetHelp (0,htr_UserEdit_AreafixNewsfixSpecial);
     END;

     IF (UserData.System IN [_SOUP,_U,_B]) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Create new areas');
          FieldAutoDefineToggles (Xb2,FieldY,UserData.AllowCreate,'no|yes',0);
          FieldSetHelp (0,htr_UserEdit_CreateNewAreas);
     END;

     IF (UserData.System = _U) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Passive');
          FieldAutoDefineToggles (Xb2,FieldY,UserData.Passive,'no|yes',0);
          FieldSetHelp (0,htr_UserEdit_Passive);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Notify');
          FieldAutoDefineToggles (Xb2,FieldY,UserData.Notify_U,'no|yes',0);
          FieldSetHelp (0,htr_UserEdit_Notify);
     END;

     IF (UserData.System = _S) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'SMTP-In path');
          FieldAutoDefineFileMgr (Xb2,FieldY,54,@UserData.SmtpInPath,PathFileMgr,FALSE);
          FieldSetHelp (0,htr_UserEdit_SmtpInPath);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'SMTP-Out path');
          FieldAutoDefineFileMgr (Xb2,FieldY,54,@UserData.SmtpOutPath,PathFileMgr,FALSE);
          FieldSetHelp (0,htr_UserEdit_SmtpOutPath);
     END;

     IF (UserData.System = _SOUP) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'SOUP-In path');
          FieldAutoDefineFileMgr (Xb2,FieldY,54,@UserData.SoupInPath,PathFileMgr,FALSE);
          FieldSetHelp (0,htr_UserEdit_SoupInPath);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'SOUP-Out path');
          FieldAutoDefineFileMgr (Xb2,FieldY,54,@UserData.SoupOutPath,PathFileMgr,FALSE);
          FieldSetHelp (0,htr_UserEdit_SoupOutPath);
     END;

     IF (UserData.System = _B) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Search path');
          FieldAutoDefineFileMgr (Xb2,FieldY,54,@UserData.BagPath,BagFileMgr,TRUE);
          FieldSetHelp (0,htr_UserEdit_BagSearchPath);
     END;

     IF (UserData.System = _F) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Outbound Path');
          FieldAutoDefineFileMgr (Xb2,FieldY,54,@UserData.NodeOutDir,PathFileMgr,TRUE);
          FieldSetHelp (0,htr_UserEdit_OutboundPath);
     END;

     IF (UserData.System IN [_INETMAIL,_SOUP,_U,_S]) THEN
     BEGIN
          Inc (FieldY);
          FieldAutoDefineOne (Xb2,FieldY,@UserData.UUCPName,RepChar (MaxLenUUCPName,'$'));

          CASE UserData.System OF
               _U : BEGIN
                         WriteXY (Xb+2,FieldY,'UUCP name');
                         FieldSetHelp (0,htr_UserEdit_UUCPname);
                    END;

               _S : BEGIN
                         WriteXY (Xb+2,FieldY,'System name');
                         FieldSetHelp (0,htr_UserEdit_SystemName)
                    END;

               _SOUP: BEGIN
                         {## This is only used for the SmartHost setting.}
                         {   Should we do something else instead?}
                         WriteXY (Xb+2,FieldY,'System name');
                         {## help}
                      END;

               _INETMAIL: BEGIN
                              {## This is only used for the SmartHost setting.}
                              {   Should we do something else instead?}
                              WriteXY (Xb+2,FieldY,'System name');
                              {## help}
                          END;

          END; { case }
     END;

     IF (UserData.System = _U) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Compress');
          FieldAutoDefineTogglesCall (Xb2,FieldY,UserData.Compress,'none|compress|gzip',0,CheckGrayCunBatch);
          FieldSetHelp (0,htr_UserEdit_Compression);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Add batch header');
          FieldAutoDefineToggles (Xb2,FieldY,UserData.CunBatch,'no|yes',0);
          FieldSetHelp (0,htr_UserEdit_AddBatchHeader);

          IF (UserData.Compress = uctNone) THEN
             FieldDisableField (0);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Mail grade');
          FieldAutoDefineOne (Xb2,FieldY,@MailGradeStr,'@');
          FieldSetHelp (0,htr_UserEdit_MailNewsGrade);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'News grade');
          FieldAutoDefineOne (Xb2,FieldY,@NewsGradeStr,'@');
          FieldSetHelp (0,htr_UserEdit_MailNewsGrade);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'GigoT specials');
          FieldAutoDefineToggles (Xb2,FieldY,UserData.GigoT,'no|yes',0);
          FieldSetHelp (0,htr_UserEdit_GigoT);
     END;

     IF (UserData.System = _B) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Return system');
          FieldAutoDefineList (Xb2,FieldY,@UserData.BAGBackLink,PickReturnSystem);
          FieldSetHelp (0,htr_UserEdit_ReturnSystem);
     END;

     { the following two or three fields can be left out for bag suppliers... }
     { RWI 960714: did just that }

     IF (UserData.System IN [_F,_U,_S]) THEN
     BEGIN
          {
          IF (UserData.System <> _F) OR (Yl > 23) THEN
          BEGIN
               Inc (FieldY);
               WriteXY (Xb+2,FieldY,'World registered');
               FieldAutoDefineToggles (Xb2,FieldY,UserData.WorldReg,'no|yes',0);
               FieldSetHelp (0,1213);
          END;
          }

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Allow sub-domains');
          FieldAutoDefineToggles (Xb2,FieldY,UserData.AllowSubDomains,'no|yes',0);
          FieldSetHelp (0,htr_UserEdit_AllowSubDomains);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Domain addresses');
          FieldAutoDefineCheckOne (Xb2,FieldY,@UserData.Domains[1],RepChar (MaxLenDomain,'$'),CheckFirstDomain);
          FieldSetHelp (0,htr_UserEdit_DomainAddresses);

          Inc (FieldY);
          FOR DomainLp:=2 TO MaxUserDomains DO
          BEGIN
               FieldAutoDefineCheckOne (Xb2,FieldY,@UserData.Domains[DomainLp],RepChar (MaxLenDomain,'$'),CheckOtherDomain);
               FieldSetHelp (0,htr_UserEdit_DomainAddresses);
               Inc (FieldY);
          END; { for }
     END;

     IF (UserData.System = _P) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Mailbox path');
          FieldAutoDefineFileMgr (Xb2,FieldY,54,@UserData.Pop3File,Pop3FileMgr,TRUE);
          FieldSetHelp (0,htr_UserEdit_Pop3MailboxPath);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Message separator');
          FieldAutoDefineOne (Xb2,FieldY,@UserData.Pop3Separator,RepChar (15,'$'));
          FieldSetHelp (0,htr_UserEdit_Pop3Separator);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Envelope header');
          FieldAutoDefineOne (Xb2,FieldY,@UserData.Pop3EnvelopeHdr,RepChar (25,'$'));
          FieldSetHelp (0,htr_UserEdit_Pop3EnvelopeHeader);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Single recipient');
          FieldAutoDefineCheckOne (Xb2,FieldY,@UserData.Pop3Recipient,RepChar (MaxLenDomain,'$'),CheckRecipient);
          FieldSetHelp (0,htr_UserEdit_Pop3SingleRecipient);
     END;

     IF (UserData.System = _SOUP) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Envelope header');
          FieldAutoDefineOne (Xb2,FieldY,@UserData.SoupEnvelopeHdr,RepChar (25,'$'));
          FieldSetHelp (0,htr_UserEdit_SoupEnvelopeHeader);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Single recipient');
          FieldAutoDefineCheckOne (Xb2,FieldY,@UserData.SoupRecipient,RepChar (MaxLenDomain,'$'),CheckRecipient);
          FieldSetHelp (0,htr_UserEdit_SoupSingleRecipient);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Using WGSOUP');
          FieldAutoDefineToggles (Xb2, FieldY, UserData.UsingWGSOUP, 'no|yes', 0);
          FieldSetHelp (0,htr_UserEdit_SoupUsingWGSOUP);
     END;

     IF (UserData.System = _INETMAIL) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Queue Path');
          FieldAutoDefineFileMgr (Xb2,FieldY,54,@UserData.InetMailQueue,InetMailFileMgr,TRUE);
          {## help}

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Source domain');
          FieldAutoDefineOne (Xb2,FieldY,@UserData.InetMailSourceDomain, RepChar (MaxLenDomain,'$'));
          {## help}
     END;

     IF (UserData.System = _BBS) THEN
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'System AKA');
          FieldAutoDefineList (Xb2,FieldY,@SystemAkaStr,EditUserDataSystemAka);
          FieldSetHelp (0,htr_USERBBS_System_AKA);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Fake AKA');
          FieldAutoDefineCheckOne (Xb2,FieldY,@FakeAkaStr,RepChar (17,'$'),CheckFakeAka);
          FieldSetHelp (0,htr_USERBBS_Fake_AKA);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'SEEN-BY and PATH');
          FieldAutoDefineToggles (Xb2,FieldY,UserData.KeepSBP,'strip|keep',0);
          FieldSetHelp (0,htr_USERBBS_KeepSBP);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Inbound');
          FieldAutoDefineFileMgr (Xb2,FieldY,54,@UserData.Inbound,PathFileMgr,FALSE);
          FieldSetHelp (0,htr_USERBBS_Inbound);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Packet extension');
          FieldAutoDefineOne (Xb2,FieldY,@UserData.InboundExt,'$$$');
          FieldSetHelp (0,htr_USERBBS_Packet_extension);

          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Outbound');
          FieldAutoDefineFileMgr (Xb2,FieldY,54,@UserData.Outbound,PathFileMgr,FALSE);
          FieldSetHelp (0,htr_USERBBS_Outbound);
     END;

     { set cursor on subscribed to field }
     IF (UserData.System = _INETMAIL) THEN
          FieldSetFirst (1)
     ELSE
          IF (UserData.System = _F) THEN
          BEGIN
               IF (DeleteBackSpaces (FidoAddrDesc) <> '0') THEN
                  FieldSetFirst (5); { subscribed to }
          END ELSE
              IF NOT (UserData.System IN [_SOUP,_S,_P]) THEN
                 FieldSetFirst (3);
     
     
     IF (UserData.System = _U) THEN
     BEGIN
          UserData.MailGrade:=MailGradeStr[1];
          UserData.NewsGrade:=NewsGradeStr[1];
     END;
END;


{--------------------------------------------------------------------------}
{ CleanEdittedUserRecord                                                   }
{                                                                          }
{ Deze routine wordt aangeroepen na het editten van een bestaand als een   }
{ nieuw record. Hier worden alles velden van spaties ontdaan en tussen-    }
{ buffers omgezet in nummers.                                              }
{                                                                          }
{ RWI 960811: aangemaakt ivm inconsistenties tussen new user en edit user. }
{                                                                          }
PROCEDURE CleanEdittedUserRecord;

VAR DomTel : 1..MaxUserDomains;
    Fout   : ValNop;

BEGIN
     WITH UserData DO
     BEGIN
          { bij deze deletebackspaces eerst controleren bij }
          { welk type deze hoort ivm velden die over elkaar }
          { heen liggen voor fido en uucp!!                 }

          { globaal }
          Organization:=DeleteFrontAndBackSpaces (Organization);
          AreaFixPwd:=DeleteFrontAndBackSpaces (AreaFixPwd);
          UUCPName:=DeleteFrontAndBackSpaces (UUCPName);

          FOR DomTel:=1 TO MaxUserDomains DO
              Domains[DomTel]:=DeleteFrontAndBackSpaces (Domains[DomTel]);

          CASE System OF
               _F :
                   BEGIN
                        PacketPwd:=DeleteFrontAndBackSpaces (PacketPwd);
                        Sysop:=DeleteFrontAndBackSpaces (Sysop);
                        TunnelTo:=DeleteFrontAndBackSpaces (TunnelTo);
                        NodeOutDir:=DeleteFrontAndBackSpaces (NodeOutDir);
                   END;

               _U :
                   BEGIN
                        MailGrade:=MailGradeStr[1];
                        IF NOT (MailGrade IN ['A'..'Z']) THEN
                           MailGrade:='A';

                        NewsGrade:=NewsGradeStr[1];
                        IF NOT (NewsGrade IN ['A'..'Z']) THEN
                           NewsGrade:='A';
                   END;

               _B :
                   BEGIN
                        BAGBackLink:=DeleteFrontAndBackSpaces (BAGBackLink);
                        BagPath:=DeleteFrontAndBackSpaces (BagPath);
                   END;

               _S :
                   BEGIN
                        SmtpInPath:=DeleteFrontAndBackSpaces (SmtpInPath);
                        SmtpOutPath:=DeleteFrontAndBackSpaces (SmtpOutPath);
                   END;

               _P :
                   BEGIN
                        Pop3File:=DeleteFrontAndBackSpaces (Pop3File);
                        Pop3Recipient:=DeleteFrontAndBackSpaces (Pop3Recipient);
                        Pop3Separator:=DeleteFrontAndBackSpaces (Pop3Separator);
                        IF (UpCaseString (Pop3Separator) = 'FROM') THEN
                           Pop3Separator:=Pop3Separator+' ';
                        Pop3EnvelopeHdr:=DeleteFrontAndBackSpaces (Pop3EnvelopeHdr);
                   END;

               _BBS:
                   BEGIN
                        Inbound:=DeleteFrontAndBackSpaces (Inbound);
                        Outbound:=DeleteFrontAndBackSpaces (Outbound);
                        InboundExt:=DeleteFrontAndBackSpaces (InboundExt);
                   END;

               _SOUP:
                    BEGIN
                         SoupInPath:=DeleteFrontAndBackSpaces (SoupInPath);
                         SoupOutPath:=DeleteFrontAndBackSpaces (SoupOutPath);
                         SoupRecipient:=DeleteFrontAndBackSpaces (SoupRecipient);
                         SoupEnvelopeHdr:=DeleteFrontAndBackSpaces (SoupEnvelopeHdr);
                    END;

           END; { case }
     END; { with }
END;


{--------------------------------------------------------------------------}
{ EditUserBaseRecord                                                       }
{                                                                          }
{ Met deze routine kan de inhoud van het opgegeven record uit de UserBase  }
{ gewijzigd worden. Als de naam gewijzigd is, dan wordt TRUE terug gegeven }
{                                                                          }
FUNCTION EditUserBaseRecord (RecNr : UserBaseRecordNrType) : BOOLEAN;

TYPE Cmp = ARRAY[1..SizeOf (UserBaseRecord)] OF BYTE;

VAR Quit        : BOOLEAN;
    OldUserData : UserBaseRecord;
    Lp          : WORD;

BEGIN
     EditUserBaseRecord:=FALSE;

     EditRecNr:=RecNr; { voor andere routines }
     ReadUserBaseRecord (EditRecNr,UserData);

     OldUserData:=UserData;

     FixUserDataRecord;
     DrawUserBaseRecordScreen;

     IF (UserData.System = _F) THEN
        GrayTunnelToField;

     FieldUpdateScreen;

     Quit:=FALSE;
     REPEAT
           FieldEdit;

           IF (Key IN [kEsc,kF10]) THEN
           BEGIN
                { Verwijder onnodige spaties uit de UserData records }
                CleanEdittedUserRecord;
                WriteUserBaseRecord (EditRecNr,UserData);
                Quit:=TRUE;
           END;

     UNTIL Quit;

     WindowPop; { UserBaseRecordScreen }

     { If user changed Passive status, update list <P> field. }
     IF (UserData.Passive <> OldUserData.Passive) THEN
          EditUserBaseRecord := TRUE;

     IF (UserData.System = _F) THEN
     BEGIN
          IF (NOT FidoCompare (UserData.Address,OldUserData.Address)) OR
             (OldUserData.Sysop <> UserData.Sysop)
          THEN
              EditUserBaseRecord:=TRUE; { er is iets gewijzigd }
     END ELSE
         FOR Lp:=1 TO SizeOf (UserBaseRecord) DO
             IF (Cmp (OldUserData)[Lp] <> Cmp (UserData)[Lp]) THEN
             BEGIN
                  EditUserBaseRecord:=TRUE; { er is iets gewijzigd }
                  Break;
             END;
END;


{--------------------------------------------------------------------------}
{ DeleteUserBaseRecord                                                     }
{                                                                          }
{ Met deze routine kan een UserBase record verwijderd worden. Er wordt     }
{ niet om een bevestiging gevraagd hier, omdat er ivm tags meerdere calls  }
{ kunnen zijn. Dat moet de aanroeper dus maar doen. Nadat het record       }
{ verwijderd is wordt HasChangedUser op TRUE gezet, zodat de select lijst  }
{ geupdate kan worden.                                                     }
{                                                                          }
PROCEDURE DeleteUserBaseRecord (RecNr : UserBaseRecordNrType);

VAR UserData : UserBaseRecord;
    AreaData : AreaBaseRecord;
    Search   : SubscrSearchRecord;

BEGIN
     ReadUserBaseRecord (RecNr,UserData);

     REPEAT
           GetFirstAreaUserIsSubscribedTo (UserData.AreaList,Search);

           IF Search.Found THEN
           BEGIN
                RemoveAreaFromUserSubscrToList (UserData,Search.AreaBaseRecordNr);
                ReadAreaBaseRecord (Search.AreaBaseRecordNr,AreaData);
                RemoveUserFromAreaSubscrList (AreaData,RecNr);
                WriteAreaBaseRecord (Search.AreaBaseRecordNr,AreaData);
           END;

     UNTIL (NOT Search.Found);

     UserData.Deleted:=TRUE;
     WriteUserBaseRecord (RecNr,UserData);
END;


{--------------------------------------------------------------------------}
{ CreateNewUserBaseRecord                                                  }
{                                                                          }
{ Met deze routine kan een nieuwe User Database record aangemaakt worden.  }
{ Als er een nieuw user record aangemaakt is wordt TRUE terug gegeven.     }
{                                                                          }
FUNCTION CreateNewUserBaseRecord (Links : BOOLEAN) : UserBaseRecordNrType;

VAR Quit : BOOLEAN;

BEGIN
     CreateNewUserBaseRecord:=0; { gen record aangemaakt }

     IF Links THEN
     BEGIN
          MenuDefine (27,10,'New link type');
          MenuAddItem ('BAG supplier link');
          MenuAddItem ('SMTP mailer link');
          MenuAddItem ('POP3 mailbox link');
          MenuAddItem ('BBS Interface link');
          MenuAddItem ('SOUP mailer link');
          MenuAddItem ('Inet.Mail mailer link');

          MenuSetHelp (htr_UserEdit_NewLinkType);
          MenuShow;

          CASE MenuSelect OF
               mOpt01 : UserData.System:=_B;  { BAG  }
               mOpt02 : UserData.System:=_S;  { SMTP }
               mOpt03 : UserData.System:=_P;  { POP3 }
               mOpt04 : UserData.System:=_BBS; { BBS Interface }
               mOpt05 : UserData.System:=_SOUP; { SOUP }
               mOpt06 : UserData.System:=_INETMAIL; { Inet.Mail }
          END;

     END ELSE
     BEGIN
          MenuDefine (27,10,'New user type');
          MenuAddItem ('FTN style user');
          MenuAddItem ('UUCP style user');
          MenuSetHelp (htr_UserEdit_NewUserType);
          MenuShow;

          CASE MenuSelect OF
               mOpt01 : UserData.System:=_F; { FTN  }
               mOpt02 : UserData.System:=_U; { UUCP }
          END;

     END;

     MenuErase;

     IF (Key = kEsc) THEN
        Exit;

     EmptyUserDataRecord;
{ RvdW 03-04-93 EditRecNr hier al invullen en record naar disk schrijven,
                anders gaat het mis bij het subscriben, want die wil ook
                het UserBase record naar disk schrijven, maar dan is
                EditRecNr nog niet ingevuld.                               }
     EditRecNr:=UserBaseRecCount+1;
     WriteUserBaseRecord (EditRecNr,UserData);
     CreateNewUserBaseRecord:=EditRecNr;

     DrawUserBaseRecordScreen;

     Quit:=FALSE;
     REPEAT
           FieldEdit;

           IF (Key IN [kEsc,kF10]) THEN
           BEGIN
                CleanEdittedUserRecord;
                WriteUserBaseRecord (EditRecNr,UserData);
                Quit:=TRUE;
           END;

     UNTIL Quit;

     WindowPop;
END;


{--------------------------------------------------------------------------}
{ FidoListConvertFunc                                                      }
{                                                                          }
FUNCTION FidoListConvertFunc (Item : STRING) : STRING; FAR;

VAR Addr : FidoAddrType;
    P    : BYTE;

BEGIN
     P:=Pos (' ',Item);
     IF (Item[1] IN ['0'..'9']) AND (Pos ('/',Item) > 0) AND (P > 0) THEN
     BEGIN
          FidoSplit (Copy (Item,1,P-1),Addr);

          IF NOT ((Addr.Zone=0) AND (Addr.Net=0) AND (Addr.Node=0) AND (Addr.Point=0)) THEN
             Item:=AddUpWithPre0s (5,Word2String (Addr.Zone))+':'+
                   AddUpWithPre0s (5,Word2String (Addr.Net))+'/'+
                   AddUpWithPre0s (5,Word2String (Addr.Node))+'.'+
                   AddUpWithPre0s (5,Word2String (Addr.Point))+
                   Copy (Item,P,255);
     END;

     FidoListConvertFunc:=Item;
END;


{--------------------------------------------------------------------------}
{ CopyAndEditUser                                                          }
{                                                                          }
{ This routine copies the user/link definition; cleans out all the fields  }
{ that must be unique, writes a new user record, subscribes it to the same }
{ areas as the original user and then enters the editor. It returns the    }
{ record number of the new user.                                           }
{                                                                          }
FUNCTION CopyAndEditUser (OrigRecNr : UserBaseRecordNrType) : UserBaseRecordNrType;

VAR NewRecNr : UserBaseRecordNrType;
    Search   : SubscrSearchRecord;
    AreaRec  : AreaBaseRecord;

BEGIN
     ReadUserBaseRecord (OrigRecNr,UserData);

     GetFirstAreaUserIsSubscribedTo (UserData.AreaList,Search);

     { clean some of the important fields }
     { the rest remains as an example     }

     WITH UserData DO
     BEGIN
          Deleted:=FALSE;

          Organization:='';
          AreaFixPwd:='';
          AreaList:=NILRecordNr;
          UUCPname:='';

          CASE System OF
               _F :
                   BEGIN
                        Address.Zone:=0;
                        Address.Net:=0;
                        Address.Node:=0;
                        Address.Point:=0;
                        Address.Domain:='';
                        SysOp:='';
                        PacketPwd:='';
                        LastArchDow:=0;
                        LastArchNr:=0;
                   END;

               _BBS :
                   BEGIN
                        FakeZone:=0;
                        FakeNet:=0;
                        FakeNode:=0;
                   END;

          END; { case }
     END; { with }

     { write the new record }
     NewRecNr:=UserBaseRecCount+1;
     WriteUserBaseRecord (NewRecNr,UserData);

     Message ('Subscring new user to the same areas');

     { now copy all the subscribed areas from the original user }
     WHILE (Search.Found) DO
     BEGIN
          ReadAreaBaseRecord (Search.AreaBaseRecordNr,AreaRec);
          AddUserToAreaSubscrList (AreaRec,NewRecNr);
          WriteAreaBaseRecord (Search.AreaBaseRecordNr,AreaRec);

          AddAreaToUserSubscrToList (UserData,Search.AreaBaseRecordNr);

          GetNextAreaUserIsSubscribedTo (Search);
     END; { while }

     WriteUserBaseRecord (NewRecNr,UserData);

     WindowPop;

     { enter the editor }
     EditUserBaseRecord (NewRecNr);

     CopyAndEditUser:=NewRecNr;
END;


{--------------------------------------------------------------------------}
{ EditSystems                                                              }
{                                                                          }
{ Van hieruit kunnen de user configs aangepast worden.                     }
{                                                                          }
PROCEDURE EditSystems (Links : BOOLEAN);

VAR Quit    : BOOLEAN;
    Lp      : UserBaseRecordNrType;
    Keuze   : WORD;

    {----------------------------------------------------------------------}
     { BuildFlags                                                           }
     {                                                                      }
     { Builds the 'flags' field in the table.  Possible flags include the   }
     { Passive/Active flag (+), the Create New Areas (C), Notify (N),  and  }
     { Allow Subdomains (S).                                                }
     {                                                                      }
     FUNCTION BuildFlags: STRING;
     VAR
          Flags: STRING;

     BEGIN
                   {+CNS  }
          Flags := '      ';

          { No flags for Inet.Mail links }
          IF (UserData.System = _INETMAIL) THEN
          BEGIN
               BuildFlags := Flags;
               Exit;
          END;

          { Passive: - = passive, + = non-passive.  Not applicable to Link }
          {          definitions, and set to ` '.                          }
          IF (NOT Links) THEN
          BEGIN
               IF (NOT UserData.Passive) THEN
                    Flags [1] := '+'
               ELSE
                    Flags [1] := '-';
          END;

          { Create New Areas: not applicable to any links, except for SOUP }
          {                   feeds.                                       }
          IF ((NOT Links) OR ((Links) AND (UserData.System = _SOUP))) THEN
               IF (UserData.AllowCreate) THEN
                    Flags [2] := 'C';

          { Notify: not applicable to links                                }
          IF (((UserData.System = _F) AND (UserData.Notify_F)) OR
              ((UserData.System = _U) AND (UserData.Notify_U))) THEN
               Flags [3] := 'N';

          { Allow sub-domains:  Applicable to SMTP + users                 }
          IF ((NOT Links) OR ((Links) AND (UserData.System = _S))) THEN
               IF (UserData.AllowSubDomains) THEN
                    Flags [4] := 'S';

          BuildFlags := Flags;
     END;

    {----------------------------------------------------------------------}
    { AddUserToList                                                        }
    {                                                                      }
    { Deze routine voegt de omschrijving van de user gesorteerd toe aan de }
    { lijst. UserData moet de gegevens bevatten.                           }
    {                                                                      }
    PROCEDURE AddUserToList (Index : WORD);

    VAR SysType,   
        SysAddress,
        SysFlags,
        SysName,
        Temp : STRING[250];

    BEGIN
         {
         LAYOUT:

Fido 201:2935/4902.999 +CNS   Anthony TIbbs (up to so many chars of org..)
---- ----------------- ------ --------------------------------------------
  4          17           6                       44         xxxxxxxxxxxxx
  
          }

         { passive only applies to FTN, BBS, and UUCP nodes (correct?) }
         
         SysFlags := BuildFlags;
         SysType := '????';
         SysName := '';

         CASE UserData.System OF
              _F: BEGIN
                       SysType := 'FTN ';
                       SysAddress := Fido2Str (UserData.Address);
                       SysName := UserData.SysOp;


                       {
                       IF (Length (Temp1)+Length (Temp2)+Length (Temp3) > 67) THEN
                          Temp3:=Copy (Temp2,1,64-Length (Temp1))+'...';
                       }

                       {ListAddItem (Temp1 + Temp2+ ' ('+Temp3+')',Index,Convert);}
                  END;

              _U : BEGIN
                         SysType := 'UUCP';
                         SysAddress := UserData.UUCPName;

                         {ListAddItem (Temp1 + UserData.UUCPName+' ('+UserData.Organization+') ',Index,Sorted);}
                    END;

              _B : BEGIN
                         SysType := 'BAG ';
                         SysAddress := UserData.UUCPName;

                         {ListAddItem (UserData.Organization+' (BAG supplier link) ',Index,Sorted);}
                   END;

              _S : BEGIN
                         SysType := 'SMTP';
                         SysAddress := UserData.UUCPName;

                         {ListAddItem (UserData.Organization+' (SMTP mailer link) ',Index,Sorted);}
                   END;

              _P : BEGIN
                         SysType := 'POP3';
                         SysAddress := UserData.UUCPName;

                         {ListAddItem (UserData.Organization+' (POP3 mailbox link) ',Index,Sorted);}
                  END;

              _BBS : BEGIN
                         SysType := 'BBS ';
                         SysAddress := Word2String (UserData.FakeZone) + ':'+
                                       Word2String (UserData.FakeNet) + '/'+
                                       Word2String (UserData.FakeNode);

                         
                         {
                         ListAddItem (Temp1 +
                                      Word2String (UserData.FakeZone)+':'+
                                      Word2String (UserData.FakeNet)+'/'+
                                      Word2String (UserData.FakeNode)+
                                      ' ('+UserData.Organization+') ',Index,Sorted);
                         }
                       END;

               _SOUP : BEGIN
                         SysType := 'SOUP';
                         SysAddress := UserData.UUCPName;

                         {ListAddItem (UserData.Organization+' (SOUP mailer link) ',Index,Sorted);}
                       END;

               _INETMAIL: BEGIN
                              SysType := 'INET';
                              SysAddress := UserData.UUCPName;
                          END;
                              
         END; { case }

         SysAddress := DeleteFrontAndBackSpaces (SysAddress);
         SysName := DeleteFrontAndBackSpaces (SysName);

         IF (SysAddress = '') THEN
              SysAddress := '<none>';

         { Build it all up. }
         Temp := SysType + ' ' + AddUpWithSpaces (17, SysAddress) +
                           ' ' + AddUpWithSpaces (6, SysFlags) +
                           ' ' + SysName;

          { If we have room for the Organization part (can fit at least the }
          { first 12 characters in), fit as much as we can after the name,  }
          { up to a maximum length of 75.                                   }
          IF ((Length (Temp) <= 56) AND (Length (UserData.Organization) > 0)) THEN
          BEGIN
               { If there wasn't a Sysop Name, don't add a space }
               IF (Length (SysName) > 0) THEN
                    Temp := Temp + ' ';

               Temp := Temp + '(';

(* ====> just show everything for now.
               IF (Length (UserData.Organization) > (75 - Length (Temp))) THEN
               BEGIN
                    Temp := Temp + Copy (UserData.Organization, 1, (75 - Length (Temp)));
                    Temp := Temp + '...';
               END ELSE
*)
                    Temp := Temp + UserData.Organization;

               Temp := Temp + ')';
          END;

          ListAddItem (Temp, Index, Sorted);
    END;

{ EditSystems }

VAR Systems : SET OF SystemType;

BEGIN
     IF Links THEN
     BEGIN
          Systems:=[_INETMAIL,_B,_S,_P,_BBS,_SOUP];
          ListDefine (3,3,74,Video.Rows-4,Default,
                      'Configured Links',
                      htr_UserEdit_LinksList);
     END ELSE
     BEGIN
          Systems:=[_F,_U];
          ListDefine (3,3,74,Video.Rows-4,Default,
                     'Configured Users',
                     htr_UserEdit_UsersList);
     END;

     ListSetConvertRoutine (FidoListConvertFunc);

     FOR Lp:=1 TO UserBaseRecCount DO
     BEGIN
          ReadUserBaseRecord (Lp,UserData);

          IF (NOT UserData.Deleted) AND (UserData.System IN Systems) THEN
             AddUserToList (Lp);
     END; { lp }

     Quit:=FALSE;
     REPEAT
           IF (ListItemCount = 0) THEN
              IF Links THEN
                 ListAddItem ('<no links configured>',65534,Bottom)
              ELSE
                  ListAddItem ('<no users configured>',65534,Bottom);

           ListTagKeysLine:=ORG_ListTagKeysLine+'  ^F2 Copy';
           Keuze:=ListSelect (DoTag,[kIns,kDel,kF2]);
           ListTagKeysLine:=ORG_ListTagKeysLine;

           ListRemoveItem (65534);

           CASE Key OF
                kEsc : Quit:=TRUE;

                kRet :
                    IF (ListTagCount = 0) THEN
                       IF EditUserBaseRecord (Keuze) THEN
                       BEGIN
                            { update de lijst }
                            ListRemoveItem (Keuze);
                            ReadUserBaseRecord (Keuze,UserData);
                            AddUserToList (Keuze);
                            ListSetCursorOnItem (Keuze);
                       END;

                kDel :
                    IF (ListTagCount = 0) THEN
                    BEGIN
                         IF (Keuze < 65000) AND (AreYouSureWithHelp ('Delete this user?',1202) = mOpt01) THEN
                         BEGIN
                              Message ('Unsubscribing areas; Deleting user');
                              DeleteUserBaseRecord (Keuze);
                              WindowPop; { message }
                              ListRemoveItem (Keuze);
                         END;
                    END ELSE
                        IF (AreYouSureWithHelp ('Delete all tagged users?',
                                                htr_UserEdit_DeleteTaggedUsers_AreYouSure) = mOpt01) THEN
                        BEGIN
                             Message ('Deleting users, please wait...');

                             WHILE (ListTagCount > 0) DO
                             BEGIN
                                  Keuze:=ListGettaggedItemNr (1);
                                  DeleteUserBaseRecord (Keuze);
                                  ListRemoveItem (Keuze);
                             END; { while }

                             WindowPop; { message }
                        END;

                kIns :
                    BEGIN
                         Keuze:=CreateNewUserBaseRecord (_S IN Systems);

                         IF (Keuze <> 0) THEN
                         BEGIN
                              ReadUserBaseRecord (Keuze,UserData);
                              AddUserToList (Keuze);
                              ListSetCursorOnItem (Keuze);
                         END;
                    END; { kIns }

                kF2 :
                    IF (ListTagCount = 0) THEN
                    BEGIN
                         MenuDefine (25,10,'Copy this definition?');
                         MenuAddItem ('Yes');
                         MenuAddItem ('No');
                         MenuShow;
                         MenuSelect;
                         MenuErase;

                         IF (Key = mOpt01) THEN
                         BEGIN
                              Keuze:=CopyAndEditUser (Keuze);

                              ReadUserBaseRecord (Keuze,UserData);
                              AddUserToList (Keuze);
                              ListSetCursorOnItem (Keuze);
                         END;
                    END;
           END; { case }

     UNTIL Quit;

     ListErase;
END;
{$ENDIF (WtrConf)}

END.

