{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT Textfile;

{$i platform.inc}

{ MD  01-04-93  Begin aan de token routine                                }
{ MD  07-04-93  TokenString verplaatst zodat zij ook aan te passen is     }
{               vanuit andere routines.                                   }
{ RvdW 18-02-95 Uitbreiding voor Usenet: invullen UserName achtigen.      }
{ RaWi 9801     Changed AddFileToMsg (TopPtr) with AddFileToBody.         }

INTERFACE

USES Database,
     Msgs;

{ Textfile interface                                                      }
{                                                                         }
{ Geeft de mogenlijkheid om tekstfiles te importeren in een bericht en zo }
{ op een nette manier antwoord te geven op fouten.                        }

{ Zoek en vervang keywords :                                              }
{                                                                         }
{ FirstUserName  - Voornaam                                               }
{ LastUserName   - Achternaam                                             }
{ UserName       - Voor + Achternaam                                      }
{ Subject        - Onderwerp van het bericht                              }
{ Password       - Gebruikte AFix password                                }
{                                                                         }
{ Date           - Huidige SysteemDatum       ( Europees formaat ! )      }
{ Time           - Huidige Systeemtijd                                    }
{ OurAddress     - Gebruikte AKA                                          }
{ FromAddress    - Aka afzender                                           }
{                                                                         }
{ Sysop          - In config ingevoerde System operator                   }
{ SysopFirst     - Voornaam van de Sysop                                  }
{ AreaName       - Huidige Area                                           }
{ PID            - Programma naam   ( StrGate )                           }
{ Version        - Programma versie ( 1.00    )                           }
{                                                                         }
{ Tokens komen voor in de vorm @Sysop@ in een tekstfile                   }

TYPE TokenType = (tokFirstUserName, tokLastUserName, tokUserName,
                  tokSubject,       tokPassword,     tokDate,
                  tokTime,         {tokOurAddress,}  tokFromAddress,
                  tokToAddress,     tokToUserName,   tokSysop,
                  tokSysopFirst,    tokAreaName,     tokPID,
                  tokVersion,       tokWeekDay,      tokDaysLeft,
                  {## add tokens for AreaMgr, %NOTIFY}
                  tokListName);

PROCEDURE InitTokens (System : SystemType);
PROCEDURE SetToken (Token : TokenType; TokenStr : STRING);
FUNCTION  AddFileToBody (Filename : STRING) : BOOLEAN;


IMPLEMENTATION

USES Globals,
     Ramon,
     Cfg,
     Dos,
     Fido,
     FBuffer,
     Logs,
     Trans;

CONST TokenStr : ARRAY[TokenType] OF STRING[13] =
                ('FIRSTUSERNAME',
                 'LASTUSERNAME',
                 'USERNAME',
                 'SUBJECT',
                 'PASSWORD',
                 'DATE',
                 'TIME',                    {'OURADDRESS',}
                 'FROMADDRESS',
                 'TOADDRESS',
                 'TOUSERNAME',
                 'SYSOP',
                 'SYSOPFIRST',
                 'AREANAME',
                 'PID',
                 'VERSION',
                 'WEEKDAY',
                 'DAYSLEFT',
                 'LISTNAME'
                );

      Days : ARRAY[0..6] OF STRING[9] =
                ('Sunday',
                 'Monday',
                 'Tuesday',
                 'Wednesday',
                 'Thursday',
                 'Friday',
                 'Saturday'
                );


VAR TokenString : ARRAY[TokenType] OF STRING[50];

{-------------------------------------------------------------------------}
{ FirstName                                                               }
{                                                                         }
{ Haalt de eerste naam uit een string, en geeft die terug.                }
{ Martijn Dijksterhuis -> Martijn                                         }
{                                                                         }
FUNCTION FirstName (Name : STRING) : STRING;

VAR X : BYTE;

BEGIN
     X:=Pos (' ',Name);
     IF (X > 0) THEN
        FirstName:=Copy (Name,1,X-1)
     ELSE
         FirstName:=Name;
END;


{--------------------------------------------------------------------------}
{ LastName                                                                 }
{                                                                          }
{ Doet hetzelfde als firstname, maar dan voor het achterste gedeelte van   }
{ de naam.                                                                 }
{                                                                          }
FUNCTION LastName (Name : STRING) : STRING;

VAR X : BYTE;

BEGIN
     X:=Pos (' ',Name);
     IF (X > 0) THEN
        LastName:=Copy (Name,X,255)
     ELSE
         LastName:='';
END;


{--------------------------------------------------------------------------}
{ SetToken                                                                 }
{                                                                          }
{ Geef andere units de mogenlijkheid om een token aan te spreken.          }
{ zonder dat meteen de hele tabel (70*20 ofzo) global gemaakt moet worden  }
{                                                                          }
PROCEDURE SetToken (Token : TokenType; TokenStr : STRING);
BEGIN
     TokenString[Token]:=TokenStr;
END;


{--------------------------------------------------------------------------}
{ InitTokens                                                               }
{                                                                          }
{ Vult de token strings met nuttige informatie.                            }
{                                                                          }
{## add destination record token }
PROCEDURE InitTokens (System : SystemType);

VAR Yea,Mon,Day,Dow : WordLong;
    Hou,Min,Sec,Hun : WordLong;
    Loc             : INTEGER;
    Lp              : TokenType;
    MatchAddr       : FidoAddrType;

BEGIN
     { maak alle strings schoon }
     FOR Lp:=tokFirstUserName TO tokListName DO
         TokenString[Lp]:='';

     { If FIDO }
     IF (System = _F) THEN
     BEGIN
          { namen }
          TokenString[tokUserName]:=Msg.FromUser_F;

          { Als er een spatie in de voornaam zit, dan splitst dit }
          { voor + achternaam.                                    }
          TokenString[tokFirstUserName]:=FirstName (Msg.FromUser_F);
          TokenString[tokLastUserName]:=LastName (Msg.FromUser_F);

          IF (Msg.FirstDest <> NIL) THEN
             TokenString[tokToUserName]:=Msg.FirstDest^.ToUser_F
          ELSE
              TokenString[tokToUserName]:='??';

          { bericht info }
          TokenString[tokSubject]:=Msg.Subj_F;
          TokenString[tokPassword]:={Areafix.Password;}''; { komt nog }

          IF Msg.Ready_F IN [Local_Netmail,Netmail] THEN
             TokenString[tokAreaName]:='Netmail'
          ELSE
              TokenString[tokAreaName]:=Msg.Area_F;

         {FidoMatchAddress( Msg.FromAddr_F , MatchAddr );}
         {TokenString[ OurAddress ] := Fido2Str( MatchAddr );}
          TokenString[tokFromAddress]:=Fido2Str (Msg.FromAddr_F);
          TokenString[tokToAddress]:='** ERROR **'; {## FIX THIS }
     END ELSE
     BEGIN
          { usenet }
          {## get info from destination record for which this init was done }
          TokenString[tokToAddress]:='?'{Msg.XqtTo_U};
          TokenString[tokFromAddress]:=Msg.FromUser_U;

          IF (Msg.Ready_U = Mail) THEN
             TokenString[tokAreaName]:='E-mail'
          ELSE BEGIN
               TokenString[tokAreaName]:=Msg.NewsGroups_U;

               { RWI 950217: eventuele terminating #13 weghalen }
               IF (Msg.NewsGroups_U[Length (Msg.NewsGroups_U)] = #13) THEN
                  Delete (TokenString[tokAreaName],Length (TokenString[tokAreaName]),1);
          END;

          TokenString[tokSubject]:=Msg.Subj_U;

          { namen }
          TokenString[tokUserName]:=Trans_RfcHeader2FullName (Length ('FROM:'),Msg.FromUser_U);

          { Als er een spatie in de voornaam zit, dan splitst dit }
          { voor + achternaam.                                    }
          TokenString[tokFirstUserName]:=FirstName (TokenString[tokUserName]);
          TokenString[tokLastUserName]:=LastName (TokenString[tokUserName]);

          IF (Msg.FirstDest <> NIL) THEN
             TokenString[tokToUserName]:=Msg.FirstDest^.To_U
          ELSE
              TokenString[tokToUserName]:='??';

          { bericht info }
          TokenString[tokSubject]:=Msg.Subj_F;
          TokenString[tokPassword]:={newsfix pwd}''; { komt nog }
     END;

     { Globals }
     { Datum + Tijd }
     GetDate (Yea,Mon,Day,Dow);
     TokenString[tokDate]:=Word2String (Day)+' '+Month[Mon]+' '+Word2String (Yea);
     TokenString[tokWeekDay]:=Days[Dow];

     GetTime (Hou,Min,Sec,Hun);
     TokenString[tokTime]:=Word2String (Hou);
     IF (Min < 10) THEN
        TokenString[tokTime]:=TokenString[tokTime]+':0'+Word2String (Min)
     ELSE
         TokenString[tokTime]:=TokenString[tokTime]+':'+Word2String (Min);

     { Etc }
     TokenString[tokVersion]:=MainVersionNr;
     TokenString[tokPID]:=DesktopProgramName;
     TokenString[tokSysop]:=Config.Sysop;
     TokenString[tokSysopFirst]:=FirstName (Config.Sysop);
END;


{--------------------------------------------------------------------------}
{ AddFileToBody                                                            }
{                                                                          }
{ This routine tries to open the text file pointed to. If no directory is  }
{ given, the sub-directory TXTS under the system directory is tried.       }
{ The file is read, scanned for @Tokens (which are replaced) and added to  }
{ the body of the message.                                                 }
{                                                                          }
{ FALSE is returned of the file could not be opened.                       }
{                                                                          }
FUNCTION AddFileToBody (FileName : STRING) : BOOLEAN;

CONST REPLACER = #0;

VAR Textfile  : TEXT;
    Token,
    Regel     : STRING;
    IORes     : INTEGER;
    Found     : BOOLEAN;
    Tel_Token : TokenType;
    Tel_Char  : BYTE;

BEGIN
     { - Probeer de tekstfile te openen }
     { Gebruik niet de buffer routine, omdat die op hol slaat bij }
     { CR/LF combinaties.                                         }

     { if no path is present, take the TXTS directory under the system dir }
     IF (Pos ('\',FileName) = 0) THEN
        Filename:=Config.SystemDir+'TXTS\'+FileName;

     Assign (TextFile,FileName);
     {$I-} Reset (TextFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          { Textfiles zijn meestal optioneel }
          IF NOT (IORes IN [2,3]) THEN
             LogDiskIOError (IORes,'Error opening '+Filename);

          AddFileToBody:=FALSE;
          Exit;
     END;

     {$IFDEF LogFileIO}PostOpenT (TextFile);{$ENDIF}

     { read the file }
     WHILE (NOT Eof (Textfile)) DO
     BEGIN
          { lees een regel in uit de tekstfile }
          ReadLn (Textfile,Regel);

          { scannen op tokens }
          WHILE (Pos ('@',Regel) > 0) DO
          BEGIN
               Tel_Char:=Pos ('@',Regel);

               { probeer token uit de string te snijden }
               Token:=Copy (Regel,Tel_Char+1,Length (Regel));
               Token:=Copy (Token,1,Pos ('@',Token)-1);
               Regel[Pos ('@',Regel)]:=REPLACER; { Bugfix, anders oneindige lus }
               Token:=UpCaseString (Token);

               { En kijk welk teken we gaan vervangen  }
               FOR Tel_Token:=tokFirstUserName TO tokListName DO
                   IF (Token = TokenStr[Tel_Token]) THEN
                   BEGIN
                        Delete (Regel,Tel_Char,Length (Token)+2);
                        Insert (TokenString[Tel_Token],Regel,Tel_Char);
                        Break; { uit de for }
                   END;
          END; { while }

          { nu alle REPLACER tekens weer terug vervangen in @-tjes }
          WHILE (Pos (REPLACER,Regel) > 0) DO
                Regel[Pos (REPLACER,Regel)]:='@';

          MsgsAddLineTo (Body,Regel);
     END; { while not eof }

     {$IFDEF LogFileIO}PreCloseT (TextFile);{$ENDIF}
     Close (Textfile);

     IF Config.LogDebug THEN
        LogMessage (liTrivial,'Added '+Filename+' to message body');

     AddFileToBody:=TRUE; { done that }
END;


END.
