{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT Start;

{$I platform.inc}

{

 This unit contains all the code to start a

  - Scanning the message bases
  - Toss inbound fido archives / packets
  - Process received UUCP files
  - Process received BAG files
  - Process received SMTP files
  - Process received POP3 files
  - Process received SOUP files

  Which jobs to start is entered through a number of flags. The
  menu options start one of the jobs and the command line can
  start multiple of them.

}

{ History:

 RWI 960714: started this unit

}

INTERFACE

CONST WORK_FIDOSCAN = $0001; { max WORD! }
      WORK_FIDOTOSS = $0002;
      WORK_UUCPTOSS = $0004;
      WORK_BAGTOSS  = $0008;
      WORK_SMTPTOSS = $0010;
      WORK_POP3TOSS = $0020;
      WORK_SOUPTOSS = $0040;
      WORK_TOSSBAD  = $0080;
      WORK_NOTIFY   = $0100;

{ add new statistics counter for e-mail? }

TYPE INFO_Set = (                   { done? }
      INFO_UucpIn_Jobs,             { yes }
      INFO_UucpIn_Msgs,             { yes }
      INFO_UucpIn_Bytes,            { yes }
      INFO_UucpIn_Mail,             { yes }
      INFO_UucpIn_News,             { yes }

      INFO_SmtpIn_Jobs,             { yes }
      INFO_SmtpIn_Msgs,             { yes }
      INFO_SmtpIn_Bytes,            { yes }
      INFO_SmtpIn_Mail,             { yes }

      INFO_BagIn_Jobs,              { yes }
      INFO_BagIn_Msgs,              { yes }
      INFO_BagIn_Bytes,             { yes }
      INFO_BagIn_Mail,              { yes }
      INFO_BagIn_News,              { yes }

      INFO_Pop3In_Jobs,             { yes }
      INFO_Pop3In_Msgs,             { yes }
      INFO_Pop3In_Bytes,            { yes }
      INFO_Pop3In_Mail,             { yes }

      INFO_SoupIn_Jobs,             { yes }
      INFO_SoupIn_Msgs,             { yes }
      INFO_SoupIn_Bytes,            { yes }
      INFO_SoupIn_Mail,             { yes }
      INFO_SoupIn_News,             { yes }

      INFO_PktIn_Jobs,              { yes }
      INFO_PktIn_Msgs,              { yes }
      INFO_PktIn_Bytes,             { yes }
      INFO_PktIn_Net,               { yes }
      INFO_PktIn_Echo,              { yes }

      INFO_MsgScan_Msgs,            { yes }
      INFO_MsgScan_Bytes,           { yes }
      INFO_MsgScan_Net,             { yes }
      INFO_MsgScan_Echo,            { yes }

      INFO_JamScan_Msgs,            { yes }
      INFO_JamScan_Bytes,           { yes }
      INFO_JamScan_Net,             { yes }
      INFO_JamScan_Echo,            { yes }

      INFO_SquishScan_Msgs,         { yes }
      INFO_SquishScan_Bytes,        { yes }
      INFO_SquishScan_Net,          { yes }
      INFO_SquishScan_Echo,         { yes }

      INFO_UucpOut_Jobs,            { yes }
      INFO_UucpOut_Msgs,            { yes }
      INFO_UucpOut_Bytes,           { yes }
      INFO_UucpOut_Mail,            { yes (1 per mail, not recipient) }
      INFO_UucpOut_News,            { yes }

      INFO_SmtpOut_Jobs,            { yes (jobs=msgs=mail) }
      INFO_SmtpOut_Msgs,            { yes }
      INFO_SmtpOut_Bytes,           { yes }
      INFO_SmtpOut_Mail,            { yes }

      INFO_SoupOut_Jobs,            { yes }
      INFO_SoupOut_Msgs,            { yes }
      INFO_SoupOut_Bytes,           { yes }
      INFO_SoupOut_Mail,            { yes }
      INFO_SoupOut_News,            { yes }

      INFO_INetMailOut_Jobs,        { no }
      INFO_INetMailOut_Msgs,        { no }
      INFO_INetMailOut_Bytes,       { no }
      INFO_INetMailOut_Mail,        { no }

      INFO_PktOut_Jobs,             { yes }
      INFO_PktOut_Msgs,             { yes }
      INFO_PktOut_Bytes,            { yes }
      INFO_PktOut_Net,              { yes }
      INFO_PktOut_Echo,             { yes }

      INFO_MsgSave_Msgs,            { yes }
      INFO_MsgSave_Bytes,           { yes }
      INFO_MsgSave_Net,             { yes }
      INFO_MsgSave_Echo,            { yes }

      INFO_JamSave_Msgs,            { yes }
      INFO_JamSave_Bytes,           { yes }
      INFO_JamSave_Net,             { yes }
      INFO_JamSave_Echo,            { yes }

      INFO_SquishSave_Msgs,         { yes }
      INFO_SquishSave_Bytes,        { yes }
      INFO_SquishSave_Net,          { yes }
      INFO_SquishSave_Echo,         { yes }

      INFO_DupBad_Msgs,             { yes }
      INFO_DupBad_Bytes,            { yes }
      INFO_DupBad_Net,              { yes }
      INFO_DupBad_Echo              { yes }
      );

PROCEDURE UpdateAction (Action : STRING);
PROCEDURE UpdateReadFile (Name : STRING; Size : LONGINT);
PROCEDURE UpdateWriteFile (Name : STRING; Size : LONGINT);
PROCEDURE UpdateInfoNr (InfoFlag : INFO_Set; Number : LONGINT);
FUNCTION  RetrieveInfoNr (InfoFlag : INFO_Set): LONGINT;

PROCEDURE ScanForFileAttaches;
PROCEDURE StartWork (WorkToDo : WORD; WaitKey : BOOLEAN);
FUNCTION  CheckMinDiskFree : BOOLEAN;

VAR Start_CountDupBad : BOOLEAN;


IMPLEMENTATION

USES Ramon,
     Dos,
     Crt,
     Globals,
     Logs,
     DupeChk,
     Fido,
     Scan,
     Cfg,
     Database,
     AreaBase,
     Msgs,
     FidoMsg,
     AreaMgr,
     Outbound,
     Squish,
     Jam,
     MsgUtil,
     Smtp,
     {$IFDEF PLATFORM_OS2}
     Os2Base,   { dosbeep }
     {$ENDIF}
     ListSrv,
     Uucp,
     Pop3,
     FidoPack,
     SeenBy,
     FD,
     NewStats,
     UnixTime,
     Soup;

(* col:    1    2     3     4   5               6    7     8     9    10
   01234567890123456789012345678      01234567890123456789012345678901
01        Jobs Msgs Bytes  Net  Echo            Jobs Msgs Bytes  Net  Echo 13
02 PKT    ...0 ...0 ....0 ...0 ....0  PKT       ...0 ...0 ....0 ...0 ....0 14
03 MSG         ...0 ....0 ...0 ....0  MSG            ...0 ....0 ...0 ....0 15
04 JAM         ...0 ....0 ...0 ....0  JAM            ...0 ....0 ...0 ....0 16
05 Squish      ...0 ....0 ...0 ....0  Squish         ...0 ....0 ...0 ....0 17
06                                    Dup/Bad        ...0 ....0 ...0 ....0 18
07        Jobs Msgs Bytes Mail  News            Jobs Msgs Bytes Mail  News 19
08 UUCP   ...0 ...0 ....0 ...0 ....0  UUCP      ...0 ...0 ....0 ...0 ....0 20
09 SMTP   ...0 ...0 ....0 ...0        SMTP      ...0 ...0 ....0 ...0       21
10 SOUP   ...0 ...0 ....0 ...0 ....0  SOUP      ...0 ...0 ....0 ...0 ....0 22
11 POP3   ...0 ...0 ....0 ...0        INet.Mail ...0 ...0 ....0 ...0       23
12 BAG    ...0 ...0 ....0 ...0 ....0                                       24
*)

CONST ColNr2XOffset : ARRAY[1..10] OF BYTE = ( 7,12,17,23,28,
                                              10,15,20,26,31);

CONST ColWidth : ARRAY[1..10] OF BYTE = (4,4,5,4,5,
                                         4,4,5,4,5);

CONST InfoSet2GroupNr : ARRAY[INFO_Set] OF BYTE =
      (
       8,8,8,8,8,      { UUCP in: 5 }
       9,9,9,9,        { SMTP in: 4 }
       12,12,12,12,12, { BAG in:  5 }
       11,11,11,11,    { POP3 in: 4 }
       10,10,10,10,10, { SOUP in: 5 }
       2,2,2,2,2,      { PKT in: 5 }
       3,3,3,3,        { MSG scan: 4 }
       4,4,4,4,        { JAM scan: 4 }
       5,5,5,5,        { Squish scan: 4 }

       20,20,20,20,20, { UUCP out: 5 }
       21,21,21,21,    { SMTP out: 4 }
       22,22,22,22,22, { SOUP out: 5 }
       23,23,23,23,    { INet.Mail out: 4 }
       14,14,14,14,14, { PKT out: 5 }
       15,15,15,15,    { MSG import: 4 }
       16,16,16,16,    { JAM import: 4 }
       17,17,17,17,    { Squish import: 4 }
       18,18,18,18     { DupBad import: 4 }
      );

      InfoSet2Col : ARRAY[INFO_Set] OF BYTE =
      (
       1,2,3,4,5,      { UUCP in: 5 }
       1,2,3,4,        { SMTP in: 4 }
       1,2,3,4,5,      { BAG in:  5 }
       1,2,3,4,        { POP3 in: 4 }
       1,2,3,4,5,      { SOUP in: 5 }
       1,2,3,4,5,      { PKT in: 5 }
         2,3,4,5,      { MSG scan: 4 }
         2,3,4,5,      { JAM scan: 4 }
         2,3,4,5,      { Squish scan: 4 }

       6,7,8,9,10,     { UUCP out: 5 }
       6,7,8,9,        { SMTP out: 4 }
       6,7,8,9,10,     { SOUP out: 5 }
       6,7,8,9,        { INet.Mail out: 4 }
       6,7,8,9,10,     { PKT out: 5 }
         7,8,9,10,     { MSG import: 4 }
         7,8,9,10,     { JAM import: 4 }
         7,8,9,10,     { Squish import: 4 }
         7,8,9,10      { DupBad import: 4 }
      );

CONST INFOSET_GROUPS = 23;
      FIRST_COL2_GROUP = 13;  { >= 13 is columns 2 }

CONST Xb = 3;
      Yb = 2;
      Xl = 75;
      Xn = 58;         { max len descr. text }
      Xw1 = 34;        { column 1 width }
      Xw2 = 37;        { column 2 width }
      Xc1 = Xb+2;      { column 1 X }
      Xc2 = Xc1+Xw1+1; { column 2 X }
(*
      ProgressX : ARRAY[INFO_Set] OF XYType = (
        { Input: }     { Jobs ,Msgs ,Bytes,Mail ,News }
                { UUCP } Xb+10,Xb+15,Xb+20,Xb+28,Xb+33,
                { SMTP } Xb+10,Xb+15,Xb+20,Xb+28,
                 { BAG } Xb+10,Xb+15,Xb+20,Xb+28,Xb+33,
                { POP3 } Xb+10,Xb+15,Xb+20,Xb+28,
                { SOUP } Xb+10,Xb+15,Xb+20,Xb+28,Xb+33,
                 { PKT } Xb+10,Xb+15,Xb+20,Xb+28,Xb+33,
                 { MSG }       Xb+15,Xb+20,Xb+28,Xb+33,
                 { JAM }       Xb+15,Xb+20,Xb+28,Xb+33,
              { Squish }       Xb+15,Xb+20,Xb+28,Xb+33,

        { Output: }    { Jobs ,Msgs ,Bytes,Mail ,News }
                { UUCP } Xb+47,Xb+52,Xb+57,Xb+65,Xb+70,
                { SMTP } Xb+47,Xb+52,Xb+57,Xb+65,
                { SOUP } Xb+47,Xb+52,Xb+57,Xb+65,Xb+70,
                 { PKT } Xb+47,Xb+52,Xb+57,Xb+65,Xb+70,
                 { MSG }       Xb+52,Xb+57,Xb+65,Xb+70,
                 { JAM }       Xb+52,Xb+57,Xb+65,Xb+70,
              { Squish }       Xb+52,Xb+57,Xb+65,Xb+70,
             { Dup/Bad }       Xb+52,Xb+57,Xb+65,Xb+70
                                              );

      ProgressY : ARRAY[Info_Set] OF XYType = (
        { Input: }     { Jobs ,Msgs ,Bytes,Mail ,News }
                { UUCP } Yb+5 ,Yb+5 ,Yb+5 ,Yb+5 ,Yb+5,
                { SMTP } Yb+6 ,Yb+6 ,Yb+6 ,Yb+6 ,
                 { BAG } Yb+7 ,Yb+7 ,Yb+7 ,Yb+7 ,Yb+7,
                { POP3 } Yb+8 ,Yb+8 ,Yb+8 ,Yb+8 ,
                { SOUP } Yb+9 ,Yb+9 ,Yb+9 ,Yb+9 ,Yb+9,
                 { PKT } Yb+11,Yb+11,Yb+11,Yb+11,Yb+11,
                 { MSG }       Yb+12,Yb+12,Yb+12,Yb+12,
                 { JAM }       Yb+13,Yb+13,Yb+13,Yb+13,
              { Squish }       Yb+14,Yb+14,Yb+14,Yb+14,

        { Output: }    { Jobs ,Msgs ,Bytes,Mail ,News }
                { UUCP } Yb+5 ,Yb+5 ,Yb+5 ,Yb+5 ,Yb+5,
                { SMTP } Yb+6 ,Yb+6 ,Yb+6 ,Yb+6 ,
                { SOUP } Yb+7 ,Yb+7 ,Yb+7 ,Yb+7 ,Yb+7,
                 { PKT } Yb+11,Yb+11,Yb+11,Yb+11,Yb+11,
                 { MSG }       Yb+12,Yb+12,Yb+12,Yb+12,
                 { JAM }       Yb+13,Yb+13,Yb+13,Yb+13,
              { Squish }       Yb+14,Yb+14,Yb+14,Yb+14,
             { Dup/Bad }       Yb+10,Yb+10,Yb+10,Yb+10
                                              );
*)
VAR ProgressCounts               : ARRAY[INFO_Set] OF LONGINT;
    Start_ScannedForFileAttaches : BOOLEAN;
    GroupNr2Y                    : ARRAY[1..INFOSET_GROUPS] OF BYTE;
    GroupVisible                 : ARRAY[1..INFOSET_GROUPS] OF BOOLEAN;
    ProgressLines                : XYType;


{--------------------------------------------------------------------------}
{ UpdateAction                                                             }
{                                                                          }
PROCEDURE UpdateAction (Action : STRING);
BEGIN
{$IFDEF WtrGate}
     IF (StayQuiet OR NoFullScreen) THEN
        Exit;

     WriteXYC (Xb+16,Yb+1,cBoxData,AddUpWithSpaces (Xn,Action));

     { wis ook de file }
     IF (Action = '') THEN
     BEGIN
          WriteXYC (Xb+16,Yb+2,cBoxData,Spaces (Xn));
          WriteXYC (Xb+16,Yb+3,cBoxData,Spaces (Xn));
     END;
{$ENDIF}
END;


{--------------------------------------------------------------------------}
{ UpdateReadFile                                                           }
{                                                                          }
PROCEDURE UpdateReadFile (Name : STRING; Size : LONGINT);
BEGIN
     IF (StayQuiet OR NoFullScreen) THEN
        Exit;

{$IFDEF WtrGate}
     IF (Size > 0) THEN
        Name:=Name+' ('+Longint2String (Size)+')';

     WriteXYC (Xb+16,Yb+2,cBoxData,AddUpWithSpaces (Xn,Name));
{$ENDIF}
END;


{--------------------------------------------------------------------------}
{ UpdateWriteFile                                                          }
{                                                                          }
PROCEDURE UpdateWriteFile (Name : STRING; Size : LONGINT);
BEGIN
{$IFDEF WtrGate}
     IF (StayQuiet OR NoFullScreen) THEN
        Exit;

     IF (Size > 0) THEN
        Name:=Name+' ('+Longint2String (Size)+')';

     WriteXYC (Xb+16,Yb+3,cBoxData,AddUpWithSpaces (Xn,Name));
{$ENDIF}
END;


{## move to ramon if we want to keep it}
{--------------------------------------------------------------------------}
{ Longint2KiloMegString                                                    }
{                                                                          }
{ This routine formats a large number using k and M, depending on how      }
{ large it is and how much space is available to print the number.         }
{                                                                          }
FUNCTION Longint2KiloMegString (MaxW : BYTE; N : LONGINT) : STRING;

VAR S : STRING[20];
    R : LONGINT;
    C : CHAR;

BEGIN
     S:=Longint2String (N);

     IF (Length (S) > MaxW) THEN
     BEGIN
          { too long; try with kilo }
          R:=N MOD 1024;
          N:=N DIV 1024;
          C:='k';
          S:=Longint2String (N);

          IF (Length (S)+1{k} > MaxW) THEN
          BEGIN
               { too large; use Mega }
               R:=N MOD 1024;
               N:=N DIV 1024;
               C:='M';
               S:=Longint2String (N);
          END;

          { if there is space, add decimals }
          { convert 1024th parts to 100th parts        }
          { this avoids 1.1023 and gives 1.99 instead. }
          IF (MaxW-Length (S) >= 3) THEN
             S:=S+'.'+AddUpWithPre0s (2,Longint2String ((R*100) DIV 1024));

          S:=Copy (S,1,MaxW-1)+C;
     END;

     Longint2KiloMegString:=AddUpWithPreSpaces (MaxW,S);
END;


{--------------------------------------------------------------------------}
{ PrintProgressCount                                                       }
{                                                                          }
{ This routine prints one of the InfoFlag values at the correct position   }
{ on the screen.                                                           }
{                                                                          }
PROCEDURE PrintProgressCount (GroupNr : BYTE; InfoFlag : INFO_Set);

VAR X,Y   : BYTE;
    ColNr : BYTE;
    Hulp  : STRING[10];

BEGIN
     ColNr:=InfoSet2Col[InfoFlag];
     Y:=GroupNr2Y[GroupNr];
     X:=ColNr2XOffset[ColNr];

     IF (GroupNr >= FIRST_COL2_GROUP) THEN
        X:=X+Xc2
     ELSE
         X:=X+Xc1;

     WriteXYC (X,Y,cBoxData,Longint2KiloMegString (ColWidth[ColNr],ProgressCounts[InfoFlag]));
END;


{--------------------------------------------------------------------------}
{ PrintGroup                                                               }
{                                                                          }
{ This routine prints a complete group, which is 4 or 5 information fields }
{ plus the header in one of the columns of one of the rows.                }
{                                                                          }
PROCEDURE PrintGroup (GroupNr : BYTE);

VAR Y  : BYTE;
    S  : STRING[50];
    Lp : INFO_Set;

BEGIN
     SetColor (cBoxBack);

     Y:=GroupNr2Y[GroupNr];

     IF (GroupNr < FIRST_COL2_GROUP) THEN
     BEGIN
          S:='?';

          CASE GroupNr OF
               01 : S:='       Jobs Msgs Bytes  Net  Echo';
               02 : S:='PKT';
               03 : S:='MSG';
               04 : S:='JAM';
               05 : S:='Squish';
               06 : S:=''; { empty }
               07 : S:='       Jobs Msgs Bytes Mail  News';
               08 : S:='UUCP';
               09 : S:='SMTP';
               10 : S:='SOUP';
               11 : S:='POP3';
               12 : S:='BAG';
          END; { case }

          WriteXY (Xc1,Y,AddUpWithSpaces (Xw1,S));
     END ELSE
     BEGIN
          S:='?';

          CASE GroupNr OF
               13 : S:='          Jobs Msgs Bytes  Net  Echo';
               14 : S:='PKT';
               15 : S:='MSG';
               16 : S:='JAM';
               17 : S:='Squish';
               18 : S:='Dup/Bad';
               19 : S:='          Jobs Msgs Bytes Mail  News';
               20 : S:='UUCP';
               21 : S:='SMTP';
               22 : S:='SOUP';
               23 : S:='INet.Mail';
          END; { case }

          WriteXY (Xc2,Y,AddUpWithSpaces (Xw2,S));
     END; { if }

     { print the numbers }
     FOR Lp:=INFO_UucpIn_Jobs TO INFO_DupBad_Echo DO
         IF (InfoSet2GroupNr[Lp] = GroupNr) THEN
            PrintProgressCount (GroupNr,Lp);
END;


{--------------------------------------------------------------------------}
{ MakeGroupVisible                                                         }
{                                                                          }
{ This routine configures and if required resizes the statistics window so }
{ the wanted group of information (a row in a column) becomes visible.     }
{                                                                          }
PROCEDURE MakeGroupVisible (GroupNr : BYTE);

VAR Lp        : BYTE;
    Col1Lines,
    Col2Lines : BYTE;
    Y         : BYTE;

BEGIN
     { enable this group }
     GroupVisible[GroupNr]:=TRUE;

     { enable titles where needed }
     IF (GroupNr IN [2..5]) THEN
        GroupVisible[1]:=TRUE;

     IF (GroupNr IN [8..12]) THEN
        GroupVisible[7]:=TRUE;

     IF (GroupNr IN [14..18]) THEN
        GroupVisible[13]:=TRUE;

     IF (GroupNr IN [20..23]) THEN
        GroupVisible[19]:=TRUE;

     { calculate how many lines each row needs }
     { renuming the Y coordinates for each group at the same time }
     Col1Lines:=3;
     Col2Lines:=3;

     FOR Lp:=1 TO 12 DO
         IF (GroupVisible[Lp]) THEN
         BEGIN
              Inc (Col1Lines);
              GroupNr2Y[Lp]:=Yb+Col1Lines;
         END;

     FOR Lp:=13 TO 23 DO
         IF (GroupVisible[Lp]) THEN
         BEGIN
              Inc (Col2Lines);
              GroupNr2Y[Lp]:=Yb+Col2Lines;
         END;

     IF (Col1Lines < Col2Lines) THEN
        Col1Lines:=Col2Lines;

     { check if we have to update the window }
     IF (Col1Lines+2 > ProgressLines) THEN
     BEGIN
          Log_SetWindowSize (Video.Rows-(Col1Lines+2)-5);

          { re-paint the box }
          BoxDrawOuter (Double,Xb,Yb,Xl,Col1Lines+2);

          { make sure the new lines do not contain garbage }
          REPEAT
                WriteXY (Xb+1,Yb+ProgressLines-1,Spaces (Xl-2));
                Inc (ProgressLines);
          UNTIL (ProgressLines = Col1Lines+2);

          WriteXY (Xb+18,Yb+ProgressLines-1,'[IN]');
          WriteXY (Xb+Xw1+18,Yb+ProgressLines-1,'[OUT]');
     END;

     { now redraw all rows. We might not have resized the window  }
     { because the other column was longer, but we need to redraw }
     { all rows anyway in case we inserted a row.                 }
     FOR Lp:=1 TO INFOSET_GROUPS DO
         IF (GroupVisible[Lp]) THEN
            PrintGroup (Lp);
END;


{--------------------------------------------------------------------------}
{ UpdateInfoNr                                                             }
{                                                                          }
{ Deze routine wordt overal vandaan aangeroepen om informatie op het       }
{ voortgangs scherm te zetten.                                             }
{                                                                          }
PROCEDURE UpdateInfoNr (InfoFlag : INFO_Set; Number : LONGINT);

VAR GroupNr : BYTE;

BEGIN
{$IFDEF WtrGate}
     IF Start_CountDupBad THEN
     BEGIN
          { Overwrite MSG/JAM/Squish with DupBad }
          IF (InfoFlag IN [INFO_MsgSave_Msgs,INFO_JamSave_Msgs,INFO_SquishSave_Msgs]) THEN
             InfoFlag:=INFO_DupBad_Msgs;

          IF (InfoFlag IN [INFO_MsgSave_Bytes,INFO_JamSave_Bytes,INFO_SquishSave_Bytes]) THEN
             InfoFlag:=INFO_DupBad_Bytes;

          IF (InfoFlag IN [INFO_MsgSave_Net,INFO_JamSave_Net,INFO_SquishSave_Net]) THEN
             InfoFlag:=INFO_DupBad_Net;

          IF (InfoFlag IN [INFO_MsgSave_Echo,INFO_JamSave_Echo,INFO_SquishSave_Echo]) THEN
             InfoFlag:=INFO_DupBad_Echo;
     END;

     Inc (ProgressCounts[InfoFlag],Number);

     IF (NOT (StayQuiet OR NoFullScreen)) THEN
     BEGIN
          GroupNr:=InfoSet2GroupNr[InfoFlag];

          IF (NOT GroupVisible[GroupNr]) THEN
             MakeGroupVisible (GroupNr)
          ELSE
              PrintProgressCount (GroupNr,InfoFlag);
     END;
{$ENDIF}
END;


{--------------------------------------------------------------------------}
{ RetrieveInfoNr                                                           }
{                                                                          }
{ Retrieves the specified counter value.  (Used primarily by statistics)   }
{                                                                          }
FUNCTION RetrieveInfoNr (InfoFlag : INFO_Set): LONGINT;
BEGIN
     RetrieveInfoNr := ProgressCounts [InfoFlag];
END;


{--------------------------------------------------------------------------}
{ DrawInfoScreen                                                           }
{                                                                          }
{ Deze routine tekent het informatie scherm voor de huidige actie die      }
{ bezig is zoals scan, toss, pack, etc.                                    }
{                                                                          }
PROCEDURE DrawInfoScreen;

VAR Lp : INFO_Set;

BEGIN
     ProgressLines:=5;
     Log_SetWindowSize (Video.Rows-ProgressLines-5);

     BoxDraw (Double,Xb,Yb,Xl,ProgressLines);

     WriteXY (Xb+27,Yb,'[Progress Monitor]');

     WriteXY (Xb+1,Yb+1,' Current task: ');
     WriteXY (Xb+1,Yb+2,' Reading file: ');
     WriteXY (Xb+1,Yb+3,' Writing file: ');

     (*
   +============================= Progress Monitor ===========================+
+1 | Current task:                                                            |
 2 | Reading file:                                                            |
 3 | Writing file:                                                            |
 4 |         Jobs Msgs Bytes   Mail News          Jobs Msgs Bytes   Mail News |
 5 | UUCP    0    0    0       0    0     UUCP    0    0    0       0    0    |
 6 | SMTP    0    0    0       0          SMTP    0    0    0       0         |
 7 | BAG     0    0    0       0    0     SOUP    0    0    0       0    0    |
 8 | POP3    0    0    0       0                                              |
 9 | SOUP    0    0    0       0    0                  Msgs Bytes   Net  Echo |
10 |              Msgs Bytes   Net  Echo  Dup/Bad      0    0       0    0    |
11 | PKT     0    0    0       0    0     PKT     0    0    0       0    0    |
12 | MSG          0    0       0    0     MSG          0    0       0    0    |
13 | JAM          0    0       0    0     JAM          0    0       0    0    |
14 | Squish       0    0       0    0     Squish       0    0       0    0    |
   +================ IN ================================= OUT ================+
     +2      +10  +15  +20     +28  +33   +39     +47  +52  +57     +65  +70
     *)

     (*
     WriteXY (Xb+10,Yb+4,'Jobs Msgs Bytes   Mail News');

     WriteXY (Xb+2,Yb+5,'UUCP');
     WriteXY (Xb+2,Yb+6,'SMTP');
     WriteXY (Xb+2,Yb+7,'BAG');
     WriteXY (Xb+2,Yb+8,'POP3');
     WriteXY (Xb+2,Yb+9,'SOUP');

     WriteXY (Xb+15,Yb+10,'Msgs Bytes   Net  Echo');

     WriteXY (Xb+2,Yb+11,'PKT');
     WriteXY (Xb+2,Yb+12,'MSG');
     WriteXY (Xb+2,Yb+13,'JAM');
     WriteXY (Xb+2,Yb+14,'Squish');

     WriteXY (Xb+18,Yb+15,'[IN]');

     WriteXY (Xb+47,Yb+4,'Jobs Msgs Bytes   Mail News');

     WriteXY (Xb+39,Yb+5,'UUCP');
     WriteXY (Xb+39,Yb+6,'SMTP');
     WriteXY (Xb+39,Yb+7,'SOUP');

     WriteXY (Xb+52,Yb+9,'Msgs Bytes   Net  Echo');

     WriteXY (Xb+39,Yb+10 ,'Dup/Bad');
     WriteXY (Xb+39,Yb+11,'PKT');
     WriteXY (Xb+39,Yb+12,'MSG');
     WriteXY (Xb+39,Yb+13,'JAM');
     WriteXY (Xb+39,Yb+14,'Squish');

     WriteXY (Xb+55,Yb+15,'[OUT]');
     *)
END;


{--------------------------------------------------------------------------}
{ SetFlagFile                                                              }
{                                                                          }
{ Deze routine creert een 0-byte flag file zoals FDRESCAN.NOW.             }
{                                                                          }
PROCEDURE SetFlagFile (Path : STRING);

VAR FlagFile : FILE;
    IORes    : BYTE;

BEGIN
     Path:=DeleteFrontAndBackSpaces (Path);
     IF (Path = '') THEN
        Exit;

     Assign (FlagFile,Path);
     {$I-} ReWrite (FlagFile,0); {$I+} IORes:=IOResult;

     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'Cannot create rescan flag file '+Path)
     ELSE BEGIN
          {$IFDEF LogFileIO}PostOpenF (FlagFile);{$ENDIF}
          {$IFDEF LogFileIO}PreCloseF (FlagFile);{$ENDIF}
          {$I-} Close (FlagFile); {$I+}
          IORes:=IOResult;
     END;
END;


{--------------------------------------------------------------------------}
{ WriteInfoToLogfile                                                       }
{                                                                          }
{ Deze routine schrijft een overzicht van alle INFO nummers naar de        }
{ logfile.                                                                 }
{                                                                          }
PROCEDURE WriteInfoToLogfile;

    PROCEDURE Write4 (Title : STRING; M,B,E,N : INFO_Set);
    BEGIN
         IF (ProgressCounts[M] > 0) THEN
            LogExtraMessage ('  '+Title+': '+
                             Longint2String (ProgressCounts[M])+' msgs/'+
                             Longint2String (ProgressCounts[B])+' bytes ('+
                             Longint2String (ProgressCounts[E])+' net, '+
                             Longint2String (ProgressCounts[N])+' echo)');
    END;

VAR NoInput,
    NoOutput : BOOLEAN;

BEGIN
     NoInput:=(ProgressCounts[INFO_UucpIn_Jobs] = 0) AND
              (ProgressCounts[INFO_SmtpIn_Jobs] = 0) AND
              (ProgressCounts[INFO_BagIn_Jobs] = 0) AND
              (ProgressCounts[INFO_Pop3In_Jobs] = 0) AND
              (ProgressCounts[INFO_SoupIn_Jobs] = 0) AND
              (ProgressCounts[INFO_PktIn_Jobs] = 0) AND
              (ProgressCounts[INFO_MsgScan_Bytes] = 0) AND
              (ProgressCounts[INFO_JamScan_Bytes] = 0) AND
              (ProgressCounts[INFO_SquishScan_Msgs] = 0);

     NoOutput:=(ProgressCounts[INFO_UucpOut_Jobs] = 0) AND
               (ProgressCounts[INFO_SmtpOut_Jobs] = 0) AND
               (ProgressCounts[INFO_SoupOut_Jobs] = 0) AND
               (ProgressCounts[INFO_PktOut_Bytes] = 0) AND
               (ProgressCounts[INFO_MsgSave_Bytes] = 0) AND
               (ProgressCounts[INFO_JamSave_Bytes] = 0) AND
               (ProgressCounts[INFO_SquishSave_Msgs] = 0) AND
               (ProgressCounts[INFO_DupBad_Bytes] = 0);

     IF NoInput AND NoOutput THEN
     BEGIN
          LogMessage (liStats,'Totals of this run: no input or output');
          Exit;
     END;

     IF NoInput THEN
        LogExtraMessage ('Input: nothing')
     ELSE
         LogExtraMessage ('Input:');

     IF (ProgressCounts[INFO_UucpIn_Jobs] > 0) THEN
        LogExtraMessage ('  UUCP: '+Longint2String (ProgressCounts[INFO_UucpIn_Jobs])+' jobs/'+
                                    Longint2String (ProgressCounts[INFO_UucpIn_Bytes])+' bytes/'+
                                    Longint2String (ProgressCounts[INFO_UucpIn_Msgs])+' msgs ('+
                                    Longint2String (ProgressCounts[INFO_UucpIn_Mail])+' mail, '+
                                    Longint2String (ProgressCounts[INFO_UucpIn_News])+' news)');

     IF (ProgressCounts[INFO_SmtpIn_Jobs] > 0) THEN
        LogExtraMessage ('  SMTP: '+Longint2String (ProgressCounts[INFO_SmtpIn_Jobs])+' jobs/'+
                                    Longint2String (ProgressCounts[INFO_SmtpIn_Bytes])+' bytes/'+
                                    Longint2String (ProgressCounts[INFO_SmtpIn_Msgs])+' mail msgs');

     IF (ProgressCounts[INFO_BagIn_Jobs] > 0) THEN
        LogExtraMessage ('  BAG: '+Longint2String (ProgressCounts[INFO_BagIn_Jobs])+' jobs/'+
                                   Longint2String (ProgressCounts[INFO_BagIn_Bytes])+' bytes/'+
                                   Longint2String (ProgressCounts[INFO_BagIn_Msgs])+' msgs ('+
                                   Longint2String (ProgressCounts[INFO_BagIn_Mail])+' mail, '+
                                   Longint2String (ProgressCounts[INFO_BagIn_News])+' news)');

     IF (ProgressCounts[INFO_SoupIn_Jobs] > 0) THEN
        LogExtraMessage ('  SOUP: '+Longint2String (ProgressCounts[INFO_SoupIn_Jobs])+' jobs/'+
                                   Longint2String (ProgressCounts[INFO_SoupIn_Bytes])+' bytes/'+
                                   Longint2String (ProgressCounts[INFO_SoupIn_Msgs])+' msgs ('+
                                   Longint2String (ProgressCounts[INFO_SoupIn_Mail])+' mail, '+
                                   Longint2String (ProgressCounts[INFO_SoupIn_News])+' news)');

     IF (ProgressCounts[INFO_Pop3In_Jobs] > 0) THEN
        LogExtraMessage ('  POP3: '+Longint2String (ProgressCounts[INFO_Pop3In_Jobs])+' jobs/'+
                                    Longint2String (ProgressCounts[INFO_Pop3In_Bytes])+' bytes/'+
                                    Longint2String (ProgressCounts[INFO_Pop3In_Msgs])+' mail msgs');

     IF (ProgressCounts[INFO_PktIn_Jobs] > 0) THEN
        LogExtraMessage ('  PKT: '+Longint2String (ProgressCounts[INFO_PktIn_Jobs])+' packets/'+
                                   Longint2String (ProgressCounts[INFO_PktIn_Bytes])+' bytes/'+
                                   Longint2String (ProgressCounts[INFO_PktIn_Msgs])+' msgs ('+
                                   Longint2String (ProgressCounts[INFO_PktIn_Net])+' netmail, '+
                                   Longint2String (ProgressCounts[INFO_PktIn_Echo])+' echomail)');

     Write4 ('MSG',INFO_MsgScan_Msgs,INFO_MsgScan_Bytes,INFO_MsgScan_Net,INFO_MsgScan_Echo);
     Write4 ('JAM',INFO_JamScan_Msgs,INFO_JamScan_Bytes,INFO_JamScan_Net,INFO_JamScan_Echo);
     Write4 ('Squish',INFO_SquishScan_Msgs,INFO_SquishScan_Bytes,INFO_SquishScan_Net,INFO_SquishScan_Echo);

     IF NoOutput THEN
        LogExtraMessage ('Output: nothing')
     ELSE
         LogExtraMessage ('Output:');

     IF (ProgressCounts[INFO_UucpOut_Jobs] > 0) THEN
        LogExtraMessage ('  UUCP: '+Longint2String (ProgressCounts[INFO_UucpOut_Jobs])+' jobs/'+
                                    Longint2String (ProgressCounts[INFO_UucpOut_Bytes])+' bytes/'+
                                    Longint2String (ProgressCounts[INFO_UucpOut_Msgs])+' msgs ('+
                                    Longint2String (ProgressCounts[INFO_UucpOut_Mail])+' mail, '+
                                    Longint2String (ProgressCounts[INFO_UucpOut_News])+' news)');

     IF (ProgressCounts[INFO_SmtpOut_Jobs] > 0) THEN
        LogExtraMessage ('  SMTP: '+Longint2String (ProgressCounts[INFO_SmtpOut_Jobs])+' jobs/'+
                                    Longint2String (ProgressCounts[INFO_SmtpOut_Bytes])+' bytes/'+
                                    Longint2String (ProgressCounts[INFO_SmtpOut_Msgs])+' mail msgs');

     IF (ProgressCounts[INFO_SoupOut_Jobs] > 0) THEN
        LogExtraMessage ('  SOUP: '+Longint2String (ProgressCounts[INFO_SoupOut_Jobs])+' jobs/'+
                                   Longint2String (ProgressCounts[INFO_SoupOut_Bytes])+' bytes/'+
                                   Longint2String (ProgressCounts[INFO_SoupOut_Msgs])+' msgs ('+
                                   Longint2String (ProgressCounts[INFO_SoupOut_Mail])+' mail, '+
                                   Longint2String (ProgressCounts[INFO_SoupOut_News])+' news)');

     IF (ProgressCounts[INFO_PktOut_Jobs] > 0) THEN
        LogExtraMessage ('  PKT: '+Longint2String (ProgressCounts[INFO_PktOut_Jobs])+' packets/'+
                                   Longint2String (ProgressCounts[INFO_PktOut_Bytes])+' bytes/'+
                                   Longint2String (ProgressCounts[INFO_PktOut_Msgs])+' msgs ('+
                                   Longint2String (ProgressCounts[INFO_PktOut_Net])+' netmail, '+
                                   Longint2String (ProgressCounts[INFO_PktOut_Echo])+' echomail)');

     Write4 ('MSG',INFO_MsgSave_Msgs,INFO_MsgSave_Bytes,INFO_MsgSave_Net,INFO_MsgSave_Echo);
     Write4 ('JAM',INFO_JamSave_Msgs,INFO_JamSave_Bytes,INFO_JamSave_Net,INFO_JamSave_Echo);
     Write4 ('Squish',INFO_SquishSave_Msgs,INFO_SquishSave_Bytes,INFO_SquishSave_Net,INFO_SquishSave_Echo);
     Write4 ('Dup/Bad',INFO_DupBad_Msgs,INFO_DupBad_Bytes,INFO_DupBad_Net,INFO_DupBad_Echo);
END;


{--------------------------------------------------------------------------}
{ ScanForFileAttaches                                                      }
{                                                                          }
PROCEDURE ScanForFileAttaches;

CONST Report = 'Scanning for ARCmail messages';

BEGIN
     IF (Config.FidoSystem = stFrontdoor) AND
        (Config.FidoNetmailType = FidoMsgType) AND  {## does not support JAM or Squish (need to?)}
        (NOT Start_ScannedForFileAttaches) THEN
     BEGIN
          Start_ScannedForFileAttaches:=TRUE;

          UpdateAction (Report);
          LogMessage (liTrivial,Report);

          { Zorg ervoor dat voor Frontdoor systemen nu ook de lijst met }
          { nodes in het geheugen word gebouwdt waarvoor al een attach  }
          { file bestaat.                                               }

          FidoMsg_ArcmailScan;

          UpdateAction ('');
     END;
END;


{--------------------------------------------------------------------------}
{ StartWork                                                                }
{                                                                          }
{ This is the big routine that starts the toss, scan, pack and more work.  }
{                                                                          }
PROCEDURE StartWork (WorkToDo : WORD; WaitKey : BOOLEAN);

VAR Orig_WorkToDo : WORD;

    PROCEDURE DoSomeWork;
    BEGIN
         { scan }
         IF ((WorkToDo AND WORK_FIDOSCAN) > 0) THEN
         BEGIN
              WorkToDo:=WorkToDo-WORK_FIDOSCAN;
              FidoScan;
              {Start_ScannedForFileAttaches:=TRUE;}
              Exit; { ## EXIT ## }
         END;

         { uucp }
         IF ((WorkToDo AND WORK_UUCPTOSS) > 0) THEN
         BEGIN
              WorkToDo:=WorkToDo-WORK_UUCPTOSS;
              UucpToss;
              Exit; { ## EXIT ## }
         END;

         { bag }
         IF ((WorkToDo AND WORK_BAGTOSS) > 0) THEN
         BEGIN
              WorkToDo:=WorkToDo-WORK_BAGTOSS;
              BagToss;
              Exit; { ## EXIT ## }
         END;

         { smtp }
         IF ((WorkToDo AND WORK_SMTPTOSS) > 0) THEN
         BEGIN
              WorkToDo:=WorkToDo-WORK_SMTPTOSS;
              SmtpToss;
              Exit; { ## EXIT ## }
         END;

         { pop3 }
         IF ((WorkToDo AND WORK_POP3TOSS) > 0) THEN
         BEGIN
              WorkToDo:=WorkToDo-WORK_POP3TOSS;
              Pop3Toss;
              Exit; { ## EXIT ## }
         END;

         { SOUP }
         IF ((WorkToDo AND WORK_SOUPTOSS) > 0) THEN
         BEGIN
               WorkToDo := WorkToDo - WORK_SOUPTOSS;
               SoupToss;
               Exit;  { ## EXIT ## }
         END;

         { tossbad }
         IF ((WorkToDo AND WORK_TOSSBAD) > 0) THEN
         BEGIN
              WorkToDo:=WorkToDo-WORK_TOSSBAD;
              FidoTossBad;
              Exit; { ## EXIT ## }
         END;

         { toss }
         IF ((WorkToDo AND WORK_FIDOTOSS) > 0) THEN
         BEGIN
              WorkToDo:=WorkToDo-WORK_FIDOTOSS;
              FidoToss;
              Exit; { ## EXIT ## }
         END;

         { notify }
         IF ((WorkToDo AND WORK_NOTIFY) > 0) THEN
         BEGIN
              WorkToDo:=WorkToDo-WORK_NOTIFY;
              SendNotificationMessages;
              Exit; { ## EXIT ## }
         END;
    END;


    PROCEDURE CheckSemaphore (WorkCode : WORD; Semafore : STRING);

    VAR DelFile : FILE;
        IORes   : BYTE;

    BEGIN
         IF GlobalAbort THEN
            Exit;

         IF (TestIfExist (Config.SystemDir+Semafore+'.NOW')) THEN
         BEGIN
              LogMessage (liGeneral,'Found semaphore file '+Semafore+'.NOW');

              IF ((WorkToDo AND WorkCode) > 0) THEN
                 LogExtraMessage (Semafore+' already scheduled')
              ELSE
                  LogExtraMessage ('Added '+Semafore+' to work list');

              WorkToDo:=WorkToDo OR WorkCode;
              Orig_WorkToDo:=Orig_WorkToDo OR WorkCode;

              { verwijder de semaphore }
              Semafore:=Config.SystemDir+Semafore+'.NOW';

              Assign (DelFile,Semafore);
              {$I-} Erase (DelFile); {$I+} IORes:=IOResult;
              IF (IORes <> 0) THEN
              BEGIN
                   LogDiskIOError (IORes,'Error deleting semaphore '+Semafore);
                   GlobalAbort:=TRUE;  { prevent endless loop }
              END;
         END;
    END;

    PROCEDURE CheckSemaphores;
    BEGIN
         CheckSemaphore (WORK_FIDOSCAN,'SCAN');
         CheckSemaphore (WORK_FIDOTOSS,'TOSS');
         CheckSemaphore (WORK_UUCPTOSS,'UUCP');
         CheckSemaphore (WORK_SMTPTOSS,'SMTP');
         CheckSemaphore (WORK_BAGTOSS ,'BAG');
         CheckSemaphore (WORK_POP3TOSS,'POP3');
         CheckSemaphore (WORK_SOUPTOSS,'SOUP');
         CheckSemaphore (WORK_NOTIFY  ,'NOTIFY');
    END;

{StartWork}

VAR WorkList     : STRING;
    Lp1          : BYTE;
    Lp2          : INFO_Set;
    Org_LogLines : BYTE;

LABEL AbortWork;

BEGIN
     FOR Lp1:=1 TO INFOSET_GROUPS DO
     BEGIN
          GroupNr2Y[Lp1]:=0;
          GroupVisible[Lp1]:=FALSE;
     END; { for }

     Org_LogLines:=Log_GetWindowSize;

     IF (NOT (StayQuiet OR NoFullScreen)) THEN
     BEGIN
          DrawInfoScreen;
          UpdateAction ('Initializing');
     END;

     FOR Lp2:=INFO_UucpIn_Jobs TO INFO_DupBad_Echo DO
         ProgressCounts[Lp2]:=0;

     Orig_WorkToDo:=WorkToDo; { for check what we did when we are ready }

     WorkList:='';
     IF (WorkToDo AND WORK_FIDOSCAN) > 0 THEN WorkList:=WorkList+'SCAN, ';
     IF (WorkToDo AND WORK_FIDOTOSS) > 0 THEN WorkList:=WorkList+'TOSS, ';
     IF (WorkToDo AND WORK_UUCPTOSS) > 0 THEN WorkList:=WorkList+'UUCP, ';
     IF (WorkToDo AND WORK_BAGTOSS)  > 0 THEN WorkList:=WorkList+'BAG, ';
     IF (WorkToDo AND WORK_SMTPTOSS) > 0 THEN WorkList:=WorkList+'SMTP, ';
     IF (WorkToDo AND WORK_POP3TOSS) > 0 THEN WorkList:=WorkList+'POP3, ';
     IF (WorkToDo AND WORK_SOUPTOSS) > 0 THEN WorkList:=WorkList+'SOUP, ';
     IF (WorkToDo AND WORK_TOSSBAD)  > 0 THEN WorkList:=WorkList+'TOSSBAD, ';
     IF (WorkToDo AND WORK_NOTIFY)   > 0 THEN WorkList:=WorkList+'NOTIFY, ';

     WorkList:=Copy (WorkList,1,Length (WorkList)-2);

     LogMessage (liGeneral,'Requested '+WorkList);

     LogExtraMessage ('Initial memory: '+Longint2String (_MemAvail));
     PeekMem;

     IF (NOT (StayQuiet OR NoFullScreen)) THEN
     BEGIN
          PushKeysLine;
          WriteKeysLine (' ^Esc Abort           Aborting might not be immediate!');
     END;

     IF (_MemAvail < 50000) THEN
     BEGIN
          LogMessage (liFatal,'Not enough free memory; aborting');
          GOTO AbortWork;
     END;

     IF (regKeyNumber < $FFFE) THEN
        FidoCreateRegTearLine
     ELSE
         Config.ReplaceTear:=TRUE; { override for un-reg users }

     { left-over initializations }
     FidoMsgInitMsgCount;

     NewAreasCreated:=0;
     GoSetFDRescan:=FALSE;
     GoSetFMRescan:=FALSE;

     GlobalAbort:=FALSE;

     Start_ScannedForFileAttaches:=FALSE;
     CheckSemaphores; { if scan, then first }

     Stats_StartTimer;

     WHILE (NOT GlobalAbort) AND (WorkToDo <> 0) DO
     BEGIN
          DoSomeWork;
          CheckSemaphores;
     END;
     
     { check mailing lists for re-confirmation requirements }
     IF (NOT GlobalAbort) THEN
        ListReconfirmCheck;

     { send report to admin - must be _before_ PACK phase }
     Log_SendReport;

     { inform users about new areas }

     { forward area requests }
     ExportAreafixForwardRequests;
     ExportNewsfixForwardRequests;

     Stats_StopTimer;
     Stats_WriteMsgsPerMin;
     
     { close outbound files }
     Outbound_FinishNow;

     { pack }
     IF (NOT GlobalAbort) THEN
     BEGIN
          Fido_Pack;           { pak de .QQQ files in }
          Outbound_FinishNow;
          {CloseAllOpenHandles; } { MailTunnel e-mails }
     END;

     { link, if anything except scan }
     IF (NOT GlobalAbort) AND Config.AutoLink AND ((Orig_WorkToDo AND (255-WORK_FIDOSCAN)) > 0) THEN
        LinkOnlySeenAreas;

     { close message bases }
     Squish_Done;
     Jam_Done;

     FidoMsgClearMsgCount;
     FrontDoor_Done;

     { set the rescan files }
     IF GoSetFDRescan THEN
        SetFlagFile (Config.RescanFlagFile);

     IF GoSetFMRescan THEN
        SetFlagFile (Config.RescanFlagFile2);

     IF GlobalAbort THEN
        LogMessage (liGeneral,'Aborted')
     ELSE
         LogMessage (liTrivial,'Completed all requests');


AbortWork:

     IF (NOT (StayQuiet OR NoFullScreen)) THEN
     BEGIN
          UpdateAction ('');
          PopKeysLine;
     END;

     LogClose;
     PeekFiles;

     {## test!! }
     (*
     UpdateInfoNr (INFO_UucpIn_Jobs,1);
     UpdateInfoNr (INFO_Pop3In_Msgs,5);
     UpdateInfoNr (INFO_PktIn_Bytes,5060);
     UpdateInfoNr (INFO_MsgScan_Msgs,1);
     UpdateInfoNr (INFO_SmtpIn_Mail,1);
     UpdateInfoNr (INFO_BagIn_Bytes,5159811);
     UpdateInfoNr (INFO_SoupIn_News,5);
     UpdateInfoNr (INFO_JamScan_Echo,5);
     UpdateInfoNr (INFO_SquishScan_Net,8);
     UpdateInfoNr (INFO_UucpOut_Jobs,10);
     UpdateInfoNr (INFO_SmtpOut_Mail,3);
     UpdateInfoNr (INFO_SoupOut_Jobs,9999);
     UpdateInfoNr (INFO_INetMailOut_Jobs,10000);
     UpdateInfoNr (INFO_PktOut_Jobs,20000);
     UpdateInfoNr (INFO_JamSave_Bytes,90000);
     UpdateInfoNr (INFO_SquishSave_Bytes,110000);
     UpdateInfoNr (INFO_DupBad_Bytes,600000);
     UpdateInfoNr (INFO_MsgSave_Bytes,70000);
     *)

     IF (NOT (StayQuiet OR NoFullScreen)) AND WaitKey THEN
     BEGIN
          WriteKeysLine (Spaces (22)+'` Press any key to continue `');

          {$IFDEF PLATFORM_OS2}
          DosBeep (500,100);
          DosBeep (700,100);
          DosBeep (900,50);
          {$ENDIF}

          {$IFDEF PLATFORM_WIN32}
          {## add Win32 sound support}
          {$ENDIF}

          {$IFDEF PLATFORM_DOS_ALL}
          Sound (500); NewDelay (100);
          Sound (700); NewDelay (100);
          Sound (900); NewDelay (50);
          NoSound;
          {$ENDIF}

          Ramon.ReadKey;
     END;

     WriteInfoToLogfile;
     LogClose;

     Log_SetWindowSize (Org_LogLines);

     { remove the stats window }
     IF (NOT (StayQuiet OR NoFullScreen)) THEN
          PaintDesktop (1,2,Video.Cols,Video.Rows-Org_LogLines-4);
END;


{--------------------------------------------------------------------------}
{ CheckMinDiskFree                                                         }
{                                                                          }
{ Deze routine kijkt of er nog genoeg vrije ruimte op ieder van de disks   }
{ is. Zoniet, dan wordt FALSE terug gegeven.                               }
{                                                                          }
FUNCTION CheckMinDiskFree : BOOLEAN;

VAR Lp : BYTE;
    D  : BYTE;
    F,
    M  : LONGINT;

BEGIN
     IF (Config.MinimumDiskFree = 0) OR (Config.DiskFreeDrives = '') THEN
     BEGIN
          CheckMinDiskFree:=TRUE;
          Exit;
     END;

     M:=Config.MinimumDiskFree*Longint(1024)*Longint(1024);

     FOR Lp:=1 TO Length (Config.DiskFreeDrives) DO
     BEGIN
          D:=Ord (Config.DiskFreeDrives[Lp])-Ord ('A')+1;
          F:=DiskFree (D);

          IF (F < 0) THEN
             F:=MAXLONGINT;

          IF (F >= 0) AND (F < M) THEN
          BEGIN
               LogMessage (liFatal,'Low disk space on drive '+Config.DiskFreeDrives[Lp]+
                           ': ('+Longint2String (Trunc (F/1024/1024))+'Mb); aborting');
               ConditionRed:=2;
               GlobalAbort:=TRUE;
               CheckMinDiskFree:=FALSE; { problemen! }
               Exit;
          END;
     END;

     CheckMinDiskFree:=TRUE; { geen problemen }
END;

{ unit end }
BEGIN
     Start_CountDupBad:=FALSE;
END.
