UNIT PackMem;

{$i platform.inc}

{ PackedBoolMem                                                        }
{                                                                      }
{ Een object om grote hoeveelheden BOOLEAN variabelen in op te slaan   }
{ geschikt als bij het compileren nog niet bekend is hoeveel           }
{ booleans er zijn. Een normaal STATISCH boolean array wordt door TP   }
{ gepacked opgeslagen.                                                 }

INTERFACE

TYPE StorageType   = ARRAY[0..0] OF BYTE;
     PackedBoolMem = OBJECT
                           Storage  : ^StorageType;
                           TotalObj : WORD;

                           CONSTRUCTOR Init (NumObjects : WORD);
                           DESTRUCTOR  Desc;

                           PROCEDURE   SetBit (ObjectNum : WORD);
                           PROCEDURE   ResetBit (ObjectNum : WORD);

                           FUNCTION    IsSet (ObjectNum : WORD) : BOOLEAN;
                     END;

IMPLEMENTATION

USES Logs;

CONSTRUCTOR PackedBoolMem.Init (NumObjects : WORD);
BEGIN
     TotalObj:=NumObjects;
     GetMem (Storage,(TotalObj DIV 8)+1);
     {$IFDEF LogGetMem} LogGetMem (Storage,(TotalObj DIV 8)+1,'GetMem PackedBoolMem'); {$ENDIF}
     FillChar (Storage^,(TotalObj DIV 8)+1,0);
END;

DESTRUCTOR PackedBoolMem.Desc;
BEGIN
     {$IFDEF LogGetMem} LogGetMem (Storage,TotalObj,'FreeMem PackedBoolMem'); {$ENDIF}
     FreeMem (Storage,TotalObj); {## wrong size?}
END;

PROCEDURE PackedBoolMem.SetBit (ObjectNum : WORD);
BEGIN
     Storage^[ObjectNum DIV 8]:=Storage^[ObjectNum DIV 8] OR (1 SHL (ObjectNum MOD 8));
END;

PROCEDURE PackedBoolMem.ReSetBit( ObjectNum : Word );
BEGIN
     Storage^[ObjectNum DIV 8]:=Storage^[ObjectNum DIV 8] AND ($FF-(1 SHL (ObjectNum MOD 8)));
END;

FUNCTION PackedBoolMem.IsSet( ObjectNum : Word ) : Boolean;
BEGIN
     IsSet:=(Storage^[ObjectNum DIV 8] AND (1 SHL (ObjectNum MOD 8)) > 0);
END;

END.
