{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT FD;

{$i platform.inc}

{ FrontDoor.PAS                                                            }
{                                                                          }
{ Wat specifieke routines om een Frontdoor outbound directory bij te       }
{ kunnen houden. Zo moet er een lijst bijgehouden worden met het archive   }
{ waaraan we op dit moment pakketen aan moeten toevoegen etc.              }


INTERFACE

USES Database,
     DList;

TYPE FDOutboundRec = RECORD
                           FileName : STRING[79];
                           Node     : FidoAddrType;
                     END;

     FDOutboundRecPtr = ^FDOutBoundRec;

VAR FDOutboundList : List;

FUNCTION  FrontDoorGetOutboundFile (Destination_Dir : STRING; Node,Source : FidoAddrType; VAR NewAttachFile : BOOLEAN;
                                    QQQRecNr : UserBaseRecordNrType; MaxArcLen,QQQSize : LONGINT) : STRING;
PROCEDURE FrontDoorAddToList (Node : FidoAddrType; ArchiveName : STRING);
PROCEDURE FrontDoor_Done;


IMPLEMENTATION

USES Cfg,
     Dos,
     Fido,
     Ramon,
     Logs,
     Start,
     Globals;

{--------------------------------------------------------------------------}
{ DeleteIfZeroBytesLong                                                    }
{                                                                          }
{ This routine checks whether the give file is zero bytes long. If so, it  }
{ is deleted. This is used to delete yesterdays truncated archives.        }
{                                                                          }
PROCEDURE DeleteIfZeroBytesLong (Filename : STRING);

VAR TestFile : FILE;
    IORes    : BYTE;
    Len      : LONGINT;

BEGIN
     Assign (TestFile,Filename);
     {$I-} Reset (TestFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'Error opening '+Filename);
          Exit;
     END;

     Len:=FileSize (TestFile);
     Close (TestFile);

     IF (Len <> 0) THEN
        Exit; { not 0 bytes }

     {$I-} Erase (TestFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'Error deleting 0-byte archive '+Filename);
END;


{--------------------------------------------------------------------------}
{ FrontdoorAddToList                                                       }
{                                                                          }
{ Voegt een archive toe aan de lijst met bekende systemen.                 }
{ RWI 960219: onthoudt nu alle attached files voor iedere node.            }
{ This is used when we have to pack a .PKT to an archive for a node to     }
{ work out whether there already is an archive for this node.              }
{                                                                          }
PROCEDURE FrontDoorAddToList (Node : FidoAddrType; ArchiveName : STRING);

VAR TmpString : STRING[79];
    TmpRec    : FDOutboundRecPtr;
    Dir       : DirStr;
    Name      : NameStr;
    Ext       : ExtStr;
    Y,M,D,DOW : WordLong;
    Found     : BOOLEAN;
    Lp        : BYTE;

BEGIN
     FSplit (ArchiveName,Dir,Name,Ext);

     IF (Ext = '') THEN
     BEGIN
          {LogMessage ('[DEBUG1] Ignoring f/a: '+ArchiveName);}
          Exit;
     END;

     IF (Ext[1] = '.') THEN
        Delete (Ext,1,1);

     Ext:=UpCaseString (Ext);

     IF (Ext = 'PKT') THEN
     BEGIN
          {LogMessage ('[DEBUG2] Ignoring f/a: '+ArchiveName);}
          Exit;
     END;

     Ext:=Copy (Ext,1,2);

     Found:=FALSE;
     FOR Lp:=0 TO 6 DO
         IF (Extensions[Lp] = Ext) THEN
            Found:=TRUE;

     IF (NOT Found) THEN
     BEGIN
          {LogMessage ('[DEBUG3] Ignoring f/a: '+ArchiveName);}
          Exit;
     END;

     { RWI 960402: controleer of de directory wel onze outbound is }
     {## fails when there is no backslash behind the outbound}
     IF NOT CaselessMatch (Dir,Config.Outbound_F) THEN
     BEGIN
          {LogMessage ('[FdDebug4] Not my outbound: '+Dir);}
          Exit;
     END;

     (* RWI 960219: niet meer... we onthouden nu alle files
     { doorzoek de lijst op zoek naar eerdere kopie }
     TmpRec:=FDOutboundList.GetFirstItem;
     WHILE (TmpRec <> NIL) DO
     BEGIN
          IF FidoCompare (TmpRec^.Node,Node) THEN
          BEGIN
               TmpRec^.FileName:=ArchiveName;
               Exit;
          END;

          TmpRec:=FDOutboundList.GetNextItem;
     END; { while }

     { blijkbaar niet gevonden, voeg dan toe aan de lijst }
     *)

     {RAWI980502: kijk of de extensie wel van vandaag is}
     GetDate (Y,M,D,DOW);
     IF (Ext <> Extensions[DOW]) THEN
     BEGIN
          { not from today so we shouldn't add to it anymore, so ignore it }
          {LogMessage ('[FdDebug5] Not today: '+ArchiveName);}

          { new: if the file is zero bytes long, then delete it }
          {## this doesn't delete the ARCmail message - is that OK?}
          {## it would be if we would still add this one to the table }
          {   but we aren't, which means we will create a new *.MSG!  }
          DeleteIfZeroBytesLong (ArchiveName);

          Exit;
     END;

     { the extension is from today. If it is zero bytes longer, then }
     { we might have a Truncate File Sent situation here. We must    }
     { then create a new archive with the next highest number.       }
     { We can either use the info from the User Record or takes the  }
     { highest we find with todays date and do +1 and delete all the }
     { older, zero-byte, archives. Best to wait with deleting until  }
     { we get to the pack phase. We can update the User Record info  }
     { until then.                                                   }
     { This is handled by FidoGetOutbound (fido.pas)                 }

     { deze toevoegen aan de lijst van gevonden f/a's }
     GetMem (TmpRec,SizeOf (FDOutboundRec));

     TmpRec^.Node:=Node;
     TmpRec^.Filename:=ArchiveName;

     FDOutboundList.Add (TmpRec);
END;


{---------------------------------------------------------------------------}
{ FrontdoorGetOutboundFile                                                  }
{                                                                           }
{ Zoekt in de lijst naar de huidige outbound file voor een bepaalde node.   }
{ Als die niet gevonden wordt, probeert de routine een nieuwe te bedenken.  }
{ QQQRecNr wordt door de aanroeper meegegeven en is het record nummer van   }
{ het zendende systeem en wordt door deze routine doorgegeven aan           }
{ FidoGetExtension.                                                         }
{                                                                           }
FUNCTION FrontDoorGetOutboundFile (Destination_Dir   : STRING;
                                   Node,
                                   Source            : FidoAddrType;
                                   VAR NewAttachFile : BOOLEAN;
                                   QQQRecNr          : UserBaseRecordNrType;
                                   MaxArcLen         : LONGINT;
                                   QQQSize           : LONGINT) : STRING;

VAR TmpString : STRING[79];
    TmpRec    : FDOutboundRecPtr;
    ZoekFile  : SearchRec;

BEGIN
     { RWI 961012: nu is het pas nodig om naar file attaches te zoeken! }
     ScanForFileAttaches;

     NewAttachFile:=FALSE; { geen nieuwe file aanmaken }

     { doorzoek de lijst op zoek naar eerdere kopie }
     TmpRec:=FDOutboundList.GetFirstItem;
     WHILE (TmpRec <> NIL) DO
     BEGIN
          IF FidoCompare (TmpRec^.Node,Node) THEN
          BEGIN
               IF (MaxArcLen > 0) THEN
               BEGIN
                    { controleer of de file niet de pan uitgroeit }
                    FindFirst (TmpRec^.FileName,saJustFiles,ZoekFile);
                    IF (DosError = 0) AND (ZoekFile.Size+QQQSize > MaxArcLen) THEN
                    BEGIN
                         { need to start a new file }
                         NewAttachFile:=TRUE;
                         TmpRec^.Filename:=Copy (TmpRec^.FileName,1,Length (TmpRec^.FileName)-4)+
                                        FidoGetExtension (Copy (TmpRec^.FileName,1,Length (TmpRec^.FileName)-4),QQQRecNr,'');
                    END;

                    FindClose (ZoekFile);
               END;

               FrontDoorGetOutboundFile:=Copy (TmpRec^.FileName,Length (TmpRec^.FileName)-11,255);
               Exit;
          END;

          TmpRec:=FDOutboundList.GetNextItem;
     END;

     { Niet gevonden, aaagll... nu moeten we dus wat nieuws verzinnen }
     IF (Node.Point > 0) THEN
        { RWI 950618: Deze P lijkt nog wat problemen te veroorzaken! }
        { RWI 950627: vervangen door een 8. De net nummers moeten nu }
        {             32000 uit elkaar liggen om hier overheen te    }
        {             schrijven.                                     }
        TmpString:='8'+Copy (Word2HexString (Node.Node),2,3)+Word2HexString (Node.Point)
     ELSE
         TmpString:=Word2HexString (Source.Net-Node.Net)+
                    Word2HexString (Source.Node-Node.Node);

     { Maak er %OUTBOUND%\xxxxxxx.SU0 van }
     TmpString:=Destination_Dir+TmpString+FidoGetExtension (Destination_Dir+TmpString,QQQRecNr,'');
     NewAttachFile:=TRUE; { maak een nieuwe file aan }

     { en voeg 'm toe aan de lijst }
     GetMem (TmpRec,SizeOf (FDOutboundRec));

     TmpRec^.Node:=Node;
     TmpRec^.Filename:=TmpString;
     FDOutboundList.Add (TmpRec);
     FrontDoorGetOutboundFile:=Copy (TmpRec^.FileName,Length (TmpRec^.FileName)-11,255);
END;


{--------------------------------------------------------------------------}
{ FrontDoor_Done                                                           }
{                                                                          }
PROCEDURE FrontDoor_Done;
BEGIN
     FDOutboundList.Clear;
END;


{--------------------------------------------------------------------------}
{ unit initialization                                                      }
{                                                                          }
BEGIN
     FDOutboundList.Init (SizeOf (FDOutboundRec),NIL);
END.


