{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT Cun;

{$i platform.inc}

{ CUN                                                                     }
{                                                                         }
{ Deze unit bevat 2 routines om de CUNBATCH string uit een gecomprimeerd  }
{ usenet bestand te halen. Aangezien er voor elke CUNBATCH geswapt moest  }
{ worden, is het veel sneller om het intern te doen !                     }
{                                                                         }
{ MD 08-10-93 AddCun + DelCun in een unit samengevoegt , en geheugen      }
{             beheer dynamisch gemaakt. (klinkt dat ff goed)              }
{                                                                         }
{ MD ?        #! gunbatch toegevoegd                                      }
{                                                                         }
{ RWI 950325: All I/O acties hebben nu een eigen IOResult afvanging en    }
{             betere logging toegevoegd.                                  }
{                                                                         }
{ RWI 950827: Buffer is nu dynamisch. PeekFiles en PeekMem verwijderd.    }
{             Support voor zunbatch toegevoegd. Memory leak in DelCun     }
{             opgelost (trad alleen op bij fouten).                       }

INTERFACE

FUNCTION DelCun (Path : STRING) : BOOLEAN;
FUNCTION AddCun (Path : STRING; BatchLetter : CHAR) : BOOLEAN;


IMPLEMENTATION

USES Dos,
     Ramon,
     Logs,
     Globals;

TYPE DataBuf = ARRAY[0..65527] OF BYTE;

{--------------------------------------------------------------------------}
{ DelCun                                                                   }
{                                                                          }
{ Verwijderd een cunbatch string uit een gecomprimeerde file.              }
{                                                                          }
FUNCTION DelCun (Path : STRING) : BOOLEAN;

VAR IORes      : BYTE;
    OutPath    : STRING;
    BufSize    : WORD;
    DataBufPtr : ^DataBuf;
    InpFile,
    OutFile    : FILE;
    BytesRead  : WordLong;
    StartPos   : WORD;
    Search     : SearchRec;
    TestString : STRING[12];

BEGIN
     DelCun:=FALSE;

     IF (NOT CalcMaxAllowedMem (BufSize,5000,65520)) THEN
     BEGIN
          LogMessage (liFatal,'[DelBatchHdr] Not enough memory for de-cunbatch');
          Exit;
     END;

     Assign (InpFile,Path);
     {$I-} Reset (InpFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[DelBatchHdr] Cannot open file: '+Path);
          Exit;
     END;

     {$IFDEF LogFileIO}PostOpenF (InpFile);{$ENDIF}

     { dit gaat mis als er geen puntje in het pad voorkomt.. }
     OutPath:=Path;
     WHILE (OutPath[Length (OutPath)] <> '.') DO
     BEGIN
          IF (OutPath[Length (OutPath)] = '\') THEN
          BEGIN
               { no . after \, so abort }
               OutPath:=OutPath+Copy (Path,Length (OutPath)+1,8)+'.';
               Break;
          END;

          Delete (OutPath,Length (OutPath),1);
     END;

     OutPath:=OutPath+'$$$';

     Assign (OutFile,OutPath);
     {$I-} ReWrite (OutFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[DelBatchHdr] Cannot create output file: '+OutPath);

          {$IFDEF LogFileIO}PreCloseF (InpFile);{$ENDIF}
          Close (InpFile);
          Exit;
     END;

     {$IFDEF LogFileIO}PostOpenF (OutFile);{$ENDIF}

     GetMem (DataBufPtr,BufSize);
     {$IFDEF LogGetMem} LogGetMem (DataBufPtr,BufSize,'GetMem DelCun'); {$ENDIF}

     StartPos:=12;
     REPEAT
           {$I-} BlockRead (InpFile,DataBufPtr^,BufSize,BytesRead); {$I+} IORes:=IOResult;
           IF (IORes <> 0) THEN
              LogDiskIOError (IORes,'[DelBatchHdr] Block read error');

           IF (StartPos > 0) THEN
           BEGIN
                Move (DataBufPtr^[0],TestString[1],12);
                TestString[0]:=#12; { length byte }
                {
                IF (TestString <> '#! cunbatch'#10) AND
                   (TestString <> '#! gunbatch'#10) AND
                   (TestString <> '#! zunbatch'#10)
                THEN
                    StartPos:=0; { laten staan }

                IF (Copy (TestString,1,3) <> '#! ') AND
                   (Copy (TestString,5,8) <> 'unbatch'#10)
                THEN
                    StartPos:=0; { laten staan }
           END;

           IF (BytesRead <> 0) THEN
           BEGIN
                {$I-} BlockWrite (OutFile,DataBufPtr^[StartPos],BytesRead-StartPos); {$I+} IORes:=IOResult;
                IF (IORes <> 0) THEN
                   LogDiskIOError (IORes,'[DelBatchHdr] Block write error');

                StartPos:=0;
           END;
     UNTIL (BytesRead = 0);

     {$IFDEF LogFileIO}PreCloseF (OutFile);{$ENDIF}
     Close (OutFile);

     {$IFDEF LogFileIO}PreCloseF (InpFile);{$ENDIF}
     Close (InpFile);

     {$I-} Erase (InpFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'[DelBatchHdr] Error removing original file');

     {$I-} Rename (OutFile,Path); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'[DelBatchHdr] Error renaming temporary file to new name');

     {$IFDEF LogGetMem} LogGetMem (DataBufPtr,BufSize,'FreeMem DelCun'); {$ENDIF}
     FreeMem (DataBufPtr,BufSize);
     DelCun:=TRUE;
END;


{--------------------------------------------------------------------------}
{ AddCun                                                                   }
{                                                                          }
{ Voegt een CUNBATCH string aan een gecomprimeerd archive toe.             }
{                                                                          }
FUNCTION AddCun (Path : STRING; BatchLetter : CHAR) : BOOLEAN;

VAR First      : BOOLEAN;
    OutName    : STRING;
    BufSize    : WORD;
    DataBufPtr : ^DataBuf;
    InpFile,
    OutFile    : FILE;
    BytesRead  : WordLong;
    StartPos   : WORD;
    Search     : SearchRec;
    TestString : STRING[12];
    IORes      : BYTE;

BEGIN
     AddCun:=FALSE;

     IF (NOT CalcMaxAllowedMem (BufSize,5000,65520)) THEN
     BEGIN
          LogMessage (liFatal,'[AddBatchHdr] Not enough memory to add '+BatchLetter+'unbatch');
          Exit;
     END;

     Assign (InpFile,Path);
     {$I-} Reset (InpFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[AddBatchHdr] Error opening input file');
          Exit;
     END;

     {$IFDEF LogFileIO}PostOpenF (InpFile);{$ENDIF}

     OutName:=Path;
     WHILE (OutName[Length (OutName)] <> '.') DO
           Delete (OutName,Length (OutName),1);
     OutName:=OutName+'$$$';

     Assign (OutFile,OutName);
     {$I-} ReWrite (OutFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'[AddBatchHdr] Cannot create temp file: '+OutName);
          {$IFDEF LogFileIO}PreCloseF (InpFile);{$ENDIF}
          Close (InpFile); {!}
          Exit;
     END;

     {$IFDEF LogFileIO}PostOpenF (OutFile);{$ENDIF}

     GetMem (DataBufPtr,BufSize);
     {$IFDEF LogGetMem} LogGetMem (DataBufPtr,BufSize,'GetMem AddCun'); {$ENDIF}

     First:=TRUE;
     REPEAT
           {$I-} BlockRead (InpFile,DataBufPtr^,BufSize,BytesRead); {$I+} IORes:=IOResult;
           IF (IORes <> 0) THEN
              LogDiskIOError (IORes,'[AddBatchHdr] Error reading block');

           IF First THEN
           BEGIN
                Move (DataBufPtr^[0],TestString[1],12);
                TestString[0]:=#12;
                IF (Copy (TestString,1,3) <> '#! ') AND (Copy (TestString,5,8) <> 'unbatch'#10) THEN
                BEGIN
                     TestString:='#! '+BatchLetter+'unbatch'#10;
                     {$I-} BlockWrite (OutFile,TestString[1],12); {$I+} IORes:=IOResult;
                     IF (IORes <> 0) THEN
                        LogDiskIOError (IORes,'[AddBatchHdr] Error writing "'+BatchLetter+'unbatch" block');
                END;

                First:=FALSE;
           END;

           IF (BytesRead <> 0) THEN
           BEGIN
                {$I-} BlockWrite (OutFile,DataBufPtr^,BytesRead); {$I+} IORes:=IOResult;
                IF (IORes <> 0) THEN
                   LogDiskIOError (IORes,'[AddBatchHdr] Error writing block');
           END;
     UNTIL (BytesRead = 0);

     {$IFDEF LogFileIO}PreCloseF (OutFile);{$ENDIF}
     Close (OutFile);
     {$IFDEF LogFileIO}PreCloseF (InpFile);{$ENDIF}
     Close (InpFile);

     {$I-} Erase (InpFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIOError (IORes,'[AddBatchHdr] Error removing '+Path);

     {$I-} Rename (OutFile,Path); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        LogDiskIoError (IORes,'[AddBatchHdr] Error renaming .$$$ to '+Path);

     {$IFDEF LogGetMem} LogGetMem (DataBufPtr,BufSize,'FreeMem AddCun'); {$ENDIF}
     FreeMem (DataBufPtr,BufSize);

     AddCun:=TRUE; { no problemos }
END;


END.
