UNIT CfgEdit;

{$i platform.inc}

{ All WtrConf routines to edit the System Configuration }

{ Started RAWI 970223 while replacing the system menu structure }
{ in an attempt to reduce the size of cfg.pas.                  }

INTERFACE

PROCEDURE EditSystemConfig;


IMPLEMENTATION

USES Ramon,
     Database,
     Msgs,
     Fido,
     Cfg,
     DupeChk,
     Globals,
     Dos,
     FlexCfg;

{$I WTRHLP.INC}

CONST MostHandles = 200;

VAR LastSelectedAFixGroup : GroupNrType;
    AkaEditStr            : FidoAddrString;
    AFixFwdRec            : AreafixForwardRecord;
    NFixFwdRec            : NewsfixForwardRecord;


{==========================================================================}
{==                                                                      ==}
{==                         GLOBAL SETTINGS                              ==}
{==                                                                      ==}
{==========================================================================}


{--------------------------------------------------------------------------}
{ ChangeColors                                                             }
{                                                                          }
{ Deze routine kan gebruikt worden om de kleuren die WaterGate gebruikt te }
{ veranderen.                                                              }
{                                                                          }
PROCEDURE ChangeColors; FAR;

    {----------------------------------------------------------------------}
    { EditOneColor                                                         }
    {                                                                      }
    PROCEDURE EditOneColor (ColorNr : BYTE);

    CONST Xb = 10;
          Yb = 7;

    VAR Lp      : BYTE;
        Attr    : BYTE;
        Quit    : BOOLEAN;
        C,PrevC,
        R,PrevR : BYTE;
        X,Y     : XYType;

    BEGIN
         PushKeysLine;
         WriteKeysLine (' ^Esc Abort  ^F10 Accept  ^Left/Right Change ^Up/Down Foreground/Background');

         WindowPush (Xb,Yb,65,12);
         BoxDraw (Double,Xb,Yb,65,12);

         WriteXY (Xb+2,Yb+2,'Foreground');
         WriteXY (Xb+2,Yb+5,'Background');

         FOR Lp:=0 TO 15 DO
         BEGIN
              ModifyColor (cCustom1,Lp);
              WriteXYC (Xb+15+Lp*3,Yb+2,cCustom1,'');

              ModifyColor (cCustom1,Lp*16);
              WriteXYC (Xb+15+Lp*3,Yb+5,cCustom1,'  ');
         END;

         Attr:=Config.Colors[ColorNr];

         R:=1;
         C:=Attr AND 15;
         PrevR:=2;
         PrevC:=255;

         SetLines (Single);

         Quit:=FALSE;
         REPEAT
               IF (PrevR <> R) OR (PrevC <> C) THEN
               BEGIN
                    SetColor (cBoxBack);

                    { oude verwijderen }
                    IF (PrevC <> 255) THEN
                    BEGIN
                         Y:=Yb+PrevR*3-2;
                         X:=Xb+14+PrevC*3;

                         WriteXY (X,Y,'    ');
                         WriteXY (X,Y+1,' ');
                         WriteXY (X+3,Y+1,' ');
                         WriteXY (X,Y+2,'    ');
                    END;

                    { nieuwe tekenen }

                    Y:=Yb+R*3-2;
                    X:=Xb+14+C*3;

                    WriteXY (X,Y,LB+HO+HO+RB);
                    WriteXY (X,Y+1,VR);
                    WriteXY (X+3,Y+1,VR);
                    WriteXY (X,Y+2,LON+HO+HO+RO);

                    PrevC:=C;
                    PrevR:=R;

                    WriteXY (Xb+5,Yb+8,Byte2HexString (Attr));

                    ModifyColor (cCustom1,Attr);
                    SetColor (cCustom1);
                    WriteXY (Xb+15,Yb+8,' This is in the selected color ');
               END;

               CASE ReadKey OF
                    kF10 :
                        BEGIN
                             Config.Colors[ColorNr]:=Attr;
                             Quit:=TRUE;
                        END;

                    kEsc :
                        Quit:=TRUE;

                    kUp :
                        IF (R = 2) THEN
                        BEGIN
                             R:=1;
                             C:=Attr AND 15;
                        END;

                    kDown :
                        IF (R = 1) THEN
                        BEGIN
                             R:=2;
                             C:=Attr SHR 4;
                        END;

                    kRight :
                        IF (C < 15) THEN
                        BEGIN
                             Inc (C);
                             IF (R = 1) THEN
                                Inc (Attr)
                             ELSE
                                 Inc (Attr,16);
                        END;

                    KLeft :
                        IF (C > 0) THEN
                        BEGIN
                             Dec (C);
                             IF (R = 1) THEN
                                Dec (Attr)
                             ELSE
                                 Dec (Attr,16);
                        END;

               END; { case }

         UNTIL Quit;

         WindowPop;
         PopKeysLine;
    END;


    {----------------------------------------------------------------------}
    { QuickEntry                                                           }
    {                                                                      }
    PROCEDURE QuickEntry;

    CONST Xb = 2;
          Yb = 7;
          Xl = 75;
          Yl = 7;

    VAR Lp         : BYTE;
        CurrentStr,
        QuickStr   : STRING[26*2];

    BEGIN
         WindowPush (Xb,Yb,Xl,Yl);
         BoxDraw (Double,Xb,Yb,Xl,Yl);

         WriteXY (Xb+2,Yb+2,'Current selection:');
         WriteXY (Xb+2,Yb+4,'Quick new entry:');

         CurrentStr:='';
         FOR Lp:=1 TO 26 DO
             CurrentStr:=CurrentStr+Byte2HexString (Config.Colors[Lp]);

         WriteXYC (Xb+21,Yb+2,cBoxData,CurrentStr);

         QuickStr:=CurrentStr;

         FieldPushAll;

         FieldInit;
         FieldDefineOne (1,Xb+21,Yb+4,26*2,0,0,@QuickStr,RepChar (26*2,'$'));

         FieldEditKeysLine:=' ^F1 Help  ^Enter Accept  ^Esc Restore old';

         FieldEditDirect;

         FieldEditKeysLine:=ORG_FieldEditKeysLine;

         IF (Key <> kEsc) THEN
         BEGIN
              FOR Lp:=1 TO 26 DO
              BEGIN
                   Config.Colors[Lp]:=HexString2Long (Copy (QuickStr,1,2));
                   Delete (QuickStr,1,2);
              END;
         END;

         FieldPopAll;

         WindowPop;
    END;

    {----------------------------------------------------------------------}
    { SelectSet                                                            }
    {                                                                      }
    PROCEDURE SelectSet;

    CONST GrayishSet : ARRAY[1..26] OF BYTE = ($78,$70,$7F,$7E,$7E,$08,$7F,
                                               $4E,$2F,$74,$70,$F4,$6F,$6E,
                                               $6B,$7A,$4F,$78,$2F,$2A,$7E,
                                               $7E,$7F,$3F,$1F,$2F);


    CONST BlackSet : ARRAY[1..26] OF BYTE = ($80,$03,$07,$03,$03,$08,$0F,
                                             $4E,$0B,$0B,$03,$84,$3F,$3E,
                                             $31,$1A,$4F,$08,$4C,$CF,$4E,
                                             $07,$0F,$70,$47,$4E);

    VAR Keuze  : WORD;
        Search : SearchRec;
        InFile : TEXT;
        IORes  : BYTE;
        Regel  : STRING[80];
        Lp     : BYTE;

    BEGIN
         ListDefine (10,5,50,Video.Rows-8,Default,'Select a built in color set',0);
         ListAddItem ('WaterGate Standard',1,Bottom);
         ListAddItem ('Sunny',2,Bottom);
         ListAddItem ('Dark Room',3,Bottom);

         Keuze:=1000;
         FindFirst (DeleteBackSpaces (Config.SystemDir)+'*.WCS',saJustFiles,Search);
         WHILE (DosError = 0) DO
         BEGIN
              ListAddItem (Search.Name,Keuze,Bottom);
              Inc (Keuze);
              FindNext (Search);
         END;

         Keuze:=ListSelect (NoTag,[]);

         IF (Key <> kEsc) THEN
            CASE Keuze OF
                 1 : RestoreSystemColors;
                 2 : Move (GrayishSet,Config.Colors,26);
                 3 : Move (BlackSet,Config.Colors,26);

                 ELSE BEGIN
                           RestoreSystemColors;

                           Assign (InFile,DeleteBackSpaces (Config.SystemDir)+ListGetItemTekst (Keuze));
                           {$I-} Reset (InFile); {$I+} IORes:=IOResult;
                           IF (IORes <> 0) THEN
                              Error ('Could not read from file')
                           ELSE BEGIN
                                ReadLn (InFile,Regel);
                                Close (InFile);

                                FOR Lp:=1 TO 26 DO
                                    IF (Length (Regel) >= Lp*2) THEN
                                       Config.Colors[Lp]:=HexString2Long (Copy (Regel,Lp*2-1,2));
                           END;
                      END;
            END;

         ListErase;
    END;

{ChangeColors}

VAR Quit  : BOOLEAN;
    Keuze : WORD;

BEGIN
     ListNoTagKeysLine:=ORG_ListNoTagKeysLine+'  ^F2 Quick Entry  ^F3 Select Set';

     ListDefine (2,3,80,Video.Rows-4,Default,'Select a color',htr_CFGGlobal_List_of_colors);

     ListAddItem ('Desktop: background',1,Bottom);
     ListAddItem ('Desktop: title',2,Bottom);
     ListAddItem ('Window: border, no focus',3,Bottom);
     ListAddItem ('Window: border, focus',4,Bottom);
     ListAddItem ('Window: background',5,Bottom);
     ListAddItem ('Window: shadow',6,Bottom);
     ListAddItem ('Window: text',7,Bottom);
     ListAddItem ('Message: error',8,Bottom);
     ListAddItem ('Message: normal',9,Bottom);
     ListAddItem ('Keys line: key name',10,Bottom);
     ListAddItem ('Keys line: key description',11,Bottom);
     ListAddItem ('Keys line: blinking text',12,Bottom);
     ListAddItem ('List: Tagged item',16,Bottom);
     ListAddItem ('List: Not taggable item',17,Bottom);
     ListAddItem ('Disabled field',18,Bottom);
     ListAddItem ('Cursor bar',19,Bottom);
     ListAddItem ('Cursor bar on tagged item',20,Bottom);
     ListAddItem ('Selected menu/list item',21,Bottom);
     ListAddItem ('Help: Normal',22,Bottom);
     ListAddItem ('Help: Highlighted',23,Bottom);
     ListAddItem ('Help: Title',24,Bottom);
     ListAddItem ('Help: Link',25,Bottom);
     ListAddItem ('Help: Cursor over link',26,Bottom);

     Quit:=FALSE;
     REPEAT
           ActivateColors;

           Keuze:=ListSelect (NoTag,[kF2,kF3]);

           CASE Key OF
                kEsc : Quit:=TRUE;

                kRet : EditOneColor (Keuze);

                kF2 : QuickEntry;

                kF3 : SelectSet;

           END; { case }

     UNTIL Quit;

     ListErase;

     ListNoTagKeysLine:=ORG_ListNoTagKeysLine;
END;


{--------------------------------------------------------------------------}
{ CheckHandles                                                             }
{                                                                          }
FUNCTION CheckHandles (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Nr  : BYTE;
    Nop : ValNop;

BEGIN
     Val (DeleteFrontAndBackSpaces (BufferPtr^),Nr,Nop);

     IF (Nop <> 0) THEN
        Nr:=8; { default }

     IF (Nr = 0) THEN
        Nr:=1;

     IF (Nr > MostHandles) THEN
     BEGIN
          Error ('Maximum allowed value is '+Word2String (MostHandles));
          Nr:=MostHandles;
     END;

     BufferPtr^:=AddUpWithSpaces (3,Byte2String (Nr));
     Config.MaxHandles:=Nr;

     CheckHandles:=TRUE;
END;


{--------------------------------------------------------------------------}
{ ChangeAdvancedSettings                                                   }
{                                                                          }
PROCEDURE ChangeAdvancedSettings; FAR;

CONST Xb = 6;
      Yb = 14;
      Xl = 28;
      Yl = 5;

      Xb2 = Xb+20;

VAR FieldY        : XYType;
    MaxHandlesStr : STRING[3];

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     MaxHandlesStr:=AddUpWithSpaces (3,Byte2String (Config.MaxHandles));
     FieldY:=Yb+1;

     WriteXY (Xb+2,FieldY,'Max. files open');
     FieldAutoDefineCheckOne (Xb2,FieldY,@MaxHandlesStr,'%%%',CheckHandles);
     FieldSetHelp (0,htr_CFGGlobAdv_Max_open_handles);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Cache .TDB files');
     FieldAutoDefineToggles (Xb2,FieldY,Config.CacheTdbs,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobAdv_Cache_TDB_files);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Time slicing');
     FieldAutoDefineToggles (Xb2,FieldY,Config.TimeSlicing,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobAdv_Time_Slicing);

     FieldEdit;

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ GraySwapFields                                                           }
{                                                                          }
PROCEDURE GraySwapFields; FAR;
BEGIN
     IF Config.UseSwapFile THEN
     BEGIN
          FieldEnableField (2);
          FieldEnableField (3);
     END ELSE
     BEGIN
          FieldDisableField (2);
          FieldDisableField (3);
     END;

     FieldUpdateOneField (2);
     FieldUpdateOneField (3);
END;


{--------------------------------------------------------------------------}
{ CheckSwapSize                                                            }
{                                                                          }
FUNCTION CheckSwapSize (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Nr  : BYTE;
    Nop : ValNop;

BEGIN
     Val (DeleteFrontAndBackSpaces (BufferPtr^),Nr,Nop);

     IF (Nop <> 0) OR (Nr = 0) THEN
        Nr:=2;

     BufferPtr^:=AddUpWithSpaces (2,Byte2String (Nr));
     Config.SwapFileSize:=Nr;

     CheckSwapSize:=TRUE;
END;


{--------------------------------------------------------------------------}
{ SwapFileMgr                                                              }
{                                                                          }
{ Laat een file/directory uitzoeken en voeg "wtrgate.swp" toe als alleen   }
{ een pad gekozen is.                                                      }
{                                                                          }
PROCEDURE SwapFileMgr (BufferPtr : StringPtr; CheckOnly : BOOLEAN); FAR;
BEGIN
     IF CheckOnly THEN
        Exit;

     BufferPtr^:=FileManager (DeleteFrontAndBackSpaces (BufferPtr^),'','*.*');
     IF (BufferPtr^[Length (BufferPtr^)] = '\') THEN
        BufferPtr^:=BufferPtr^+'WTRGATE.SWP';
     BufferPtr^:=AddUpWithSpaces (MaxLenPath,BufferPtr^);
END;


{--------------------------------------------------------------------------}
{ ChangeSwapFileSettings                                                   }
{                                                                          }
PROCEDURE ChangeSwapFileSettings; FAR;

CONST Xb = 8;
      Yb = 13;
      Xl = 64;
      Yl = 5;

VAR SwapSizeStr : STRING[2];

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     IF (Config.SwapfileSize > 99) THEN
        Config.SwapfileSize:=99; { just in case }

     SwapSizeStr:=AddUpWithSpaces (2,Byte2String (Config.SwapfileSize));

     WriteXY (Xb+2,Yb+1,'Use swap file?');
     FieldAutoDefineTogglesCall (Xb+20,Yb+1,Config.UseSwapfile,'no|yes',0,GraySwapFields);
     FieldSetHelp (0,htr_CFGGlobSwap_Swapfile_enable);

     WriteXY (Xb+2,Yb+2,'Swap file path');
     FieldAutoDefineFileMgr (Xb+20,Yb+2,42,@Config.SwapfilePath,SwapFileMgr,FALSE);
     FieldSetHelp (0,htr_CFGGlobSwap_Swapfile_path);

     WriteXY (Xb+2,Yb+3,'Swap file size');
     FieldAutoDefineCheckOne (Xb+20,Yb+3,@SwapSizeStr,'##',CheckSwapSize);
     FieldSetHelp (0,htr_CFGGlobSwap_Swapfile_size);

     GraySwapFields;

     FieldEdit;

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ ChangeLogfileSettings_DebugHasChanged                                    }
{                                                                          }
PROCEDURE ChangeLogfileSettings_DebugHasChanged; FAR;

VAR Lp : BYTE;

BEGIN
     FOR Lp:=2 TO MaxFields DO { gewoon alle andere velden... }
     BEGIN
          IF (Config.LogDebug) THEN
             FieldDisableField (Lp)
          ELSE
              FieldEnableField (Lp);

          FieldUpdateOneField (Lp);
     END;
END;


{--------------------------------------------------------------------------}
{ ChangeLogfileSettings                                                    }
{                                                                          }
{ Met deze routine kunnen de booleans gezet worden die bijhouden wat er in }
{ de logfile komt te staan.                                                }
{                                                                          }
PROCEDURE ChangeLogfileSettings; FAR;

CONST Xb = 25;
      Yb = 3;
      Xl = 37;
      Yl = 21;

      Xb2 = Xb+29;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     WriteXY (Xb+2,Yb+1,'Debug (=all to YES)');
     FieldAutoDefineTogglesCall (Xb2,Yb+1,Config.LogDebug,'no|yes',0,ChangeLogfileSettings_DebugHasChanged);
     FieldSetHelp (0,htr_CFGGlobLog_LogDebug);

     WriteXY (Xb+2,Yb+3,'Tossing .X and .D files');
     FieldAutoDefineToggles (Xb2,Yb+3,Config.LogSpoolTossed,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogSpoolTossed);

     WriteXY (Xb+2,Yb+4,'Extracting Fido archives');
     FieldAutoDefineToggles (Xb2,Yb+4,Config.LogFidoExtract,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogFidoExtract);

     WriteXY (Xb+2,Yb+5,'Tossing Fido .PKT files');
     FieldAutoDefineToggles (Xb2,Yb+5,Config.LogFidoTossed,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogFidoTossed);

     WriteXY (Xb+2,Yb+6,'Address translation F->U');
     FieldAutoDefineToggles (Xb2,Yb+6,Config.LogTranslationFU,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogTranslationFU);

     WriteXY (Xb+2,Yb+7,'New newsgroup names check');
     FieldAutoDefineToggles (Xb2,Yb+7,Config.LogCheckFilter,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogCheckFilter);

     WriteXY (Xb+2,Yb+8,'Incomplete .X address fix');
     FieldAutoDefineToggles (Xb2,Yb+8,Config.LogXFix,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogXFix);

     WriteXY (Xb+2,Yb+9,'Copied headers F->U');
     FieldAutoDefineToggles (Xb2,Yb+9,Config.LogCopyHeaders,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogCopyHeaders);

     WriteXY (Xb+2,Yb+10,'Illegal copy headers');
     FieldAutoDefineToggles (Xb2,Yb+10,Config.LogIllegalHeaders,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogIllegalHeaders);

     WriteXY (Xb+2,Yb+11,'Area/newsfix processing');
     FieldAutoDefineToggles (Xb2,Yb+11,Config.LogAreaFix,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogAreaFix);

     WriteXY (Xb+2,Yb+12,'Applied mapping statements');
     FieldAutoDefineToggles (Xb2,Yb+12,Config.LogMapApply,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogMapApply);

     WriteXY (Xb+2,Yb+13,'Importing of netmail');
     FieldAutoDefineToggles (Xb2,Yb+13,Config.LogNetmailImport,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogNetmailImport);

     WriteXY (Xb+2,Yb+14,'Read-only denied postings');
     FieldAutoDefineToggles (Xb2,Yb+14,Config.LogRODeny,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogRODeny);

     WriteXY (Xb+2,Yb+15,'Each message from a .PKT');
     FieldAutoDefineToggles (Xb2,Yb+15,Config.LogPktEachEcho,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogPktEachEcho);

     WriteXY (Xb+2,Yb+16,'Created UUCP jobs');
     FieldAutoDefineToggles (Xb2,Yb+16,Config.LogUUCPOutbound,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogUUCPOutbound);

     WriteXY (Xb+2,Yb+17,'Created SMTP jobs');
     FieldAutoDefineToggles (Xb2,Yb+17,Config.LogSMTPOutbound,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogSMTPOutbound);

     WriteXY (Xb+2,Yb+18,'Exported messages');
     FieldAutoDefineToggles (Xb2,Yb+18,Config.LogExportedMsgs,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogExportedMsgs);

     WriteXY (Xb+2,Yb+19,'Article newsgroups');
     FieldAutoDefineToggles (Xb2,Yb+19,Config.LogErrNewsgroups,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobLog_LogErrNewsgroups);

     { hier nieuwe velden bijvoegen }

     {
     WriteXY (Xb+2,Yb+Yl-2,'(more to come in future releases)');
     }

     ChangeLogfileSettings_DebugHasChanged; { initial graying }

     FieldEdit;
     FieldPopAll;

     WindowPop;
END;


(*
{--------------------------------------------------------------------------}
{ CheckDupes                                                               }
{                                                                          }
FUNCTION CheckDupes (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Nr  : WORD;
    Nop : ValNop;

BEGIN
     Val (DeleteFrontAndBackSpaces (BufferPtr^),Nr,Nop);

     IF (Nop <> 0) THEN
        Nr:=10000; { default }

     IF (Nr > MAXDUPECHECKS) THEN
     BEGIN
          Error ('Maximum allowed value is '+Word2String (MAXDUPECHECKS));
          Nr:=MaxDupeChecks;
     END;

     BufferPtr^:=AddUpWithSpaces (5,Word2String (Nr));
     Config.DupeChecks:=Nr;

     CheckDupes:=TRUE;
END;


{--------------------------------------------------------------------------}
{ GrayDupeChecks                                                           }
{                                                                          }
PROCEDURE GrayDupeChecks; FAR;
BEGIN
     IF Config.DoDupeChk THEN
        FieldEnableField (6)
     ELSE
         FieldDisableField (6);

     FieldUpdateOneField (6);
END;
*)

{--------------------------------------------------------------------------}
{ CheckMinDiskFree                                                         }
{                                                                          }
FUNCTION CheckMinDiskFree (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Nop : ValNop;

BEGIN
     Val (DeleteFrontAndBackSpaces (BufferPtr^),Config.MinimumDiskFree,Nop);
     IF (Nop <> 0) THEN
        Config.MinimumDiskFree:=0;

     BufferPtr^:=AddUpWithSpaces (2,Byte2String (Config.MinimumDiskFree));

     CheckMinDiskFree:=TRUE;
END;


{--------------------------------------------------------------------------}
{ CheckDiskFreeDrives                                                      }
{                                                                          }
FUNCTION CheckDiskFreeDrives (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Lp   : BYTE;
    D    : CHAR;
    Temp : STRING[26];

BEGIN
     Temp:='';

     FOR Lp:=0 TO 25 DO
     BEGIN
          D:=Chr (Ord ('A')+Lp);

          IF (Pos (D,BufferPtr^) > 0) THEN
             Temp:=Temp+D;
     END;

     BufferPtr^:=AddUpWithSpaces (26,Temp);

     CheckDiskFreeDrives:=TRUE;
END;


{--------------------------------------------------------------------------}
{ LogFileMgr                                                               }
{                                                                          }
{ Laat een file/directory uitzoeken en voeg "wtrgate.log" toe als alleen   }
{ een pad gekozen is.                                                      }
{                                                                          }
PROCEDURE LogFileMgr (BufferPtr : StringPtr; CheckOnly : BOOLEAN); FAR;
BEGIN
     IF CheckOnly THEN
        Exit;

     BufferPtr^:=FileManager (DeleteFrontAndBackSpaces (BufferPtr^),'','*.*');
     IF (BufferPtr^[Length (BufferPtr^)] = '\') THEN
        BufferPtr^:=BufferPtr^+'WTRGATE.LOG';
     BufferPtr^:=AddUpWithSpaces (MaxLenPath,BufferPtr^);
END;


{--------------------------------------------------------------------------}
{ EditGlobalSettings                                                       }
{                                                                          }
PROCEDURE EditGlobalSettings;

CONST Xb  = 3;
      Yb  = 3;
      Xl  = 75;
      Yl  = 14;

      Xb2 = Xb+21;

VAR FieldY         : XYType;
   {DupeCheckStr   : STRING[5];}
    MinDiskFreeStr : STRING[2];

BEGIN
     FixConfigRecord;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;

     {DupeCheckStr:=AddUpWithSpaces (5,Word2String (Config.DupeChecks));}
     MinDiskFreeStr:=AddUpWithSpaces (2,Byte2String (Config.MinimumDiskFree));

     FieldY:=Yb+1;

     WriteXY (Xb+2,FieldY,'Sysop name');
     FieldAutoDefineOne (Xb2,FieldY,@Config.Sysop,RepChar (MaxLenSysopName,'$'));
     FieldSetHelp (0,htr_CFGGlobal_Sysop_name);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'System path');
     FieldAutoDefineFileMgr (Xb2,FieldY,52,@Config.SystemDir,PathFileMgr,FALSE);
     FieldSetHelp (0,htr_CFGGlobal_System_path);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Log file path');
     FieldAutoDefineFileMgr (Xb2,FieldY,52,@Config.LogFilePath,LogFileMgr,FALSE);
     FieldSetHelp (0,htr_CFGGlobal_Logfile_path);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Oversized path');
     FieldAutoDefineFileMgr (Xb2,FieldY,52,@Config.TooLargePath,PathFileMgr,FALSE);
     FieldSetHelp (0,htr_CFGGlobal_Oversized_path);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Dupe checking');
     FieldAutoDefineToggles (Xb2,FieldY,Config.DoDupeChk,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobal_Dupe_checking);

     (*
     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Dupe checks');
     FieldAutoDefineCheckOne (Xb2,FieldY,@DupeCheckStr,'%%%%%',CheckDupes);
     FieldSetHelp (0,1014);
     *)

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Minimum disk free');
     WriteXY (Xb2+3,FieldY,'Mb');
     FieldAutoDefineCheckOne (Xb2,FieldY,@MinDiskFreeStr,'$$',CheckMinDiskFree);
     FieldSetHelp (0,htr_CFGGlobal_Minimum_disk_free);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Drives to check');
     FieldAutoDefineCheckOne (Xb2,FieldY,@Config.DiskFreeDrives,RepChar (26,'@'),CheckDiskFreeDrives);
     FieldSetHelp (0,HTR_CFGGlobal_Drives_to_check);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Log file settings');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,ChangeLogFileSettings);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Swap file settings');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,ChangeSwapFileSettings);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Advanced settings');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,ChangeAdvancedSettings);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Empty tear-line');
     FieldAutoDefineToggles (Xb2,FieldY,Config.EmptyTear,'no|yes',0);
     FieldSetHelp (0,htr_CFGGlobal_Empty_tearline);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Colors');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,ChangeColors);

     {GrayDupeChecks;}

     FieldEdit;

     WindowPop;
     UnfixConfigRecord;
END;


{==========================================================================}
{==                                                                      ==}
{==                         FTN SETTINGS                                 ==}
{==                                                                      ==}
{==========================================================================}


{--------------------------------------------------------------------------}
{ AddAkaUsageToList                                                        }
{                                                                          }
{ This routine searches the areabase for places where the system node      }
{ numbers are used. This is helpful when working out whether a node number }
{ is still in use or not and adds this information to the list.            }
{ Use 0 for all AKAs or otherwise 1..MaxAkas.                              }
{                                                                          }
PROCEDURE AddAkaUsageToList (AkaLimit : BYTE);

TYPE UsageRecord = RECORD
                         ForAreaOrigin            : WORD;
                         ForAreaSeenBy            : WORD;
                         ForUserExportAka         : WORD;
                         ForGroupDefaultOriginAka : WORD;
                         InGroups                 : GroupFlagType;
                   END;

     UsageArray = ARRAY[AkaIndexType] OF UsageRecord;

VAR AreaLp   : AreaBaseRecordNrType;
    AkaLp    : AkaIndexType;
    AreaRec  : AreaBaseRecord;

    UserLp   : UserBaseRecordNrType;
    UserRec  : UserBaseRecord;

    GroupLp  : GroupDescBaseRecordNrType;
    GroupRec : GroupDescRecord;

    AkaUsagePtr : ^UsageArray;

    Anything : WORD;

BEGIN
     IF (MaxAvail < SizeOf (UsageArray)) THEN
     BEGIN
          Error ('Sorry, not enough free memory to perform operation');
          ListAddItem ('Not enough free memory to perform operation',0,Bottom);
          Exit;
     END;

     GetMem (AkaUsagePtr,SizeOf (UsageArray));
     FillChar (AkaUsagePtr^,SizeOf (UsageArray),0);

     FOR AreaLp:=1 TO AreaBaseRecCount DO
     BEGIN
          ReadAreaBaseRecord (AreaLp,AreaRec);

          IF (NOT AreaRec.Deleted) THEN
          BEGIN
               IF (AreaRec.OriginAka < 1) OR (AreaRec.OriginAka > MaxAkas) THEN
               BEGIN
                    ListAddItem ('ERROR: OriginAka out of range for area '+AreaRec.AreaName_F,65530,Bottom);
               END ELSE
               BEGIN
                    Inc (AkaUsagePtr^[AreaRec.OriginAka].ForAreaOrigin);
                    MergeGroups (AkaUsagePtr^[AreaRec.OriginAka].InGroups,AreaRec.IsInGroups);
               END;

               FOR AkaLp:=1 TO MaxAKAs DO
                   IF HasSeenByBit (AreaRec.AddSeenByAkas,AkaLp) THEN
                   BEGIN
                        Inc (AkaUsagePtr^[AkaLp].ForAreaSeenBy);
                        MergeGroups (AkaUsagePtr^[AkaLp].InGroups,AreaRec.IsInGroups);
                   END;
          END; { if not deleted }
     END; { arealp }

     FOR UserLp:=1 TO UserBaseRecCount DO
     BEGIN
          ReadUserBaseRecord (UserLp,UserRec);

          IF (NOT UserRec.Deleted) THEN
             IF (UserRec.System = _F) THEN
                { note: automatic export aka not included! }
                IF (UserRec.ExportAka >= 1) AND (UserRec.ExportAka <= MaxAkas) THEN
                   Inc (AkaUsagePtr^[UserRec.ExportAka].ForUserExportAka);
     END; { userlp }

     FOR GroupLp:=1 TO MaxGroups DO
     BEGIN
          ReadGroupDescRecord (GroupLp,GroupRec);

          IF (GroupRec.OriginAka >= 1) AND (GroupRec.OriginAka <= MaxAkas) THEN
             Inc (AkaUsagePtr^[GroupRec.OriginAka].ForGroupDefaultOriginAka);
     END; { userlp }

     { fill the window with the info }

     FOR AkaLp:=1 TO MaxAkas DO
         IF (AkaLimit = 0) OR (AkaLp = AkaLimit) THEN
            IF (NOT FidoCompare (Config.NodeNrs[AkaLp],NullAdres)) THEN
            BEGIN
                 IF (AkaLimit = 0) THEN
                    ListAddItem (AddUpWithSpaces (50,Fido2Str (Config.NodeNrs[AkaLp])),0,Bottom);

                 Anything:=ListItemCount;

                 WITH AkaUsagePtr^[AkaLp] DO
                 BEGIN
                      IF (ForUserExportAka > 0) THEN
                         ListAddItem ('  Used as Export AKA for '+Word2String (ForUserExportAka)+' users',0,Bottom);

                      IF (ForGroupDefaultOriginAka > 0) THEN
                         ListAddItem ('  Used as default origin aka for '+Word2String (ForGroupDefaultOriginAka)+' groups',
                                      0,Bottom);

                      IF (ForAreaOrigin > 0) THEN
                         ListAddItem ('  Used as Origin AKA for '+Word2String (ForAreaOrigin)+' areas',0,Bottom);

                      IF (ForAreaSeenBy > 0) THEN
                         ListAddItem ('  Used in the SEEN-BY for '+Word2String (ForAreaSeenBy)+' areas',0,Bottom);

                      IF (ForAreaOrigin > 0) OR (ForAreaSeenBy > 0) THEN
                         ListAddItem ('  ..for areas in groups: '+BuildGroupListDesc (InGroups,255),0,Bottom);
                 END; { with }

                 IF (Anything = ListItemCount) THEN
                    IF (AkaLimit = 0) THEN
                       ListAddItem ('  <no usage found>',0,Bottom)
                    ELSE
                        ListAddItem ('  Not used anywhere',0,Bottom);
            END; { if, akalp }

     FreeMem (AkaUsagePtr,SizeOf (UsageArray));
END;


{--------------------------------------------------------------------------}
{ FindSystemNodeNrUsage                                                    }
{                                                                          }
{ This routine searches the areabase for places where the system node      }
{ numbers are used. This is helpful when working out whether a node number }
{ is still in use or not.                                                  }
{                                                                          }
PROCEDURE FindSystemNodeNrUsage;

BEGIN
     ListDefine (10,4,65,Video.Rows-5,Default,
                 'System node numbers usage',
                 htr_SysFTN_System_node_numbers_usage);

     AddAkaUsageToList (0);

     ListShow (Double,FALSE);

     REPEAT
           ListSelect (NoTag,[]);
     UNTIL (Key = kEsc);

     ListErase;
END;


{--------------------------------------------------------------------------}
{ EditOneSystemNodeNr                                                      }
{                                                                          }
PROCEDURE EditOneSystemNodeNr (Aka : AkaIndexType);

CONST Xb = 12;
      Yb =  7;
      Xl = MaxLenFidoAddrString+16;
      Yl =  4;

VAR FidoStr      : FidoAddrString;
    PointStr     : STRING[5];
    Nop          : ValNop;
    PrevFidoStr  : FidoAddrString;
    Quit         : BOOLEAN;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     FidoStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[Aka]));
     PointStr:=AddUpWithSpaces (5,Word2String (Config.PointNets[Aka]));

     WriteXY (Xb+2,Yb+1,'Node number');
     FieldAutoDefineCheckOne (Xb+14,Yb+1,@FidoStr,RepChar (MaxLenFidoAddrstring,'$'),CheckFidoAddr);
     FieldSetHelp (1,htr_SysAkaEdit_Node_number);

     WriteXY (Xb+2,Yb+2,'Point net');
     FieldAutoDefineCheckOne (Xb+14,Yb+2,@PointStr,'%%%%%',FieldCheckWordFunc);
     FieldSetHelp (2,htr_SysAkaEdit_Point_net);

     IF (DeleteBackSpaces (FidoStr) = '0') THEN
        PrevFidoStr:=''
     ELSE
         PrevFidoStr:=FidoStr;

     Quit:=FALSE;
     REPEAT
           FieldEdit;

           {## add protection against duplicate system node numbers?}

           Quit:=TRUE;
           IF (PrevFidoStr <> '') AND (FidoStr <> PrevFidoStr) THEN
           BEGIN
                { find usage }
                ListDefine (2,5,77,15,Default,'Current system node number usage',0);

                ListAddItem ('You are about to replace',0,Bottom);
                ListAddItem ('  system node number '+DeleteBackSpaces (PrevFidoStr),0,Bottom);
                ListAddItem ('    with node number '+DeleteBackSpaces (FidoStr),0,Bottom);

                ListAddItem ('',0,Bottom);
                ListAddItem ('This AKA is currently...',0,Bottom);

                AddAkaUsageToList (Aka);

                { could accept if ListItemCount < some limit }

                ListShow (Single,{active:}FALSE);
                ListUpdateWindow ({active:}FALSE,{LineOffset:}0,{CursorLine:}0);

                MenuDefine (35,17,'What do you want to do?');
                MenuAddItem ('Continue editing');
                MenuAddItem ('Exit without saving');
                MenuAddItem ('Make the change');
                MenuShow;

                CASE MenuSelect OF
                     kEsc,
                     mOpt01 :
                         Quit:=FALSE;

                     mOpt02 :
                         BEGIN
                              { exit without saving }
                              FidoStr:=PrevFidoStr;
                              Quit:=TRUE;
                         END;
                END; { case }

                MenuErase;
                ListErase;
           END;

     UNTIL Quit;

     FidoSplit (DeleteBackSpaces (FidoStr),Config.NodeNrs[Aka]);
     Val (DeleteBackSpaces (PointStr),Config.PointNets[Aka],Nop);

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ EditSystemNodeNrs                                                        }
{                                                                          }
PROCEDURE EditSystemNodeNrs; FAR;

VAR AkaLp   : AkaIndexType;
    FieldNr : FieldNrType;
    Keuze   : WORD;
    Quit    : BOOLEAN;
    Prev,
    Next    : FieldNrType;
    OldLine : STRING[100];

BEGIN
     { Het zelfde als eerst, maar nu via een select lijst }
     ListDefine (3,3,70,Video.Rows-4,Default,
                 'System node numbers',
                 htr_SysFTN_System_node_numbers);

     FOR AkaLp:=1 TO MaxAkas DO
         ListAddItem (AddUpWithSpaces (50,Fido2Str (Config.NodeNrs[AkaLp]))+
                      AddUpWithPreSpaces (5,Word2String (Config.PointNets[Akalp])),AkaLp,Bottom);

     ListShow (Double,FALSE);

     OldLine:=ListNoTagKeysLine;
     ListNoTagKeysLine:=ListNoTagKeysLine+' ^F2 AKA Usage';

     Quit:=FALSE;
     REPEAT
           Keuze:=ListSelect (NoTag,[kF2]);

           CASE Key OF
                kEsc : Quit:=TRUE;

                kF2  : FindSystemNodeNrUsage;

                kRet : BEGIN
                            EditOneSystemNodeNr (Keuze);
                            ListSetItemTekst (Keuze,AddUpWithSpaces (50,Fido2Str (Config.NodeNrs[Keuze]))+
                                                    AddUpWithPreSpaces (5,Word2String (Config.PointNets[Keuze])));
                       END;
           END; { case }

     UNTIL Quit;

     ListNoTagKeysLine:=OldLine;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ EditFTNArchivers                                                         }
{                                                                          }
PROCEDURE EditFTNArchivers (VAR Archivers : FtnArchivers; Title : STRING);

CONST Xb  = 28;
      Yb  = 4;
      Xl  = 47;
      Yl  = 18;
      Xb2 = Xb+8;

VAR ComprLp : CompressionType;
    FieldY  : XYType;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     WriteXY (Xb+1,Yb,' '+Title+' Archivers ');

     FieldPushAll;
     FieldInit;

     FieldY:=Yb;

     FOR ComprLp:=fctARC TO fctGUS DO
     BEGIN
          IF (ComprLp <> fctGUS) THEN
          BEGIN
               Inc (FieldY);
               WriteXY (Xb+2,FieldY,ComprDescr[ComprLp]);
               Archivers.Archive[ComprLp]:=AddUpWithSpaces (MaxLenComprPrgDescr,Archivers.Archive[ComprLp]);
               FieldAutoDefineLongOne (Xb2,FieldY,Xl-(Xb2-Xb)-2,
                                       @Archivers.Archive[ComprLp],
                                       RepChar (MaxLenComprPrgDescr,'$'));
               FieldSetHelp (0,htr_SysFTN_Archivers);
          END;

          IF (ComprLp <> fctOP1) THEN
          BEGIN
               Inc (FieldY);
               IF (ComprLp = fctGUS) THEN
                  WriteXY (Xb+2,FieldY,'GUS')
               ELSE
                   WriteXY (Xb+2,FieldY,'UN'+ComprDescr[ComprLp]);

               Archivers.Unarchive[ComprLp]:=AddUpWithSpaces (MaxLenComprPrgDescr,Archivers.Unarchive[ComprLp]);
               FieldAutoDefineLongOne (Xb2,FieldY,Xl-(Xb2-Xb)-2,
                                       @Archivers.Unarchive[ComprLp],
                                       RepChar (MaxLenComprPrgDescr,'$'));

               IF (ComprLp = fctGUS) THEN
                  FieldSetHelp (0,htr_SysFTN_Unpacking_with_GUS)
               ELSE
                   FieldSetHelp (0,htr_SysFTN_Archivers);
          END;
     END;

     FieldEdit;

     FOR ComprLp:=fctARC TO fctGUS DO
     BEGIN
          IF (ComprLp <> fctGUS) THEN
             Archivers.Archive[ComprLp]:=DeleteFrontAndBackSpaces (Archivers.Archive[ComprLp]);

          Archivers.Unarchive[ComprLp]:=DeleteFrontAndBackSpaces (Archivers.Unarchive[ComprLp]);
     END;

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ EditDosArchivers                                                         }
{                                                                          }
PROCEDURE EditDosArchivers; FAR;

VAR ReadPos   : LONGINT;
    Archivers : FtnArchivers;

BEGIN
     ReadPos:=Flex_DosArchivers_Read (Archivers);
     EditFtnArchivers (Archivers,'DOS');
     Flex_DosArchivers_Write (Archivers,ReadPos);
END;


{--------------------------------------------------------------------------}
{ EditOS2Archivers                                                         }
{                                                                          }
PROCEDURE EditOS2Archivers; FAR;

VAR ReadPos   : LONGINT;
    Archivers : FtnArchivers;

BEGIN
     ReadPos:=Flex_OS2Archivers_Read (Archivers);
     EditFtnArchivers (Archivers,'OS/2');
     Flex_OS2Archivers_Write (Archivers,ReadPos);
END;


{--------------------------------------------------------------------------}
{ SelectAFixGroup                                                          }
{                                                                          }
PROCEDURE SelectAFixGroup; FAR;

VAR Keuze     : WORD;
    Lp        : GroupNrType;
    GroupData : GroupDescRecord;

BEGIN
     ListDefine (Video.Cols-3,3,Video.Cols-10,Video.Rows-4,TopRight,'Select a group',0);

     FOR Lp:=1 TO MaxGroups DO
     BEGIN
          ReadGroupDescRecord (Lp,GroupData);
          ListAddItem (BuildGroupDesc (Lp,GroupData),Lp,Bottom);
     END;

     ListSetCursorOnItem (LastSelectedAFixGroup);

     Keuze:=ListSelect (NoTag,[]);

     IF (Key = kRet) THEN
     BEGIN
          ReadGroupDescRecord (Keuze,GroupData);
          GroupListDesc:=AddUpWithSpaces (30+4,BuildSingleGroupDesc (Keuze)+': '+GroupData.GroupDesc);
          LastSelectedAFixGroup:=Keuze;
     END;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ GrayUnconditional                                                        }
{                                                                          }
PROCEDURE GrayUnconditional; FAR;
BEGIN
     IF (AFixFwdRec.Unconditional) THEN
     BEGIN
          FieldDisableField (4);
          FieldDisableField (5);
     END ELSE
     BEGIN
          FieldEnableField (4);
          FieldEnableField (5);
     END;

     FieldUpdateOneField (4);
     FieldUpdateOneField (5);
END;


{--------------------------------------------------------------------------}
{ AreaListFileMgr                                                          }
{                                                                          }
PROCEDURE AreaListFileMgr (BufferPtr : StringPtr; CheckOnly : BOOLEAN); FAR;
BEGIN
     IF CheckOnly THEN
        Exit;

     BufferPtr^:=AddUpWithSpaces (50,FileManager (DeleteFrontAndBackSpaces (BufferPtr^),'','*.*'));
END;


{--------------------------------------------------------------------------}
{ EditAreafixFwdExportAka                                                  }
{                                                                          }
{ Met deze routine kan de ExportAka gekozen worden.                        }
{                                                                          }
PROCEDURE EditAreafixFwdExportAka; FAR;

VAR AkaLp : 1..MaxAKAs;
    Keuze : WORD;

BEGIN
     ListDefine (40,7,30,Video.Rows-15,Default,'Export AKA selection',4109);

     ListSetConvertRoutine (FidoAkaListConvertFunc);

     FOR AkaLp:=1 TO MaxAKAs DO
         IF (Fido2Str (Config.NodeNrs[AkaLp]) <> '0') THEN
            ListAddItem (Fido2Str (Config.NodeNrs[AkaLp]),AkaLp,Convert);

     ListSetCursorOnItem (AFixFwdRec.ExportAKA);

     Keuze:=ListSelect (NoTag,[]);

     IF (Key = kRet) THEN
        AFixFwdRec.ExportAKA:=Keuze;

     AkaEditStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[AFixFwdRec.ExportAKA]));

     ListErase;
END;


{--------------------------------------------------------------------------}
{ EditAreafixForward                                                       }
{                                                                          }
{ Edit een Areafix forward record in de configuratie.                      }
{                                                                          }
PROCEDURE EditAreafixForward;

CONST Xb = 8;
      Yb = 6;
      Xl = 68;
      Yl = 11;

VAR FidoStr   : FidoAddrString;
    GroupData : GroupDescRecord;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     WITH AFixFwdRec DO
     BEGIN
          FidoStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (UplinkAddress));

          IF (ExportAKA < 1) OR (ExportAKA > MaxAKAs) THEN
          BEGIN
               Error ('Invalid export AKA; reset to first AKA');
               ExportAKA:=1;
          END;

          AkaEditStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[ExportAKA]));

          AreaListPath:=AddUpWithSpaces (50,AreaListPath);
          AreaManager:=AddUpWithSpaces (10,AreaManager);
          Password:=AddUpWithSpaces (10,Password);

          ReadGroupDescRecord (Group,GroupData);
          GroupListDesc:=AddUpWithSpaces (30+4,BuildSingleGroupDesc (Group)+': '+GroupData.GroupDesc);
          LastSelectedAFixGroup:=Group;

          WriteXY (Xb+2,Yb+1,'Address');
          FieldAutoDefineCheckOne (Xb+16,Yb+1,@FidoStr,RepChar (MaxLenFidoAddrstring,'$'),CheckFidoAddr);
          FieldSetHelp (0,htr_SysAFix_Address);

          WriteXY (Xb+2,Yb+2,'Export AKA');
          FieldAutoDefineList (Xb+16,Yb+2,@AkaEditStr,EditAreafixFwdExportAKA);
          FieldSetHelp (0,htr_SysAFix_ExportAKA);

          WriteXY (Xb+2,Yb+3,'Unconditional');
          FieldAutoDefineTogglesCall (Xb+16,Yb+3,Unconditional,'no|yes',0,GrayUnconditional);
          FieldSetHelp (0,htr_SysAFix_Unconditional);

          WriteXY (Xb+2,Yb+4,'Arealist path');
          FieldAutoDefineFileMgr (Xb+16,Yb+4,50,@AreaListPath,AreaListFileMgr,FALSE);
          FieldSetHelp (0,htr_SysAFix_Arealist_path);

          WriteXY (Xb+2,Yb+5,'Arealist type');
          FieldAutoDefineToggles (Xb+16,Yb+5,AreaList,'areas.bbs|name-list',0);
          FieldSetHelp (0,htr_SysAFix_Arealist_type);

          WriteXY (Xb+2,Yb+6,'Area manager');
          FieldAutoDefineOne (Xb+16,Yb+6,@AreaManager,RepChar (10,'$'));
          FieldSetHelp (0,htr_SysaFix_Area_manager);

          WriteXY (Xb+2,Yb+7,'Password');
          FieldAutoDefineOne (Xb+16,Yb+7,@Password,RepChar (10,'$'));
          FieldSetPassword (0);
          FieldSetHelp (0,htr_SysAFix_Password);

          WriteXY (Xb+2,Yb+8,'Group');
          FieldAutoDefineList (Xb+16,Yb+8,@GroupListDesc,SelectAFixGroup);
          FieldSetHelp (0,htr_SysAFix_Group);

          WriteXY (Xb+2,Yb+9,'Add "+"');
          FieldAutoDefineToggles (Xb+16,Yb+9,AddPlus,'no|yes',0);
          FieldSetHelp (0,htr_SysAFix_AddPlus);

          GrayUnconditional;

          FieldEdit;

          Group:=LastSelectedAFixGroup;

          FidoSplit (DeleteBackSpaces (FidoStr),UplinkAddress);
          AreaListPath:=DeleteFrontAndBackSpaces (AreaListPath);
          AreaManager:=DeleteFrontAndBackSpaces (AreaManager);
          Password:=DeleteFrontAndBackSpaces (Password);
     END; { with }

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ EditAreaFixForwardList                                                   }
{                                                                          }
{ Laat een lijstje zien met MaxForward aan entry's.                        }
{                                                                          }
PROCEDURE EditAreaFixForwardList; FAR;

    FUNCTION AFixDesc : STRING;
    BEGIN
         AFixDesc:=BuildSingleGroupDesc (AFixFwdRec.Group)+' '+
                   AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (AFixFwdRec.UplinkAddress));
    END;

VAR Keuze : LONGINT;
    Quit  : BOOLEAN;

BEGIN
     ListDefine (3,3,70,Video.Rows-4,Default,
                 'AreaFix Forward Systems',
                 htr_SysAFix_Area_Request_Forward_Systems);

     {## must use ListSetItemRef instead of Keuze - limits to 64Kb flexcfg.tdb!}
     IF Flex_AreaFixFwd_ReadFirst (AFixFwdRec,Keuze) THEN
        REPEAT
              ListAddItem (AFixDesc,Keuze,Bottom);
        UNTIL (NOT Flex_AreaFixFwd_ReadNext (AFixFwdRec,Keuze));

     Quit:=FALSE;
     REPEAT
           IF (ListItemCount = 0) THEN
              ListAddItem ('<no areafix forward configurations>',65534,Bottom);

           Keuze:=ListSelect (NoTag,[kIns,KDel]);

           ListRemoveItem (65534);

           CASE Key OF
                kEsc :
                    Quit:=TRUE;

                kDel :
                    IF (Keuze <> 65534) THEN
                    BEGIN
                         MenuDefine (30,10,'Are you sure?');
                         MenuAddItem ('Yes, delete this entry');
                         MenuAddItem ('No, keep this entry');
                         MenuShow;
                         MenuSelect;
                         MenuErase;

                         IF (Key = mOpt01) THEN
                         BEGIN
                              Flex_AreaFixFwd_Erase (Keuze);
                              ListRemoveItem (Keuze);
                         END;
                    END;

                kIns :
                    BEGIN
                         Flex_AreaFixFwd_New (Keuze,AFixFwdRec);
                         EditAreaFixForward;
                         Flex_AreaFixFwd_Write (Keuze,AFixFwdRec);
                         ListAddItem (AFixDesc,Keuze,Bottom);
                         ListSetCursorOnItem (Keuze);
                    END;

                kRet :
                    BEGIN
                         Flex_AreaFixFwd_Read (Keuze,AFixFwdRec);
                         EditAreaFixForward;
                         Flex_AreaFixFwd_Write (Keuze,AFixFwdRec);
                         ListSetItemTekst (Keuze,AFixDesc);
                    END;
           END; { case }

     UNTIL Quit;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ CheckRescanDaysLimit                                                     }
{                                                                          }
FUNCTION CheckRescanDaysLimit (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Nop : ValNop;

BEGIN
     Val (DeleteFrontAndBackSpaces (BufferPtr^),Config.RescanDaysLimit,Nop);
     IF (Nop <> 0) THEN
        Config.RescanDaysLimit:=0;

     BufferPtr^:=AddUpWithSpaces (3,Byte2String (Config.RescanDaysLimit));

     CheckRescanDaysLimit:=TRUE; { input accepted }
END;


{--------------------------------------------------------------------------}
{ CheckRescanMsgsLimit                                                     }
{                                                                          }
FUNCTION CheckRescanMsgsLimit (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Nop : ValNop;

BEGIN
     Val (DeleteFrontAndBackSpaces (BufferPtr^),Config.RescanMsgsLimit,Nop);
     IF (Nop <> 0) THEN
        Config.RescanMsgsLimit:=0;

     BufferPtr^:=AddUpWithSpaces (5,Word2String (Config.RescanMsgsLimit));

     CheckRescanMsgsLimit:=TRUE; { input accepted }
END;


{--------------------------------------------------------------------------}
{ EditAreafixSettings                                                      }
{                                                                          }
PROCEDURE EditAreaFixSettings; FAR;

CONST Xb = 12;
      Yb = 7;
      Xl = 62;
      Yl = 11;

      Xb2 = Xb+23;

VAR FieldY  : XYType;
    MsgsStr : STRING[5];
    DaysStr : STRING[3];
    Lp      : INTEGER;

BEGIN
     FixConfigRecord;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     MsgsStr:=AddUpWithSpaces (5,Word2String (Config.RescanMsgsLimit));
     DaysStr:=AddUpWithSpaces (3,Byte2String (Config.RescanDaysLimit));

     FieldPushAll;
     FieldInit;

     FieldY:=Yb;

     FOR Lp := 1 TO MaxAreafixNames DO
     BEGIN
          Inc (FieldY);
          WriteXY (Xb+2,FieldY,'Areafix name '+Integer2String (Lp));
          FieldAutoDefineOne (Xb2,FieldY,@Config.AreafixNames[Lp],RepChar (MaxAreafixNameLen,'$'));
          FieldSetHelp (0,htr_SysFTN_Areafix_name);
     END;

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Kill after AreaFix');
     FieldAutoDefineToggles (Xb2,FieldY,Config.KillAreaFixMsgs,'no|yes',0);
     FieldSetHelp (0,htr_SysFTN_Kill_after_AreaFix);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Rescan message limit');
     FieldAutoDefineCheckOne (Xb2,FieldY,@MsgsStr,'$$$$$',CheckRescanMsgsLimit);
     FieldSetHelp (0,htr_SysFTN_Rescan_Msgs_Limit);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Rescan days limit');
     FieldAutoDefineCheckOne (Xb2,FieldY,@DaysStr,'$$$',CheckRescanDaysLimit);
     FieldSetHelp (0,htr_SysFTN_Rescan_Days_Limit);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Areafix forwarding');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditAreafixForwardList);

     FieldEdit;

     WindowPop;
     FieldPopAll;
     UnfixConfigRecord;
END;


{--------------------------------------------------------------------------}
{ CheckMaxArcLen                                                           }
{                                                                          }
FUNCTION CheckMaxArcLen (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     Config.MaxFidoArcLen:=CheckNumberLimits (BufferPtr,50000,MaxLongint);
     CheckMaxArcLen:=TRUE;
END;


VAR DBridgeFieldNr : FieldNrType;

{--------------------------------------------------------------------------}
{ GrayDBridgeQueueField                                                    }
{                                                                          }
{ This routine grays the D'Bridge queue path field when the mailer type is }
{ not set to d'Bridge.                                                     }
{                                                                          }
PROCEDURE GrayDBridgeQueueField; FAR;
BEGIN
     IF (Config.FidoSystem <> stDBridge) THEN
        FieldDisableField (DBridgeFieldNr)
     ELSE
         FieldEnableField (DBridgeFieldNr);

     FieldUpdateOneField (DBridgeFieldNr);
END;


{--------------------------------------------------------------------------}
{ EditFTNSettings                                                          }
{                                                                          }
PROCEDURE EditFTNSettings;

CONST Xb = 3;
      Xl = 75;
      Yl = 21;

      Xb2 = Xb+22;

VAR FieldY       : XYType;
    MaxArcLenStr : STRING[7];
    Yb           : XYType;

BEGIN
     FixConfigRecord;

     IF (Video.Rows > 25) THEN
        Yb:=3
     ELSE
         Yb:=2;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;

     FieldY:=Yb+1;
     MaxArcLenStr:=AddUpWithSpaces (7,Longint2String (Config.MaxFidoArcLen));

     WriteXY (Xb+2,FieldY,'System node numbers');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditSystemNodeNrs);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Inbound 1');
     FieldAutoDefineFileMgr (Xb2,FieldY,51,@Config.InBound_F[1],PathFileMgr,FALSE);
     FieldSetHelp (0,htr_SysFTN_Inbound);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Security');
     FieldAutoDefineToggles (Xb2,FieldY,Config.Security_F[1],'on|off',0);
     FieldSetHelp (0,htr_SysFTN_Security);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Inbound 2');
     FieldAutoDefineFileMgr (Xb2,FieldY,51,@Config.InBound_F[2],PathFileMgr,FALSE);
     FieldSetHelp (0,htr_SysFTN_Inbound);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Security');
     FieldAutoDefineToggles (Xb2,FieldY,Config.Security_F[2],'on|off',0);
     FieldSetHelp (0,htr_SysFTN_Security);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Outbound dir');
     FieldAutoDefineFileMgr (Xb2,FieldY,51,@Config.OutBound_F,PathFileMgr,FALSE);
     FieldSetHelp (0,htr_SysFTN_Outbound);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Origin 1');
     FieldAutoDefineLongOne (Xb2,FieldY,51,@Config.Origins[1],RepChar (MaxLenOrigin,'$'));
     FieldSetHelp (0,htr_SysFTN_Origin);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Origin 2');
     FieldAutoDefineLongOne (Xb2,FieldY,51,@Config.Origins[2],RepChar (MaxLenOrigin,'$'));
     FieldSetHelp (0,htr_SysFTN_Origin);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Mailer type');
     FieldAutoDefineTogglesCall (Xb2,FieldY,Config.FidoSystem,'binkley|frontdoor|d''bridge',0,GrayDBridgeQueueField);
     FieldSetHelp (0,htr_SysFTN_Mailer_Type);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'D''Bridge queue');
     FieldAutoDefineFileMgr (Xb2,FieldY,51,@Config.DBridgeQueuePath,AnyFileMgr,FALSE);
     FieldSetHelp (0,htr_SysFTN_DBridge_queue);
     DBridgeFieldNr:=FieldGetLastAutoFieldNr;

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Mailer rescan file');
     FieldAutoDefineFileMgr (Xb2,FieldY,51,@Config.RescanFlagFile,AnyFileMgr,FALSE);
     FieldSetHelp (0,htr_SysFTN_Rescan_files);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Editor rescan file');
     FieldAutoDefineFileMgr (Xb2,FieldY,51,@Config.RescanFlagFile2,AnyFileMgr,FALSE);
     FieldSetHelp (0,htr_SysFTN_Rescan_files);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Max archive length');
     FieldAutoDefineCheckOne (Xb2,FieldY,@MaxArcLenStr,RepChar (7,'%'),CheckMaxArcLen);
     FieldSetHelp (0,htr_SysFTN_Maximum_archive_length);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'ARCmail flag');
     FieldAutoDefineToggles (Xb2,FieldY,Config.Mailer_TFS,'kill|truncate',0);
     FieldSetHelp (0,htr_SysFTN_ARCmail_flag);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'ARCmail extensions');
     FieldAutoDefineToggles (Xb2,FieldY,Config.FidoArcmailExtension,'arcmail|hex|all',0);
     FieldSetHelp (0,htr_SysFTN_ARCmail_extensions);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'DOS Archivers');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditDOSArchivers);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'OS/2 Archivers');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditOS2Archivers);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Default archiver');
     FieldAutoDefineToggles (Xb2,FieldY,Config.DefaultCompressor,'arc|arj|lzh|pak|zip|zoo|rar|op1||none',0);
     FieldSetHelp (0,htr_SysFTN_Default_archiver);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Areafix settings');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditAreafixSettings);

     GrayDBridgeQueueField;

     FieldEdit;

     WindowPop;
     UnfixConfigRecord;
END;


{==========================================================================}
{==                                                                      ==}
{==                         RFC SETTINGS                                 ==}
{==                                                                      ==}
{==========================================================================}


{--------------------------------------------------------------------------}
{ EditNewsfixForward                                                       }
{                                                                          }
PROCEDURE EditNewsfixForward;

CONST Xb = 8;
      Yb = 6;
      Xl = 68;
      Yl = 5;

VAR GroupData : GroupDescRecord;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     WITH NFixFwdRec DO
     BEGIN
          ReadGroupDescRecord (Group,GroupData);
          GroupListDesc:=AddUpWithSpaces (30+4,BuildSingleGroupDesc (Group)+': '+GroupData.GroupDesc);
          LastSelectedAFixGroup:=Group;

          UUCPName:=AddUpWithSpaces (10,UUCPName);
          AreaListPath:=AddUpWithSpaces (50,AreaListPath);

          WriteXY (Xb+2,Yb+1,'UUCP name of uplink');
          FieldAutoDefineOne (Xb+26,Yb+1,@UUCPName,RepChar (MaxLenUUCPName,'$'));
          FieldSetHelp (0,htr_SysNFix_UUCPname);

          WriteXY (Xb+2,Yb+2,'Newsgroups listing path');
          FieldAutoDefineFileMgr (Xb+26,Yb+2,40,@AreaListPath,AreaListFileMgr,FALSE);
          FieldSetHelp (0,htr_SysNFix_Newsgroup_listing_path);

          WriteXY (Xb+2,Yb+3,'Group for created areas');
          FieldAutoDefineList (Xb+26,Yb+3,@GroupListDesc,SelectAFixGroup);
          FieldSetHelp (0,htr_SysNFix_Group);

          FieldEdit;

          UUCPName:=DeleteFrontAndBackSpaces (UUCPName);
          AreaListPath:=DeleteFrontAndBackSpaces (AreaListPath);

          Group:=LastSelectedAFixGroup;
     END; { with }

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ EditNewsfixForwardList                                                   }
{                                                                          }
PROCEDURE EditNewsfixForwardList; FAR;

    FUNCTION NFixDesc : STRING;
    BEGIN
         NFixDesc:=BuildSingleGroupDesc (NFixFwdRec.Group)+' '+
                   NFixFwdRec.UUCPName+' '+
                   DeleteBackSpaces (NFixFwdRec.AreaListPath);
    END;

VAR Quit  : BOOLEAN;
    Keuze : LONGINT;

BEGIN
     ListDefine (3,3,70,Video.Rows-4,Default,
                 'NewsFix Forwarding Configuration',
                 htr_SysNFix_Area_Request_Forward_Systems);

     IF Flex_ReadNewsFixFwd_First (NFixFwdRec,Keuze) THEN
        REPEAT
              ListAddItem (NFixDesc,Keuze,Bottom);
        UNTIL (NOT Flex_ReadNewsFixFwd_Next (NFixFwdRec,Keuze));

     Quit:=FALSE;
     REPEAT
           IF (ListItemCount = 0) THEN
              ListAddItem ('<no newsfix forward configurations>',65534,Bottom);

           Keuze:=ListSelect (NoTag,[kIns,KDel]);

           ListRemoveItem (65534);

           CASE Key OF
                kEsc :
                    Quit:=TRUE;

                kDel :
                    BEGIN
                         MenuDefine (30,10,'Are you sure?');
                         MenuAddItem ('Yes, delete this entry');
                         MenuAddItem ('No, keep this entry');
                         MenuShow;
                         MenuSelect;
                         MenuErase;

                         IF (Key = mOpt01) THEN
                         BEGIN
                              Flex_EraseNewsFixFwd (Keuze);
                              ListRemoveItem (Keuze);
                         END;
                    END;

                kIns :
                    BEGIN
                         Flex_NewNewsFixFwd (Keuze,NFixFwdRec);
                         EditNewsFixForward;
                         Flex_WriteNewsFixFwd (Keuze,NFixFwdRec);
                         ListAddItem (NFixDesc,Keuze,Bottom);
                         ListSetCursorOnItem (Keuze);
                    END;

                kRet :
                    BEGIN
                         Flex_ReadNewsFixFwd (Keuze,NFixFwdRec);
                         EditNewsFixForward;
                         Flex_WriteNewsFixFwd (Keuze,NFixFwdRec);
                         ListSetItemTekst (Keuze,NFixDesc);
                    END;
           END; { case }

     UNTIL Quit;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ EditSystemDomains                                                        }
{                                                                          }
PROCEDURE EditSystemDomains; FAR;

CONST Xb = 20;
      Yb = 6;
      Xl = MaxLenDomain+4;
      Yl = MaxSystemDomains+2;

VAR Lp : 1..MaxSystemDomains;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     FOR Lp:=1 TO MaxSystemDomains DO
     BEGIN
          FieldAutoDefineOne (Xb+2,Yb+Lp,@Config.Domains[Lp],RepChar (MaxLenDomain,'$'));
          FieldSetHelp (0,htr_SysRFC_System_domains);
     END;

     FieldEdit;

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ EditUUCPCompressionProgs                                                 }
{                                                                          }
PROCEDURE EditUUCPCompressionProgs; FAR;

CONST Xb = 20;
      Yb = 11;
      Xl = 49;
      Yl = 6;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     WriteXY (Xb+2,Yb+1,'Compress');
     FieldAutoDefineLongOne (Xb+14,Yb+1,33,
                             @Config.ComprPrg_U[Compress,Compr],
                             RepChar (MaxLenComprPrgDescr,'$'));
     FieldSetHelp (0,htr_SysRFC_UUCP_Compression_Programs);

     WriteXY (Xb+2,Yb+2,'De-compress');
     FieldAutoDefineLongOne (Xb+14,Yb+2,33,
                             @Config.ComprPrg_U[Compress,DeCompr],
                             RepChar (MaxLenComprPrgDescr,'$'));
     FieldSetHelp (0,htr_SysRFC_UUCP_Compression_Programs);

     WriteXY (Xb+2,Yb+3,'GZip');
     FieldAutoDefineLongOne (Xb+14,Yb+3,33,
                             @Config.ComprPrg_U[Gzip,Compr],
                             RepChar (MaxLenComprPrgDescr,'$'));
     FieldSetHelp (0,htr_SysRFC_UUCP_Compression_Programs);

     WriteXY (Xb+2,Yb+4,'Un-GZip');
     FieldAutoDefineLongOne (Xb+14,Yb+4,33,
                             @Config.ComprPrg_U[GZip,DeCompr],
                             RepChar (MaxLenComprPrgDescr,'$'));
     FieldSetHelp (0,htr_SysRFC_UUCP_Compression_Programs);

     FieldEdit;

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ CheckDatLength                                                           }
{                                                                          }
FUNCTION CheckDatLength (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     Config.MaxDatLength:=CheckNumberLimits (BufferPtr,10000,MaxLongint);
     CheckDatLength:=TRUE;
END;


{--------------------------------------------------------------------------}
{ CheckRMailLength                                                         }
{                                                                          }
FUNCTION CheckRMailLength (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     Config.MaxRMailLineLen:=CheckNumberLimits (BufferPtr,0,65535);
     CheckRMailLength:=TRUE;
END;


{--------------------------------------------------------------------------}
{ EditUUCPSettings                                                         }
{                                                                          }
PROCEDURE EditUUCPSettings; FAR;

CONST Xb = 5;
      Yb = 6;
      Xl = 70;
      Yl = 10;

      Xb2 = Xb+23;

VAR FieldY         : XYType;
    MaxDatLenStr   : STRING[6];
    MaxRMailLenStr : STRING[5];

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     MaxDatLenStr:=AddUpWithSpaces (6,Longint2String (Config.MaxDatLength));
     MaxRMailLenStr:=AddUpWithSpaces (5,Word2String (Config.MaxRMailLineLen));

     FieldY:=Yb+1;

     WriteXY (Xb+2,FieldY,'Spool directory');
     FieldAutoDefineFileMgr (Xb2,FieldY,Xl-(Xb2-Xb)-2,@Config.SpoolBaseDir,PathFileMgr,FALSE);
     FieldSetHelp (0,htr_SysRFCUUCP_Spool_directory);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Spool mode');
     FieldAutoDefineToggles (Xb2,FieldY,Config.UUPCMode,'uucp|uupc',0);
     FieldSetHelp (0,htr_SysRFCUUCP_SpoolMode);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'System UUCP name');
     FieldAutoDefineOne (Xb2,FieldY,@Config.UUCPName,RepChar (MaxLenUUCPName,'$'));
     FieldSetHelp (0,htr_SysRFCUUCP_UUCP_name);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'World registered');
     FieldAutoDefineToggles (Xb2,FieldY,Config.WorldWide,'no|yes',0);
     FieldSetHelp (0,htr_SysRFCUUCP_World_registered);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Maximum .DAT length');
     FieldAutoDefineCheckOne (Xb2,FieldY,@MaxDatLenStr,RepChar (6,'%'),CheckDatLength);
     FieldSetHelp (0,htr_SysRFCUUCP_Maximum_DAT_length);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Maximum rmail length');
     FieldAutoDefineCheckOne (Xb2,FieldY,@MaxRMailLenStr,RepChar (5,'%'),CheckRMailLength);
     FieldSetHelp (0,htr_SysRFCUUCP_Maximum_rmail_length);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'UUCP filenames');
     FieldAutoDefineToggles (Xb2,FieldY,Config.ForceNoBitmask,'normal|no bitmask',0);
     FieldSetHelp (0,htr_SysRFCUUCP_Force_no_bitmask);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Compression programs');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditUUCPCompressionProgs);

     FieldEdit;

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ CheckMaxXPostNewsgroups                                                  }
{                                                                          }
FUNCTION CheckMaxXPostNewsgroups (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Nop : ValNop;

BEGIN
     Val (DeleteFrontAndBackSpaces (BufferPtr^),Config.MaxXPostNewsgroups,Nop);

     IF (Nop <> 0) THEN
        Config.MaxXPostNewsgroups:=255
     ELSE
         IF (Config.MaxXPostNewsgroups = 0) THEN
            Config.MaxXPostNewsgroups:=255;

     BufferPtr^:=AddUpWithSpaces (3,Byte2String (Config.MaxXPostNewsgroups));
END;


{--------------------------------------------------------------------------}
{ EditSmartHost                                                            }
{                                                                          }
{ This routine builds a list of possible smart-host systems define and     }
{ lets the user have a pick. It warns when no user/link definitions for    }
{ smart-hosts are present.                                                 }
{                                                                          }
PROCEDURE EditSmartHost; FAR;

VAR Cursor,
    UserLp  : WORD;
    UserRec : UserBaseRecord;

BEGIN
     ListDefine (15,6,40,Video.Rows-7,Default,
                 'Possible smart-host systems',
                 htr_SysRFC_SmartHost_PickList);

     Cursor:=0;
     FOR UserLp:=1 TO UserBaseRecCount DO
     BEGIN
          ReadUserBaseRecord (UserLp,UserRec);
          IF (NOT UserRec.Deleted) AND
             (UserRec.System IN [_INETMAIL,_SOUP,_U,_S]) AND
             (UserRec.UucpName <> '') THEN
          BEGIN
               IF (UserRec.System = _U) THEN
                  ListAddItem (UserRec.UucpName+' (UUCP)',UserLp,Sorted)
               ELSE IF (UserRec.System = _S) THEN
                   ListAddItem  (UserRec.UucpName+' (SMTP)',UserLp,Sorted)
               ELSE IF (UserRec.System = _SOUP) THEN
                   ListAddItem (UserRec.UucpName+' (SOUP)',UserLp,Sorted)
               ELSE
                   ListAddItem (UserRec.UucpName+' (INET.MAIL)',UserLp,Sorted);

               IF (AddUpWithSpaces (MaxLenUUCPName,UserRec.UucpName) = Config.SmartHost) THEN
                  Cursor:=UserLp;
          END;
     END;

     ListAdditem ('<no smarthost>',0,Bottom);

     {
     IF (ListItemCount = 0) THEN
     BEGIN
          Error ('Add a UUCP user definition, or an SMTP, SOUP, or INET.MAIL link first.');
          ListErase;
          Exit;
     END;
     }

     ListSetCursorOnItem (Cursor);

     UserLp:=ListSelect (NoTag,[]);

     ListErase;

     IF (Key <> kEsc) THEN
     BEGIN
          IF (UserLp = 0) THEN
             UserRec.UUCPName:=''  { no smarthost }
          ELSE
              ReadUserBaseRecord (UserLp,UserRec);
          Config.SmartHost:=AddUpWithSpaces (MaxLenUUCPName,UserRec.UucpName);
     END;
END;


{--------------------------------------------------------------------------}
{ EditRFCSettings                                                          }
{                                                                          }
PROCEDURE EditRFCSettings;

CONST Xb = 3;
      Yb = 3;
      Xl = 74;
      Yl = 16;

      Xb2 = Xb+21;

VAR FieldY       : XYType;
    CrossPostStr : STRING[3];

BEGIN
     FixConfigRecord;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;

     FieldY:=Yb+1;

     CrossPostStr:=AddUpWithSpaces (3,Byte2String (Config.MaxXPostNewsgroups));

     WriteXY (Xb+2,FieldY,'Organization');
     FieldAutoDefineLongOne (Xb2,FieldY,Xl-Xb2+1,@Config.Organization,RepChar (MaxLenOrganization,'$'));
     FieldSetHelp (0,htr_SysRFC_Organization);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Smart host');
     FieldAutoDefineList (Xb2,FieldY,@Config.SmartHost,EditSmartHost);
     FieldSetHelp (0,htr_SysRFC_SmartHost);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'System domains');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditSystemDomains);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Time zone');
     FieldAutoDefineOne (Xb2,FieldY,@Config.TimeZone,RepChar (25,'$'));
     FieldSetHelp (0,htr_SysRFC_Time_zone);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Undeliverable mail');
     FieldAutoDefineToggles (Xb2,FieldY,Config.BounceUnknown,'netmail|bounce|delete',0);
     FieldSetHelp (0,htr_SysRFC_Undeliverable_mail);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Bounce small');
     FieldAutoDefineToggles (Xb2,FieldY,Config.BounceSmall,'no|yes',0);
     FieldSetHelp (0,htr_SysRFC_Bounce_small);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Cross-post limit');
     FieldAutoDefineCheckOne (Xb2,FieldY,@CrossPostStr,'###',CheckMaxXPostNewsgroups);
     FieldSetHelp (0,htr_SysRFC_Cross_post_limit);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Newsfix name');
     FieldAutoDefineOne (Xb2,FieldY,@Config.NewsfixName,RepChar (10,'$'));
     FieldSetHelp (0,htr_SysRFC_Newsfix_name);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Newsfix forwarding');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditNewsfixForwardList);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'UUCP settings');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditUUCPSettings);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'SMTP forward');
     FieldAutoDefineOne (Xb2,FieldY,@Config.SmtpForward,RepChar (MaxLenDomain,'$'));
     FieldSetHelp (0,htr_SysRFC_SMTP_forward);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Address completion');
     FieldAutoDefineToggles (Xb2,FieldY,Config.RMailCorrect,'add system domain|search headers',1);
     FieldSetHelp (0,htr_SysRFC_Address_completion);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Backbone');
     FieldAutoDefineOne (Xb2,FieldY,@Config.BackBone,RepChar (MaxLenDomain,'$'));
     FieldSetHelp (0,htr_SysRFC_Backbone);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'RFC bad path');
     FieldAutoDefineFileMgr (Xb2,FieldY,Xl-(Xb2-Xb)-2,@Config.RFCBadPath,PathFileMgr,FALSE);
     FieldSetHelp (0,htr_SysRFC_RFCBadPath);

     FieldEdit;

     WindowPop;
     UnfixConfigRecord;
END;


{==========================================================================}
{==                                                                      ==}
{==                   MESSAGE BASE SETTINGS                              ==}
{==                                                                      ==}
{==========================================================================}


{--------------------------------------------------------------------------}
{ FidoFileMgr                                                              }
{                                                                          }
{ Controleerd of een JAM/SQUISH/WC area geen trailing '\' heeft, en plakt  }
{ hem er juist bij voor een Fido *.MSG area. Deze routine is speciaal voor }
{ de Fido MsgBase Settings routine. Aan de hand van het veldnummer wordt   }
{ gekeken naar het netmail, badmail of dupemail pad.                       }
{                                                                          }
PROCEDURE FidoFileMgr (BufferPtr : StringPtr; CheckOnly : BOOLEAN); FAR;

VAR BaseType : FidoMsgStyleType;
    OldLen   : BYTE;

BEGIN
     CASE LastFieldNr OF
          2 : BaseType:=Config.FidoNetmailType;   { netmail path }
          7 : BaseType:=Config.FidoBadAreaType;   { badmail path }
          9 : BaseType:=Config.FidoDupeAreaType;  { dupemail path }
     END; { case }

     IF CheckOnly THEN
     BEGIN
          OldLen:=Length (BufferPtr^);
          BufferPtr^:=DeleteFrontAndBackSpaces (BufferPtr^);

          IF (BaseType = FidoMsgType) THEN
             BufferPtr^:=CorrectPath (BufferPtr^);

          CheckAndCreatePath (BufferPtr^,(BaseType <> FidoMsgType));

          BufferPtr^:=AddUpWithSpaces (OldLen,BufferPtr^);
          Exit;
     END;

     MsgBaseFileMgr (BufferPtr,BaseType);
END;


{--------------------------------------------------------------------------}
{ GrayNetFilesPath                                                         }
{                                                                          }
PROCEDURE GrayNetFilesPath; FAR;
BEGIN
     IF Config.NetmailDecode THEN
        FieldEnableField (4)
     ELSE
         FieldDisableField (4);

     FieldUpdateOneField (4);
END;


{--------------------------------------------------------------------------}
{ GrayBadPathField                                                         }
{                                                                          }
PROCEDURE GrayBadPathField; FAR;
BEGIN
     IF (Config.FidoBadAreaType <> NoneType) THEN
        FieldEnableField (7)
     ELSE
         FieldDisableField (7);

     FieldUpdateOneField (7);
END;


{--------------------------------------------------------------------------}
{ GrayDupePathField                                                        }
{                                                                          }
PROCEDURE GrayDupePathField; FAR;
BEGIN
     IF (Config.FidoDupeAreaType <> NoneType) THEN
        FieldEnableField (9)
     ELSE
         FieldDisableField (9);

     FieldUpdateOneField (9);
END;


{--------------------------------------------------------------------------}
{ GrayOpusDateField                                                        }
{                                                                          }
PROCEDURE GrayOpusDateField; FAR;
BEGIN
     IF (Config.FidoNetmailType <> FidoMsgType) THEN
        FieldDisableField (5)
     ELSE
         FieldEnableField (5);

     FieldUpdateOneField (5);
END;


{--------------------------------------------------------------------------}
{ EditSystemMsgBases                                                       }
{                                                                          }
PROCEDURE EditSystemMsgBases; FAR;

CONST Xb = 6;
      Yb = 8;
      Xl = 72;
      Yl = 13;

      Xb2 = Xb+20;

VAR FieldY : XYType;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldPushAll;
     FieldInit;

     FieldY:=Yb+1;

     WriteXY (Xb+2,FieldY,'Netmail type');
     FieldAutoDefineTogglesCall (Xb2,FieldY,Config.FidoNetmailType,'msg|squish|jam',1,GrayOpusDateField);
     FieldSetHelp (0,htr_SysMsg_Netmail_type);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Netmail path');
     FieldAutoDefineFileMgr (Xb2,FieldY,50,@Config.FidoNetmailPath,FidoFileMgr,FALSE);
     FieldSetHelp (0,htr_SysMsg_Netmail_path);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Decode files');
     FieldAutoDefineTogglesCall (Xb2,FieldY,Config.NetmailDecode,'no|on import',0,GrayNetFilesPath);
     FieldSetHelp (0,htr_SysMsg_Decode_files);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Files path');
     FieldAutoDefineFileMgr (Xb2,FieldY,50,@Config.NetmailDecodePath,PathFileMgr,FALSE);
     FieldSetHelp (0,htr_SysMsg_Files_path);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Opus date format');
     FieldAutoDefineToggles (Xb2,FieldY,Config.OpusDateFormat,'no|yes',0);
     FieldSetHelp (0,htr_SysMsg_Opus_date_format);

     Inc (FieldY);
     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Badmail type');
     FieldAutoDefineTogglesCall (Xb2,FieldY,Config.FidoBadAreaType,'none|msg|squish|jam',0,GrayBadPathField);
     FieldSetHelp (0,htr_SysMsg_Badmail_type);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Badmail path');
     FieldAutoDefineFileMgr (Xb2,FieldY,50,@Config.FidoBadPath,FidoFileMgr,FALSE);
     FieldSetHelp (0,htr_SysMsg_Badmail_path);

     Inc (FieldY);
     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Dupemail type');
     FieldAutoDefineTogglesCall (Xb2,FieldY,Config.FidoDupeAreaType,'none|msg|squish|jam',0,GrayDupePathField);
     FieldSetHelp (0,htr_SysMsg_Dupemail_type);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Dupemail path');
     FieldAutoDefineFileMgr (Xb2,FieldY,50,@Config.FidoDupePath,FidoFileMgr,FALSE);
     FieldSetHelp (0,htr_SysMsg_Dupemail_path);

     GrayNetFilesPath;
     GrayBadPathField;
     GrayDupePathField;

     FieldEdit;

     FieldPopAll;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ CheckMsgLen                                                              }
{                                                                          }
FUNCTION CheckMsgLen (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     CheckNumberLimits (BufferPtr,5000,MaxLongint);
     CheckMsgLen:=TRUE;
END;


{--------------------------------------------------------------------------}
{ EditMessageBaseSettings                                                  }
{                                                                          }
PROCEDURE EditMessageBaseSettings;

CONST Xb = 3;
      Yb = 3;
      Xl = 72;
      Yl = 11;

      Xb2 = Xb+23;

VAR FieldY     : XYType;
    {WcStr,}
    JamStr,
    SquishStr,
    MsgStr     : STRING[11];
    Nop        : ValNop;

BEGIN
     FixConfigRecord;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;

     MsgStr:=AddUpWithSpaces (11,Longint2String (Config.MaxFidoMsgLen));
     SquishStr:=AddUpWithSpaces (11,Longint2String (Config.MaxSquishMsgLen));
     JamStr:=AddUpWithSpaces (11,Longint2String (Config.MaxJamMsgLen));

     FieldY:=Yb+1;

     WriteXY (Xb+2,FieldY,'System message bases');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditSystemMsgBases);

     Inc (FieldY);
     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Auto link');
     FieldAutoDefineToggles (Xb2,FieldY,Config.AutoLink,'no|yes',0);
     FieldSetHelp (0,htr_SysMsg_Auto_link);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Strip SEEN-BY');
     FieldAutoDefineToggles (Xb2,FieldY,Config.StripSeenBy,'no|yes',0);
     FieldSetHelp (0,htr_SysMsg_Strip_SEENBY);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Replace tear');
     FieldAutoDefineToggles (Xb2,FieldY,Config.ReplaceTear,'no|yes',0);
     FieldSetHelp (0,htr_SysMsg_Replace_tear);

     Inc (FieldY);
     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Message size *.MSG');
     FieldAutoDefineCheckOne (Xb2,FieldY,@MsgStr,RepChar (11,'%'),CheckMsgLen);
     FieldSetHelp (0,htr_SysMsg_Message_size);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Message size Squish');
     FieldAutoDefineCheckOne (Xb2,FieldY,@SquishStr,RepChar (11,'%'),CheckMsgLen);
     FieldSetHelp (0,htr_SysMsg_Message_size);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Message size JAM');
     FieldAutoDefineCheckOne (Xb2,FieldY,@JamStr,RepChar (11,'%'),CheckMsgLen);
     FieldSetHelp (0,htr_SysMsg_Message_size);

     FieldEdit;

     Val (DeleteFrontAndBackSpaces (MsgStr),Config.MaxFidoMsgLen,Nop);
     Val (DeleteFrontAndBackSpaces (SquishStr),Config.MaxSquishMsgLen,Nop);
     Val (DeleteFrontAndBackSpaces (JamStr),Config.MaxJamMsgLen,Nop);

     WindowPop;
     UnfixConfigRecord;
END;


{==========================================================================}
{==                                                                      ==}
{==                        GATEWAY SETTINGS                              ==}
{==                                                                      ==}
{==========================================================================}


{--------------------------------------------------------------------------}
{ CheckWrapLineLen                                                         }
{                                                                          }
FUNCTION CheckWrapLineLen (BufferPtr : StringPtr) : BOOLEAN; FAR;

VAR Nop : ValNop;

BEGIN
     Val (DeleteFrontAndBackSpaces (BufferPtr^),Config.WrapLineLen,Nop);

     IF (Nop <> 0) THEN
        Config.WrapLineLen:=72; { default }

     IF (Config.WrapLineLen > 99) THEN
        Config.WrapLineLen:=99;

     IF (Config.WrapLineLen <> 0) AND (Config.WrapLineLen < 50) THEN
     BEGIN
          Error ('Minimum allowed value is 50');
          Config.WrapLineLen:=50;
     END;

     BufferPtr^:=Byte2String (Config.WrapLineLen);

     CheckWrapLineLen:=TRUE;
END;


{--------------------------------------------------------------------------}
{ GrayLineWrapField                                                        }
{                                                                          }
PROCEDURE GrayLineWrapField; FAR;
BEGIN
     IF Config.AlwaysMimeQuotePrint THEN
        FieldDisableField (8)
     ELSE
         FieldEnableField (8);

     FieldUpdateOneField (8);
END;


{--------------------------------------------------------------------------}
{ GrayQuotedPrintableField                                                 }
{                                                                          }
(*
PROCEDURE GrayQuotedPrintableField; FAR;
BEGIN
     IF Config.Allow8Bit THEN
     BEGIN
          FieldDisableField (7);
          FieldDisableField (8);
          FieldUpdateOneField (8);
     END ELSE
     BEGIN
          FieldEnableField (7);
          GrayLineWrapField;
     END;

     FieldUpdateOneField (7);
END;
*)


{--------------------------------------------------------------------------}
{ EditGatewayAKA                                                           }
{                                                                          }
PROCEDURE EditGatewayAKA; FAR;

VAR AkaLp : 1..MaxAkas;
    Keuze : WORD;
    Quit  : BOOLEAN;

BEGIN
     ListDefine (3,3,39,Video.Rows-4,Default,
                 'Select the Gateway AKA',
                 htr_SysGW_Select_gateway_AKA);

     ListSetConvertRoutine (FidoAkaListConvertFunc);

     FOR AkaLp:=1 TO MaxAkas DO
         IF (Fido2Str (Config.NodeNrs[AkaLp]) <> '0') THEN
            ListAddItem (Fido2Str (Config.NodeNrs[AkaLp]),AkaLp,Convert);

     IF (ListItemCount = 0) THEN
     BEGIN
          Error ('Please define a system node number first');
          ListErase;
          Exit;
     END;

     ListSetCursorOnItem (Config.GatewayAka);

     Quit:=FALSE;
     REPEAT
           Keuze:=ListSelect (NoTag,[]);

           CASE Key OF
                kRet : BEGIN
                            Config.GatewayAKA:=Keuze;
                            AkaEditStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[Config.GatewayAKA]));
                            Quit:=TRUE;
                       END;

                kEsc : Quit:=TRUE;
           END; { case }
     UNTIL Quit;

     ListErase;
     FixConfigRecord;
END;


{--------------------------------------------------------------------------}
{ EditCopyHeaders                                                          }
{                                                                          }
PROCEDURE EditCopyHeaders; FAR;

    {----------------------------------------------------------------------}
    { BuildCopyHeadersDescr                                                }
    {                                                                      }
    { Build a description to put in the list.                              }
    {                                                                      }
    FUNCTION BuildCopyHeadersDescr (Index : BYTE) : STRING;

    VAR SelectStr :STRING;

    BEGIN
         CASE Config.CopyHeaderHow[Index] OF
              chNot :    SelectStr:='Don''t copy';
              chKludge : SelectStr:='Copy as kludge';
              chText :   SelectStr:='Copy as plain text';
         END; { case }

         BuildCopyHeadersDescr:=Config.CopyHeaderNames[Index]+' '+SelectStr;
    END;

    {----------------------------------------------------------------------}
    { EditCopyHeaders                                                      }
    {                                                                      }
    { Edit one of the entries. Assume FixConfig has already added spaces   }
    { and UnfixConfig removes them.                                        }
    {                                                                      }
    PROCEDURE EditCopyHeaders (Index : BYTE);

    CONST Xb  = 20;
          Yb  = 10;
          Xl  = 32;
          Yl  = 4;
          Xb2 = Xb+15;

    BEGIN
         FieldPushAll; { Gateway screen }

         WindowPush (Xb,Yb,Xl,Yl);
         BoxDraw (Double,Xb,Yb,Xl,Yl);

         FieldInit;

         WriteXY (Xb+2,Yb+1,'Header name');
         FieldAutoDefineOne (Xb2,Yb+1,
                             @Config.CopyHeaderNames[Index],
                             RepChar (MaxLenCopyHeaderName,'$'));
         FieldSetHelp (0,htr_SysGW_CopyHeaders_Name);

         WriteXY (Xb+2,Yb+2,'Copy whereto');
         FieldAutoDefineToggles (Xb2,Yb+2,
                                 Config.CopyHeaderHow[Index],
                                 'not|kludge|text',0);
         FieldSetHelp (0,htr_SysGW_CopyHeaders_WhereTo);

         FieldEdit;

         WindowPop;
         FieldPopAll;
    END;

{ EditCopyHeaders }

CONST Title = 'E-mail/news headers to copy netmail/echomail';

VAR Lp    : BYTE;
    Keuze : WORD;
    Quit  : BOOLEAN;

BEGIN
     ListDefine (22,3,Length (Title)+4,Video.Rows-4,Default,Title,
                 htr_SysGW_Copy_Headers_Editor);

     FOR Lp:=1 TO MaxCopyHeaders DO
         ListAddItem (BuildCopyHeadersDescr (Lp),Lp,Bottom);

     Quit:=FALSE;
     REPEAT
           Keuze:=ListSelect (NoTag,[]);

           CASE Key OF
                kEsc :
                    Quit:=TRUE;

                kRet :
                    BEGIN
                         EditCopyHeaders (Keuze);
                         ListSetItemTekst (Keuze,BuildCopyHeadersDescr (Keuze));
                    END;

           END; { case }

     UNTIL Quit;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ EditGatewaySettings                                                      }
{                                                                          }
PROCEDURE EditGatewaySettings;

CONST Xb = 3;
      Yb = 3;
      Xl = 75;

      Xb2 = Xb+25;

VAR WrapLineLenStr : STRING[3];
    TransName      : STRING[1];
    TransName2     : STRING[1];
    Yl,FieldY      : XYType;

BEGIN
     FixConfigRecord;

     IF (Video.Rows > 25) THEN
        Yl:=23
     ELSE
         Yl:=21;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;

     TransName:=Config.NameSeparator; { cant edit CHAR as field }
     TransName2:=Config.TransChar2;
     WrapLineLenStr:=Byte2String (Config.WrapLineLen);

     FieldY:=Yb+1;

     AkaEditStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.NodeNrs[Config.GatewayAKA]));

     SetLines (Single);
     WriteXY (Xb2,FieldY,HO+HO+HO+' FTN to RFC '+HO+HO+HO);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Gateway AKA');
     FieldAutoDefineList (Xb2,FieldY,@AkaEditStr,EditGatewayAka);
     FieldSetHelp (0,htr_SysGW_Gateway_AKA);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Gateway user');
     FieldAutoDefineOne (Xb2,FieldY,@Config.GatewayUser,RepChar (MaxLenUserName_F,'$'));
     FieldSetHelp (0,htr_SysGW_Gateway_user);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Accept To:');
     FieldAutoDefineToggles (Xb2,FieldY,Config.FidoAcceptTO,'no|yes',0);
     FieldSetHelp (0,htr_SysGW_AcceptTo);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Kill gated netmail');
     FieldAutoDefineToggles (Xb2,FieldY,Config.KillGatedNetmail,'no|yes',0);
     FieldSetHelp (0,htr_SysGW_Kill_gated_netmail);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Allow headers');
     FieldAutoDefineToggles (Xb2,FieldY,Config.CopyHeaders_FU,'no|yes',0);
     FieldSetHelp (0,htr_SysGW_Allow_headers);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Transport limitation');
     FieldAutoDefineToggles (Xb2,FieldY,Config.Allow8Bit,'7bit|8bit',0);
     FieldSetHelp (0,htr_SysGW_Transport_limitation);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Quoted-printable');
     FieldAutoDefineTogglesCall (Xb2,FieldY,Config.AlwaysMimeQuotePrint,'when needed|always',0,GrayLineWrapField);
     FieldSetHelp (0,htr_SysGW_Quoted_printable);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Line wrap');
     FieldAutoDefineCheckOne (Xb2,FieldY,@WrapLineLenStr,'$$',CheckWrapLineLen);
     FieldSetHelp (0,htr_SysGW_Line_wrap);

     { deze vervangen door default FTN en MIME sets }
     (*
     WriteXY (Xb+2,FieldY,'ASCII Conversion');
     FieldAutoDefineList (Xb2,FieldY,@EnterToEdit,ConfigChangeConvTable);
     FieldSetHelp (0,3040);
     *)

     Inc (FieldY);
     IF (Video.Rows > 25) THEN
        Inc (FieldY);

     WriteXY (Xb2,FieldY,HO+HO+HO+' Both directions '+HO+HO+HO);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Small addresses');
     FieldAutoDefineToggles (Xb2,FieldY,Config.PackedAddresses,'no|yes',0);
     FieldSetHelp (0,htr_SysGW_Small_addresses);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Name separator');
     FieldAutoDefineOne (Xb2,FieldY,@TransName,'$');
     FieldSetHelp (0,htr_SysGW_Name_separator);

     Inc (FieldY);
     IF (Video.Rows > 25) THEN
        Inc (FieldY);

     WriteXY (Xb2,FieldY,HO+HO+HO+' RFC to FTN '+HO+HO+HO);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'FSC-35 kludges?');
     FieldAutoDefineToggles (Xb2,FieldY,Config.ReplyFSC35,'no|yes',0);
     FieldSetHelp (0,htr_SysGW_FSC35_Kludges);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'FTN From:');
     FieldAutoDefineToggles (Xb2,FieldY,Config.HeaderFullname,'e-mail address|full name',0);
     FieldSetHelp (0,htr_SysGW_FTN_From);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Copy headers');
     FieldAutoDefineList (Xb2,FieldY,@DotDotDot,EditCopyHeaders);
     FieldSetHelp (0,htr_SysGW_Copy_headers);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Message-ID to MSGID');
     FieldAutoDefineToggles (Xb2,FieldY,Config.GateMsgId,'no|include',0);
     FieldSetHelp (0,htr_SysGW_MessageID_to_MSGID);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Organization to Origin');
     FieldAutoDefineToggles (Xb2,FieldY,Config.OrganizationInOrigin,'no|yes|override',0);
     FieldSetHelp (0,htr_SysGW_Organization_to_Origin);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Name separator 2');
     FieldAutoDefineOne (Xb2,FieldY,@TransName2,'$');
     FieldSetHelp (0,htr_SysGW_Name_separator_2);

     GrayLineWrapField;

     FieldEdit;

     IF (TransName[1] = ' '{important}) OR
        (Pos (TransName[1],'<>()[]@!%,;:\"') <> 0) THEN
     BEGIN
          Error2Lines (''''+TransName[1]+''' is not a valid Name Separator',
                       'Changing to ''_''');

          TransName[1]:='_';
     END;

     IF (Pos (TransName2[1],'<>()[]@!%,;:\"') <> 0) THEN
     BEGIN
          Error2Lines (''''+TransName2[1]+''' is not valid for Name Separator 2',
                       'Changing to ''_''');

          TransName2[1]:='_';
     END;

     Config.NameSeparator:=TransName[1];
     Config.TransChar2:=TransName2[1];

     WindowPop;

     UnfixConfigRecord;
END;


{==========================================================================}
{==                                                                      ==}
{==                        NEW USER DEFAULTS                             ==}
{==                                                                      ==}
{==========================================================================}


{--------------------------------------------------------------------------}
{ EditDefaultGroupsFTN                                                     }
{                                                                          }
PROCEDURE EditDefaultGroupsFTN (BufferPtr : StringPtr); FAR;
BEGIN
     EditGroupsList (Config.DefGroups_F,
                     'Default groups for new FTN style users',
                     'No groups',
                     htr_SysNew_AllowedGroups,
                     htr_SysNew_NotYetAllowedGroups);
     BufferPtr^:=AddUpWithSpaces (45,BuildGroupListDesc (Config.DefGroups_F,45));
END;


{--------------------------------------------------------------------------}
{ EditDefaultGroupsRFC                                                     }
{                                                                          }
PROCEDURE EditDefaultGroupsRFC (BufferPtr : StringPtr); FAR;
BEGIN
     EditGroupsList (Config.DefGroups_U,
                     'Default groups for new UUCP/BAG style users',
                     'No groups',
                     htr_SysNew_AllowedGroups,
                     htr_SysNew_NotYetAllowedGroups);
     BufferPtr^:=AddUpWithSpaces (45,BuildGroupListDesc (Config.DefGroups_U,45));
END;


{--------------------------------------------------------------------------}
{ CheckNewMaxPktLenFunc                                                    }
{                                                                          }
{ This routine checks the new contents of the Maxmimum PKT Length field,   }
{ stores it in the PKT record and reformats the field on screen.           }
{                                                                          }
FUNCTION CheckNewMaxPktLenFunc (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     Config.NewUserMaxPktSize:=CheckNumberLimits (BufferPtr,50000,MaxLongint);
     CheckNewMaxPktLenFunc:=TRUE;
END;


{--------------------------------------------------------------------------}
{ CheckNewMaxArcLenFunc                                                    }
{                                                                          }
FUNCTION CheckNewMaxArcLenFunc (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     Config.NewUserMaxArcSize:=CheckNumberLimits (BufferPtr,50000,MaxLongint);
     CheckNewMaxArcLenFunc:=TRUE;
END;


{--------------------------------------------------------------------------}
{ EditNewUserDefaults                                                      }
{                                                                          }
PROCEDURE EditNewUserDefaults;

CONST Xb = 3;
      Yb = 3;
      Xl = 75;
      Yl = 13;

      Xb2 = Xb+25;

VAR DefGroupsStr_F : STRING[45];
    DefGroupsStr_U : STRING[45];
    FieldY         : XYType;
    MaxPktLenStr,
    MaxArcLenStr   : STRING[8];
    MailGradeStr,
    NewsGradeStr   : STRING[1];

BEGIN
     FixConfigRecord;

     { system dir wordt gebruikt om de groups database te lezen }
     Config.SystemDir:=DeleteBackSpaces (Config.SystemDir);

     DefGroupsStr_F:=AddUpWithSpaces (45,BuildGroupListDesc (Config.DefGroups_F,45));
     DefGroupsStr_U:=AddUpWithSpaces (45,BuildGroupListDesc (Config.DefGroups_U,45));
     MaxPktLenStr:=AddUpWithSpaces (8,Longint2String (Config.NewUserMaxPktSize));
     MaxArcLenStr:=AddUpWithSpaces (8,Longint2String (Config.NewUserMaxArcSize));
     MailGradeStr:=Config.NewUserMailGrade;
     NewsGradeStr:=Config.NewUserNewsGrade;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;

     FieldY:=Yb+1;

     WriteXY (Xb+2,FieldY,'Notify');
     FieldAutoDefineToggles (Xb2,FieldY,Config.NewUserNotify,'no|yes',0);
     FieldSetHelp (0,htr_SysNewUser_Notify);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'FTN user groups');
     FieldAutoDefineEdit (Xb2,FieldY,@DefGroupsStr_F,EditDefaultGroupsFTN);
     FieldSetHelp (0,htr_SysNewUser_FTNGroups);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Compression');
     FieldAutoDefineToggles (Xb2,FieldY,Config.NewUserFTNCompressor,'arc|arj|lzh|pak|zip|zoo|rar|op1||none',0);
     FieldSetHelp (0,htr_SysNewUser_FTNCompression);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Send format');
     FieldAutoDefineToggles (Xb2,FieldY,Config.NewUserSendFormat,'normal|hold|crash|direct|mailtunnel|seat',0);
     FieldSetHelp (0,htr_SysNewUser_SendFormat);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Max. PKT length');
     FieldAutoDefineCheckOne (Xb2,FieldY,@MaxPktLenStr,RepChar (8,'%'),CheckNewMaxPktLenFunc);
     FieldSetHelp (0,htr_SysNewUser_MaxPktLength);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Max. ARC length');
     FieldAutoDefineCheckOne (Xb2,FieldY,@MaxArcLenStr,RepChar (8,'%'),CheckNewMaxArcLenFunc);
     FieldSetHelp (0,htr_SysNewUser_MaxArcLength);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'UUCP/BAG user groups');
     FieldAutoDefineEdit (Xb2,FieldY,@DefGroupsStr_U,EditDefaultGroupsRFC);
     FieldSetHelp (0,htr_SysNewUser_RFCGroups);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'UUCP Compression');
     FieldAutoDefineToggles (Xb2,FieldY,Config.NewUserUUCPCompress,'none|compress|gzip',0);
     FieldSetHelp (0,htr_SysNewUser_RFCCompression);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Add batch header');
     FieldAutoDefineToggles (Xb2,FieldY,Config.NewUserAddBatchHdr,'no|yes',0);
     FieldSetHelp (0,htr_SysNewUser_AddBatchHeader);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Mail grade');
     FieldAutoDefineOne (Xb2,FieldY,@MailGradeStr,'@');
     FieldSetHelp (0,htr_SysNewUser_Mail_and_news_grades);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'News grade');
     FieldAutoDefineOne (Xb2,FieldY,@NewsGradeStr,'@');
     FieldSetHelp (0,htr_SysNewUser_Mail_and_news_grades);

     FieldEdit;

     Config.NewUserMailGrade:=MailGradeStr[1];
     Config.NewUserNewsGrade:=NewsGradeStr[1];

     WindowPop;
     UnfixConfigRecord;
END;


{--------------------------------------------------------------------------}
{ CheckDefaultDays                                                         }
{                                                                          }
FUNCTION CheckDefaultDays (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     Config.DefDaysToKeep_F:=CheckNumberLimits (BufferPtr,DefaultFidoAge,32767);
     CheckDefaultDays:=TRUE; { no problems }
END;


{--------------------------------------------------------------------------}
{ CheckDefaultNumber                                                       }
{                                                                          }
FUNCTION CheckDefaultNumber (BufferPtr : StringPtr) : BOOLEAN; FAR;
BEGIN
     Config.DefNumbToKeep_F:=CheckNumberLimits (BufferPtr,DefaultFidoLimit,32767);
     CheckDefaultNumber:=TRUE; { no problems }
END;


{--------------------------------------------------------------------------}
{ EditNewAreaDefaults                                                      }
{                                                                          }
PROCEDURE EditNewAreaDefaults; FAR;

CONST Xb = 6;
      Yb = 7;
      Xl = 72;
      Yl = 6;

      Xb2 = Xb+20;

VAR FieldY  : XYType;
    NumStr,
    DaysStr : STRING[5];

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;

     FieldY:=Yb+1;

     NumStr:=AddUpWithSpaces (5,Word2String (Config.DefNumbToKeep_F));
     DaysStr:=AddUpWithSpaces (5,Word2String (Config.DefDaysToKeep_F));
     Config.DefaultFidoMsgPath:=AddUpWithSpaces (79,Config.DefaultFidoMsgPath);

     WriteXY (Xb+2,FieldY,'Msg base type');
     FieldAutoDefineToggles (Xb2,FieldY,Config.FidoAutoCreateType,'pass-through|msg|squish|jam',0);
     FieldSetHelp (0,htr_SysNewArea_MsgBaseType);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Default number');
     FieldAutoDefineCheckOne (Xb2,FieldY,@NumStr,'%%%%%',CheckDefaultNumber);
     FieldSetHelp (0,htr_SysNewArea_DefaultNumber);

     Inc (FieldY);
     WriteXY (Xb+2,FieldY,'Default days');
     FieldAutoDefineCheckOne (Xb2,FieldY,@DaysStr,'%%%%%',CheckDefaultDays);
     FieldSetHelp (0,htr_SysNewArea_DefaultDays);

     Inc (FieldY);
     WriteXy (Xb+2,FieldY,'Default new path');
     FieldAutoDefineFileMgr (Xb2,FieldY,50,@Config.DefaultFidoMsgPath,PathFileMgr,FALSE);
     FieldSetHelp (0,htr_SysNewArea_DefaultNewPath);

     FieldEdit;

     Config.DefaultFidoMsgPath:=DeleteFrontAndBackSpaces (Config.DefaultFidoMsgPath);

     WindowPop;
END;


{==========================================================================}
{==                                                                      ==}
{==                        ADMINISTRATOR SETTINGS                        ==}
{==                                                                      ==}
{==========================================================================}


{--------------------------------------------------------------------------}
{ ChangeAdminSettings_TypeHasChanged                                       }
{                                                                          }
PROCEDURE ChangeAdminSettings_TypeHasChanged; FAR;

VAR Ok1,Ok2,Ok3 : BOOLEAN;
    Lp          : BYTE;

BEGIN
     CASE Config.AdminAddrType OF
          0 : BEGIN
                   { disabled }
                   Ok1:=FALSE;
                   Ok2:=FALSE;
                   Ok3:=FALSE;
              END;

          1 : BEGIN
                   { fido }
                   Ok1:=TRUE;
                   Ok2:=FALSE;
                   Ok3:=TRUE;
              END;

          2 : BEGIN
                   { usenet }
                   Ok1:=FALSE;
                   Ok2:=TRUE;
                   Ok3:=TRUE;
              END;
     END; { case }

     IF Ok1 THEN
     BEGIN
          FieldEnableField (2);
          FieldEnableField (3);
     END ELSE
     BEGIN
          FieldDisableField (2);
          FieldDisableField (3);
     END;

     FieldUpdateOneField (2);
     FieldUpdateOneField (3);

     IF Ok2 THEN
        FieldEnableField (4)
     ELSE
         FieldDisableField (4);

     FieldUpdateOneField (4);

     FOR Lp:=5 TO 20 DO
     BEGIN
          IF Ok3 THEN
             FieldEnableField (Lp)
          ELSE
              FieldDisableField (Lp);

          FieldUpdateOneField (Lp);
     END; { for }
END;


{--------------------------------------------------------------------------}
{ EditAdministratorSettings                                                }
{                                                                          }
PROCEDURE EditAdministratorSettings;

CONST Xb = 20;
      Yb = 4;
      Xl = 55;
      Yl = 15;

      Xb2 = 37;

VAR FidoStr : STRING[MaxLenFidoAddrString];
    Lp      : BYTE;

BEGIN
     FixConfigRecord;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FidoStr:=AddUpWithSpaces (MaxLenFidoAddrString,Fido2Str (Config.AdminFidoAddr));

     FieldInit;

     WriteXY (Xb+2,Yb+1,'Administrator Settings');

     WriteXY (Xb+2,Yb+3,'Address type');
     FieldAutoDefineTogglesCall (Xb2,Yb+3,Config.AdminAddrType,'disable|netmail|e-mail',0,ChangeAdminSettings_TypeHasChanged);
     FieldSetHelp (0,htr_SysAdmin_AddressType);

     WriteXY (Xb+2,Yb+5,'FTN username');
     FieldAutoDefineOne (Xb2,Yb+5,@Config.AdminFidoName,RepChar (MaxLenUserName_F,'$'));
     FieldSetHelp (0,htr_SysAdmin_FTNUserName);

     WriteXY (Xb+2,Yb+6,'FTN address');
     FieldAutoDefineLongOne (Xb2,Yb+6,36,@FidoStr,RepChar (MaxLenFidoAddrstring,'$'));
     FieldSetHelp (0,htr_SysAdmin_FTNAddress);

     WriteXY (Xb+2,Yb+8,'E-mail address');
     FieldAutoDefineLongOne (Xb2,Yb+8,36,@Config.AdminUUCPAddr,RepChar (255,'$'));
     FieldSetHelp (0,htr_SysAdmin_EmailAddress);

     WriteXY (Xb+2,Yb+10,'Send copy of part added to log?');
     FieldAutoDefineToggles (Xb+35,Yb+10,Config.AdminSendLog,'no|yes',0);
     FieldSetHelp (0,htr_SysAdmin_SendLog);

     WriteXY (Xb+2,Yb+11,'CC: of AreaFix Forward Requests?');
     FieldAutoDefineToggles (Xb+35,Yb+11,Config.AdminCCAFixFwd,'no|yes',0);
     FieldSetHelp (0,htr_SysAdmin_CCAFixFwd);

     WriteXY (Xb+2,Yb+13,'(more to come in future releases)');

     ChangeAdminSettings_TypeHasChanged; { initial graying }

     FieldEdit;

     FidoSplit (DeleteFrontAndBackSpaces (FidoStr),Config.AdminFidoAddr);

     WindowPop;
     UnFixConfigRecord;
END;


{--------------------------------------------------------------------------}
{ EditSystemConfig                                                         }
{                                                                          }
PROCEDURE EditSystemConfig;

VAR Quit,
    Quit2 : BOOLEAN;

BEGIN
     MenuDefine (3,3,'System configuration Menu');
     MenuSetHelp (htr_WtrConf_System_Configuration_Menu);
     MenuAddItem ('Global settings');
     MenuAddItem ('FTN settings');
     MenuAddItem ('RFC settings');
     MenuAddItem ('Gateway settings');
     MenuAddItem ('Message base settings');
    {MenuAddItem ('Private mail scan settings');}
     MenuAddItem ('Administrator settings');
     MenuAddItem ('New user defaults');
     MenuAddItem ('New area defaults');
     MenuShow;

     Quit:=FALSE;
     REPEAT
           CASE MenuSelect OF
                mOpt01 : EditGlobalSettings;
                mOpt02 : EditFTNSettings;
                mOpt03 : EditRFCSettings;
                mOpt04 : EditGatewaySettings;
                mOpt05 : EditMessageBaseSettings;
               {mOpt06 : EditPrivateMailScanSettings;}
                mOpt06 : EditAdministratorSettings;
                mOpt07 : EditNewUserDefaults;
                mOpt08 : EditNewAreaDefaults;
                kEsc   : Quit:=TRUE;
           END; { case }

           IF Quit AND ConfigHasChanged THEN
           BEGIN
                MenuDefine (6,Video.Rows-10,'Save changes?');
                MenuSetHelp (htr_WtrConf_Save_System_Configuration);
                MenuAddItem ('Yes');
                MenuAddItem ('No');
                MenuShow;

                { moet een keuze maken, Escape keert terug naar het menu }
                Quit2:=FALSE;
                REPEAT
                      CASE MenuSelect OF
                           mOpt01 : BEGIN
                                         SaveConfigFile;
                                         Quit2:=TRUE;
                                    END;

                           mOpt02 : Quit2:=TRUE;

                           kEsc : BEGIN
                                       Quit2:=TRUE;
                                       Quit:=FALSE;
                                  END;
                      END; { case }
                UNTIL Quit2;

                MenuErase;
           END;

     UNTIL Quit;

     MenuErase;
     UnFixConfigRecord; { ivm healt check }
END;


END.
