PROGRAM RamonTst;

{==========================================================================}
{ (c) Copyright Waterline Software Developent V.O.F. 1990-1994             }
{                                                                          }
{    Waterline Software Development V.O.F.                                 }
{    Wouter Sluislaan 12                                                   }
{    1461 AC  Zuidoostbeemster                                             }
{    The Netherlands                                                       }
{                                                                          }
{ It not allowed to use this user interface in any program not owned by    }
{ the Waterline Software Development V.O.F.                                }
{ Special conditions apply to programs distributed by the Waterline        }
{ Software Development V.O.F. If the source code of any of these programs  }
{ is distributed as well, it is NOT allowed to use the user interface in   }
{ your own programs. Violators may be prosecuted!                          }
{                                                                          }
{ Please contact the Waterline Software Development V.O.F. at the above    }
{ address for your licence to use the "Ramon" user interface. You will get }
{ the most recent copy of the "Ramon" user interface and the "Ramon" user  }
{ interface expert for free. This program helps you design your user       }
{ interfaces at an instance.                                               }
{                                                                          }
{ This copyright notice should remain in this file and all files that are  }
{ part of the user interface "Ramon".                                      }
{==========================================================================}

USES Ramon;

{---------------------------------------------------------------------------}
{ TestCorrectPathName                                                       }
{                                                                           }
PROCEDURE TestCorrectPathName;

CONST Xb = 15;
      Yb = 10;
      Xl = 55;
      Yl = 7;

VAR Path,
    Corrected : STRING[79];
    Quit      : BOOLEAN;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     WriteXY (Xb+2,Yb+2,'Path:');
     WriteXY (Xb+2,Yb+4,'Corrected:');

     Path:=AddUpWithSpaces (79,'C:\vp10\bin');
     Corrected:=Path;

     FieldInit;
     FieldDefineLongOne (1,Xb+13,Yb+2,79,40,0,0,@Path,RepChar (79,'$'));
     FieldDefineLongOne (20,Xb+13,Yb+4,79,40,0,0,@Corrected,RepChar (79,'$'));

     Quit:=FALSE;
     REPEAT
           FieldSetFirst (1);
           FieldEditDirectSpecial ([kF2]);

           CASE Key OF
                kEsc : Quit:=TRUE;

                kRet : BEGIN
                            Corrected:=AddUpWithSpaces (79,CorrectPath (Path));
                            FieldUpdateOneField (20);
                       END;

                kF2 : Path:=AddUpWithSpaces (79,FileManager (Path,FALSE));

           END; { case }
     UNTIL Quit;

     WindowPop; { window }
END;


{---------------------------------------------------------------------------}
{ ListTest                                                                  }
{                                                                           }
PROCEDURE ListTest;

VAR Keuze : WORD;
    Quit  : BOOLEAN;
    Lp    : WORD;

BEGIN
     ListDefine (40,7,40,15,Default,'Dit is een List Test',100);

     ListAddItem ('Ramon van der Winkel',Random (10000),Bottom);
     ListAddItem ('Martijn Dijksterhuis',Random (10000),Bottom);
     ListAddItem ('Thea Ringersma',Random (10000),Bottom);
     ListAddItem ('Nanda Copola',Random (10000),Bottom);
     ListAddItem ('Marcel ten Brake',Random (10000),Bottom);
     ListAddItem ('Maurits van der Winkel',Random (10000),Bottom);
     ListAddItem ('Simone Kleinsma',Random (10000),Bottom);
     ListAddItem ('Andre van Duin',Random (10000),Bottom);
     ListAddItem ('Andre stadt',Random (10000),Bottom);
     ListAddItem ('Joop Stokvis',Random (10000),Bottom);
     ListAddItem ('Ome Schrauwen',Random (10000),Bottom);
     ListAddItem ('Sandra Ringersma',Random (10000),Bottom);
     ListAddItem ('Patrick Schreurs',Random (10000),Bottom);
     ListAddItem ('Jan van der Weide',Random (10000),Bottom);
     ListAddItem ('Michel van der Laan',Random (10000),Bottom);
     ListAddItem ('Ik weet niets meer...',Random (10000),Bottom);

     {
     WriteXY (1,2,Longint2String (MemAvail));
     WHILE (MemAvail > 127000) AND (ListItemCount < 10) DO
           ListAddItem (RepChar (1+Random (40),Chr (32+Random (94))),ListItemCount+1,Bottom);
     }

     {
     Keuze:=0;
     Error ('Cursor will go to item nr '+Word2String (Keuze));
     ListSetCursorOnItem (Keuze);
     }

     Quit:=FALSE;
     REPEAT
           Keuze:=ListSelect (DoTag,[kF2,kF3,kDel]);

           CASE Key OF
                kEsc : Quit:=TRUE;

                kDel : BEGIN
                            MenuDefine (10,10,'Delete this item?');
                            MenuAddItem ('Which item?');
                            MenuShow;
                            MenuSelect;
                            MenuErase;
                       END;

                kF2  : ListAddItem ('Dit is een hele lange hoor!',45,Sorted);
                kF3  : ListRemoveItem (45);

                kRet : IF (ListTagCount = 0) THEN
                          Error ('Selected item was: '+Word2String (Keuze))
                       ELSE
                           FOR Lp:=1 TO ListTagCount DO
                               Error ('One of the tagged items was: '+Word2String (ListGetTaggedItemNr (Lp)));
           END; { case }
     UNTIL Quit;

     ListErase;
END;


{--------------------------------------------------------------------------}
{ main                                                                     }
{                                                                          }
BEGIN
     AssignHelpFile ('RAMONTST.HLP');

     OpenDesktop ('RAMONTST','1.1');

     MenuDefine (10,5,'RamonTest hoofd menu');
     MenuSetHelp (400);
     MenuAddItem ('List test');
     MenuAddItem ('CorrectPathName test');
     MenuAddItem ('Stoppen');
     MenuShow;

     REPEAT
           CASE MenuSelect OF

                mOpt01 : ListTest;

                mOpt02 : TestCorrectPathName;

                mOpt03,
                kEsc   : MenuQuit:=TRUE;
           END; { case }
     UNTIL MenuQuit;

     MenuErase;

     CloseDesktop;
END.
