{ BOX.INC: Box Routines }

{==========================================================================}
{ (c) Copyright Waterline Software Developent V.O.F. 1990-1994             }
{                                                                          }
{    Waterline Software Development V.O.F.                                 }
{    Wouter Sluislaan 12                                                   }
{    1461 AC  Zuidoostbeemster                                             }
{    The Netherlands                                                       }
{                                                                          }
{ It not allowed to use this user interface in any program not owned by    }
{ the Waterline Software Development V.O.F.                                }
{ Special conditions apply to programs distributed by the Waterline        }
{ Software Development V.O.F. If the source code of any of these programs  }
{ is distributed as well, it is NOT allowed to use the user interface in   }
{ your own programs. Violators may be prosecuted!                          }
{                                                                          }
{ Please contact the Waterline Software Development V.O.F. at the above    }
{ address for your licence to use the "Ramon" user interface. You will get }
{ the most recent copy of the "Ramon" user interface and the "Ramon" user  }
{ interface expert for free. This program helps you design your user       }
{ interfaces at an instance.                                               }
{                                                                          }
{ This copyright notice should remain in this file and all files that are  }
{ part of the user interface "Ramon".                                      }
{==========================================================================}

TYPE BoxLinesParts = (bLb,bLon,bRb,bRo,bTb,bTon,bTl,bTr,bHo,bVr,bKr);
     InnerType     = (Clean,Keep);
     ShadowType    = (NoShadow,Shadow);

CONST BoxLinesSets : ARRAY[BoxLines] OF ARRAY[BoxLinesParts] OF CHAR = (
                     ('','','','','','','','','','',''),
                     ('','','','','','','','','','',''));


{--------------------------------------------------------------------------}
{ SetLines                                                                 }
{                                                                          }
{ Zet de lijnstukken voor het opbouwen van schermdelen.                    }
{                                                                          }
PROCEDURE SetLines (Lines : BoxLines);
BEGIN
     Lb:=BoxLinesSets[Lines,bLb];
     Lon:=BoxLinesSets[Lines,bLon];
     Rb:=BoxLinesSets[Lines,bRb];
     Ro:=BoxLinesSets[Lines,bRo];
     Tb:=BoxLinesSets[Lines,bTb];
     Ton:=BoxLinesSets[Lines,bTon];
     Tl:=BoxLinesSets[Lines,bTl];
     Tr:=BoxLinesSets[Lines,bTr];
     Ho:=BoxLinesSets[Lines,bHo];
     Vr:=BoxLinesSets[Lines,bVr];
     Kr:=BoxLinesSets[Lines,bKr];
END;


{--------------------------------------------------------------------------}
{ BoxDrawMain                                                              }
{                                                                          }
{ Teken een box op het scherm vanaf de opgegeven coordinaten met de opge-  }
{ geven lengtes. Als CleanInner gezet is, dan wordt de inhoud van de box   }
{ gewist.                                                                  }
{ LX en LY moeten minimaal 3 zijn.                                         }
{                                                                          }
PROCEDURE BoxDrawMain (X,Y,LX,LY : XYType;
                       Inner     : InnerType;
                       DoShadow  : ShadowType);

VAR TempHo,
    TempSp : STRING;
    Lp     : XYType;
    Offset : WORD;
    A      : BYTE;

BEGIN
     IF (LX < 2) THEN LX:=2;
     IF (LY < 2) THEN LY:=2;

     FillChar (TempHo[1],LX-2,Ho);
     TempHo[0]:=Chr (LX-2);

     IF (Inner = Clean) THEN
     BEGIN
          FillChar (TempSp[1],LX-2,' ');
          TempSp[0]:=Chr (LX-2);
     END;

     WriteXY (X,Y,Lb+TempHo+Rb);

     FOR Lp:=1 TO LY-2 DO
     BEGIN
          WriteXY (X,Y+Lp,Vr);
          IF (Inner = Clean) THEN RWrite (TempSp)
                             ELSE RGotoXY (X+LX-1,Y+Lp);

          Offset:=((Y-1+Lp)*Video.Cols+X+LX-1)*2+1;
          IF (DoShadow = Shadow) THEN
          BEGIN
               {$IFDEF PLATFORM_OS2}
               VioWrtNAttr (ColorAttrs[cBoxShadow,Video.Color],2,Y+Lp-1,X+LX-1,0);
               {$ENDIF}
               {$IFDEF PLATFORM_WIN32}
               Win32WriteNewAttribute (ColorAttrs [cBoxShadow, Video.Color], X+LX-1, Y+Lp-1, 2, 1);
               {$ENDIF}
               {$IFDEF PLATFORM_DOS_ALL}
               Mem[Video.Base:Offset]:=ColorAttrs[cBoxShadow,Video.Color];
               Mem[Video.Base:Offset+2]:=ColorAttrs[cBoxShadow,Video.Color];
               {$ENDIF}
          END;

          RWrite (Vr);
     END;

     WriteXY (X,Y+LY-1,Lon+TempHo+Ro);

     IF (DoShadow = Shadow) THEN
     BEGIN
          {$IFDEF PLATFORM_OS2}
          VioWrtNAttr (ColorAttrs[cBoxShadow,Video.Color],2,Y+LY-2,X+LX-1,0);
          {$ENDIF}
          {$IFDEF PLATFORM_WIN32}
          Win32WriteNewAttribute (ColorAttrs [cBoxShadow, Video.Color], X+LX-1, Y+LY-2, 2, 1);
          {$ENDIF}
          {$IFDEF PLATFORM_DOS_ALL}
          Offset:=((Y+LY-2)*Video.Cols+X+LX-1)*2+1;
          {Inc (Offset,Video.Cols*2);}

          Mem[Video.Base:Offset]:=ColorAttrs[cBoxShadow,Video.Color];
          Mem[Video.Base:Offset+2]:=ColorAttrs[cBoxShadow,Video.Color];
          {$ENDIF}

          {$IFDEF PLATFORM_OS2}
          VioWrtNAttr (ColorAttrs[cBoxShadow,Video.Color],LX,Y+LY-1,X+1,0);
          {$ENDIF}
          {$IFDEF PLATFORM_WIN32}
          Win32WriteNewAttribute (ColorAttrs [cBoxShadow, Video.Color], X+1, Y+LY-1, LX, 1);
          {$ENDIF}
          {$IFDEF PLATFORM_DOS_ALL}
          Offset:=((Y+LY-1)*Video.Cols+X)*2+1;
          FOR Lp:=1 TO LX DO
              Mem[Video.Base:Offset+Lp*2]:=ColorAttrs[cBoxShadow,Video.Color];
          {$ENDIF}
     END;
END;


{--------------------------------------------------------------------------}
{ BoxDraw                                                                  }
{                                                                          }
{ Teken een box in de BoxLinesActive kleuren en de opgegeven Lines set     }
{ vanaf de opgegeven coordinaten (linksboven), met de opgegeven lengtes.   }
{ Het binnendeel van de box wordt gewist.                                  }
{                                                                          }
PROCEDURE BoxDraw (Lines : BoxLines; X,Y,LX,LY : XYType);
BEGIN
     SetColor (cBoxLinesActive);
     SetLines (Lines);
     BoxDrawMain (X,Y,LX,LY,Clean,Shadow);
     SetColor (cBoxBack);
END;


{--------------------------------------------------------------------------}
{ BoxDrawOuter                                                             }
{                                                                          }
{ Like BoxDraw, but it doesn't change the contents inside the box.         }
{                                                                          }
PROCEDURE BoxDrawOuter (Lines : BoxLines; X,Y,LX,LY : XYType);
BEGIN
     SetColor (cBoxLinesActive);
     SetLines (Lines);
     BoxDrawMain (X,Y,LX,LY,Keep,Shadow);
     SetColor (cBoxBack);
END;


{--------------------------------------------------------------------------}
{ BoxDrawC                                                                 }
{                                                                          }
{ Teken een box in de opgegeven kleuren en de opgegeven Lines set vanaf de }
{ opgegeven coordinaten (linksboven), met de opgegeven lengtes.            }
{ Het binnendeel van de box wordt gewist.                                  }
{                                                                          }
PROCEDURE BoxDrawC (Color : ColorSet; Lines : BoxLines; X,Y,LX,LY : XYType);
BEGIN
     SetColor (Color);
     SetLines (Lines);
     BoxDrawMain (X,Y,LX,LY,Clean,Shadow);
     SetColor (cBoxBack);
END;


{--------------------------------------------------------------------------}
{ BoxDrawNS                                                                }
{                                                                          }
{ Deze routine tekent een box zonder dat er een schaduw rand omheen gezet  }
{ wordt. Dit voorkomt overlapping over het einde van het scherm heen.      }
{                                                                          }
PROCEDURE BoxDrawNS (Lines : BoxLines; X,Y,LX,LY : XYType);
BEGIN
     SetColor (cBoxLinesActive);
     SetLines (Lines);
     BoxDrawMain (X,Y,LX,LY,Clean,NoShadow);
     SetColor (cBoxBack);
END;


{--------------------------------------------------------------------------}
{ BoxDrawNSOuter                                                           }
{                                                                          }
{ Like BoxDrawNS, but it doesn't change the contents inside the box.       }
{                                                                          }
PROCEDURE BoxDrawNSOuter (Lines : BoxLines; X,Y,LX,LY : XYType);
BEGIN
     SetColor (cBoxLinesActive);
     SetLines (Lines);
     BoxDrawMain (X,Y,LX,LY,Keep,NoShadow);
     SetColor (cBoxBack);
END;


{--------------------------------------------------------------------------}
{ BoxDrawCNS                                                               }
{                                                                          }
{ Deze routine tekent een box zonder dat er een schaduw rand omheen gezet  }
{ wordt. Dit voorkomt overlapping over het einde van het scherm heen.      }
{                                                                          }
PROCEDURE BoxDrawCNS (Color : ColorSet; Lines : BoxLines; X,Y,LX,LY : XYType);
BEGIN
     SetColor (Color);
     SetLines (Lines);
     BoxDrawMain (X,Y,LX,LY,Clean,NoShadow);
     SetColor (cBoxBack);
END;


{--------------------------------------------------------------------------}
{ SetBoxActive                                                             }
{                                                                          }
{ Maak de kleuren van een box in de BoxLinesActive kleuren.                }
{                                                                          }
PROCEDURE BoxSetActive (X,Y,LX,LY : XYType);
BEGIN
     SetColor (cBoxLinesActive);
     BoxDrawMain (X,Y,LX,LY,Keep,Shadow);
END;


{--------------------------------------------------------------------------}
{ BoxSetInactive                                                           }
{                                                                          }
{ Maak de kleuren van een box in de BoxLinesInactive kleuren.              }
{                                                                          }
PROCEDURE BoxSetInactive (X,Y,LX,LY : XYType);
BEGIN
     SetColor (cBoxLinesInactive);
     BoxDrawMain (X,Y,LX,LY,Keep,Shadow);
END;

