PROGRAM WtrStat;

{ dit programm kan de .STA file van WtrGate verwerken en er wat leuke }
{ grafieken van maken.                                                }

USES Dos,
     RamonX;

CONST Version = '1.21';

TYPE StatRecordPtr = ^StatRecord;
     StatRecord    = RECORD
                           slMailTo,    { "sl" = "sum flow" }
                           slMailFrom,
                           slNewsTo,
                           slNewsFrom,
                           slNetTo,
                           slNetFrom,
                           slEchoTo,
                           slEchoFrom,

                           slTo,
                           slFrom     : LONGINT;

                           snMailTo,    { "sn" = "sum aantal" }
                           snMailFrom,
                           snNewsTo,
                           snNewsFrom,
                           snNetTo,
                           snNetFrom,
                           snEchoTo,
                           snEchoFrom,

                           snTo,
                           snFrom    : LONGINT;

                           System    : STRING[50];

                           NextPtr   : StatRecordPtr;
                     END;

CONST MAXAREAS = 65520 DIV 4;

TYPE AreaArrayPtr = ^AreaArray;
     AreaArray    = ARRAY[1..MAXAREAS] OF LONGINT; { CRC32 / Flow }

VAR StaFile,
    OutFile,
    AreaNamesFile : TEXT;
    FirstStatPtr  : StatRecordPtr;
    AreaCountPtr,
    AreaFlowPtr,
    AreaIndexPtr  : AreaArrayPtr;
    AreaCount     : WORD;
    StatDays      : WORD;
    TakeUUCPName  : BOOLEAN;
    SortAmount    : BOOLEAN;
    CurrDMY       : LONGINT;
    StatStart     : STRING;
    StatStop      : STRING;

{--------------------------------------------------------------------------}
{ CalcDMY                                                                  }
{                                                                          }
FUNCTION CalcDMY (D,M,Y : LONGINT) : LONGINT;

CONST DaysPerMonth : ARRAY[1..12] OF BYTE = (31,28,31,30,31,30,31,31,30,31,30,31);

VAR Result : LONGINT;
    Lp     : BYTE;

BEGIN
     Result:=D;

     IF (M > 1) THEN
        FOR Lp:=M-1 DOWNTO 1 DO
            Result:=Result+DaysPerMonth[Lp];

     Result:=Result+(Y*365);

     CalcDMY:=Result;
END;


{--------------------------------------------------------------------------}
{ AreaIndexAdd                                                             }
{                                                                          }
FUNCTION AreaIndexAdd (CRC : LONGINT) : WORD;
BEGIN
     IF (AreaCount = MAXAREAS) THEN
     BEGIN
          WriteLn ('Too many areas! Maximum is ',MAXAREAS);
          AreaIndexAdd:=0;
     END;

     Inc (AreaCount);
     AreaIndexPtr^[AreaCount]:=CRC;
     AreaFlowPtr^[AreaCount]:=0;
     AreaCountPtr^[AreaCount]:=0;

     AreaIndexAdd:=AreaCount;
END;


{--------------------------------------------------------------------------}
{ FindAreaIndex                                                            }
{                                                                          }
{ Deze routine zoekt naar de index en geeft de offset in het array terug.  }
{ Als de area niet gevonden kon worden, dan wordt 0 terug gegeven.         }
{                                                                          }
FUNCTION FindAreaIndex (CRC : LONGINT) : WORD;

VAR FoundIndex : WORD;
    Found      : BOOLEAN;
    ResultCX   : WORD;

BEGIN
     { scan de tabel in het geheugen }
     Found:=FALSE;

     ASM
        LES DI,AreaIndexPtr  { adres van het buffer ophalen }
        MOV CX,AreaCount     { aantal te doorzoeken }
        SHL CX,1             { *2 omdat we in words zoeken }

        LEA SI,CRC           { hierop controleren }
        SEGSS MOV AX,[SI]    { bx:ax laden met de CRC }
        SEGSS MOV BX,[SI+2]

        CLD                  { vooruit zoeken }
      @Cont:
        REPNE SCASW          { zoek naar AX }
        JCXZ @NotFound       { einde tabel, niet gevonden dus }

        PUSH AX              { wel gevonden, kijk of we aan het begin }
        MOV AX,DI            { van een longint staan, dan is het verkeerd }
        AND AL,3             { omdat SCASW altijd verhoogd controleren we }
        POP AX               { dus of we NU wel aan het begin staan, dan }
                             { stonden we het ten tijd van de controle niet }
        JE @Cont             { niet aan het begin, zoek verder }

        CMP BX,ES:[DI]       { kijk of het tweede deel ook klopt }
        JNE @Cont            { nee, zoek verder }

        MOV Found,TRUE

      @NotFound:
        MOV ResultCX,CX      { 0 of AreaCount-CX = Index }
     END;

     IF Found THEN
        FoundIndex:=AreaCount-(ResultCX DIV 2)
     ELSE
         FoundIndex:=0;

     FindAreaIndex:=FoundIndex;
END;


{--------------------------------------------------------------------------}
{ DateTimeStamp                                                            }
{                                                                          }
{ Deze routine geeft een string in het formaat                             }
{ "Fri 26 Mar 1993 10:34:20"                                               }
{                                                                          }
FUNCTION DateTimeStamp : STRING;

CONST DOWs : ARRAY[0..6] OF STRING[3] = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');

CONST Months : ARRAY[1..12] OF STRING[3] = ('Jan','Feb','Mar','Apr','May','Jun',
                                            'Jul','Aug','Sep','Oct','Nov','Dec');

VAR Y,M,D,DOW,H,Mi,S,SH : WORD;

BEGIN
     GetDate (Y,M,D,DOW);
     GetTime (H,Mi,S,SH);

     CurrDMY:=CalcDMY (D,M,Y);

     DateTimeStamp:=DOWs[DOW]+' '+AddUpWithPre0s (2,Word2String (D))+' '+
                    Months[M]+' '+Word2String (Y)+' '+
                    AddUpWithPre0s (2,Byte2String (H))+':'+
                    AddUpWithPre0s (2,Byte2String (Mi))+':'+
                    AddUpWithPre0s (2,Byte2String (S));
END;


{---------------------------------------------------------------------------}
{ ReadStaFile                                                               }
{                                                                           }
{ Deze routine leest de hele .STA file in en maakt in het geheugen een      }
{ overzicht van de totale flow per systeem en area, waaruit de grafieken    }
{ geproduceert worden.                                                      }
{                                                                           }
{ u MailTo MailFrom NewsTo NewsFrom NetTo NetFrom EchoTo EchoFrom           }
{                                                        SystemName (Sysop) }
{                                                                           }
PROCEDURE ReadStaFile;

CONST MonthTexts : ARRAY[1..12] OF STRING[3] = ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');

VAR Regel       : STRING;
    Option      : CHAR;
    Nop         : INTEGER;
    MailTo,
    MailFrom,
    NewsTo,
    NewsFrom,
    NetTo,
    NetFrom,
    EchoTo,
    EchoFrom    : LONGINT;
    SystemName  : STRING[50];
    Sysop       : STRING[50];

    PrevStatPtr,
    ZoekStatPtr : StatRecordPtr;

    AreaCRC32   : LONGINT;
    AreaIndex   : WORD;
    Flow        : LONGINT;
    Count       : LONGINT;

    Lp          : BYTE;
    D,M         : BYTE;
    Y           : WORD;
    ThisDMY     : LONGINT;
    LastStat    : STRING[50];

BEGIN
     FirstStatPtr:=NIL;
     ThisDMY:=CurrDMY;

     WHILE (NOT Eof (StaFile)) DO
     BEGIN
          ReadLn (StaFile,Regel);

          IF (Regel = '') THEN
             Continue; { met de while }

          { Statistics report of toss on Sun 27 Aug 1995 17:07:47 }
          IF (Copy (Regel,1,20) = 'Statistics report of') THEN
          BEGIN
               Delete (Regel,1,29); { tot aan Sun }

               LastStat:=Regel;

               Delete (Regel,1,4); { dow }

               Val (Copy (Regel,1,2),D,Nop);
               Delete (Regel,1,3);

               M:=0;
               FOR Lp:=1 TO 12 DO
                   IF (MonthTexts[Lp] = Copy (Regel,1,3)) THEN
                   BEGIN
                        M:=Lp;
                   END;

               Delete (Regel,1,4);

               Val (Copy (Regel,1,4),Y,Nop);

               ThisDMY:=CalcDMY (D,M,Y);

               Continue; { met de while }
          END;

          { CurrDMY-ThisDMY StatDays >= }
          {               0    3     N  }
          {               1    3     N  } { 3 dagen OK. Klopt dus }
          {               2    3     N  }
          {               3    3     Y  }
          IF ((CurrDMY-ThisDMY) >= StatDays) THEN
             Continue; { skip this one }

          IF (StatStart = '') THEN
             StatStart:=LastStat;

          StatStop:=LastStat;

          Option:=Regel[1];

          IF (Option = 'a') THEN
          BEGIN
               { area regel }
               { "a 507 ALT.BBS.WATERGATE" }

               Delete (Regel,1,2);

               Val (Copy (Regel,1,Pos (' ',Regel)-1),Flow,Nop);
               Delete (Regel,1,Pos (' ',Regel));

               Regel:=AddUpWithSpaces (60{MaxLenAreaName},Regel);
               AreaCRC32:=UpdateCRC32 (0,Regel[1],Length (Regel));

               AreaIndex:=FindAreaIndex (AreaCRC32);
               IF (AreaIndex = 0) THEN
               BEGIN
                    AreaIndex:=AreaIndexAdd (AreaCRC32);
                    WriteLn (AreaNamesFile,DeleteBackSpaces (Regel));
               END;

               IF (AreaIndex <> 0) THEN
                  Inc (AreaFlowPtr^[AreaIndex],Flow);

               Continue;
          END;

          IF (Option = 'b') THEN
          BEGIN
               { area regel }
               { "b 507 5 ALT.BBS.WATERGATE" }

               Delete (Regel,1,2);

               Val (Copy (Regel,1,Pos (' ',Regel)-1),Count,Nop);
               Delete (Regel,1,Pos (' ',Regel));

               Val (Copy (Regel,1,Pos (' ',Regel)-1),Flow,Nop);
               Delete (Regel,1,Pos (' ',Regel));

               IF (Pos (' ',Regel) > 0) THEN
               BEGIN
                    IF TakeUUCPName THEN
                       Regel:=AddUpWithSpaces (60,Copy (Regel,Pos (' ',Regel)+1,255))
                    ELSE
                        Regel:=Copy (Regel,1,Pos (' ',Regel)-1);
               END ELSE
                   Regel:=AddUpWithSpaces (60{MaxLenAreaName},Regel);

               AreaCRC32:=UpdateCRC32 (0,Regel[1],Length (Regel));

               AreaIndex:=FindAreaIndex (AreaCRC32);
               IF (AreaIndex = 0) THEN
               BEGIN
                    AreaIndex:=AreaIndexAdd (AreaCRC32);
                    WriteLn (AreaNamesFile,DeleteBackSpaces (Regel));
               END;

               IF (AreaIndex <> 0) THEN
               BEGIN
                    Inc (AreaFlowPtr^[AreaIndex],Flow);
                    Inc (AreaCountPtr^[AreaIndex],Count);
               END;

               Continue;
          END;

          IF NOT ((Option IN ['u','v'])) THEN
             Continue;

          Delete (Regel,1,2);

          Val (Copy (Regel,1,Pos (' ',Regel)-1),MailTo,Nop);
          Delete (Regel,1,Pos (' ',Regel));

          Val (Copy (Regel,1,Pos (' ',Regel)-1),MailFrom,Nop);
          Delete (Regel,1,Pos (' ',Regel));

          Val (Copy (Regel,1,Pos (' ',Regel)-1),NewsTo,Nop);
          Delete (Regel,1,Pos (' ',Regel));

          Val (Copy (Regel,1,Pos (' ',Regel)-1),NewsFrom,Nop);
          Delete (Regel,1,Pos (' ',Regel));

          Val (Copy (Regel,1,Pos (' ',Regel)-1),NetTo,Nop);
          Delete (Regel,1,Pos (' ',Regel));

          Val (Copy (Regel,1,Pos (' ',Regel)-1),NetFrom,Nop);
          Delete (Regel,1,Pos (' ',Regel));

          Val (Copy (Regel,1,Pos (' ',Regel)-1),EchoTo,Nop);
          Delete (Regel,1,Pos (' ',Regel));

          Val (Copy (Regel,1,Pos (' ',Regel)-1),EchoFrom,Nop);
          Delete (Regel,1,Pos (' ',Regel));

          SystemName:=Copy (Regel,1,Pos (' ',Regel)-1);
          Delete (Regel,1,Pos (' ',Regel));
          Regel:=DeleteFrontSpaces (Regel);

          ZoekStatPtr:=FirstStatPtr;
          PrevStatPtr:=NIL;
          WHILE (ZoekStatPtr <> NIL) AND (ZoekStatPtr^.System <> SystemName) DO
          BEGIN
               PrevStatPtr:=ZoekStatPtr; { voor linken }
               ZoekStatPtr:=ZoekStatPtr^.NextPtr;
          END; { while }

          IF (ZoekStatPtr = NIL) THEN
          BEGIN
               { not found, add new record }
               GetMem (ZoekStatPtr,SizeOf (StatRecord));
               WITH ZoekStatPtr^ DO
               BEGIN
                    slMailTo:=0;
                    slMailFrom:=0;
                    slNewsTo:=0;
                    slNewsFrom:=0;
                    slNetTo:=0;
                    slNetFrom:=0;
                    slEchoTo:=0;
                    slEchoFrom:=0;

                    slTo:=0;
                    slFrom:=0;

                    snMailTo:=0;
                    snMailFrom:=0;
                    snNewsTo:=0;
                    snNewsFrom:=0;
                    snNetTo:=0;
                    snNetFrom:=0;
                    snEchoTo:=0;
                    snEchoFrom:=0;

                    snTo:=0;
                    snFrom:=0;

                    System:=SystemName;
                    NextPtr:=NIL;
               END; { with }

               { nieuwe record aan de chain hangen }
               IF (PrevStatPtr = NIL) THEN
                  FirstStatPtr:=ZoekStatPtr
               ELSE
                   PrevStatPtr^.NextPtr:=ZoekStatPtr;
          END;

          WITH ZoekStatPtr^ DO
          BEGIN
               IF (Option = 'u') THEN
               BEGIN
                    { found, add these countings }
                    Inc (slMailTo,MailTo);
                    Inc (slMailFrom,MailFrom);
                    Inc (slNewsTo,NewsTo);
                    Inc (slNewsFrom,NewsFrom);
                    Inc (slNetTo,NetTo);
                    Inc (slNetFrom,NetFrom);
                    Inc (slEchoTo,EchoTo);
                    Inc (slEchoFrom,EchoFrom);

                    slTo:=slTo+MailTo+NewsTo+NetTo+EchoTo;
                    slFrom:=slFrom+MailFrom+NewsFrom+NetFrom+EchoFrom;
               END;

               IF (Option = 'v') THEN
               BEGIN
                    Inc (snMailTo,MailTo);
                    Inc (snMailFrom,MailFrom);
                    Inc (snNewsTo,NewsTo);
                    Inc (snNewsFrom,NewsFrom);
                    Inc (snNetTo,NetTo);
                    Inc (snNetFrom,NetFrom);
                    Inc (snEchoTo,EchoTo);
                    Inc (snEchoFrom,EchoFrom);

                    snTo:=snTo+MailTo+NewsTo+NetTo+EchoTo;
                    snFrom:=snFrom+MailFrom+NewsFrom+NetFrom+EchoFrom;
               END;
          END;
     END; { while not eof }
END;


{---------------------------------------------------------------------------}
{ CreateTotalFlowPerSystemListing                                           }
{                                                                           }
{ Deze routine maakt een overzicht van de totale message flow van en naar   }
{ ieder systeem.                                                            }
{                                                                           }
PROCEDURE CreateTotalFlowPerSystemListing;

VAR ZoekStatPtr : StatRecordPtr;

BEGIN
     WriteLn (OutFile,'Summary of messages flow in kilobytes');
     WriteLn (OutFile);
     WriteLn (OutFile,'To            From          System');
     WriteLn (OutFile,RepChar (77,'-'));

     { print the totals in the file }
     ZoekStatPtr:=FirstStatPtr;
     WHILE (ZoekStatPtr <> NIL) DO
           WITH ZoekStatPtr^ DO
           BEGIN
                WriteLn (OutFile,AddUpWithSpaces (14,Longint2String (slTo DIV 1024))+
                                 AddUpWithSpaces (14,Longint2String (slFrom DIV 1024))+
                                 System);

                ZoekStatPtr:=NextPtr;
           END; { with, while }

     WriteLn (OutFile,RepChar (77,'-'));
END;


{---------------------------------------------------------------------------}
{ CreateTotalNumberPerSystemListing                                         }
{                                                                           }
{ Deze routine maakt een overzicht van de totale message flow van en naar   }
{ ieder systeem.                                                            }
{                                                                           }
PROCEDURE CreateTotalNumberPerSystemListing;

VAR ZoekStatPtr : StatRecordPtr;

BEGIN
     WriteLn (OutFile,'Summary of flow in number of messages');
     WriteLn (OutFile);
     WriteLn (OutFile,'To            From          System');
     WriteLn (OutFile,RepChar (77,'-'));

     { print the totals in the file }
     ZoekStatPtr:=FirstStatPtr;
     WHILE (ZoekStatPtr <> NIL) DO
           WITH ZoekStatPtr^ DO
           BEGIN
                WriteLn (OutFile,AddUpWithSpaces (14,Longint2String (snTo))+
                                 AddUpWithSpaces (14,Longint2String (snFrom))+
                                 System);

                ZoekStatPtr:=NextPtr;
           END; { with, while }

     WriteLn (OutFile,RepChar (77,'-'));
END;


{---------------------------------------------------------------------------}
{ CreateTotalFlowToEachSystemGraph                                          }
{                                                                           }
{ Deze routine maakt een overzicht van de totale message flow naar ieder    }
{ systeem.                                                                  }
{                                                                           }
PROCEDURE CreateTotalFlowToEachSystemGraph;

VAR ZoekStatPtr : StatRecordPtr;
    TopTo       : LONGINT;

BEGIN
     WriteLn (OutFile,'Graph showing flow from this system to each system');
     WriteLn (OutFile);

     { bepaal het hoogste totaal }
     TopTo:=0;
     ZoekStatPtr:=FirstStatPtr;
     WHILE (ZoekStatPtr <> NIL) DO
           WITH ZoekStatPtr^ DO
           BEGIN
                IF (slTo > TopTo) THEN
                   TopTo:=slTo;
                ZoekStatPtr:=NextPtr;
           END; { with, while }

     IF (TopTo = 0) THEN
        TopTo:=1;

     { nu voor ieder systeem de graph maken }
     ZoekStatPtr:=FirstStatPtr;
     WHILE (ZoekStatPtr <> NIL) DO
           WITH ZoekStatPtr^ DO
           BEGIN
                WriteLn (OutFile,AddUpWithSpaces (25,System+' ('+Longint2String (slTo DIV 1024)+'k)')+' '+
                                 RepChar (Round (slTo/TopTo*50),''));
                ZoekStatPtr:=NextPtr;
           END;
END;


{---------------------------------------------------------------------------}
{ CreateTotalNumberToEachSystemGraph                                        }
{                                                                           }
{ Deze routine maakt een overzicht van de totale message flow naar ieder    }
{ systeem.                                                                  }
{                                                                           }
PROCEDURE CreateTotalNumberToEachSystemGraph;

VAR ZoekStatPtr : StatRecordPtr;
    TopTo       : LONGINT;

BEGIN
     WriteLn (OutFile,'Graph showing number of messages sent to each system');
     WriteLn (OutFile);

     { bepaal het hoogste totaal }
     TopTo:=0;
     ZoekStatPtr:=FirstStatPtr;
     WHILE (ZoekStatPtr <> NIL) DO
           WITH ZoekStatPtr^ DO
           BEGIN
                IF (snTo > TopTo) THEN
                   TopTo:=snTo;
                ZoekStatPtr:=NextPtr;
           END; { with, while }

     IF (TopTo = 0) THEN
        TopTo:=1;

     { nu voor ieder systeem de graph maken }
     ZoekStatPtr:=FirstStatPtr;
     WHILE (ZoekStatPtr <> NIL) DO
           WITH ZoekStatPtr^ DO
           BEGIN
                WriteLn (OutFile,AddUpWithSpaces (25,System+' ('+Longint2String (snTo)+')')+' '+
                                 RepChar (Round (snTo/TopTo*50),''));
                ZoekStatPtr:=NextPtr;
           END;
END;


{---------------------------------------------------------------------------}
{ CreateTotalFlowFromEachSystemGraph                                        }
{                                                                           }
{ Deze routine maakt een overzicht van de totale message flow van ieder     }
{ systeem.                                                                  }
{                                                                           }
PROCEDURE CreateTotalFlowFromEachSystemGraph;

VAR ZoekStatPtr : StatRecordPtr;
    TopFrom     : LONGINT;

BEGIN
     WriteLn (OutFile,'Graph showing flow from each system to this system');
     WriteLn (OutFile);

     { bepaal het hoogste totaal }
     TopFrom:=0;
     ZoekStatPtr:=FirstStatPtr;
     WHILE (ZoekStatPtr <> NIL) DO
           WITH ZoekStatPtr^ DO
           BEGIN
                IF (slFrom > TopFrom) THEN
                   TopFrom:=slFrom;
                ZoekStatPtr:=NextPtr;
           END; { with, while }

     { nu voor ieder systeem de graph maken }
     ZoekStatPtr:=FirstStatPtr;
     WHILE (ZoekStatPtr <> NIL) DO
           WITH ZoekStatPtr^ DO
           BEGIN
                WriteLn (OutFile,AddUpWithSpaces (25,System+' ('+Longint2String (slFrom DIV 1024)+'k)')+' '+
                                 RepChar (Round (slFrom/TopFrom*50),''));
                ZoekStatPtr:=NextPtr;
           END;
END;


{---------------------------------------------------------------------------}
{ CreateTotalNumberFromEachSystemGraph                                      }
{                                                                           }
{ Deze routine maakt een overzicht van de totale message flow van ieder     }
{ systeem.                                                                  }
{                                                                           }
PROCEDURE CreateTotalNumberFromEachSystemGraph;

VAR ZoekStatPtr : StatRecordPtr;
    TopFrom     : LONGINT;

BEGIN
     WriteLn (OutFile,'Graph showing number of messages received from each system');
     WriteLn (OutFile);

     { bepaal het hoogste totaal }
     TopFrom:=0;
     ZoekStatPtr:=FirstStatPtr;
     WHILE (ZoekStatPtr <> NIL) DO
           WITH ZoekStatPtr^ DO
           BEGIN
                IF (snFrom > TopFrom) THEN
                   TopFrom:=snFrom;
                ZoekStatPtr:=NextPtr;
           END; { with, while }

     IF (TopFrom = 0) THEN
        TopFrom:=1;

     { nu voor ieder systeem de graph maken }
     ZoekStatPtr:=FirstStatPtr;
     WHILE (ZoekStatPtr <> NIL) DO
           WITH ZoekStatPtr^ DO
           BEGIN
                WriteLn (OutFile,AddUpWithSpaces (25,System+' ('+Longint2String (snFrom)+')')+' '+
                                 RepChar (Round (snFrom/TopFrom*50),''));
                ZoekStatPtr:=NextPtr;
           END;
END;


{---------------------------------------------------------------------------}
{ CreateAreaFlowGraph                                                       }
{                                                                           }
{ Deze routine schrijft een overzicht van de totale flow in elke newsgroup. }
{                                                                           }
PROCEDURE CreateAreaFlowGraph;

TYPE SortedArray    = ARRAY[1..MAXAREAS] OF WORD;
     SortedArrayPtr = ^SortedArray;

VAR Lp1,Lp2   : WORD;
    Regel     : STRING;
    TotalFlow : LONGINT;
    SortedPtr : SortedArrayPtr;
    Next      : WORD;

BEGIN
     WriteLn (OutFile,'Flow in bytes for each of the ',AreaCount,' areas');
     WriteLn (OutFile);

     TotalFlow:=0;
     GetMem (SortedPtr,SizeOf (SortedArray));
     FOR Lp1:=1 TO AreaCount DO
     BEGIN
          TotalFlow:=TotalFlow+AreaFlowPtr^[Lp1];
          SortedPtr^[Lp1]:=Lp1;
     END;

     { first... sort the list }
     IF (SortAmount) AND (AreaCount > 1) THEN
        FOR Lp1:=1 TO AreaCount-1 DO
            FOR Lp2:=Lp1+1 TO AreaCount DO
                IF (AreaFlowPtr^[SortedPtr^[Lp2]] > AreaFlowPtr^[SortedPtr^[Lp1]]) THEN
                BEGIN
                     { swappen }
                     Next:=SortedPtr^[Lp1];
                     SortedPtr^[Lp1]:=SortedPtr^[Lp2];
                     SortedPtr^[Lp2]:=Next;
                END;

     Close (AreaNamesFile);
     Reset (AreaNamesFile);
     Next:=1;

     FOR Lp1:=1 TO AreaCount DO
     BEGIN
          Lp2:=SortedPtr^[Lp1]; { deze nu in de lijst zetten }

          IF (Lp2 <> Next) THEN
          BEGIN
               Close (AreaNamesFile);
               Reset (AreaNamesFile);
               Next:=1;

               WHILE (Next <> Lp2) DO
               BEGIN
                    ReadLn (AreaNamesFile,Regel);
                    Inc (Next);
               END;
          END;

          ReadLn (AreaNamesFile,Regel);
          Inc (Next);

          WriteLn (OutFile,AddUpWithPreSpaces (10,Longint2String (AreaFlowPtr^[Lp2]))+
                           AddUpWithPreSpaces (9,Real2String (AreaFlowPtr^[Lp2]/TotalFlow*100,0,1)+'%  ')+
                           Regel);
     END;

     FreeMem (SortedPtr,SizeOf (SortedArray));

     WriteLn (OutFile);
     WriteLn (OutFile,'Total flow is ',TotalFlow,' bytes / ',(TotalFlow DIV 1024),' Kb / ',(TotalFlow DIV 1050466),' Mb');
END;


{---------------------------------------------------------------------------}
{ CreateAreaNumberGraph                                                     }
{                                                                           }
{ Deze routine schrijft een overzicht van het totale aantal berichten in    }
{ iedere newsgroep.                                                         }
{                                                                           }
PROCEDURE CreateAreaNumberGraph;

TYPE SortedArray    = ARRAY[1..MAXAREAS] OF WORD;
     SortedArrayPtr = ^SortedArray;

VAR Lp1,Lp2   : WORD;
    Regel     : STRING;
    Total     : LONGINT;
    SortedPtr : SortedArrayPtr;
    Next      : WORD;

BEGIN
     WriteLn (OutFile,'Flow in message count for each of the ',AreaCount,' areas');
     WriteLn (OutFile);

     { initialise the sort array and calculate the tot flow }
     Total:=0;
     GetMem (SortedPtr,SizeOf (SortedArray));
     FOR Lp1:=1 TO AreaCount DO
     BEGIN
          Total:=Total+AreaCountPtr^[Lp1];
          SortedPtr^[Lp1]:=Lp1;
     END;

     { first... sort the list }
     IF (SortAmount) AND (AreaCount > 1) THEN
        FOR Lp1:=1 TO AreaCount-1 DO
            FOR Lp2:=Lp1+1 TO AreaCount DO
                IF (AreaCountPtr^[SortedPtr^[Lp2]] > AreaCountPtr^[SortedPtr^[Lp1]]) THEN
                BEGIN
                     { swappen }
                     Next:=SortedPtr^[Lp1];
                     SortedPtr^[Lp1]:=SortedPtr^[Lp2];
                     SortedPtr^[Lp2]:=Next;
                END;

     Close (AreaNamesFile);
     Reset (AreaNamesFile);
     Next:=1;

     FOR Lp1:=1 TO AreaCount DO
     BEGIN
          Lp2:=SortedPtr^[Lp1]; { deze nu in de lijst zetten }

          IF (Lp2 <> Next) THEN
          BEGIN
               Close (AreaNamesFile);
               Reset (AreaNamesFile);
               Next:=1;

               WHILE (Next <> Lp2) DO
               BEGIN
                    ReadLn (AreaNamesFile,Regel);
                    Inc (Next);
               END;
          END;

          ReadLn (AreaNamesFile,Regel);
          Inc (Next);

          WriteLn (OutFile,AddUpWithPreSpaces (7,Longint2String (AreaCountPtr^[Lp2]))+
                           AddUpWithPreSpaces (9,Real2String (AreaCountPtr^[Lp2]/Total*100,0,1)+'%  ')+
                           Regel);
     END;

     FreeMem (SortedPtr,SizeOf (SortedArray));

     WriteLn (OutFile);
     WriteLn (OutFile,'Total is ',Total,' messages');
END;


{---------------------------------------------------------------------------}
{ TellUsage                                                                 }
{                                                                           }
{ Deze routine vertelt even hoe het programma gebruikt moet worden.         }
{                                                                           }
PROCEDURE TellUsage;
BEGIN
     WriteLn ('Usage: WTRSTAT <options> <.sta path> <graph nr> [<graph nr> [...]]');
     WriteLn;
     WriteLn ('<.sta path>  is the path to WTRGATE.STA');
     WriteLn ('<graph n nr> is any of the following and selects the graph to produce');
     WriteLn ('             Output filenames are GRAPHn.TXT');
     WriteLn ('             1 - Listing of total flow to/from each system');
     WriteLn ('             2 - Graph of flow in kilobytes to each system');
     WriteLn ('             3 - Graph of flow in kilobytes from each system');
     WriteLn ('             4 - Graph of flow in each area');
     WriteLn ('             5 - Listing of total messages to/from each system');
     WriteLn ('             6 - Graph of message sent to each system');
     WriteLn ('             7 - Graph of message received from each system');
     WriteLn ('             8 - Graph of messages per area');
     WriteLn;
     WriteLn ('Options: -D<n> Show results over the last n days, including today');
     WriteLn ('         -N    Use the UUCP areaname instead of the Fido areaname');
     WriteLn ('         -A    Sort graphs 4 and 8 descending by amount of msgs/flow');
     WriteLn;
     WriteLn ('Example: WTRSTAT WTRGATE.STA 1 7');
END;


{--------------------------------------------------------------------------}
{ main                                                                     }
{                                                                          }

CONST MAX_GRAPHS = 8;

VAR Lp      : BYTE;
    DoGraph : ARRAY[1..MAX_GRAPHS] OF BOOLEAN;
    Param   : STRING;
    StaPath : STRING;

    GraphNr : BYTE;
    Nop     : INTEGER;
    Stamp   : STRING[30];
    IORes   : BYTE;

BEGIN
     WriteLn ('WaterGate Statistics File Processor v',Version);
     WriteLn ('Copyright (c) 1994,1995 Waterline Software Development V.O.F.');
     WriteLn;

     IF (ParamCount = 0) THEN
     BEGIN
          TellUsage;
          Halt (1);
     END;

     FOR Lp:=1 TO MAX_GRAPHS DO
         DoGraph[Lp]:=FALSE;

     StaPath:='';
     StatDays:=65535; { all days }
     TakeUUCPName:=FALSE;
     SortAmount:=FALSE;

     FOR Lp:=1 TO ParamCount DO
     BEGIN
          Param:=ParamStr (Lp);

          Val (Param,GraphNr,Nop);

          IF (Nop = 0) THEN
          BEGIN
               { legale graph nummer }
               IF (GraphNr < 1) OR (GraphNr > MAX_GRAPHS) THEN
               BEGIN
                    WriteLn ('Illegal graph: ',Param);
                    Halt;
               END;

               DoGraph[GraphNr]:=TRUE;
               Continue; { met de for }
          END;

          { kijk of het een optie is }
          IF (Param[1] IN ['-','/']) THEN
          BEGIN
               IF (Length (Param) < 2) THEN
               BEGIN
                    WriteLn ('Illegal: ',Param);
                    Halt;
               END;

               CASE UpCase (Param[2]) OF

                    'N' : BEGIN
                               IF (Length (Param) <> 2) THEN
                               BEGIN
                                    WriteLn ('N option takes NO parameters');
                                    Halt;
                               END;

                               TakeUUCPName:=TRUE;
                               Continue;
                          END;

                    'A' : BEGIN
                               IF (Length (Param) <> 2) THEN
                               BEGIN
                                    WriteLn ('A option takes NO parameters');
                                    Halt;
                               END;

                               SortAmount:=TRUE;
                               Continue;
                          END;

                    'D' : BEGIN
                               { set number of days for report }
                               Delete (Param,1,2);
                               Val (Param,StatDays,Nop);
                               IF (Nop <> 0) THEN
                               BEGIN
                                    WriteLn ('Cannot interpret number in D option: ',Param);
                                    Halt;
                               END;

                               IF (StatDays = 0) THEN
                               BEGIN
                                    WriteLn ('0 is invalid for D option. Minimum is 1 day (today)');
                                    Halt;
                               END;

                               Continue;
                          END;

                    ELSE BEGIN
                         WriteLn ('Unknown option: ',Param);
                         Halt;
                    END;
               END; { case }

               Continue;
          END;

          { niets van dat alles. Dus moet het de filename van de .STA  }
          { file zijn. Als we die al gehad hebben, dan klagen we hard. }
          IF (StaPath <> '') THEN
          BEGIN
               WriteLn ('ONE .sta file is enough!');
               Halt;
          END;

          StaPath:=FExpand (Param);

     END; { for param lp }

     IF (StatDays <> 65535) THEN
        WriteLn ('Generating report over the last ',StatDays,' days');

     Assign (StaFile,StaPath);
     {$I-} Reset (StaFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          WriteLn ('Cannot open .sta file ',StaPath,' (error ',IORes,')');
          Halt (2);
     END;

     Assign (AreaNamesFile,'WTRSTAT.$$$');
     {$I-} ReWrite (AreaNamesFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          WriteLn ('Cannot create temporary file WTRSTAT.$$$ (error ',IORes,')');
          Close (StaFile);
          Halt (2);
     END;

     IF (MaxAvail < (4*SizeOf (AreaArray))) THEN
     BEGIN
          WriteLn ('Not enough memory');
          Halt (2);
     END;

     GetMem (AreaIndexPtr,SizeOf (AreaArray));
     GetMem (AreaFlowPtr,SizeOf (AreaArray));
     GetMem (AreaCountPtr,SizeOf (AreaArray));
     AreaCount:=0;

     Stamp:=DateTimeStamp;
     StatStart:='';
     StatStop:='';

     WriteLn ('Reading statistics file...');
     ReadStaFile;
     Close (StaFile);

     FOR Lp:=1 TO MAX_GRAPHS DO
         IF DoGraph[Lp] THEN
         BEGIN
              Assign (OutFile,'GRAPH'+Byte2String (Lp)+'.TXT');
              {$I-} ReWrite (OutFile); {$I+} IORes:=IOResult;
              IF (IORes <> 0) THEN
                 WriteLn ('Cannot create graph output file GRAPH',Lp,'.TXT (error ',IORes,')')
              ELSE BEGIN
                   WriteLn ('Creating GRAPH',Lp,'.TXT');

                   CASE Lp OF
                        1 : CreateTotalFlowPerSystemListing;
                        2 : CreateTotalFlowToEachSystemGraph;
                        3 : CreateTotalFlowFromEachSystemGraph;
                        4 : CreateAreaFlowGraph;

                        5 : CreateTotalNumberPerSystemListing;
                        6 : CreateTotalNumberToEachSystemGraph;
                        7 : CreateTotalNumberFromEachSystemGraph;
                        8 : CreateAreaNumberGraph;
                   END; { case }

                   WriteLn (OutFile);
                   WriteLn (OutFile);
                   WriteLn (OutFile,'First sample: ',StatStart);
                   WriteLn (OutFile,'Last sample : ',StatStop);
                   WriteLn (OutFile,'Generated on: ',Stamp);
                   WriteLn (OutFile,'WtrStat v',Version);

                   Close (OutFile);
              END;
         END; { for, if }

     Close (AreaNamesFile);
     {$I-} Erase (AreaNamesFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
        WriteLn ('Error deleting temporary file WTRSTAT.$$$ (error',IORes,')');

     FreeMem (AreaIndexPtr,SizeOf (AreaArray));
     FreeMem (AreaFlowPtr,SizeOf (AreaArray));
     FreeMem (AreaCountPtr,SizeOf (AreaArray));
END.
