PROGRAM WtrTest;

{ test program for WaterGate configuration. Simulates WaterGate }

{$IFDEF DPMI}     ### Wrong target! ### {$ENDIF}

{$IFNDEF WtrTest} ### Check your conditional defines! ### {$ENDIF}
{$IFDEF UseOvr}   ### Check your conditional defined! ### {$ENDIF}

{$IFNDEF OS2}
{$IFOPT G+}       ### 286 moet uit staan!             ### {$ENDIF}
{$ENDIF}

USES Globals,
     Ramon,
     Err_Func,
     Cfg,
     Database,
     Logs,
     Keys,
     Routing,
     ReadRout,
     ListSrv,
     UUCPRout,
     Msgs,
     Fido,
     Usenet,
     Language,
     Charsets,
     Tdb,
     BBSUsers,
     Gateway;

VAR FromUser : STRING[MaxLenFromUser_F];
    FromAddr : STRING[MaxLenFidoAddrString];
    ToUser   : STRING[MaxLenFromUser_F];
    ToAddr   : STRING[MaxLenFidoAddrString];
    ToLine   : STRING[50];
    RMail    : STRING;
    DTo      : STRING;
    DFrom    : STRING;

{--------------------------------------------------------------------------}
{ SimulateNetmailMapping                                                   }
{                                                                          }
PROCEDURE SimulateNetmailMapping;

CONST Xb = 5;
      Yb = 2;

VAR Quit  : BOOLEAN;
    Regel : STRING;

BEGIN
     WindowPush (Xb,Yb,73,7);
     BoxDraw (Double,Xb,Yb,73,7);

     FieldInit;

     WriteXY (Xb+2,Yb+1,'From User');
     FieldAutoDefineOne (Xb+12,Yb+1,@FromUser,RepChar (MaxLenFromUser_F,'$'));
     FieldSetHelp (0,10100);

     WriteXY (Xb+2,Yb+2,'From AKA');
     FieldAutoDefineCheckOne (Xb+12,Yb+2,@FromAddr,RepChar (MaxLenFidoAddrString,'$'),CheckFidoAddr);
     FieldSetHelp (0,10100);

     WriteXY (Xb+2,Yb+3,'To User');
     FieldAutoDefineOne (Xb+12,Yb+3,@ToUser,RepChar (MaxLenFromUser_F,'$'));
     FieldSetHelp (0,10100);

     WriteXY (Xb+2,Yb+4,'To AKA');
     FieldAutoDefineCheckOne (Xb+12,Yb+4,@ToAddr,RepChar (MaxLenFidoAddrString,'$'),CheckFidoAddr);
     FieldSetHelp (0,10100);

     WriteXY (Xb+2,Yb+5,'To: line');
     FieldAutoDefineOne (Xb+12,Yb+5,@ToLine,RepChar (50,'$'));
     FieldSetHelp (0,10100);

     Quit:=FALSE;
     REPEAT
           FieldEdit;

           CASE Key OF
                kEsc : Quit:=TRUE;

                kF10 :
                    BEGIN
                         FidoSplit (DeleteBackSpaces (FromAddr),Msg.FromAddr_F);
                         FidoSplit (DeleteBackSpaces (ToAddr),Msg.ToAddr_F);
                         Regel:=DeleteFrontAndBackSpaces (ToLine);

                         LogExtraMessage ('');
                         LogExtraMessage ('-- Processing Simulated Netmail --');

                         LogExtraMessage ('|From "'+DeleteFrontAndBackSpaces (FromUser)+'" '+Fido2Str (Msg.FromAddr_F));
                         LogExtraMessage ('|To "'+DeleteFrontAndBackSpaces (ToUser)+'" '+Fido2Str (Msg.ToAddr_F));
                         LogExtraMessage ('|To: '+Regel);

                         FidoBuildNetmail (
                                       TRUE,
                                       Msg.FromAddr_F,
                                       Msg.ToAddr_F,
                                       DeleteFrontAndBackSpaces (FromUser),
                                       DeleteFrontAndBackSpaces (ToUser),
                                       'Subject');

                         IF (Regel <> '') THEN
                            MsgsAddLineTo (Body,'To: '+Regel);

                         FidoRouteNetmail;
                    END;
           END;

     UNTIL Quit;

     WindowPop;
END;


{--------------------------------------------------------------------------}
{ SimulateEMailMapping                                                     }
{                                                                          }
PROCEDURE SimulateEMailMapping;

CONST Xb = 3;
      Yb = 3;

VAR Quit  : BOOLEAN;
    Regel : STRING;

BEGIN
     WindowPush (Xb,Yb,75,5);
     BoxDraw (Double,Xb,Yb,75,5);

     FieldInit;

     WriteXY (Xb+2,Yb+1,'Envelope address');
     FieldAutoDefineLongOne (Xb+19,Yb+1,54,@RMail,RepChar (255,'$'));
     FieldSetHelp (0,10200);

     WriteXY (Xb+2,Yb+2,'To: header');
     FieldAutoDefineLongOne (Xb+19,Yb+2,54,@DTo,RepChar (255,'$'));
     FieldSetHelp (0,10200);

     WriteXY (Xb+2,Yb+3,'From: header');
     FieldAutoDefineLongOne (Xb+19,Yb+3,54,@DFrom,RepChar (255,'$'));
     FieldSetHelp (0,10200);

     Quit:=FALSE;
     REPEAT
           FieldEdit;

           CASE Key OF
                kEsc : Quit:=TRUE;
                kF10 :
                    BEGIN
                         MsgsEmpty;

                         Msg.XqtTo_U:=DeleteFrontAndBackSpaces (RMail);
                         Msg.ToUser_U:='To: '+DeleteFrontAndBackSpaces (DTo);
                         Msg.FromUser_U:='From: '+DeleteFrontAndBackSpaces (DFrom);
                         Msg.MessageID_U:='Message-ID: <wtrtest@nowhere>';

                         Msg.Ready_U:=Mail;

                         LogExtraMessage ('');
                         LogExtraMessage ('-- Processing Simulated E-mail --');

                         LogExtraMessage ('|Envelope: '+Msg.XqtTo_U);
                         LogExtraMessage ('|'+Msg.ToUser_U);
                         LogExtraMessage ('|'+Msg.FromUser_U);

                         FinishUsenetMsgBuildup;
                         UsenetRouteMail;
                    END;
           END;

     UNTIL Quit;

     WindowPop;
END;


{--------------------------------------------------------------------------}
{ TellAboutMessage                                                         }
{                                                                          }
{ Deze routine geeft de 'About' message op het scherm en wacht daarna op   }
{ een toetsdruk.                                                           }
{                                                                          }
PROCEDURE TellAboutMessage;

CONST Xb = 22;
      Yl = 12;

VAR Yb : XYType;
    Xl : XYType;

BEGIN
     Yb:=(Video.Rows DIV 2)-(Yl DIV 2);
     Xl:=19+Length (FullProgramVersion);
     IF (Xl < 35) THEN Xl:=35;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDrawC (cMessage,Single,Xb,Yb,Xl,Yl);

     PushKeysLine;
     WriteKeysLine (' Press any key to continue...');

     WriteXYC (Xb+2,Yb+1,cMessage,DesktopProgramName+' Test');
     WriteXY (Xb+2,Yb+2,'Version number '+FullProgramVersion);
     WriteXY (Xb+2,Yb+3,'Compiled at '+CompileDateAndTime);
     WriteXY (Xb+2,Yb+5,'Author: Ramon van der Winkel');

     WriteXY (Xb+2,Yb+7,'Support: support@wsd.wline.se');
     WriteXY (Xb+2,Yb+8,RepChar (Xl-4,'' ));

     {$IFDEF DPMI}
     WriteXY (Xb+2,Yb+9,'Mode        : Protected');
     {$ELSE}
     WriteXY (Xb+2,Yb+9,'Mode        : Real');
     {$ENDIF}
     WriteXY (Xb+2,Yb+10,'Free memory : '+Longint2String (MemAvail DIV 1024)+'Kb');

     ReadKey;
     PopKeysLine;
     WindowPop;
END;


{--------------------------------------------------------------------------}
{ ShowRoutingTables                                                        }
{                                                                          }
PROCEDURE ShowRoutingTables;
BEGIN
     ListDefine (1,2,Video.Cols-2,Video.Rows-2,Default,'Routing Tables',10400);
     Routing_ListTables;
     UUCPRouting_ListTables;
     ListSelect (NoTag,[]);
     ListErase;
END;


{--------------------------------------------------------------------------}
{ ChangeControlFlags                                                       }
{                                                                          }
PROCEDURE ChangeControlFlags;

CONST Xb = 25;
      Yb = 10;
      Xl = 42;
      Yl = 9;

      Xb2 = Xb+14;

BEGIN
     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     FieldInit;

     WriteXY (Xb+2,Yb+1,'Processing Controls');

     WriteXY (Xb+2,Yb+3,'-NONETMAIL');
     FieldAutoDefineToggles (Xb2,Yb+3,ForceNoRoute,'no|yes',0);
     FieldSetHelp (0,10300);

     WriteXY (Xb+2,Yb+4,'-NOEXPORT');
     FieldAutoDefineToggles (Xb2,Yb+4,ForceNoExport,'no|yes',0);
     FieldSetHelp (0,10300);

     WriteXY (Xb+2,Yb+5,'-NOLOCAL');
     FieldAutoDefineToggles (Xb2,Yb+5,ForceNoImport,'no|yes',0);
     FieldSetHelp (0,10300);

     WriteXY (Xb+2,Yb+7,'System mode');
     FieldAutoDefineToggles (Xb2,Yb+7,Config.FidoSystem,'binkley|frontdoor|d''bridge',0);
     FieldSetHelp (0,10300);

     FieldEdit;

     WindowPop;
END;


{--------------------------------------------------------------------------}
{ main                                                                     }
{                                                                          }

VAR Quit   : BOOLEAN;
    ReMenu : BOOLEAN;

BEGIN
     WriteLn (DesktopProgramName+' Test v'+FullProgramVersion);
     WriteLn (CopyrightLine);
     WriteLn;

     { lees de configuratie file }
     IF (NOT ReadConfigFile) THEN
     BEGIN
          WriteLn (' Could not find WTRCFG.TDB. Please run WtrConf.'#7);
          Exit;
     END;

     IF (NOT OpenDatabases) OR
        (NOT InitLang (Config.SystemDir)) OR
        (NOT InitCharsets) THEN
     BEGIN
          CloseDatabases;
          WriteLn;
          WriteLn (' Unable to open configuration files'#7);
          WriteLn;
          Halt (1);
     END;

    {WtrCheckKey;}

     DesktopCopyright:='WSD';
     OpenDesktop (DesktopProgramName+' Test',FullProgramVersion);
     WriteKeysLine (' Initializing...');

     LogScreenLines:=Video.Rows-12;
     BoxDrawNS (Single,1,Video.Rows-LogScreenLines-2,80,LogScreenLines+2);
     WriteXY (2,Video.Rows-LogScreenLines-2,' Log ');
     ScreenToo:=TRUE; { logs ook op het scherm afdrukken }

     LogExtraMessage ('');
     LogMessage ('Starting '+DesktopProgramName+' Test v'+FullProgramVersion);

     AssignHelpFile (Config.SystemDir+'WTRGATE.HLP');

     ReadUserBaseIndexTable;
     ReadAreaBaseIndexTable;
     InitRoutingTable;
     ListServerTabelInit;
     LoadDefaultCharsets;

     IF (BBSNormalAreaRecNr <> NILRecordNr) OR
        (BBSEMailAreaRecNr <> NILRecordNr) OR
        (BBSViaRecNr <> NILRecordNr)
     THEN
         ReadBBSUsersIndex (DebugMem);

     LogClose;

     FromUser:=AddUpWithSpaces (MaxLenFromUser_F,Config.Sysop);

     FromAddr:=AddUpWithSpaces (MaxLenFidoAddrString,'0');
     ToUser:=Spaces (MaxLenFromUser_F);
     ToAddr:=AddUpWithSpaces (MaxLenFidoAddrString,'0');
     ToLine:=Spaces (50);
     {
     FromAddr:=AddUpWithSpaces (MaxLenFidoAddrString,'2:200/111.15');
     ToUser:=AddUpWithSpaces (MaxLenFromUser_F,'UUCP');
     ToAddr:=FromAddr;
     ToLine:=AddUpWithSpaces (50,'freetex!Jan.Botter@relay.nl.net');
     }

     RMail:=Spaces (255);
     DTo:=Spaces (255);
     DFrom:=AddUpWithSpaces (255,'ramon@wsd.wline.se (Ramon van der Winkel)');

     Delete (FieldSelectKeysLine,1,Length (F1Help));
     Delete (FieldSelectKeysLine,Pos (',^F10',FieldSelectKeysLine),5);
     Delete (FieldEditKeysLine,1,Length (F1Help));
     Delete (MenuKeysLine,1,Length (F1Help));

     FieldSelectKeysLine:=FieldSelectKeysLine+'    --> ^F10 Execute <--';

     ForceNoRoute:=FALSE;
     ForceNoExport:=FALSE;
     ForceNoImport:=FALSE;

     ReMenu:=TRUE;
     Quit:=FALSE;
     REPEAT
           IF ReMenu THEN
           BEGIN
                MenuDefine (30,4,'Main Menu');
                MenuSetHelp (10000);
                MenuAddItem ('Simulate netmail');
                MenuAddItem ('Simulate e-mail');
                MenuAddItem ('Control flags');
                MenuAddItem ('Routing tables');
                MenuAddItem ('About '+DesktopProgramName+' Test');
                MenuAddItem ('Exit program');
                MenuShow;
                ReMenu:=FALSE;
           END;

           CASE MenuSelect OF

                mOpt01 :
                    BEGIN
                         MenuErase;
                         ReMenu:=TRUE;
                         SimulateNetmailMapping;
                    END;

                mOpt02 :
                    BEGIN
                         MenuErase;
                         ReMenu:=TRUE;
                         SimulateEmailMapping;
                    END;

                mOpt03 : ChangeControlFlags;

                mOpt04 : ShowRoutingTables;

                mOpt05 : TellAboutMessage;

                kEsc,
                mOpt06 : Quit:=TRUE;

           END; { case }

     UNTIL Quit;

     IF (NOT ReMenu) THEN
        MenuErase;

     CloseDatabases;
     JunkBBSUsersIndex;
     JunkUserBaseIndexTable;
     JunkAreaBaseIndexTable;
     JunkListServerTable;
     JunkRoutingTable;
     DeleteUUCPRoutingTable; { RWI 951028: moved here }
     JunkLang;
     JunkCharsets;
     JunkGatewayChecks;

     LogMessage ('Ending program');
     LogExtraMessage ('');
     LogClose;

     CloseDesktop;
     ScreenToo:=FALSE;

     WriteLn ('Ending '+DesktopProgramName+' Test v',FullProgramVersion);

     TdbDone;
     DumpMem;
END.
