{$IFDEF WtrGate}{$IFDEF UseOvr}{$O+,F+}{$ENDIF}{$ENDIF}
UNIT Logs;

{ Routines om gegevens naar de LogFile te sturen }

{ History

RvdW 20-02-93 Deze unit opgepoetst.
     25-05-93 Toevoeging ScreenToo.

}


INTERFACE

TYPE DateStampString = STRING[15]; { Sat 03 Apr 1993 }
     TimeStampString = STRING[8];  { 09:35:10 }

FUNCTION  DateStamp : DateStampString;
FUNCTION  TimeStamp : TimeStampString;
PROCEDURE LogMessage (Tekst : STRING);
PROCEDURE LogExtraMessage (Tekst : STRING);
PROCEDURE LogDiskIOError (IORes : BYTE; Tekst : STRING);
PROCEDURE LogClose;
PROCEDURE Log_StoreFilePos;
PROCEDURE Log_SendReport;
PROCEDURE LogGetMem (At : POINTER; Len : WORD; Descr : STRING);

(*
PROCEDURE DeleteLogFile;
PROCEDURE LogBad (Tekst : STRING);
PROCEDURE LogNetmail (Tekst : STRING);
PROCEDURE LogFatalError (Tekst : STRING);
*)

{$IFDEF WtrUtil}
PROCEDURE ShrinkLogFile (Auto : BOOLEAN);
PROCEDURE ShrinkStaFile (Auto : BOOLEAN);
{$ENDIF}

VAR ScreenToo      : BOOLEAN;
    LogScreenLines : BYTE; { 4 voor 25 regels/scherm, 22 voor 43 regels/scherm }
{$IFDEF WtrUtil}
    ShrinkDays     : BYTE;
{$ENDIF}


IMPLEMENTATION

USES Dos,
     Ramon,
     Cfg,
     Globals,

{ added for writing admin report: }
     FBuffer,
     Fido,
     Usenet,
     Msgs;

VAR LogIsOpen : BOOLEAN;
    LogFile   : TEXT;
    StoredPos : LONGINT;
{$IFDEF Pre}
    MemStrLen : BYTE;
{$ENDIF}

{--------------------------------------------------------------------------}
{ DateStamp                                                                }
{                                                                          }
{ Deze routine geeft een string in het formaat "Fri 26 Mar 1993" terug met }
{ de huidige dag van de week en datum erin.                                }
{                                                                          }
FUNCTION DateStamp : DateStampString;

CONST DOWs : ARRAY[0..6] OF STRING[3] = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');

VAR Year,Monthv,Day,DOW : WordLong;

BEGIN
     GetDate (Year,Monthv,Day,DOW);

     DateStamp:=DOWs[DOW]+' '+AddUpWithPre0s (2,Word2String (Day))+' '+
                Month[Monthv]+' '+Word2String (Year);
END;


{--------------------------------------------------------------------------}
{ TimeStamp                                                                }
{                                                                          }
{ Deze functie geeft een string in het formaat "10:13:12" terug met de     }
{ huidige tijd erin.                                                       }
{                                                                          }
FUNCTION TimeStamp : TimeStampString;

VAR Hour,Min,Sec,SecH  : WordLong;

BEGIN
     GetTime (Hour,Min,Sec,SecH);

     TimeStamp:=AddUpWithPre0s (2,Word2String (Hour))+':'+
                AddUpWithPre0s (2,Word2String (Min))+':'+
                AddUpWithPre0s (2,Word2String (Sec));
END;


{--------------------------------------------------------------------------}
{ LogOpen                                                                  }
{                                                                          }
{ This procedure opens the logfile and then sets IsOpen to TRUE.           }
{                                                                          }
PROCEDURE LogOpen;

VAR IORes   : BYTE;

BEGIN
     IF LogIsOpen THEN
        Exit;

     Assign (LogFile,Config.LogFilePath);
     {$I-} Append (LogFile); {$I+} IORes:=IOResult;
     IF (IORes = 2) THEN
     BEGIN
          {$I-} ReWrite (LogFile); {$I+} IORes:=IOResult;
     END;

     {
     IF (IORes = 4) THEN
        Error ('[LogMessage] Too many open files! Cannot write to log');
     }

     LogIsOpen:=(IORes = 0);
END;


{---------------------------------------------------------------------------}
{ LogClose                                                                  }
{                                                                           }
PROCEDURE LogClose;
BEGIN
     IF LogIsOpen THEN
     BEGIN
          Close (LogFile);
          LogIsOpen:=FALSE;
     END;
END;


{--------------------------------------------------------------------------}
{ LogWriteMessage                                                          }
{                                                                          }
{ Deze routine schrijft een melding weg naar de logfile. Deze wordt        }
{ geopent, de melding geschreven en meteen weer gesloten om er zeker van   }
{ te zijn dat de tekst erin staat.                                         }
{                                                                          }
PROCEDURE LogWriteMessage (Tekst : STRING);
BEGIN
     {$IFDEF Pre}
     IF (Tekst <> '') THEN
        Tekst:=AddUpWithSpaces (MemStrLen,Longint2String (MemAvail))+Tekst;
     {$ENDIF}

     LogOpen;

     IF LogIsOpen THEN
        WriteLn (LogFile,Tekst);

     IF ScreenToo AND (Tekst <> '') THEN
     BEGIN
          ScrollUp (2,Video.Rows-LogScreenLines-1,78,LogScreenLines{4});
          WriteXYC (2,Video.Rows-2,cBoxData,AddUpWithSpaces (78,Tekst));
     END;
END;


{--------------------------------------------------------------------------}
{ LogMessage                                                               }
{                                                                          }
{ Deze routine logt de opgegeven regel, met een DateTimeStamp ervoor.      }
{                                                                          }
PROCEDURE LogMessage (Tekst : STRING);
BEGIN
     LogWriteMessage (TimeStamp+' '+Tekst);
END;


{--------------------------------------------------------------------------}
{ LogExtraMessage                                                          }
{                                                                          }
{ Zelfde routine als LogMessage, alleen worden er nu spaties ter lengte    }
{ van de DateTimeStamp aan vooraf gezet.                                   }
{                                                                          }
PROCEDURE LogExtraMessage (Tekst : STRING);
BEGIN
     IF (Tekst <> '') THEN
        Tekst:=Spaces (9)+Tekst;

     LogWriteMessage (Tekst);
END;


{--------------------------------------------------------------------------}
{ LogDiskIOError                                                           }
{                                                                          }
{ Met deze routine kan een melding van een disk I/O fout gemeld worden op  }
{ het scherm en in de log file. Het is geen critical error en de routine   }
{ zal dus gewoon terug keren.                                              }
{                                                                          }
PROCEDURE LogDiskIOError (IORes : BYTE; Tekst : STRING);

VAR Desc : STRING;

BEGIN
     Desc:='';

     CASE IORes OF
          2 : Desc:=':File not found';
          3 : Desc:=':Path not found';
          4 : Desc:=':Too many open files';
          5 : Desc:=':Access denied';
          100 : Desc:=':Disk read error';

          {101 : RWI961027: verwijderd }
     END; { case }

     LogMessage (Tekst+' (dos='+Byte2String (IORes)+Desc+')');

     IF (IORes = 4) THEN
        LogExtraMessage ('Please lower "Max. open handles" in WtrConf!!');
END;

(*
{--------------------------------------------------------------------------}
{ LogBad                                                                   }
{                                                                          }
{ Deze routine schrijft een melding weg naar de logfile waarin komt te     }
{ staan waarom een bericht de bad in is gegooid.                           }
{                                                                          }
PROCEDURE LogBad (Tekst : STRING);

VAR LogFile : TEXT;
    IORes   : BYTE;

BEGIN
     Assign (LogFile,Config.SystemDir+'BAD.LOG');
     {$I-} Append (LogFile); {$I+} IORes:=IOResult;
     IF (IORes = 2) THEN
     BEGIN
          {$I-} ReWrite (LogFile); {$I+} IORes:=IOResult;
     END;

     {
     IF (IORes = 4) THEN
        Error ('[LogBad] Too many open files! Cannot write to log');
     }

     IF (IORes = 0) THEN
     BEGIN
          WriteLn (LogFile,Tekst);
          Close (LogFile);
     END;
END;


{--------------------------------------------------------------------------}
{ LogNetmail                                                               }
{                                                                          }
{ Deze routine schrijft een melding weg naar de logfile waarin komt te     }
{ staan wat er met de netmail is gedaan.                                   }
{                                                                          }
PROCEDURE LogNetmail (Tekst : STRING);

VAR LogFile : TEXT;
    IORes   : BYTE;

BEGIN
     Assign (LogFile,Config.SystemDir+'NETMAIL.LOG');
     {$I-} Append (LogFile); {$I+} IORes:=IOResult;
     IF (IORes = 2) THEN
     BEGIN
          {$I-} ReWrite (LogFile); {$I+} IORes:=IOResult;
     END;

     {
     IF (IORes = 4) THEN
        Error ('[LogNetmail] Too many open files! Cannot write to log');
     }

     IF (IORes = 0) THEN
     BEGIN
          WriteLn (LogFile,Tekst);
          Close (LogFile);
     END;
END;


{--------------------------------------------------------------------------}
{ DeleteLogFile                                                            }
{                                                                          }
{ Deze routine wist de logfile van disk, zodat alleen de melden van deze   }
{ run aan het einde in de .LOG file staan.                                 }
{ De BAD.LOG wordt op dit moment ook tijdelijk even verwijderd.            }
{                                                                          }
PROCEDURE DeleteLogFile;

VAR DelFile : FILE;
    IORes   : BYTE;

BEGIN
     Assign (DelFile,Config.LogFilePath);
     {$I-} Erase (DelFile); {$I+} IORes:=IOResult;

     Assign (DelFile,Config.SystemDir+'BAD.LOG');
     {$I-} Erase (DelFile); {$I+} IORes:=IOResult;

     Assign (DelFile,Config.SystemDir+'NETMAIL.LOG');
     {$I-} Erase (DelFile); {$I+} IORes:=IOResult;
END;
*)

(* RWI 961027: waaaayy too grof!
{--------------------------------------------------------------------------}
{ LogFatalError                                                            }
{                                                                          }
{ Sluit de desktop, en schrijft een string naar het scherm.                }
{                                                                          }
PROCEDURE LogFatalError (Tekst : STRING);
BEGIN
     CloseDesktop;
     WriteLn (Tekst);
     WriteLn;
     Halt (2);
END;
*)


{$IFDEF WtrUtil}
{---------------------------------------------------------------------------}
{ ShrinkLogFile                                                             }
{                                                                           }
{ Deze routine zorgt dat de history in de logfile uitgedunt wordt tot een   }
{ X aantal dagen.                                                           }
{                                                                           }
PROCEDURE ShrinkLogFile (Auto : BOOLEAN);

CONST Xb = 20;
      Yb = 7;
      Xl = 40;
      Yl = 5;

      MonthStrs : ARRAY[1..12] OF STRING[5] = (' Jan ',' Feb ',' Mar ',
                                               ' Apr ',' May ',' Jun ',
                                               ' Jul ',' Aug ',' Sep ',
                                               ' Oct ',' Nov ',' Dec ');

      DaysPerMonth : ARRAY[1..12] OF BYTE = (31,28,31,30,31,30,31,31,30,31,30,31);

VAR InFile,
    NewFile  : TEXT;
    Regel    : STRING;
    Lp,P     : BYTE;
    DayStr   : STRING[2];
    Day      : BYTE;
    Nop      : ValNop;
    CurrD,
    CurrM,
    Dummy    : WordLong;
    TrashedSome,
    KeepRest : BOOLEAN;
    IORes    : BYTE;

    { onthoud buffer voor regels van het blok die misschien toch nog wel }
    { mee mogen.                                                         }
    Buffer      : ARRAY[1..10] OF STRING;
    BufferCount : 0..10;

LABEL QuitNow,
      DoneNow;

BEGIN
     LogClose;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     WriteXY (Xb+2,Yb+1,'History keep:');
     WriteXY (Xb+2,Yb+2,'Keeping from:');
     WriteXY (Xb+2,Yb+3,'Status:');

     WriteXYC (Xb+16,Yb+1,cBoxData,Byte2String (ShrinkDays)+' days');
     WriteXY (Xb+16,Yb+3,'Searching...');

     PushKeysLine;
     WriteKeysLine (' Please wait...');

     Assign (InFile,Config.LogFilePath);
     {$I-} Reset (InFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          IF (NOT Auto) THEN
             Error ('Error opening logfile '+Config.LogFilePath+' (error '+Byte2String (IORes)+')');
          GOTO QuitNow;
     END;

     Assign (NewFile,'WTRLOG.$$$');
     {$I-} ReWrite (NewFile); {$I+}
     IF (IOResult <> 0) THEN
     BEGIN
          { tijdelijke file kan niet aangemaakt worden -> kappen }
          Close (InFile);

          IF (NOT Auto) THEN
             Error ('Cannot create temporary logfile WTRLOG.$$$ (error '+Byte2String (IORes)+')');

          GOTO QuitNow;
     END;

     GetDate (Dummy,CurrM,CurrD,Dummy);

     KeepRest:=FALSE;
     TrashedSome:=FALSE;
     BufferCount:=0;
     WHILE (NOT Eof (InFile)) DO
     BEGIN
          ReadLn (InFile,Regel);

          IF KeepRest THEN
          BEGIN
               WriteLn (NewFile,Regel);
               Continue;
          END;

          Regel:=DeleteFrontSpaces (Regel);

          IF (Regel = '') THEN
          BEGIN
               BufferCount:=0;
               TrashedSome:=TRUE;
               Continue; { volgende regel }
          END;

          IF (BufferCount < 10) THEN
          BEGIN
               Inc (BufferCount);
               Buffer[BufferCount]:=Regel;
          END;

          FOR Lp:=1 TO 12 DO
          BEGIN
               P:=Pos (MonthStrs[Lp],Regel);
               IF (P > 0) THEN
               BEGIN
                    DayStr:=Copy (Regel,P-2,2);
                    IF (DayStr[1] = ' ') THEN
                       Delete (DayStr,1,1);

                    Val (DayStr,Day,Nop);

                    IF (Lp = CurrM) THEN
                    BEGIN
                         IF (CurrD-Day <= ShrinkDays) THEN
                            KeepRest:=TRUE;
                    END ELSE
                        IF ((Lp = 12) AND (CurrM = 1)) OR (Lp = CurrM-1) THEN
                        BEGIN
                             IF (CurrD+DaysPerMonth[Lp]-Day <= ShrinkDays) THEN
                                KeepRest:=TRUE;
                        END;

                    IF KeepRest THEN
                    BEGIN
                         Regel:=Copy (Regel,P-6,255);
                         IF (Regel[1] = ' ') THEN
                            Delete (Regel,1,1);

                         WriteXYC (Xb+16,Yb+2,cBoxData,Regel);

                         IF (NOT TrashedSome) THEN
                         BEGIN
                              { snelle sessie, er verandert namelijk niets! }
                              Close (InFile);
                              Close (NewFile);
                              Erase (NewFile); { niet meer nodig }
                              WriteXYC (Xb+16,Yb+3,cBoxData,'Done (nothing changed)');
                              LogMessage ('Shrinking the logfile (nothing to do)');
                              GOTO DoneNow;
                         END;

                         WriteXYC (Xb+16,Yb+3,cBoxData,'Copying...  ');
                    END;

                    Break; { uit de for }
               END;
          END; { for }

          { hier komt ie alleen bij de opgang van KeepRest naar TRUE }
          IF KeepRest THEN
             { buffer naar de nieuwe file schrijven }
             FOR Lp:=1 TO BufferCount DO
                 WriteLn (NewFile,Buffer[Lp]);
     END; { while }

     Close (InFile);
     Close (NewFile);

     {$I-} Erase (InFile); {$I+} IORes:=IOResult;
     IF Auto AND (IORes <> 0) THEN
        Error ('Cannot erase old logfile (error '+Byte2String (IORes)+')');

     {$I-} Rename (NewFile,Config.LogFilePath); {$I+} IORes:=IOResult;
     IF Auto AND (IORes <> 0) THEN
        Error ('Cannot rename temporary logfile (error '+Byte2String (IORes)+')');

     WriteXYC (Xb+16,Yb+3,cBoxData,'Done        ');
     LogMessage ('Shrunk the logfile to '+Byte2String (ShrinkDays)+' history days');

     LogClose;

DoneNow:
     IF (NOT Auto) THEN
     BEGIN
          WriteKeysLine (' Press ^any key to continue...');
          ReadKey;
     END;

QuitNow:
     PopKeysLine;
     WindowPop;
END;


{---------------------------------------------------------------------------}
{ ShrinkStaFile                                                             }
{                                                                           }
{ Deze routine zorgt dat de history in de statistics file uitgedunt wordt   }
{ tot een X aantal dagen.                                                   }
{ Alles draait om deze regel:                                               }
{ Statistics report of toss on Sat 23 Mar 1996 18:00:06                     }
{                                                                           }
PROCEDURE ShrinkStaFile (Auto : BOOLEAN);

CONST Xb = 20;
      Yb = 7;
      Xl = 40;
      Yl = 5;

      MonthStrs : ARRAY[1..12] OF STRING[5] = (' Jan ',' Feb ',' Mar ',
                                               ' Apr ',' May ',' Jun ',
                                               ' Jul ',' Aug ',' Sep ',
                                               ' Oct ',' Nov ',' Dec ');

      DaysPerMonth : ARRAY[1..12] OF BYTE = (31,28,31,30,31,30,31,31,30,31,30,31);

VAR Dir      : DirStr;
    Name     : NameStr;
    Ext      : ExtStr;
    StaPath  : STRING[80];
    InFile,
    NewFile  : TEXT;
    IORes    : BYTE;
    Regel    : STRING;
    Lp,P     : BYTE;
    DayStr   : STRING[2];
    Day      : BYTE;
    Nop      : ValNop;
    CurrD,
    CurrM,
    Dummy    : WordLong;
    TrashedSome,
    KeepRest : BOOLEAN;

LABEL QuitNow,
      DoneNow;

BEGIN
     LogClose;

     WindowPush (Xb,Yb,Xl,Yl);
     BoxDraw (Double,Xb,Yb,Xl,Yl);

     WriteXY (Xb+2,Yb+1,'History keep:');
     WriteXY (Xb+2,Yb+2,'Keeping from:');
     WriteXY (Xb+2,Yb+3,'Status:');

     WriteXYC (Xb+16,Yb+1,cBoxData,Byte2String (ShrinkDays)+' days');
     WriteXY (Xb+16,Yb+3,'Searching...');

     PushKeysLine;
     WriteKeysLine (' Please wait...');

     FSplit (FExpand (Config.LogfilePath),Dir,Name,Ext);
     StaPath:=Dir+Name+'.STA';

     Assign (InFile,StaPath);
     {$I-} Reset (InFile); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          IF (NOT Auto) THEN
             Error ('Error opening statistics file '+StaPath+' (error '+Byte2String (IORes)+')');
          GOTO QuitNow;
     END;

     Assign (NewFile,'WTRSTA.$$$');
     {$I-} ReWrite (NewFile); {$I+}
     IF (IOResult <> 0) THEN
     BEGIN
          { tijdelijke file kan niet aangemaakt worden -> kappen }
          Close (InFile);

          IF (NOT Auto) THEN
             Error ('Cannot create temporary logfile WTRSTA.$$$ (error '+Byte2String (IORes)+')');

          GOTO QuitNow;
     END;

     GetDate (Dummy,CurrM,CurrD,Dummy);

     KeepRest:=FALSE;
     TrashedSome:=FALSE;
     WHILE (NOT Eof (InFile)) DO
     BEGIN
          ReadLn (InFile,Regel);

          IF KeepRest THEN
          BEGIN
               WriteLn (NewFile,Regel);
               Continue;
          END;

          IF (Copy (Regel,1,29) <> 'Statistics report of toss on ') THEN
          BEGIN
               TrashedSome:=TRUE;
               Continue; { moeten we niet }
          END;

          { kijk of dit volgende blok wel mee mag }
          FOR Lp:=1 TO 12 DO
          BEGIN
               P:=Pos (MonthStrs[Lp],Regel);
               IF (P > 0) THEN
               BEGIN
                    DayStr:=Copy (Regel,P-2,2);
                    IF (DayStr[1] = ' ') THEN
                       Delete (DayStr,1,1);

                    Val (DayStr,Day,Nop);

                    IF (Lp = CurrM) THEN
                    BEGIN
                         IF (CurrD-Day <= ShrinkDays) THEN
                            KeepRest:=TRUE;
                    END ELSE
                        IF ((Lp = 12) AND (CurrM = 1)) OR (Lp = CurrM-1) THEN
                        BEGIN
                             IF (CurrD+DaysPerMonth[Lp]-Day <= ShrinkDays) THEN
                                KeepRest:=TRUE;
                        END;

                    IF KeepRest THEN
                    BEGIN
                         WriteLn (NewFile,Regel);

                         Regel:=Copy (Regel,P-6,255);
                         Regel:=Copy (Regel,1,Length (Regel)-9); { tijd eraf hakken }
                         IF (Regel[1] = ' ') THEN
                            Delete (Regel,1,1);

                         WriteXYC (Xb+16,Yb+2,cBoxData,Regel);

                         IF (NOT TrashedSome) THEN
                         BEGIN
                              { snelle sessie, er verandert namelijk niets! }
                              Close (InFile);
                              Close (NewFile);
                              Erase (NewFile); { niet meer nodig }
                              WriteXYC (Xb+16,Yb+3,cBoxData,'Done (nothing changed)');
                              LogMessage ('Shrinking the statistics file (nothing to do)');
                              GOTO DoneNow;
                         END;

                         WriteXYC (Xb+16,Yb+3,cBoxData,'Copying...  ');
                    END;

                    Break; { uit de for }
               END;
          END; { for }

     END; { while }

     Close (InFile);
     Close (NewFile);

     {$I-} Erase (InFile); {$I+} IORes:=IOResult;
     IF Auto AND (IORes <> 0) THEN
        Error ('Cannot erase old statistics file (error '+Byte2String (IORes)+')');

     {$I-} Rename (NewFile,StaPath); {$I+} IORes:=IOResult;
     IF Auto AND (IORes <> 0) THEN
        Error ('Cannot rename temporary file (error '+Byte2String (IORes)+')');

     WriteXYC (Xb+16,Yb+3,cBoxData,'Done        ');
     LogMessage ('Shrunk the statistics file to '+Byte2String (ShrinkDays)+' history days');

     LogClose;

DoneNow:
     IF (NOT Auto) THEN
     BEGIN
          WriteKeysLine (' Press ^any key to continue...');
          ReadKey;
     END;

QuitNow:
     PopKeysLine;
     WindowPop;
END;
{$ENDIF}


{--------------------------------------------------------------------------}
{ Log_StoreFilePos                                                         }
{                                                                          }
{ Deze routine slaat de fysieke grootte van de logfile op, zodat bij het   }
{ maken van het rapport straks het stuk logfile vanaf deze positie tot het }
{ einde genomen kan worden.                                                }
{                                                                          }
PROCEDURE Log_StoreFilePos;

VAR AFile : FILE;
    IORes : BYTE;

BEGIN
     LogClose;

     StoredPos:=0;

     Assign (AFile,Config.LogFilePath);
     {$I-} Reset (AFile,1); {$I+} IORes:=IOResult;
     IF (IORes = 0) THEN
     BEGIN
          StoredPos:=FileSize (AFile);
          Close (AFile);
     END;
END;


{--------------------------------------------------------------------------}
{ Log_SendReport                                                           }
{                                                                          }
{ Deze routine schrijft de hele logfile vanaf de opgeslagen positie tot en }
{ met het einde van de file als een rapport naar de administrator.         }
{                                                                          }
PROCEDURE Log_SendReport;

TYPE BufType = ARRAY[1..10000] OF BYTE;

VAR TempLog   : FILE;
    LogFile   : FILE;
    IORes     : BYTE;
    BufPtr    : ^BufType;
    BytesRead : WordLong;
    FLog      : FBufferType;
    Regel     : STRING;
    BufSize   : WORD;

BEGIN
     IF (Config.AdminAddrType = 0) THEN
        Exit; { disabled }

     { kijk of we de logfile moeten sturen }
     IF (NOT Config.AdminSendLog) THEN
        Exit;

     IF (MaxAvail < 15000) THEN
     BEGIN
          LogMessage ('Not enough free memory to send report');
          Exit;
     END;

     { stuur de logfile vanaf StoredPos tot het einde van de file }
     LogMessage ('Sending logfile to administrator');

     Assign (TempLog,'ADMINLOG.$$$');
     {$I-} ReWrite (TempLog,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'Failed to create temporary ADMINLOG.$$$');
          Exit;
     END;

     { sluit nu de originele logfile en open deze in binaire mode }
     LogClose;

     Assign (LogFile,Config.LogFilePath);
     {$I-} Reset (LogFile,1); {$I+} IORes:=IOResult;
     IF (IORes <> 0) THEN
     BEGIN
          LogDiskIOError (IORes,'Error opening logfile '+Config.LogFilePath);
          Close (TempLog);
          Erase (TempLog);
          Exit;
     END;

     Seek (LogFile,StoredPos);

     GetMem (BufPtr,10000);
     PeekMem;

     REPEAT
           BlockRead (LogFile,BufPtr^,10000,BytesRead);

           IF (BytesRead <> 0) THEN
              BlockWrite (TempLog,BufPtr^,BytesRead);

     UNTIL (BytesRead = 0);

     { nieuwe positie }
     StoredPos:=FileSize (LogFile);

     Close (LogFile);
     Close (TempLog);

     FreeMem (BufPtr,10000);

     { de logfile is nu gekopieerd in templog en die kunnen we nu }
     { gaan mailen. Als er tijdens het mailen iets mis gaat, dan  }
     { kan dat gewoon gelogged worden en treden er geen fouten op }
     { omdat de logfile al ergens anders geopend is.              }

     CASE Config.AdminAddrType OF
          1 : FidoBuildNetmail (TRUE{empty},
                                Config.NodeNrs[1],
                                Config.AdminFidoAddr,
                                'WtrGate',
                                Config.AdminFidoName,
                                'WtrGate report '+DateStamp+' '+TimeStamp);

          2 : UsenetBuildMail (Config.AdminUUCPAddr,
                               'wtrgate',
                               'WtrGate',
                               'WtrGate report '+DateStamp+' '+TimeStamp);
     END; { case }

     IF FBufferOpen (FLog,'ADMINLOG.$$$',10000,10000) THEN
     BEGIN
          WHILE FBReadLnCr (FLog,Regel) DO
                MsgsAddLineToNoEOL (Body,Regel);
     END ELSE
         MsgsAddLineTo (Body,'System error: cannot access temporary copy of log file');

     FBufferClose (FLog);

     { remove the ADMINLOG.$$$ file }
     {$I-} Erase (TempLog); {$I+} IORes:=IOResult;

     CASE Config.AdminAddrType OF
          1 : FidoRouteNetmail;
          2 : UsenetRouteMail;
     END; { case }
END;


{--------------------------------------------------------------------------}
{ LogGetMem                                                                }
{                                                                          }
{ Deze routine wordt gebruikt om alle memory allocaties te loggen.         }
{                                                                          }
PROCEDURE LogGetMem (At : POINTER; Len : WORD; Descr : STRING);

    FUNCTION Ptr2Long (X : POINTER) : LONGINT;
    BEGIN
         Ptr2Long:=(Longint (X) SHR 12)+Word (X);
    END;

BEGIN
     {$IFNDEF DPMI}
     {$IFNDEF OS2}
     LogExtraMessage ('+$'+Long2HexString (Ptr2Long (At)-Ptr2Long (HeapOrg))+' '+Long2HexString (Len)+' '+Descr);
     {$ENDIF (OS2) }
     {$ENDIF (DPMI) }
END;


{--------------------------------------------------------------------------}
{ unit initialization                                                      }
{                                                                          }
BEGIN
     ScreenToo:=FALSE;
     LogIsOpen:=FALSE;
     LogScreenLines:=4; { window inhoud }
{$IFDEF WtrUtil}
     ShrinkDays:=7; { hele week behouden }
{$ENDIF}
{$IFDEF Pre}
     MemStrLen:=Length (Longint2String (MemAvail))+1;
{$ENDIF}
END.
