{ SCRSAVER.INC: Screen Saver Routine }

{$IFDEF OS2}
## OH OH!!
{$ENDIF}

{==========================================================================}
{ (c) Copyright Waterline Software Developent V.O.F. 1990-1994             }
{                                                                          }
{    Waterline Software Development V.O.F.                                 }
{    Wouter Sluislaan 12                                                   }
{    1461 AC  Zuidoostbeemster                                             }
{    The Netherlands                                                       }
{                                                                          }
{ It not allowed to use this user interface in any program not owned by    }
{ the Waterline Software Development V.O.F.                                }
{ Special conditions apply to programs distributed by the Waterline        }
{ Software Development V.O.F. If the source code of any of these programs  }
{ is distributed as well, it is NOT allowed to use the user interface in   }
{ your own programs. Violators may be prosecuted!                          }
{                                                                          }
{ Please contact the Waterline Software Development V.O.F. at the above    }
{ address for your licence to use the "Ramon" user interface. You will get }
{ the most recent copy of the "Ramon" user interface and the "Ramon" user  }
{ interface expert for free. This program helps you design your user       }
{ interfaces at an instance.                                               }
{                                                                          }
{ This copyright notice should remain in this file and all files that are  }
{ part of the user interface "Ramon".                                      }
{==========================================================================}

{ de Screen Saver staat standaard uit als de Desktop routine niet gebruikt }
{ worden. OpenDesktop zet 'm aan, CloseDesktop zet 'm uit.                 }
CONST ScreenSaverState : ScreenSaverOnOffType = ssOff;
      ScrSaverKbdFncNr : BYTE = $00; { wordt gewijzigd door KeyboardInit }

CONST SCREENSAVER_INITIALCOUNTDOWNTIMER : WORD = Trunc (300{sec}*18.2);

VAR ScreenSaverCountDownTimer   : WORD;
    ScreenSaverPrevTimerReadout : LONGINT;


{--------------------------------------------------------------------------}
{ ScreenSaver_SetState                                                     }
{                                                                          }
{ Met deze routine kan de Screen Saver aan of uit worden gezet. Open en    }
{ CloseDesktop doen dit automatisch. Default is uit.                       }
{                                                                          }
PROCEDURE ScreenSaver_SetState (OnOff : ScreenSaverOnOffType);
BEGIN
     ScreenSaverState:=OnOff;
     IF (OnOff = ssOn) THEN
     BEGIN
          ScreenSaverCountDownTimer:=SCREENSAVER_INITIALCOUNTDOWNTIMER;
          ScreenSaverPrevTimerReadout:=GetTimer;
     END;
END;


{--------------------------------------------------------------------------}
{ ScreenSaver_GotAKey                                                      }
{                                                                          }
{ Deze routine wordt aangeroepen als er op een toets gedrukt is of met de  }
{ muis een klik is gedaan. De routine ReadKey roept deze routine aan. Hier }
{ wordt de timer gereset, mits de Screen Saver actief is natuurlijk.       }
{                                                                          }
PROCEDURE ScreenSaver_GotAKey;
BEGIN
     IF (ScreenSaverState = ssOn) THEN
     BEGIN
          ScreenSaverCountDownTimer:=SCREENSAVER_INITIALCOUNTDOWNTIMER;
          ScreenSaverPrevTimerReadout:=GetTimer;
     END;
END;


{--------------------------------------------------------------------------}
{ ScreenSaver_NoKeyYet                                                     }
{                                                                          }
{ Deze routine wordt aangeroepen zolang er nog niet op een toets is        }
{ gedrukt en de ReadKey routine dus op een toets staat te wachten. Hier    }
{ wordt de timer uitgelezen en vergeleken met een vorige waarde. Het       }
{ verschil wordt van de CountDown timer afgetrokken. Als die 0 bereikt,    }
{ dan wordt de Screen Saver actief. Normaal geeft deze routine kUnknown    }
{ terug. Maar als de IdleRoutine tijdens het actief zijn van de Screen     }
{ Saver geen kUnknown terug geeft, dan wordt die toets terug gegeven. Als  }
{ er op een toets wordt gedrukt door de gebruiker, dan wordt die toets     }
{ weggelezen en vergeten.                                                  }
{                                                                          }
FUNCTION ScreenSaver_NoKeyYet : KeyType;

VAR PrevTimer,
    Timer     : LONGINT;
    X,Y       : XYType;
    IdleKey   : KeyType;
    OldCursor : BOOLEAN;

BEGIN
     IF (ScreenSaverState = ssOff) THEN
     BEGIN
          ScreenSaver_NoKeyYet:=kUnknown;
          Exit;
     END;

     Timer:=GetTimer;
     ScreenSaverCountDownTimer:=ScreenSaverCountDownTimer-(Timer-ScreenSaverPrevTimerReadout);
     ScreenSaverPrevTimerReadout:=Timer;
     {WriteXY (1,2,AddUpWithSpaces (5,Word2String (ScreenSaverCountDownTimer)));}

     IF (ScreenSaverCountDownTimer <= 0) THEN
     BEGIN
          { activate screen saver }

          { bewaar het scherm en maak deze leeg }
          WindowPush (0,0,Video.Cols,Video.Rows);
          OldCursor:=CursorIsOn;
          CursorOff;

          Randomize; { anders altijd eerst op 1,1 }
          PrevTimer:=-1; { forceer afdrukken melding }
          REPEAT
                Timer:=GetTimer;
                IF (Timer > PrevTimer+91{aprox. 5 sec.}) THEN
                BEGIN
                     PrevTimer:=Timer;
                     X:=Random (Video.Cols-Length (ScreenSaverMsg))+1;
                     Y:=Random (Video.Rows)+1;

                     SetColor (cScrSaver);
                     FillVideo (0,0,Video.Cols,Video.Rows,' ');
                     WriteXY (X,Y,ScreenSaverMsg);
                END;

                IdleKey:=IdleRoutine (Blanked); { wel blijven aanroepen }
          UNTIL KeyPressed OR (IdleKey <> kUnknown);

          { herstel het scherm }
          WindowPop;
          IF OldCursor THEN
          BEGIN
               CursorGotoXY (CursorX,CursorY);
               CursorOn;
          END;

          IF (IdleKey = kUnknown) THEN
          BEGIN
               { geen automatisch terugkeer uit screen saver, maar via }
               { toetsdruk. Lees deze toets weg uit het buffer.        }
               ASM
                  MOV AH,ScrSaverKbdFncNr { ingevuld door KeyboardInit }
                  INT 16h
               END; { asm }

               IdleKey:=IdleRoutine (Visible);
          END;

          { voorkom meteen weer triggeren }
          ScreenSaver_GotAKey; { restart timer }
     END ELSE
         IdleKey:=kUnknown;

     ScreenSaver_NoKeyYet:=IdleKey;
END;
