{ CONVERT.INC: Conversie routines }

{==========================================================================}
{ (c) Copyright Waterline Software Developent V.O.F. 1990-1994             }
{                                                                          }
{    Waterline Software Development V.O.F.                                 }
{    Wouter Sluislaan 12                                                   }
{    1461 AC  Zuidoostbeemster                                             }
{    The Netherlands                                                       }
{                                                                          }
{ It not allowed to use this user interface in any program not owned by    }
{ the Waterline Software Development V.O.F.                                }
{ Special conditions apply to programs distributed by the Waterline        }
{ Software Development V.O.F. If the source code of any of these programs  }
{ is distributed as well, it is NOT allowed to use the user interface in   }
{ your own programs. Violators may be prosecuted!                          }
{                                                                          }
{ Please contact the Waterline Software Development V.O.F. at the above    }
{ address for your licence to use the "Ramon" user interface. You will get }
{ the most recent copy of the "Ramon" user interface and the "Ramon" user  }
{ interface expert for free. This program helps you design your user       }
{ interfaces at an instance.                                               }
{                                                                          }
{ This copyright notice should remain in this file and all files that are  }
{ part of the user interface "Ramon".                                      }
{==========================================================================}

{--------------------------------------------------------------------------}
{ Byte2HexString                                                           }
{                                                                          }
{ Zet de opgegeven BYTE om in een hexadecimale representatie van 2 digits. }
{                                                                          }
FUNCTION Byte2HexString (Getal : BYTE) : HexByteString;

CONST HexDigits : ARRAY[0..15] OF CHAR = ('0','1','2','3','4','5','6','7',
                                          '8','9','A','B','C','D','E','F');

BEGIN
     Byte2HexString:=HexDigits[Getal SHR 4]+HexDigits[Getal AND 15];
END;


{--------------------------------------------------------------------------}
{ Word2HexString                                                           }
{                                                                          }
{ Zet de opgegeven WORD om in een hexadecimale representatie van 4 tekens. }
{                                                                          }
FUNCTION Word2HexString (Getal : WORD) : HexWordString;
BEGIN
     Word2HexString:=Byte2HexString (Getal SHR 8)+
                     Byte2HexString (Getal AND 255);
END;


{--------------------------------------------------------------------------}
{ Long2HexString                                                           }
{                                                                          }
{ Zet de opgegeven LONG om in een hexadecimale representatie van 8 tekens. }
{                                                                          }
FUNCTION Long2HexString (Getal : LONGINT) : HexLongString;
BEGIN
     Long2HexString:=Byte2HexString ((Getal SHR 24) AND 255)+
                     Byte2HexString ((Getal SHR 16) AND 255)+
                     Byte2HexString ((Getal SHR 8) AND 255)+
                     Byte2HexString (Getal AND 255);
END;


{--------------------------------------------------------------------------}
{ HexString2Long                                                           }
{                                                                          }
{ Deze routine zet een hex string om in een getal ter grootte van een      }
{ longint. Alle de tekens van de string worden verwerkt.                   }
{                                                                          }
FUNCTION HexString2Long (HexStr : STRING ) : LONGINT;

VAR Getal : LONGINT;
    Digit : CHAR;
    Lp    : BYTE;

BEGIN
     Getal:=0;
     FOR Lp:=1 TO Length (HexStr) DO
     BEGIN
          Digit:=UpCase (HexStr[Lp]);
          Getal:=Getal*16;

          IF (Digit IN ['0'..'9']) THEN
             Getal:=Getal+Ord (Digit)-Ord ('0')
          ELSE
              IF (Digit IN ['A'..'F']) THEN
                 Getal:=Getal+Ord (Digit)-Ord ('A')+10;
          { anders was het een illegaal teken, die slaan we gewoon over }
     END; { for }

     HexString2Long:=Getal;
END;


{--------------------------------------------------------------------------}
{ Byte2String                                                              }
{                                                                          }
{ Zet de opgegeven BYTE om in een decimale representatie. Geen voorloop    }
{ spaties of nullen.                                                       }
{                                                                          }
FUNCTION Byte2String (Getal : BYTE) : ByteString;

VAR Temp : ByteString;

BEGIN
     Str (Getal,Temp);
     Byte2String:=Temp;
END;


{--------------------------------------------------------------------------}
{ Integer2String                                                           }
{                                                                          }
{ Zet een INTEGER getal om in een decimale representatie. Geen voorloop    }
{ nullen of spaties.                                                       }
{                                                                          }
FUNCTION Integer2String (Getal : INTEGER) : IntegerString;

VAR Temp : IntegerString;

BEGIN
     Str (Getal,Temp);
     Integer2String:=Temp;
END;


{--------------------------------------------------------------------------}
{ SignedInteger2String                                                     }
{                                                                          }
{ Deze routine is gelijk aan Integer2String, alleen wordt er bij een       }
{ positief getal nog even een + teken voor gezet.                          }
{                                                                          }
FUNCTION SignedInteger2String (Getal : INTEGER) : IntegerString;
BEGIN
     IF (Getal < 0) THEN
        SignedInteger2String:=Integer2String (Getal)
     ELSE
         SignedInteger2String:='+'+Integer2String (Getal);
END;


{--------------------------------------------------------------------------}
{ Word2String                                                              }
{                                                                          }
{ Zet de opgegeven WORD in een decimale representatie. Geen voorloop       }
{ nullen of spaties.                                                       }
{                                                                          }
FUNCTION Word2String (Getal : WORD) : WordString;

VAR Temp : WordString;

BEGIN
     Str (Getal,Temp);
     Word2String:=Temp;
END;


{--------------------------------------------------------------------------}
{ Longint2String                                                           }
{                                                                          }
{ Zet de opgegeven LONGINT in een decimale representatie. Geen voorloop    }
{ nullen of spaties.                                                       }
{                                                                          }
FUNCTION Longint2String (Getal : LONGINT) : LongintString;

VAR Temp : LongintString;

BEGIN
     Str (Getal,Temp);
     Longint2String:=Temp;
END;


{--------------------------------------------------------------------------}
{ Real2String                                                              }
{                                                                          }
{ Deze routine zet een getal om in een real getal om in een string met een }
{ opgegeven aantal getallen voor en na de punt.                            }
{                                                                          }
FUNCTION Real2String (Getal : REAL; SumDigits,Decimals : BYTE) : RealString;

VAR Res : RealString;

BEGIN
     Str (Getal:SumDigits:Decimals,Res);
     Real2String:=Res;
END;


{--------------------------------------------------------------------------}
{ Byte2BinString                                                           }
{                                                                          }
{ Deze routine zet een byte om in een binair getal.                        }
{                                                                          }
FUNCTION Byte2BinString (Getal : BYTE) : BinByteString;

VAR Lp  : BYTE;
    Res : BinByteString;

BEGIN
     Res:='';
     FOR Lp:=7 DOWNTO 0 DO
         Res:=Res+Chr (48+Byte ((Getal AND (1 SHL Lp)) <> 0));

     Byte2BinString:=Res;
END;


{--------------------------------------------------------------------------}
{ Longint2BinString                                                        }
{                                                                          }
{ Deze routine zet een byte om in een binair getal.                        }
{                                                                          }
FUNCTION Longint2BinString (Getal : LONGINT) : BinLongString;

VAR Lp  : BYTE;
    Res : BinLongString;

BEGIN
     Res:='';
     FOR Lp:=31 DOWNTO 0 DO
         Res:=Res+Chr (48+Byte ((Getal AND (Longint (1) SHL Lp)) <> 0));
     Longint2BinString:=Res;
END;


{---------------------------------------------------------------------------}
{ Longint2NrString                                                          }
{                                                                           }
{ Deze routine converteert de opgegeven longint naar een string en zet om   }
{ de drie cijfers vanaf de rechterkant een puntje.                          }
{                                                                           }
FUNCTION Longint2NrString (Getal : LONGINT) : NrString;

VAR Res  : NrString;
    Dots : BYTE;
    Lp   : BYTE;

BEGIN
     Str (Getal,Res);
     Dots:=(Length (Res)-1) DIV 3;
     IF (Res[1] = '-') AND (((Length (Res)-1) MOD 3) = 0) THEN
        Dec (Dots);

     FOR Lp:=Dots DOWNTO 1 DO { zoveel puntjes plaatsen }
         Insert ('.',Res,Length (Res)-Lp*3+1);
     Longint2NrString:=Res;
END;
