PROGRAM RWHelpComp;

(* 

    RWBD - ReneWave mail packet bundling (downloads)

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

USES Misc1,MSTRINGS,DOS,CRT;

CONST MaxIdx = 200;

TYPE RWIdxRec = RECORD
        ShortDesc : String[60];
        RWPtr     : LongInt;
        TextSize  : Word;
     END;


VAR  RWIdxFile  : FILE OF RWIdxRec;
     RWIdx      : RWIdxRec;
     RWDatFile  : File;
     OneLine    : String;
     RWHelpFile : Text;
     RecNum     : Word;
     CurrID     : Word;


     PROCEDURE Init;
     BEGIN
         Assign(RWHelpFile,'RWHELP.HLP'); Reset(RWHelpFile);
         Assign(RWIdxFile,'RWHELP.IDX');  Rewrite(RWIdxFile);
         Assign(RWDatFile,'RWHELP.DAT');  Rewrite(RWDatFile,1);

         FillChar(RwIdx,SizeOf(RwIdx),0);
         FOR RecNum := 0 TO MaxIdx DO
            BEGIN
               Seek(RwIdxFile,RecNum);
               Write(RwIdxFile,RwIdx);
            END;
     END;

BEGIN
   Init;
   RecNum := 0;
   CurrID := 0;
   WHILE NOT Eof(RWHelpFile) DO
      BEGIN
         ReadLn(RWHelpFile,OneLine);
         OneLine := StripTrailingCh(OneLine,' ');

         IF (Copy(OneLine,1,3) = '%ID') THEN
            BEGIN
               IF CurrID > 0 THEN
                  BEGIN
                     Seek(RWIdxFile,CurrID);
                     Write(RWIdxFile,RWIdx);
                  END;
               FillChar(RWIdx,SizeOf(RWIdx),0);
               CurrID := ValFunc(Copy(OneLine,4,3));
               RWIdx.TextSize := 0;
               RWIdx.RWPtr := FilePos(RWDatFile);
               RWIdx.ShortDesc := Copy(OneLine,8,Length(OneLine)-7);
               WritePipe(RWIdx.ShortDesc+#13#10);
               Inc(RecNum);
            END
         ELSE IF OneLine[1] = ';' THEN
         ELSE BEGIN
               BlockWrite(RWDatFile,OneLine[0],Length(OneLine)+1);
               RWIdx.TextSize := RWIdx.TextSize + Length(OneLine) + 1;
            END;
      END;
   Close(RWHelpFile);
   Close(RWIdxFile);
   Close(RWDatFile);
END.



