PROGRAM MDCOMP;

(* 

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

USES  DOS,CRT,MISC1,MSTRINGS;

TYPE  MenuDescRec   = RECORD
         Desc,
         Status     : String[127];
      END;

VAR   MenuDescFile   : TEXT;
      ResourceFile   : FILE OF MenuDescRec;
      OneLine        : String;
      MenuDesc       : MenuDescRec;

      PROCEDURE ParseLine;
      VAR EndPos,StrPos:Byte;
      BEGIN
         OneLine := StripLeadingCh(OneLine,' ');
         OneLine := StripTrailingCh(OneLine,' ');
         OneLine := StripChar(OneLine,#9);

         EndPos := Pos(']',OneLine);
         IF (OneLine[1] = '[') AND (EndPos > 0) THEN
            BEGIN
               MenuDesc.Desc   := Copy(OneLine,2,EndPos-2);
               MenuDesc.Status := '';
               Delete(OneLine,1,EndPos);
               OneLine := StripLeadingCh(OneLine,' ');
               Delete(OneLine,1,1);
               OneLine := StripLeadingCh(OneLine,' ');

               EndPos := Pos(']',OneLine);
               IF (OneLine[1] = '[') AND (EndPos > 0) THEN
                  BEGIN
                     MenuDesc.Status := Copy(OneLine,2,EndPos-2);

                     Write(ResourceFile,MenuDesc);
                  END;
            END;
      END;

BEGIN
   Assign(MenuDescFile,'MENUDESC.TXT');
   Reset(MenuDescFile);
   Assign(ResourceFile,'RWSETUP.RES');
   Rewrite(ResourceFile);

   WHILE NOT Eof(MenuDescFile) DO
      BEGIN
         ReadLn(MenuDescFile,OneLine);
         ParseLine;
      END;

   Close(MenuDescFile);
   Close(ResourceFile);
END.
