CONST ZPAD        = 42;  { '*' - Pad character begins frames }
      ZDLE        = 24;  { ^X  - Zmodem escape - ala BISYNC DLE }
      ZDLEE       = 88;  { X   - Escaped ZDLE as transmitted }
      ZBIN        = 65;  { 'A' - Binary frame indicator }
      ZHEX        = 66;  { 'B' - HEX frame indicator }
      ZBIN32      = 67;  { 'C' - Binary frame with 32-bit FCS }
      ZBINR32     = 68;  { 'D' - RLE packed binary frame with 32-bit FCS }
      ZVBIN       = 97;  { 'a' - Binary frame indicator (CRC-16) }
      ZVHEX       = 98;  { 'b' - HEX frame indicator }
      ZVBIN32     = 99;  { 'c' - Binary frame with 32 bit FCS }
      ZVBINR32    = 100; { 'd' - RLE packed binary frame with 32 bit FCS }
      ZRESC       = 126; { '~' - RLE escape character }

      { Frame types }

      ZRQINIT     = 0;  { Request receive init }
      ZRINIT      = 1;  { Receive init }
      ZSINIT      = 2;  { Send init sequence (optional) }
      ZACK        = 3;  { ACK to above }
      ZFILE       = 4;  { File name from sender }
      ZSKIP       = 5;  { To sender: skip this file }
      ZNAK        = 6;  { Last packet was garbled }
      ZABORT      = 7;  { Abort batch transfers }
      ZFIN        = 8;  { Finish session }
      ZRPOS       = 9;  { Resume transmit at this position }
      ZDATA       = 10; { Data packet(s) follow }
      ZEOF        = 11; { End of file }
      ZFERR       = 12; { Fatal read/write error }
      ZCRC        = 13; { Request for file CRC / Response to request }
      ZCHALLENGE  = 14; { Receiver's challenge }
      ZCOMPL      = 15; { Request is complete }
      ZCAN        = 16; { Other end canned with 5 CAN's }
      ZFREECNT    = 17; { Request for free bytes on disk }
      ZCOMMAND    = 18; { Command from sending program }
      ZSTDERR     = 19; { Send following to stderr }

      { ZDLE sequences }

      ZCRCE       = 104; { 'h' - CRC next/frame ends/hdr follows }
      ZCRCG       = 105; { 'i' - CRC next/frame continues nonstop }
      ZCRCQ       = 106; { 'j' - CRC next/frame continues/want ZACK }
      ZCRCW       = 107; { 'k' - CRC next/ZACK expected/end of frame }
      ZRUB0       = 108; { 'l' - Translate to rubout 0177 (octal) }
      ZRUB1       = 109; { 'm' - Translate to rubout 0377 (octal) }


      ZOK         = 0;
      ZERROR      = -1;

CONST { GetZDL return values (internal) }
      GOTOR       = 256;
      GOTCRCE     = 360; { 'h' OR 256 - ZDLE-ZCRCE received }
      GOTCRCG     = 361; { 'i' OR 256 - ZDLE-ZCRCG received }
      GOTCRCQ     = 362; { 'j' OR 256 - ZDLE-ZCRCQ received }
      GOTCRCW     = 363; { 'k' OR 256 - ZDLE-ZCRCW received }
      GOTCAN      = 272; { CAN OR 256 - 5 CAN's seen }

CONST { Xmodem parameters }
      CAN         = 24;
      XOFF        = 19;
      XON         = 17;
      SOH         = 1;
      STX         = 2;
      EOT         = 4;
      ACK         = 6;
      CPMEOF      = 26;

CONST { Byte positions within header array }

      ZF0         = 3;  { First flags byte }
      ZF1         = 2;
      ZF2         = 1;
      ZF3         = 0;
      ZP0         = 0;  { Low order 8 bits of file position }
      ZP1         = 1;
      ZP2         = 2;
      ZP3         = 3;  { High order 8 bits of file position }

CONST { Parameters for ZRINIT header }

      ZRPXWN      = 8;   { 9th byte in header contains window size/256 }
      ZRPXQQ      = 9;   { 10th to 14th bytes contain quote mask }

CONST { Bit masks for ZRINIT flags byte F0 }

      CANFDX      = 1;   { Can handle full-duplex }
      CANOVIO     = 2;   { Can overlay disk and serial I/O }
      CANBRK      = 4;   { Can send a break - TRUE but superfluous }
      CANRLE      = 8;   { Can decode RLE }
      CANLZW      = 16;  { Can LZ compress - not defined yet }
      CANFC32     = 32;  { Can use 32 bit crc frame checks - true }
      ESCALL      = 64;  { Escapes all control chars. NOT implemented }
      ESC8        = 128; { Escapes the 8th bit. NOT implemented  }


CONST { Parameters for ZSINIT frame }
      ZATTNLEN    = 32;  { Max length of attention string }
      ALTCOFF     = ZF1; { Offset to alternate canit string, 0 if not used }

{ bit masks for ZSINIT }
CONST TESCCTL     = 64;
      TESC8       = 128;


CONST { Parameters for ZFILE frame - conversion options for ZF0 }

      ZCBIN       = 1;  { Binary transfer - no conversion }
      ZCNL        = 2;  { Convert NL to local EOLN }
      ZCRESUM     = 3;  { Resume interrupted file transfer }

CONST { Parameters for ZFILE frame - management options for ZF1.  Most }
      { of these are superfluous and have not been implemented }

      ZMNEW       = 1;  { Transfer iff source newer/longer }
      ZMCRC       = 2;  { Transfer if different CRC/length }
      ZMAPND      = 3;  { Append contents to existing file }
      ZMCLOB      = 4;  { Replace existing file }
      ZMSPARS     = 5;  { Encoding for sparse file }
      ZMDIFF      = 6;  { Transfer if dates/lengths differ }
      ZMPROT      = 7;  { Protect destination file }

CONST { Parameters for ZFILE frame - transport options for ZF2 }

      ZTLZW       = 1;  { Lempel-Ziv compression }
      ZTCRYPT     = 2;  { Encryption }
      ZTRLE       = 3;  { Run length encoding }

CONST ZCACK1      = 1;  { ? }
