UNIT RWVARS;

(* 

    RWVARS - ReneWave variable/type declarations (not overlayable)

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE

USES  RECORDS,BWSTRUCT,RWSTRUCT,MSBWGEN;

CONST MaxSelected      = 4096;
      DupesMax         = 256;
      MaxMsgBuffSize   = $FFFE;

VAR   ScanInfo         : ^ScanInfoPtr;
      ScanInfoLen      : Word;
      ScanInfoFile     : FILE;

TYPE  TScanTableMsg    = Array[1..1] OF ScanTableMessageFlags;
VAR   ScanTableMsgFile : FILE;
      ScanTableMsgArr  : ^TScanTableMsg;
      ScanTableMsgMax  : Word;

TYPE  MsgTxtBuffType   = Array[1..MaxMsgBuffSize] OF Char; { Message text }
VAR   MsgTxtBuff       : ^MsgTxtBuffType;
      MsgTxtBuffSize   : Word;
VAR   AcsTableLen      : Word;

VAR   RwStrTable       : MsStrTableType;
      RwStrBuff        : ^MsStrBuffType;
      RwStrBuffSize    : Word;

TYPE  DupeRecBuffType  = Array[1..DupesMax] OF DupeRec;
VAR   DupeRecBuff      : ^DupeRecBuffType;
      DupesFilePos     : LongInt;
      DupeBuffLen,
      DupeBuffPos      : Word;
      DupeTime         : LongInt;

VAR   ScanTable        : ScanTableRec;
      ScanTableFile    : FILE OF ScanTableRec;
      HighQwkIndex     : Word;

TYPE  TBasesIndex     = Array[0..MaxSelected-1] OF Integer;
                        { Index of QWK index numbers of ALL message areas }
                        { the current user has access to on the system,   }
                        { the array index # = MBASES.DAT recnum           }

                        {      -$7FFF = User does not have access to base }
                        {    Positive = Base is NOT selected              }
                        {    Negative = Base is selected                  }
                        {    Abs(idx) = QWK index number of the base      }
VAR   RwBaseIdxPos,
      RwBaseIdxLen     : Word;
      RwBaseIdx        : ^TBasesIndex;

      ThisBase         : Word;
      ThisMsg          : Word;

      RwNodeStr        : String[3];
      RwWorkDir        : String[127];
      RwOvrPath        : String[72];         { Overlay path }

      UserNameUpper    : String[36];
      UserAliasUpper   : String[36];
      UserNameCrc      : LongInt;
      UserAliasCrc     : LongInt;

      BwFtiFile        : FILE OF FtiRec;
      BwFreqFile       : FILE OF ReqRec;
      BwDatFile        : FILE;
      BwInfFile        : FILE;
      BwReplyHdr       : UplHeader;

      RepInfo          : ^RepInfoRec;
      GraphNumWrite    : Word;

VAR   { Command line switches }

      ForceNode        : Byte;    { /N:<#> Override node # in DOOR.SYS }
      ForceEmul        : Byte;    { /E:<#> Override emulation }
      ForceIRQ         : Byte;    { /P:x.. Override IRQ }
      ForceAddr        : Word;    { /P:x.. Override base address }
      ForceCommType    : Byte;    { /F:x.. Override comm type }

      ForceUserNum,               { /U:<#> Override DOOR.SYS with userID }
      ForcePort,                  { /C:x.. Override COMM info - port }
      ForceBaud,                  { /C:x.. Override COMM info - baud }
      ForceLocked      : LongInt; { /C:x.. Override COMM info - locked }

      QuickMode,                  { /Q     Quick intro mode }
      WarpDL,                     { /D     Download packet, no user input }
      WarpUL,                     { /U     Upload packet, no user input }
      PrescanMode      : Boolean; { /Px    Prescan mode }

IMPLEMENTATION


END.
