{$O+,F+,I-}
UNIT RWQWK;

(* 

    RWQWK - ReneWave Qwk processing unit

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


TYPE  CharStr5  = Array[1..5]  OF Char;
      CharStr6  = Array[1..6]  OF Char;
      CharStr7  = Array[1..7]  OF Char;
      CharStr8  = Array[1..8]  OF Char;
      CharStr12 = Array[1..12] OF Char;
      CharStr25 = Array[1..25] OF Char;

      Qwk_MsgTextType = Array[1..128] OF Char;

      Qwk_MsgHdrRec  = RECORD
         MsgStatus : Char;      { Message status flags }
                                { */~ Private, unread  ' ' Public, read }
                                { +/` Private, read    '-' Public, unread }
         MsgNum    : CharStr7;  { Message number ASCIIZ }
         MsgDate   : CharStr8;  { Message date (MM-DD-YY) }
         MsgTime   : CharStr5;  { Message time (HH:MM) }
         MsgTo     : CharStr25; { To   (upper)  > These 3 fields are left }
         MsgFrom   : CharStr25; { From (upper)  > justified, and padded }
         Subject   : CharStr25; { Subject       > with spaces }
         Password  : CharStr12; { Password - unused/blank }
         MsgRef    : CharStr8;  { Reference # }
         NumBlocks : CharStr6;  { Number of 128 byte blocks INCL. header }
         MsgActive : Char;      { /#225 = Active, /#226 = Inactive }
         ConfNum   : Word;      { Conference number }
         Res1      : Integer;   { Unused }
         TagLine   : Char;      { '*' = Network tagline present, ' ' = None }
      END;

      Qwk_NdxRec = RECORD
         MsgPointer : LongInt;
         Conference : Byte;
      END;


VAR ControlDat   : Text;
    MsgNdx       : QWK_NdxRec;
    MsgNdxFile   : FILE OF QWK_NdxRec;
    MsgFile      : FILE;
    MsgTextBuf   : QWK_MsgTextType;
    MsgHdrBlock  : QWK_MsgHdrRec;
    OrigBuffSize : Word;

    QwkDoorID    : Text;    { These three files are used for the QWKE }
    QwkToReader  : Text;    { (Extended QWK) format }
    QwkToDoor    : Text;


PROCEDURE RWQU_InitFiles;
PROCEDURE RWQU_LoadText;
PROCEDURE RWQU_ProcPacket;
PROCEDURE RWQU_ProcReplies;

FUNCTION  RWQ_FormatTime:String;
PROCEDURE RWQ_InitQwk;
PROCEDURE RWQ_DeInitQwk;
PROCEDURE RWQ_CreateDOORID;
PROCEDURE RWQ_CreateControlDAT;
FUNCTION  RWQ_WriteMessageDat(Size:LongInt):LongInt;
PROCEDURE RWQ_WriteMessageHdr;
PROCEDURE RWQ_UpdateGraph;
FUNCTION  RWQ_ProcAllBases:Boolean;


IMPLEMENTATION

USES {$I FOSSTYPE.INC }

     MISC1,    MSTRINGS, UNIXDATE, CRT,      DOS,      CRC32,
     RWBB,     RWBD,     RWBT,     RWACS,    RWLOGS,
     RWMAIN,   RWUP,     RWSTRUCT, BWSTRUCT, RECORDS,  RWVARS,
     MSRGGEN,  RWFL,     MSBWGEN,  RWAREAS;

VAR  NumOfTotal : LongInt;
     ThisRec    : Word;


PROCEDURE RWQU_InitFiles;
BEGIN
   Assign(MsgFile,RwWorkDir+MsRg_General.PacketName+'.MSG');
   Reset(MsgFile,1);
END;


PROCEDURE RWQU_ProcPacket;
BEGIN
   RWM_KeyPressOff;
   RWQU_InitFiles;
   IF (FileSize(MsgFile) >= 256) THEN RWQU_ProcReplies;
   RWM_KeyPressOn;
END;


PROCEDURE RWQU_LoadText;
VAR Counter,NumRecs:Word; OneLine:String;
BEGIN
   NumRecs := ValFunc(Qwk2Str(MsgHdrBlock.NumBlocks,6));
   ThisRec := ThisRec+NumRecs-1;
   BlockRead(MsgFile,MsgTxtBuff^,LongInt(NumRecs-1)*128,MsgTxtBuffSize);
   WHILE ((MsgTxtBuff^[MsgTxtBuffSize]=#0) OR (MsgTxtBuff^[MsgTxtBuffSize]=#32)) AND (MsgTxtBuffSize > 0) DO
      Dec(MsgTxtBuffSize);
   OneLine := '';
   FOR Counter := 1 TO MsgTxtBuffSize DO
      BEGIN
         IF MsgTxtBuff^[Counter] = #227
            THEN BEGIN
                  Move(OneLine[0],MsgTxtBuff^[Counter-Length(OneLine)],Ord(OneLine[0])+1);
                  OneLine := '';
               END
            ELSE BEGIN
                  Inc(OneLine[0]);
                  OneLine[Ord(OneLine[0])] := MsgTxtBuff^[Counter];
               END;
      END;
END;


PROCEDURE RWQU_ProcReplies;
VAR MsgHdr      : MHeaderRec;
    BaseFile    : String;

    PROCEDURE SkipText;
    BEGIN
       NumRecs := ThisRec+ValFunc(Qwk2Str(MsgHdrBlock.NumBlocks,6))-1;
    END;

    PROCEDURE PostText;
    BEGIN
       Assign(Dat,BaseFile+'.DAT');
       IF FExists(BaseFile+'.DAT') THEN Reset(Dat,1) ELSE Rewrite(Dat,1);
       Seek(Dat,FileSize(Dat));
       MsgHdr.Pointer := FilePos(Dat)+1;
       MsgHdr.TextSize := MsgTxtBuffSize;
       BlockWrite(Dat,MsgTxtBuff^,MsgTxtBuffSize,BytesWritten);
       RWU_AddTear(MsgHdr.TextSize,MsRg_MArea.Aka);
       MsgHdr.OriginDate := 'Local';
       Close(Dat);
    END;

    PROCEDURE DoEmail;
    BEGIN
       WITH MsgHdr DO
          BEGIN
             IF NOT EvalAcs(RwConfig.AnyNameEmail) THEN
                CASE RwConfig.NTypeEmail OF
                   NameAlias  : From.As := MsRg_User.Name;
                   NameReal   : From.As := MsRg_User.RealName;
                   NameEither : IF UpcaseStr(From.As) <> UpcaseStr(MsRg_User.RealName)
                                   THEN From.As := MsRg_User.Name;
                END;
             MsRg_UserIdxOpen;
             mTo.UserNum := MsRg_UserIdxSearch(mTo.As);
             MsRg_UserIdxClose;
             IF mTo.UserNum = -1 THEN
                BEGIN
                   RWM_WriteColor(RWM_GetString(159));
                   RWL_WriteLog('+',RWL_LogTime+' Unable to find user "'+mTo.As+'"!');
                   Close(MsgHdrFile);
                   Exit;
                END;
          END;
    END;

    PROCEDURE ConvHeader;
    BEGIN
       WITH MsgHdr DO
          BEGIN
             From.As := Qwk2Str(MsgHdrBlock.MsgFrom,25);
             From.Real := MsRg_User.Realname;
             From.Name := MsRg_User.Name;

             IF (mbRealName IN MsRg_MArea.mbStat)
                THEN From.AS := MsRg_User.RealName
                ELSE From.AS := FormatName(MsRg_User.Name);

             IF NOT (MsRg_MArea.Anonymous IN [atno,atyes]) THEN
                BEGIN
                   IF (MsRg_MArea.anonymous = atforced)
                      THEN From.Anon := 1
                      ELSE IF (MsRg_MArea.anonymous = atanyname)
                         THEN BEGIN
                               From.AS := Qwk2Str(MsgHdrBlock.MsgFrom,25);
                               From.Anon := 5;
                            END
                         ELSE From.Anon := 4;
                END;

            mTo.As := FormatName(Qwk2Str(MsgHdrBlock.MsgTo,25));
            mTo.Real := mTo.As;
            mTo.Name := mTo.As;
            Subject := Qwk2Str(MsgHdrBlock.Subject,25);
            CurrentSecs(Date,DayOfWeek);
            OriginDate := 'Local';
          END;

       RwVariables^[1] := MsgHdr.From.As;
       RwVariables^[2] := MsgHdr.mTo.As;
       RwVariables^[3] := MsgHdr.Subject;
       RwVariables^[4] := Unix2DateStr(0,MsgHdr.Date);
       RwVariables^[8] := MsRg_MArea.FileName;

       IF MsRg_MArea.FileName='EMAIL' THEN DoEmail;
       MsgHdr.From.As := FormatName(MsgHdr.From.As);
    END;

    PROCEDURE PostMessage;
    BEGIN
       CASE MsRg_MArea.mbType OF
          10, 11 : BaseFile := MsRg_General.MsgPath+'EMAIL';
          ELSE     BaseFile := MsRg_General.MsgPath+MsRg_MArea.FileName;
       END;

       Assign(MsgHdrFile,BaseFile+'.HDR');
       IF FExists(BaseFile+'.HDR') THEN Reset(MsgHdrFile) ELSE Rewrite(MsgHdrFile);
       Seek(MsgHdrFile,FileSize(MsgHdrFile));
       FillChar(MsgHdr,SizeOf(MsgHdr),0);

       ConvHeader;
       RWQU_LoadText;

       IF RWU_CheckDupes THEN
          BEGIN
             RWM_WriteColor(RWM_GetString(158));
             RWL_WriteLog('+',RWL_LogTime+' Skipped duplicate message');
             Close(MsgHdrFile);
             Exit;
          END;

       PostText;

       Write(MsgHdrFile,MsgHdr);
       Close(MsgHdrFile);
       RWL_WriteLog('+',RWL_LogTime+' Message to "'+MsgHdr.mto.As+'" in base "'+MsRg_MArea.Filename+'"');
       RWM_WriteColor(RWM_GetString(155));

       IF MsRg_MArea.FileName='EMAIL'
          THEN BEGIN
                MsRg_UserFileOpen;
                MsRg_UserFileRead(MsgHdr.mTo.UserNum);
                Inc(MsRg_User.Waiting);
                MsRg_UserFileWrite(MsgHdr.mTo.UserNum);
                MsRg_UserFileRead(RgUserNum);
                MsRg_UserFileClose;
                Inc(RepInfo^.RepEmail);
             END
          ELSE Inc(RepInfo^.RepPublic);

       MsRg_MArea.mbStat := MsRg_MArea.mbStat + [mbScanOut];
       MsRg_MAreaWrite(ThisBase);
       CreateSem := TRUE;
    END;

    PROCEDURE ProcOneMsg;
    VAR s:String;
    BEGIN
       ThisBase := RWM_BaseIdxFind(MsgHdrBlock.ConfNum);
       IF (ThisBase = $FFFF) OR NOT (scn_HasAccess IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
          BEGIN
             SkipText;
             RWM_WriteColor(RWM_GetString(160));
             Exit;
          END;
       MsRg_MAreaRead(ThisBase);

       s := UpcaseStr(Qwk2Str(MsgHdrBlock.MsgTo,25));
       IF (s='RENEWAVE') OR (s='RENEGADE') OR (s='QMAIL') OR (s='ROSEMAIL') THEN
          BEGIN
             s := Qwk2Str(MsgHdrBlock.Subject,25);
             s := StripLeadingCh(StripTrailingCh(UpcaseStr(s),' '),' ');
             IF s = 'ADD'
{ ADD }         THEN BEGIN
                      RwVariables^[1] := 'ADD';
                      RWA_ToggleBase(ThisBase,'+');
                      RWM_WriteColor(RWM_GetString(149));
                   END
{ ADD YOURS }   ELSE IF (s = 'ADD YOURS') OR (s = 'ADD Y') OR (s = 'YOURS') THEN BEGIN
                      RwVariables^[1] := 'ADD YOURS';
                      RWA_ToggleBase(ThisBase,'P');
                      RWM_WriteColor(RWM_GetString(149));
                   END
{ ADD YA }      ELSE IF (s = 'ADD YA') OR (s = 'YOURS ALL') OR (s = 'YA') THEN BEGIN
                      RwVariables^[1] := 'ADD YOURS ALL';
                      RWA_ToggleBase(ThisBase,'A');
                      RWM_WriteColor(RWM_GetString(149));
                   END
{ DROP }        ELSE IF s = 'DROP' THEN BEGIN
                      RwVariables^[1] := 'DROP';
                      RWA_ToggleBase(ThisBase,'-');
                      RWM_WriteColor(RWM_GetString(149));
                   END;
            SkipText;
            Exit;
         END;

       PostMessage;
    END;

BEGIN
   RWM_KeyPressOff;

   FillChar(RepInfo^,SizeOf(RepInfo^),0);

   RWM_WriteColor(RWM_GetString(150));
   RWM_WriteColor(RWM_GetString(151));
   RWM_WriteColor(RWM_GetString(152));
   RWM_WriteColor(RWM_GetString(153));
   RWM_WriteColor(RWM_GetString(154));

   ThisRec := 1;
   REPEAT
      Seek(MsgFile,LongInt(ThisRec)*128);
      BlockRead(MsgFile,MsgHdrBlock,128);
      ProcOneMsg;
      Inc(ThisRec);
   UNTIL (LongInt(ThisRec)*128) >= FileSize(MsgFile);

   RWU_UpdateStats;
   RWM_KeyPressOn;
   IF NOT WarpUL THEN RWM_Pause;
END;


PROCEDURE RWQ_InitQwk;
BEGIN
   Assign(MsgFile,RwWorkDir+'MESSAGES.DAT');
   Rewrite(MsgFile,1);

   CASE RwConfig.FileListType OF
      1 : BEGIN
             IF (NOT RwConfig.FileListOptional) OR (RwFileList IN RwUser.BWaveFlags) THEN
                RWF_CreateFileList(RwWorkDir+'NEWFILES.DAT');
          END;
      2 : IF (RwConfig.FilesList <> '') AND FExists(RwConfig.FilesList) THEN
             CopyFile(RwConfig.FilesList,RwWorkDir+'NEWFILES.DAT',TRUE);
   END;
END;


PROCEDURE RWQ_DeInitQwk;
BEGIN
    Close(MsgFile); IF IOResult <> 0 THEN ;
END;


FUNCTION RWQ_FormatTime:String;
VAR Year,Month,Day,Hour,Min,Sec,Junk:Word;
BEGIN
   GetDate(Year,Month,Day,Junk);
   GetTime(Hour,Min,Sec,Junk);
   RWQ_FormatTime := LeadingZero(Month,2) + '-' +
                     LeadingZero(Day,2)   + '-' +
                     LeadingZero(Year,4)  + ',' +
                     LeadingZero(Hour,2)  + ':' +
                     LeadingZero(Min,2);
END;


PROCEDURE RWQ_CreateDOORID;
BEGIN
   Assign(QwkDoorID,RwWorkDir+'DOOR.ID');
   Rewrite(QwkDoorID);
   WriteLn(QwkDoorID,'DOOR = ReneWave');
   WriteLn(QwkDoorID,'VERSION = '+RwVer);
   WriteLn(QwkDoorID,'SYSTEM = ReneWave v'+RwVer);
   WriteLn(QwkDoorID,'CONTROLNAME = RENEWAVE');
   WriteLn(QwkDoorID,'CONTROLTYPE = ADD <area>');
   WriteLn(QwkDoorID,'CONTROLTYPE = DROP <area>');
   WriteLn(QwkDoorID,'CONTROLTYPE = RESET <area> <message>');
   WriteLn(QwkDoorID,'CONTROLTYPE = MAXKEYWORDS 10');
   WriteLn(QwkDoorID,'CONTROLTYPE = MAXFILTERS 10');
   WriteLn(QwkDoorID,'CONTROLTYPE = MAXTWITS 0');
   WriteLn(QwkDoorID,'MIXEDCASE = YES');
   WriteLn(QwkDoorID,'FIDOTAG = YES');
   Close(QwkDoorID);
END;


PROCEDURE RWQ_CreateControlDAT;
BEGIN
   Assign(ControlDat,RwWorkDir+'CONTROL.DAT');
   Rewrite(ControlDat);

   WriteLn(ControlDat,MsRg_General.BBSName);
   WriteLn(ControlDat,'');
   WriteLn(ControlDat,MsRg_General.BBSPhone);
   WriteLn(ControlDat,MsRg_General.SysopName+', Sysop');
   WriteLn(ControlDat,'0,'+MsRg_General.PacketName);
   WriteLn(ControlDat,RWQ_FormatTime);
   WriteLn(ControlDat,UpcaseStr(MsRg_User.RealName));
   WriteLn(ControlDat,'');
   WriteLn(ControlDat,'0');
   RWB_CalcTotals;
   WriteLn(ControlDat,StrFunc(GDL));
   WriteLn(ControlDat,StrFunc(AcsTableLen));
   FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
      IF (scn_HasAccess IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
         BEGIN
            MsRg_MAreaRead(ThisBase);
            WriteLn(ControlDat,StrFunc(MsRg_MArea.QwkIndex));
            WriteLn(ControlDat,StripColor(MsRg_MArea.Name));
         END;
   WriteLn(ControlDat,'WELCOME');
   WriteLn(ControlDat,'NEWS');
   WriteLn(ControlDat,'GOODBYE');
   Close(ControlDat);
END;


PROCEDURE RWQ_FlushMsgBuff;
VAR i:LongInt;
BEGIN
   IF MsgTxtBuffSize > 0 THEN
      BEGIN
         Seek(MsgFile,FileSize(MsgFile));
         BlockWrite(MsgFile,MsgTxtBuff^,MsgTxtBuffSize);
      END;
   MsgTxtBuffSize := 0;
END;


FUNCTION RWQ_WriteMessageDat(Size:LongInt):LongInt;
VAR b:Byte; BuffPos:Word; i:Word; NewSize:LongInt;
BEGIN
   IF (MsgHdr.TextSize = 0) OR (FileSize(Dat) < (MsgHdr.Pointer-1+MsgHdr.TextSize)) THEN
      BEGIN
         RWQ_WriteMessageDat := 1;
         Exit;
      END;

   NewSize := Size;
   IF NewSize+MsgTxtBuffSize > $FFFE THEN NewSize := 65408-MsgTxtBuffSize;
   FillChar(MsgTxtBuff^[MsgTxtBuffSize+1],NewSize,0);
   IF MsgHdr.TextSize > NewSize THEN MsgHdr.TextSize := NewSize;
   Seek(Dat,MsgHdr.Pointer-1);
   BlockRead(Dat,MsgTxtBuff^[MsgTxtBuffSize+1],MsgHdr.TextSize);
   i := MsgTxtBuffSize+1;
   REPEAT
      Move(MsgTxtBuff^[i],b,1);
      Move(MsgTxtBuff^[i+1],MsgTxtBuff^[i],b);
      MsgTxtBuff^[i+b] := #227;
      Inc(i,b+1);
   UNTIL (i >= MsgHdr.TextSize+MsgTxtBuffSize);
   Inc(MsgTxtBuffSize,NewSize);
   RWQ_WriteMessageDat := (NewSize DIV 128)+1;
END;


PROCEDURE RWQ_WriteMessageHdr;
VAR TempFPos,NumBlocks:Word; NewSize:LongInt;
BEGIN
   WITH MsgHdr DO
      BEGIN
         IF (mbRealName IN MsRg_MArea.mbStat)
            THEN Str2Nul(From.Real,MsgHdrBlock.MsgFrom,25,#32)
            ELSE Str2Nul(From.As,MsgHdrBlock.MsgFrom,25,#32);

         Str2Nul(mTo.As,MsgHdrBlock.MsgTo,25,#32);
         Str2Nul(Subject,MsgHdrBlock.Subject,25,#32);
         Str2Nul(StrFunc(ThisMsg+1),MsgHdrBlock.MsgNum,7,#32);
         Str2Nul(StrFunc(0),MsgHdrBlock.MSgRef,8,#32);

         IF (MsgHdr.TextSize = 0) OR (FileSize(Dat) < (MsgHdr.Pointer-1+MsgHdr.TextSize))
            THEN BEGIN
                  NewSize := 0;
                  NumBlocks := 1;
               END
            ELSE BEGIN
                  NewSize := MsgHdr.TextSize;
                  IF NewSize MOD 128 > 0 THEN NewSize := NewSize+128-(NewSize MOD 128);
               END;

         IF (LongInt(MsgTxtBuffSize)+128+NewSize) >= LongInt(MaxMsgBuffSize) THEN RWQ_FlushMsgBuff;
         TempFpos := MsgTxtBuffSize;
         MsgTxtBuffSize := MsgTxtBuffSize+128;

         NumBlocks := RWQ_WriteMessageDat(NewSize);
         Str2Nul(Unix2DateStr(4,Date),MsgHdrBlock.MsgDate,8,#32);
         Str2Nul(Unix2DateStr(5,Date),MsgHdrBlock.MsgTime,5,#32);
         Str2Nul(StrFunc(NumBlocks),MsgHdrBlock.NumBlocks,6,#32);

         Move(MsgHdrBlock,MsgTxtBuff^[TempFPos+1],128);
      END;
END;


PROCEDURE RWQ_UpdateGraph;
VAR MsgsPerBlock:Real;
BEGIN
   IF GraphNumWrite >= 42 THEN Exit;
   MsgsPerBlock := GDL / 42;
   IF NumOfTotal >= (GraphNumWrite * MsgsPerBlock) + MsgsPerBlock THEN
      BEGIN
         RWM_WriteColor('|09');
         Inc(GraphNumWrite);
      END;
END;


FUNCTION RWQ_ProcAllBases:Boolean;
VAR s             : String;
    Aborted,
    Found         : Boolean;
    SInfoPos      : Word;

    PROCEDURE CheckAborted;
    VAR ch:Char;
    BEGIN
       IF fk_KeyPressed THEN
          BEGIN
             ch := UpCase(fk_Read);
             IF Ch = ' ' THEN
                BEGIN
                   RWM_WriteColor(RWM_GetString(28));
                   RWL_WriteLog('#',RWL_LogTime+' Bundling aborted!');
                   Aborted := TRUE;
                   RWM_DeInitSTF;
                   Close(MsgNdxFile);
                   Close(MsgHdrFile);
                   Close(Dat);
                END;
          END;
    END;

    PROCEDURE OneBase;
    VAR BaseFile:String; i:LongInt; ch:Char;
    BEGIN
       CASE MsRg_MArea.mbType OF
          10, 11 : BEGIN
                      BaseFile := MsRg_General.MsgPath+'EMAIL';
                      MsRg_Scn.LastRead := 0;
                   END;
              ELSE BEGIN
                      BaseFile := MsRg_General.MsgPath+MsRg_MArea.FileName;
                      MsRg_ScnOpen;
                      MsRg_ScnRead(rgUserNum-1);
                      MsRg_ScnClose;
                   END;
       END;

       IF NOT FExists(BaseFile+'.HDR') OR NOT FExists(BaseFile+'.DAT') THEN Exit;

       Assign(MsgHdrFile,BaseFile+'.HDR');
       Reset(MsgHdrFile);
       Assign(Dat,BaseFile+'.DAT');
       Reset(Dat,1);

       IF (ScanTable.MsgsDownload = 0) OR (FileSize(MsgHdrFile) = 0) THEN
          BEGIN
             Close(MsgHdrFile);
             Close(Dat);
             Exit;
          END;

       RWM_ReadSTF;
       Assign(MsgNdxFile,RwWorkDir+LeadingZero(MsRg_MArea.QwkIndex,3)+'.NDX');
       Rewrite(MsgNdxFile);

       i := FileSize(MsgHdrFile)-1;
       IF (stb_BundleFirst IN ScanTable.BaseStat) THEN
          BEGIN
             IF (stb_BundleNew IN ScanTable.BaseStat)
                THEN i := ScanTable.PtrMsg+ScanTable.MsgsFirst-2
                ELSE i := ScanTable.MsgsFirst-1;
          END;

       IF i >= 0 THEN
          BEGIN
             Seek(MsgHdrFile,i);
             BlockRead(File(MsgHdrFile),MsgHdr,1);
             UPointerData.Update := stb_UpdatePointers IN ScanTable.BaseStat;
             UPointerData.LastMsg := FilePos(MsgHdrFile);
             UPointerData.LastDate := MsgHdr.Date;
          END;

       FOR ThisMsg := 0 TO (FileSize(MsgHdrFile)-1) DO
          IF ((stm_NoBundle IN ScanTableMsgArr^[ThisMsg+1])=FALSE) AND
             ((stm_ShouldDL IN ScanTableMsgArr^[ThisMsg+1])=TRUE) THEN
             BEGIN
                RWQ_UpdateGraph;
                CheckAborted;
                IF Aborted THEN Exit;
                Seek(MsgHdrFile,ThisMsg);
                BlockRead(File(MsgHdrFile),MsgHdr,1);

                MsgTo   := UpcaseStr(MsgHdr.mTo.As);
                MsgFrom := UpcaseStr(MsgHdr.From.As);
                MsgSubj := UpcaseStr(MsgHdr.Subject);

                IF (MsRg_MArea.QwkIndex < 3) THEN
                  IF (stm_IsPersonal IN ScanTableMsgArr^[ThisMsg+1]) AND (MsgHdr.FileAttached = 0) THEN
                     BEGIN
                        NukeEmail := ThisMsg;
                        BlockWrite(NukeEmailFile,NukeEmail,1);
                     END;

                FillChar(MsgHdrBlock,SizeOf(MsgHdrBlock),#32);
                MsgHdrBlock.MsgStatus := ' ';
                MsgHdrBlock.MsgActive := #225;
                MsgHdrBlock.ConfNum := MsRg_MArea.QwkIndex;
                MsgHdrBlock.Res1 := 0;
                MsgHdrBlock.TagLine := ' ';

                MsgNdx.MsgPointer := Long2BasicReal(((FileSize(MsgFile)+MsgTxtBuffSize) DIV 128)+1);
                MsgNdx.Conference := MsRg_MArea.QwkIndex;
                Write(MsgNdxFile,MsgNdx);

                RWQ_WriteMessageHdr;
                Inc(NumOfTotal);
             END;

      RWM_DeInitSTF;
      Close(MsgNdxFile);
      Close(MsgHdrFile);
      Close(Dat);
   END;

   PROCEDURE Init;
   BEGIN
      RWM_KeyPressOff;

      FillChar(s,SizeOf(s),#32);
      s := 'Produced by Qmail...Copyright (c) 1987 by Sparkware.  All Rights Reserved';
      BlockWrite(MsgFile,s[1],128);

      FillChar(MsgTxtBuff^,SizeOf(MsgTxtBuff^),#32);
      MsgTxtBuffSize := 0;
      Aborted := FALSE;
      NumOfTotal := 0;
      GraphNumWrite := 0;
      RWD_InitPointerData;
      RWQ_CreateControlDat;
      RWQ_CreateDoorID;
      RWM_WriteColor(RWM_GetString(20)+RWM_GetString(21)+#13);
   END;

BEGIN
   Init;
   FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
      IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) AND
         (scn_HasAccess IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
         BEGIN
            RWM_STableRead(ThisBase);
            IF NOT (stb_SkipBase IN ScanTable.BaseStat) AND (ScanTable.MsgsDownload > 0) THEN
               BEGIN
                  UPointerData.Update   := FALSE;
                  UPointerData.BaseNum  := ThisBase;
                  UPointerData.LastMsg  := 0;
                  UPointerData.LastDate := 0;

                  MsRg_MAreaRead(ThisBase);
                  OneBase;
                  IF Aborted THEN
                     BEGIN
                        RWQ_ProcAllBases := FALSE;
                        Exit;
                     END;
                  Write(UPointerFile,UPointerData);
               END;
         END;
   RWQ_FlushMsgBuff;
   fk_TextColor(9);
   IF GraphNumWrite < 42 THEN FOR SInfoPos := GraphNumWrite TO 42 DO fk_Write('');
   RWM_KeyPressOn;
   RWQ_ProcAllBases := True;
END;


END.


